(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[    348765,      16372]*)
(*NotebookOutlinePosition[    349905,      16409]*)
(*  CellTagsIndexPosition[    349861,      16405]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[TextData[
"Shor's Quantum Algorithm for Factoring Composite Integers"], "Title",
  Editable->False,
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData["Colin P. Williams"], "Subsubtitle",
  Editable->False,
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[TextData["Copyright Notice"], "Section",
  Editable->False,
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[
"Copyright Colin P. Williams (1997).\n\nThis Notebook is intended to be used \
in conjunction with \"Explorations in Quantum Computing\" by Colin P. \
Williams and Scott H. Clearwater, TELOS, Springer-Verlag (1997), \
ISBN:0-387-94768-X. Permission is hereby granted to copy and distribute this \
Notebook freely for any non-commercial activity provided you include this \
copyright notice at the beginning of all such copies. Please send suggestions \
and bug reports to Colin P. Williams at \n        colin@solstice.jpl.nasa.gov \
     (818) 306 6512 or \n        cpw@cs.stanford.edu               (415) 728 \
2118\nFor information on \"Explorations in Quantum Computing\" check out the \
TELOS web site:  http://www.telospub.com/catalog/PHYSICS/Explorations.html. \
To order call 1-800-777-4643.\n\nAll other rights reserved."], "Text",
  Editable->False,
  Evaluatable->False,
  AspectRatioFixed->True]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData["How to use this Notebook"], "Section",
  Editable->False,
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[
"This Notebook contains code for simulating the steps taken by a quantum \
computer following Peter Shor's algorithm for factoring integers. See \
\"Explorations in Quantum Computing\", Chapter 6.\n\nTo run the simulator use \
the command \"RunShorsAlgorithm\". For example, "], "Text",
  Editable->False,
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData["RunShorsAlgorithm[15]"], "Input",
  Editable->False,
  AspectRatioFixed->True],

Cell[TextData[
"will simulate an attempt to factor 15. This command may take two options:"], 
  "Text",
  Editable->False,
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[
"RunShorsAlgorithm[15, Period->QuantumMethod]\nRunShorsAlgorithm[15, \
Period->ClassicalMethod]"], "Input",
  Editable->False,
  AspectRatioFixed->True],

Cell[TextData[
"which controls whether the determination of the period is done using the \
classical or quantum method. The ClassicalMethod option is merely intended as \
a way of checking that the quantum algorithm returns the correct factors.  \
Note that Shor's algorithm is non-deterministic and is not guaranteed to \
succeed every time. However, just a few repeats are usually enough to \
determine non-trivial factors. For more details, see Chapter 6.\n\nThe \
simulation is very slow due to the need to operate upon exponentially large \
data structures that represent the mathematical description of the contents \
of a quantum memory register. An actual quantum computer would be vastly more \
efficient at running Shor's algorithm by exploiting the Principle of \
Superposition to represent the contents of the quantum register directly in a \
single physical state. Indeed, if anyone COULD ever simulate Shor's algorithm \
efficiently on a classical computer, this in itself would lead to a fast \
method for factoring integers.\n\nIn the output from the simulator you will \
see the state of certain registers written in the form:\na0 ket[0] + a1 \
ket[1] + ... <<238>> ... + a242 ket[242]\nThe <<238>> notation is a just \
shorthand for saying \"plus 238 similar terms\". To print the entire \
mathematical description of the state of the register would be rather \
messy."], "Text",
  Editable->False,
  Evaluatable->False,
  AspectRatioFixed->True]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData["Shor's Quantum Algorithm for Factoring an Integer"], "Section",
  Editable->False,
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[
"To remind yourself how to run the simulator enter ?RunShorsAlgorithm:"], 
  "Text",
  Editable->False,
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[TextData["?RunShorsAlgorithm"], "Input",
  Editable->False,
  AspectRatioFixed->True],

Cell[TextData[
"RunShorsAlgorithm[n] creates a simulation of how a quantum computer would \
find the\n   factors of n using Peter Shor's quantum factoring algorithm. You \
can give\n   RunShorsAlgorithm various options that control the output from \
the simulator. The\n   period of x^a mod n can be calculated in one of two \
ways. If you set\n   Period->QuantumMethod (the default) then \
RunShorsAlgorithm performs a faithful\n   quantum simulation of the steps a \
quantum computer would take to compute the\n   period of x^a mod n. This can \
be slow because of the need to compute a discrete\n   Fourier transform. If \
you are only interested in seeing what factors a quantum\n   computer would \
have found (not how it did it) then you can set\n   Period->ClassicalMethod. \
This returns the same result as the quantum simulation\n   but computes the \
period in a classical way."], "Print",
  Editable->False,
  Evaluatable->False,
  AspectRatioFixed->True]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData["Try me!"], "Subsubsection",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[TextData["RunShorsAlgorithm[15]"], "Input",
  AspectRatioFixed->True],

Cell[TextData[
"Step 1: Picking a random integer x, 1 < x < 15, that is co-prime to 15.\n>> \
Picked x == 7.\n\n\nStep 2: Picking a \"smooth\" q, i.e. an integer of order \
O(n^2) ~ 225\n   that has small prime factors.\n>> Picked q == 243.\n         \
                        a\nStep 3: Computing the period of 7  mod 15.\nRepeat \
steps 3(a)-3(g) O(log(q)) times.\n\nStep 3(a):\nInitially, place Reg1 and \
Reg2 in the state |0,0>.\n\nStep 3(b):\nLoading Reg1 with a superposition of \
all integers in the range 0 to q-1,\n   i.e. creating the superposition \
1/Sqrt[q] Sum[ket[a], {a,0,q-1}\nThis puts Reg1 in the state:\nReg1 = 0.06415 \
ket[0] + 0.06415 ket[1] + 0.06415 ket[2] + 0.06415 ket[3] + \n \n   0.06415 \
ket[4] + 0.06415 ket[5] + 0.06415 ket[6] + 0.06415 ket[7] + \n \n   0.06415 \
ket[8] + 0.06415 ket[9] + 0.06415 ket[10] + 0.06415 ket[11] + \n \n   0.06415 \
ket[12] + 0.06415 ket[13] + 0.06415 ket[14] + 0.06415 ket[15] + \n \n   \
0.06415 ket[16] + <<217>> + 0.06415 ket[234] + 0.06415 ket[235] + \n \n   \
0.06415 ket[236] + 0.06415 ket[237] + 0.06415 ket[238] + 0.06415 ket[239] + \n\
 \n   0.06415 ket[240] + 0.06415 ket[241] + 0.06415 ket[242]\n\nStep 3(c):\n  \
                 a\nLoading Reg2 with x  mod 15\nThis puts Reg2 in a state \
representing a superposition of the integers:\n{1, 7, 4, 13, 1, 7, 4, 13  ... \
 13, 1, 7, 4, 13, 1, 7, 4}\n\n\nStep 3(d): Measuring the state of Reg2\n\
measureReg2 = 4\nThe measurement of Reg2 has a side effect on the state of \
Reg1.\nIn fact the state of Reg1 is projected into:\nprojectReg1 = 0.128037 \
ket[2] + 0.128037 ket[6] + 0.128037 ket[10] + \n \n   0.128037 ket[14] + \
0.128037 ket[18] + 0.128037 ket[22] + 0.128037 ket[26] + \n \n   0.128037 \
ket[30] + 0.128037 ket[34] + 0.128037 ket[38] + 0.128037 ket[42] + \n \n   \
0.128037 ket[46] + 0.128037 ket[50] + 0.128037 ket[54] + 0.128037 ket[58] + \n\
 \n   0.128037 ket[62] + <<37>> + 0.128037 ket[214] + 0.128037 ket[218] + \n \
\n   0.128037 ket[222] + 0.128037 ket[226] + 0.128037 ket[230] + 0.128037 \
ket[234] + \n \n   0.128037 ket[238] + 0.128037 ket[242]\n\n\nStep 3(e): \
Computing discrete Fourier transform of the contents of Reg1.\nThis may take \
several minutes!\n(Remember you are watching a classical simulation of a \
quantum algorithm).\nThe Fourier transform puts Reg1 in the state:\n\nFourier \
= 0.501028 ket[0] + (0.00205408 + 0.0000265574 I) ket[1] + \n \n   \
(0.00205614 + 0.0000531769 I) ket[2] + (0.00205959 + 0.0000799213 I) ket[3] + \
\n \n   (0.00206442 + 0.000106854 I) ket[4] + (0.00207067 + 0.000134039 I) \
ket[5] + \n \n   (0.00207835 + 0.000161542 I) ket[6] + (0.00208749 + \
0.000189432 I) ket[7] + \n \n   (0.00209812 + 0.000217779 I) ket[8] + <<230>> \
+ \n \n   (0.00206442 - 0.000106854 I) ket[239] + (0.00205959 - 0.0000799213 \
I) ket[240] + \n \n   (0.00205614 - 0.0000531769 I) ket[241] + (0.00205408 - \
0.0000265574 I) ket[242]\n\n\nSteps 3(f)&3(g): Sample from Fourier spectrum \
created in Reg1\nThis entails repeating the previous steps & measuring Reg1 \
each time.\nFound samples: {ket[182], ket[0], ket[0], ket[181], ket[0], \
ket[121], ket[182], \n \n   ket[0], ket[182], ket[121], ket[59], ket[60]}\n\n\
Step 4: Extract the period, r, from the given samples.\nEach sample provides \
a value k\nFinding the closest rational to k/q, whose denominator is less \
than n.\nEach such rational has the form lambda/r, where r is the period.\n\
Period was r=4\n\nStep 5: Obtain the factors of n from the period, r.\n\
Computing the factors of n from\nGCD[x^(r/2) - 1, n] and\nGCD[x^(r/2) + 1, n]\
\nIn this case, x=7, r=4, n=15\nGCD[49 - 1, 15] = 3\nGCD[49 + 1, 15] = 5\nSo \
the factors of n=15 are 3 and 5."], "Print",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-4.25007e-17 0.00411523 0 0.0412023 [
[(50)] .20576 0 0 2 0 Minner Mrotsboxa
[(100)] .41152 0 0 2 0 Minner Mrotsboxa
[(150)] .61728 0 0 2 0 Minner Mrotsboxa
[(200)] .82305 0 0 2 0 Minner Mrotsboxa
[(Contents Reg1)] .5 0 0 2 0 0 -1 Mouter Mrotsboxa
[(0)] -0.0125 0 1 0 0 Minner Mrotsboxa
[(2)] -0.0125 .0824 1 0 0 Minner Mrotsboxa
[(4)] -0.0125 .16481 1 0 0 Minner Mrotsboxa
[(6)] -0.0125 .24721 1 0 0 Minner Mrotsboxa
[(8)] -0.0125 .32962 1 0 0 Minner Mrotsboxa
[(10)] -0.0125 .41202 1 0 0 Minner Mrotsboxa
[(12)] -0.0125 .49443 1 0 0 Minner Mrotsboxa
[(14)] -0.0125 .57683 1 0 0 Minner Mrotsboxa
[(Contents Reg2)] -0.0125 .30902 1 0 90 -1 0 Mouter Mrotsboxa
[(Initialize Reg1 & Reg2 as |0,0>)] .5 .61803 0 -2 Msboxa
[ -0.001 -0.001 0 0 ]
[ 1.001 .61903 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
[ ] 0 setdash
0 g
p
p
0 0 .5 r
.001 w
.20576 0 m
.20576 .61803 L
s
P
p
0 0 .5 r
.001 w
.41152 0 m
.41152 .61803 L
s
P
p
0 0 .5 r
.001 w
.61728 0 m
.61728 .61803 L
s
P
p
0 0 .5 r
.001 w
.82305 0 m
.82305 .61803 L
s
P
p
0 0 .5 r
.001 w
0 .0824 m
1 .0824 L
s
P
p
0 0 .5 r
.001 w
0 .16481 m
1 .16481 L
s
P
p
0 0 .5 r
.001 w
0 .24721 m
1 .24721 L
s
P
p
0 0 .5 r
.001 w
0 .32962 m
1 .32962 L
s
P
p
0 0 .5 r
.001 w
0 .41202 m
1 .41202 L
s
P
p
0 0 .5 r
.001 w
0 .49443 m
1 .49443 L
s
P
p
0 0 .5 r
.001 w
0 .57683 m
1 .57683 L
s
P
p
.002 w
.20576 0 m
.20576 .00625 L
s
P
[(50)] .20576 0 0 2 0 Minner Mrotshowa
p
.002 w
.41152 0 m
.41152 .00625 L
s
P
[(100)] .41152 0 0 2 0 Minner Mrotshowa
p
.002 w
.61728 0 m
.61728 .00625 L
s
P
[(150)] .61728 0 0 2 0 Minner Mrotshowa
p
.002 w
.82305 0 m
.82305 .00625 L
s
P
[(200)] .82305 0 0 2 0 Minner Mrotshowa
p
.001 w
.04115 0 m
.04115 .00375 L
s
P
p
.001 w
.0823 0 m
.0823 .00375 L
s
P
p
.001 w
.12346 0 m
.12346 .00375 L
s
P
p
.001 w
.16461 0 m
.16461 .00375 L
s
P
p
.001 w
.24691 0 m
.24691 .00375 L
s
P
p
.001 w
.28807 0 m
.28807 .00375 L
s
P
p
.001 w
.32922 0 m
.32922 .00375 L
s
P
p
.001 w
.37037 0 m
.37037 .00375 L
s
P
p
.001 w
.45267 0 m
.45267 .00375 L
s
P
p
.001 w
.49383 0 m
.49383 .00375 L
s
P
p
.001 w
.53498 0 m
.53498 .00375 L
s
P
p
.001 w
.57613 0 m
.57613 .00375 L
s
P
p
.001 w
.65844 0 m
.65844 .00375 L
s
P
p
.001 w
.69959 0 m
.69959 .00375 L
s
P
p
.001 w
.74074 0 m
.74074 .00375 L
s
P
p
.001 w
.78189 0 m
.78189 .00375 L
s
P
p
.001 w
.8642 0 m
.8642 .00375 L
s
P
p
.001 w
.90535 0 m
.90535 .00375 L
s
P
p
.001 w
.9465 0 m
.9465 .00375 L
s
P
p
.001 w
.98765 0 m
.98765 .00375 L
s
P
[(Contents Reg1)] .5 0 0 2 0 0 -1 Mouter Mrotshowa
p
.002 w
0 0 m
1 0 L
s
P
p
.002 w
0 0 m
.00625 0 L
s
P
[(0)] -0.0125 0 1 0 0 Minner Mrotshowa
p
.002 w
0 .0824 m
.00625 .0824 L
s
P
[(2)] -0.0125 .0824 1 0 0 Minner Mrotshowa
p
.002 w
0 .16481 m
.00625 .16481 L
s
P
[(4)] -0.0125 .16481 1 0 0 Minner Mrotshowa
p
.002 w
0 .24721 m
.00625 .24721 L
s
P
[(6)] -0.0125 .24721 1 0 0 Minner Mrotshowa
p
.002 w
0 .32962 m
.00625 .32962 L
s
P
[(8)] -0.0125 .32962 1 0 0 Minner Mrotshowa
p
.002 w
0 .41202 m
.00625 .41202 L
s
P
[(10)] -0.0125 .41202 1 0 0 Minner Mrotshowa
p
.002 w
0 .49443 m
.00625 .49443 L
s
P
[(12)] -0.0125 .49443 1 0 0 Minner Mrotshowa
p
.002 w
0 .57683 m
.00625 .57683 L
s
P
[(14)] -0.0125 .57683 1 0 0 Minner Mrotshowa
p
.001 w
0 .01648 m
.00375 .01648 L
s
P
p
.001 w
0 .03296 m
.00375 .03296 L
s
P
p
.001 w
0 .04944 m
.00375 .04944 L
s
P
p
.001 w
0 .06592 m
.00375 .06592 L
s
P
p
.001 w
0 .09889 m
.00375 .09889 L
s
P
p
.001 w
0 .11537 m
.00375 .11537 L
s
P
p
.001 w
0 .13185 m
.00375 .13185 L
s
P
p
.001 w
0 .14833 m
.00375 .14833 L
s
P
p
.001 w
0 .18129 m
.00375 .18129 L
s
P
p
.001 w
0 .19777 m
.00375 .19777 L
s
P
p
.001 w
0 .21425 m
.00375 .21425 L
s
P
p
.001 w
0 .23073 m
.00375 .23073 L
s
P
p
.001 w
0 .26369 m
.00375 .26369 L
s
P
p
.001 w
0 .28018 m
.00375 .28018 L
s
P
p
.001 w
0 .29666 m
.00375 .29666 L
s
P
p
.001 w
0 .31314 m
.00375 .31314 L
s
P
p
.001 w
0 .3461 m
.00375 .3461 L
s
P
p
.001 w
0 .36258 m
.00375 .36258 L
s
P
p
.001 w
0 .37906 m
.00375 .37906 L
s
P
p
.001 w
0 .39554 m
.00375 .39554 L
s
P
p
.001 w
0 .4285 m
.00375 .4285 L
s
P
p
.001 w
0 .44498 m
.00375 .44498 L
s
P
p
.001 w
0 .46147 m
.00375 .46147 L
s
P
p
.001 w
0 .47795 m
.00375 .47795 L
s
P
p
.001 w
0 .51091 m
.00375 .51091 L
s
P
p
.001 w
0 .52739 m
.00375 .52739 L
s
P
p
.001 w
0 .54387 m
.00375 .54387 L
s
P
p
.001 w
0 .56035 m
.00375 .56035 L
s
P
p
.001 w
0 .59331 m
.00375 .59331 L
s
P
p
.001 w
0 .60979 m
.00375 .60979 L
s
P
[(Contents Reg2)] -0.0125 .30902 1 0 90 -1 0 Mouter Mrotshowa
p
.002 w
0 0 m
0 .61803 L
s
P
P
p
p
.002 w
0 .61178 m
0 .61803 L
s
P
p
.002 w
.20576 .61178 m
.20576 .61803 L
s
P
p
.002 w
.41152 .61178 m
.41152 .61803 L
s
P
p
.002 w
.61728 .61178 m
.61728 .61803 L
s
P
p
.002 w
.82305 .61178 m
.82305 .61803 L
s
P
p
.001 w
.04115 .61428 m
.04115 .61803 L
s
P
p
.001 w
.0823 .61428 m
.0823 .61803 L
s
P
p
.001 w
.12346 .61428 m
.12346 .61803 L
s
P
p
.001 w
.16461 .61428 m
.16461 .61803 L
s
P
p
.001 w
.24691 .61428 m
.24691 .61803 L
s
P
p
.001 w
.28807 .61428 m
.28807 .61803 L
s
P
p
.001 w
.32922 .61428 m
.32922 .61803 L
s
P
p
.001 w
.37037 .61428 m
.37037 .61803 L
s
P
p
.001 w
.45267 .61428 m
.45267 .61803 L
s
P
p
.001 w
.49383 .61428 m
.49383 .61803 L
s
P
p
.001 w
.53498 .61428 m
.53498 .61803 L
s
P
p
.001 w
.57613 .61428 m
.57613 .61803 L
s
P
p
.001 w
.65844 .61428 m
.65844 .61803 L
s
P
p
.001 w
.69959 .61428 m
.69959 .61803 L
s
P
p
.001 w
.74074 .61428 m
.74074 .61803 L
s
P
p
.001 w
.78189 .61428 m
.78189 .61803 L
s
P
p
.001 w
.8642 .61428 m
.8642 .61803 L
s
P
p
.001 w
.90535 .61428 m
.90535 .61803 L
s
P
p
.001 w
.9465 .61428 m
.9465 .61803 L
s
P
p
.001 w
.98765 .61428 m
.98765 .61803 L
s
P
p
.002 w
0 .61803 m
1 .61803 L
s
P
[(Initialize Reg1 & Reg2 as |0,0>)] .5 .61803 0 -2 Mshowa
p
.002 w
.99375 0 m
1 0 L
s
P
p
.002 w
.99375 .0824 m
1 .0824 L
s
P
p
.002 w
.99375 .16481 m
1 .16481 L
s
P
p
.002 w
.99375 .24721 m
1 .24721 L
s
P
p
.002 w
.99375 .32962 m
1 .32962 L
s
P
p
.002 w
.99375 .41202 m
1 .41202 L
s
P
p
.002 w
.99375 .49443 m
1 .49443 L
s
P
p
.002 w
.99375 .57683 m
1 .57683 L
s
P
p
.001 w
.99625 .01648 m
1 .01648 L
s
P
p
.001 w
.99625 .03296 m
1 .03296 L
s
P
p
.001 w
.99625 .04944 m
1 .04944 L
s
P
p
.001 w
.99625 .06592 m
1 .06592 L
s
P
p
.001 w
.99625 .09889 m
1 .09889 L
s
P
p
.001 w
.99625 .11537 m
1 .11537 L
s
P
p
.001 w
.99625 .13185 m
1 .13185 L
s
P
p
.001 w
.99625 .14833 m
1 .14833 L
s
P
p
.001 w
.99625 .18129 m
1 .18129 L
s
P
p
.001 w
.99625 .19777 m
1 .19777 L
s
P
p
.001 w
.99625 .21425 m
1 .21425 L
s
P
p
.001 w
.99625 .23073 m
1 .23073 L
s
P
p
.001 w
.99625 .26369 m
1 .26369 L
s
P
p
.001 w
.99625 .28018 m
1 .28018 L
s
P
p
.001 w
.99625 .29666 m
1 .29666 L
s
P
p
.001 w
.99625 .31314 m
1 .31314 L
s
P
p
.001 w
.99625 .3461 m
1 .3461 L
s
P
p
.001 w
.99625 .36258 m
1 .36258 L
s
P
p
.001 w
.99625 .37906 m
1 .37906 L
s
P
p
.001 w
.99625 .39554 m
1 .39554 L
s
P
p
.001 w
.99625 .4285 m
1 .4285 L
s
P
p
.001 w
.99625 .44498 m
1 .44498 L
s
P
p
.001 w
.99625 .46147 m
1 .46147 L
s
P
p
.001 w
.99625 .47795 m
1 .47795 L
s
P
p
.001 w
.99625 .51091 m
1 .51091 L
s
P
p
.001 w
.99625 .52739 m
1 .52739 L
s
P
p
.001 w
.99625 .54387 m
1 .54387 L
s
P
p
.001 w
.99625 .56035 m
1 .56035 L
s
P
p
.001 w
.99625 .59331 m
1 .59331 L
s
P
p
.001 w
.99625 .60979 m
1 .60979 L
s
P
p
.002 w
1 0 m
1 .61803 L
s
P
P
p
P
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
p
p
.035 w
0 0 Mdot
P
P
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  Evaluatable->False,
  AspectRatioFixed->True,
  ImageSize->{282, 174},
  ImageMargins->{{34, Inherited}, {Inherited, Inherited}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004J0000[Q000`40O003h00Oogoo6goo003oOolK
Ool00;=oo`<006Aoo`00]Woo00<007ooOol0HGoo001`Ool40003Ool30002Ool200000goo00000002
Ool30003Ool4000017oo000007oo0P000Woo0`000Woo10001goo0P000Woo0P000Woo10000Woo1000
00Aoo`00000005moo`00Kgoo00<007ooOol017oo00L007ooOomoo`00Ool00002Ool01@00Oomoogoo
00000Woo00<007oo00001Goo00@007ooOol000=oo`04001oogoo0004Ool00`00Oomoo`06Ool01000
Ool000000Woo00<007ooOol00goo00D007ooOomoo`00009oo`03001oogoo05ioo`00Kgoo00<007oo
Ool017oo00L007ooOomoo`00Ool00002Ool01@00Oomoogoo000017oo1@0000Eoo`00Oomoo`0000=o
o`03001oogoo009oo`@000Qoo`<000=oo`D00003Ool007oo009oo`04001oogoo001POol006moo`03
001oogoo00Aoo`07001oogooOol007oo00000Woo00D007ooOomoo`0000Aoo`07001oogooOol007oo
00000Woo00D007ooOomoo`0000Aoo`03001oogoo00Uoo`04001oogoo0002Ool01`00Oomoogoo001o
o`0000=oo`04001oogoo001POol006moo`05001oogooOol00003Ool300000goo000000030002Ool4
0003Ool300000goo000000030002Ool40002Ool40008Ool01000Oomoo`000goo0`000goo1@0000=o
o`00Ool0Ggoo001`Ool4000?Ool00`00Oomoo`0?Ool00`00Oomoo`0=Ool4000?Ool2001POol008=o
o`03001oogoo00moo`03001oogoo089oo`00ogoo6goo003oOolKOol00?mooa]oo`00ogoo6goo003o
OolKOol00?mooa]oo`00ogoo6goo003oOolKOol00?mooa]oo`00ogoo6goo001FOol30004Ool2000M
Ool30004Ool20004Ool2000KOol30003Ool30004Ool2000KOol40003Ool20004Ool2000kOol005Uo
o`04001oogoo0002Ool00`00Oomoo`0KOol00`00Oomoo`02Ool01000Oomoo`000Woo00@007ooOol0
01]oo`03001oogoo00Eoo`04001oogoo0002Ool00`00Oomoo`0IOol00`00Oomoo`02Ool01000Oomo
o`000Woo00@007ooOol003Yoo`00FGoo00@007ooOol0009oo`03001oogoo01]oo`03001oogoo009o
o`04001oogoo0002Ool01000Oomoo`006goo00<007ooOol01Goo00@007ooOol0009oo`03001oogoo
01Yoo`05001oogooOol00002Ool01000Oomoo`000Woo00<007ooOol0>7oo001FOol30003Ool01000
Oomoo`007Goo00<007ooOol00Woo00@007ooOol0009oo`04001oogoo000KOol00`00Oomoo`02Ool3
0003Ool01000Oomoo`007Goo00@007ooOol0009oo`04001oogoo0002Ool00`00Oomoo`0hOol005Io
o`03001oogoo00=oo`04001oogoo000MOol00`00Oomoo`02Ool01000Oomoo`000Woo00@007ooOol0
01]oo`03001oogoo009oo`03001oogoo00=oo`04001oogoo000JOol01000Oomoo`000Woo00@007oo
Ool0009oo`04001oogoo000jOol005Ioo`@000=oo`8001eoo`8000Eoo`8000Aoo`8001]oo`8000Ao
o`@000=oo`8001aoo`8000Aoo`8000Aoo`8003]oo`00ogoo6goo003oOolKOol00?mooa]oo`00<7oo
0`00igoo000ZOol20003Ool5003VOol002Uoo`05001oogoo001oo`07003UOol002Uoo`05001oogoo
001oo`3?000MOol002Uoo`05001oogoo001oo`070004Ool00`00Oomoo`05Ool00`00Oomoo`06Ool0
0`00Oomoo`05Ool00`00Oomoo`06Ool00`00Oomoo`05Ool00`00Oomoo`05Ool00`00Oomoo`06Ool0
0`00Oomoo`05Ool00`00Oomoo`05Ool00`00Oomoo`06Ool00`00Oomoo`05Ool00`00Oomoo`05Ool0
0`00Oomoo`06Ool00`00Oomoo`05Ool00`00Oomoo`05Ool00`00Oomoo`06Ool00`00Oomoo`05Ool0
0`00Oomoo`05Ool00`00Oomoo`06Ool00`00Oomoo`05Ool00`00Oomoo`05Ool00`00Oomoo`06Ool0
0`00Oomoo`05Ool01000Oomoo`007Goo000YOol01000Oomoo`000Woo1@009goo00<03gooOol09Woo
00<03gooOol09goo00<03gooOol09goo00<03gooOol08Goo00<007ooOol06goo000ZOol20004Ool3
000XOol00`0?Oomoo`0VOol00`0?Oomoo`0WOol00`0?Oomoo`0WOol00`0?Oomoo`0QOol00`00Oomo
o`0KOol0035oo`8002Qoo`0300moogoo02Ioo`0300moogoo02Moo`0300moogoo02Moo`0300moogoo
021oo`8001eoo`00<Goo00<007ooOol09goo00<03gooOol09Woo00<03gooOol09goo00<03gooOol0
9goo00<03gooOol08Goo00<007ooOol06goo000aOol00`00Oomoo`0WOol00`0?Oomoo`0VOol00`0?
Oomoo`0WOol00`0?Oomoo`0WOol00`0?Oomoo`0QOol00`00Oomoo`0KOol0035oo`8002Qoo`0300mo
ogoo02Ioo`0300moogoo02Moo`0300moogoo02Moo`0300moogoo021oo`8001eoo`00<Goo00<007oo
Ool09goo00<03gooOol09Woo00<03gooOol09goo00<03gooOol09goo00<03gooOol08Goo00<007oo
Ool06goo000aOol00`00Oomoo`0WOol00`0?Oomoo`0VOol00`0?Oomoo`0WOol00`0?Oomoo`0WOol0
0`0?Oomoo`0QOol00`00Oomoo`0KOol0035oo`8002Qoo`0300moogoo02Ioo`0300moogoo02Moo`03
00moogoo02Moo`0300moogoo021oo`8001eoo`00<Goo00<007ooOol09goo00<03gooOol09Woo00<0
3gooOol09goo00<03gooOol09goo00<03gooOol08Goo00<007ooOol06goo000aOol00`00Oomoo`0W
Ool00`0?Oomoo`0VOol00`0?Oomoo`0WOol00`0?Oomoo`0WOol00`0?Oomoo`0QOol00`00Oomoo`0K
Ool0035oo`03001oogoo02Moo`0300moogoo02Ioo`0300moogoo02Moo`0300moogoo02Moo`0300mo
ogoo025oo`03001oogoo01]oo`00<Goo0P00:7oo00<03gooOol09Woo00<03gooOol09goo00<03goo
Ool09goo00<03gooOol087oo0P007Goo000YOol40004Ool00`00Oomoo`0WOol00`0?Oomoo`0VOol0
0`0?Oomoo`0WOol00`0?Oomoo`0WOol00`0?Oomoo`0QOol00`00Oomoo`0KOol002Yoo`03001oogoo
00Aoo`03001oogoo02Moo`0300moogoo02Ioo`0300moogoo02Moo`0300moogoo02Moo`0300moogoo
025oo`03001oogoo01]oo`00:goo00<007ooOol00goo0P00a`0?0`007Goo000/Ool00`00Oomoo`02
Ool00`00Oomoo`0WOol00`0?Oomoo`0VOol00`0?Oomoo`0WOol00`0?Oomoo`0WOol00`0?Oomoo`0Q
Ool00`00Oomoo`0KOol002Uoo`04001oogoo0004Ool00`00Oomoo`0WOol00`0?Oomoo`0VOol00`0?
Oomoo`0WOol00`0?Oomoo`0WOol00`0?Oomoo`0QOol00`00Oomoo`0KOol002Yoo`8000Eoo`8002Qo
o`0300moogoo02Ioo`0300moogoo02Moo`0300moogoo02Moo`0300moogoo021oo`8001eoo`00<Goo
00<007ooOol09goo00<03gooOol09Woo00<03gooOol09goo00<03gooOol09goo00<03gooOol08Goo
00<007ooOol06goo000aOol00`00Oomoo`0WOol00`0?Oomoo`0VOol00`0?Oomoo`0WOol00`0?Oomo
o`0WOol00`0?Oomoo`0QOol00`00Oomoo`0KOol0035oo`03001oogoo02Moo`0300moogoo02Ioo`03
00moogoo02Moo`0300moogoo02Moo`0300moogoo025oo`03001oogoo01]oo`00<Goo0P00:7oo00<0
3gooOol09Woo00<03gooOol09goo00<03gooOol09goo00<03gooOol087oo0P007Goo000MOol4000@
Ool00`00Oomoo`0WOol00`0?Oomoo`0VOol00`0?Oomoo`0WOol00`0?Oomoo`0WOol00`0?Oomoo`0Q
Ool00`00Oomoo`0KOol001aoo`03001oogoo019oo`03001oogoo02Moo`0300moogoo02Ioo`0300mo
ogoo02Moo`0300moogoo02Moo`0300moogoo025oo`03001oogoo01]oo`0077oo00<007ooOol04Woo
0P00:7oo00<03gooOol09Woo00<03gooOol09goo00<03gooOol09goo00<03gooOol087oo0P007Goo
000LOol00`00Oomoo`0BOol00`00Oomoo`0WOol00`0?Oomoo`0VOol00`0?Oomoo`0WOol00`0?Oomo
o`0WOol00`0?Oomoo`0QOol00`00Oomoo`0KOol001aoo`05001oogooOol0000@Ool00`00Oomoo`0W
Ool00`0?Oomoo`0VOol00`0?Oomoo`0WOol00`0?Oomoo`0WOol00`0?Oomoo`0QOol00`00Oomoo`0K
Ool001eoo`@0011oo`8002Qoo`0300moogoo02Ioo`0300moogoo02Moo`0300moogoo02Moo`0300mo
ogoo021oo`8001eoo`007Woo0`0047oo00<007ooOol09goo00<03gooOol09Woo00<03gooOol09goo
00<03gooOol09goo00<03gooOol08Goo00<007ooOol06goo000MOol01@00Oomoogoo000027oo0`00
17oo00<007ooOol09goo00<03gooOol09Woo00<03gooOol09goo00<03gooOol09goo00<03gooOol0
8Goo00<007ooOol06goo000MOol01@00Oomoogoo00002Goo00<007ooOol00goo00<007ooOol09goo
00<03gooOol09Woo00<03gooOol09goo00<03gooOol09goo00<03gooOol08Goo00<007ooOol06goo
000MOol01@00Oomoogoo00001goo100017oo0P00a`0?0`007Goo000NOol30008Ool00`00Ool00005
Ool00`00Oomoo`0WOol00`0?Oomoo`0VOol00`0?Oomoo`0WOol00`0?Oomoo`0WOol00`0?Oomoo`0Q
Ool00`00Oomoo`0KOol002Uoo`03001oo`0000Eoo`03001oogoo02Moo`0300moogoo02Ioo`0300mo
ogoo02Moo`0300moogoo02Moo`0300moogoo025oo`03001oogoo01]oo`007Goo0P0000=oo`000000
27oo0P001Goo0P00:7oo00<03gooOol09Woo00<03gooOol09goo00<03gooOol09goo00<03gooOol0
87oo0P007Goo000MOol01000Oomoo`0047oo00<007ooOol09goo00<03gooOol09Woo00<03gooOol0
9goo00<03gooOol09goo00<03gooOol08Goo00<007ooOol06goo000MOol01000Oomoo`0047oo00<0
07ooOol09goo00<03gooOol09Woo00<03gooOol09goo00<03gooOol09goo00<03gooOol08Goo00<0
07ooOol06goo000MOol01000Oomoo`0047oo0P00:7oo00<03gooOol09Woo00<03gooOol09goo00<0
3gooOol09goo00<03gooOol087oo0P007Goo000LOol5000@Ool00`00Oomoo`0WOol00`0?Oomoo`0V
Ool00`0?Oomoo`0WOol00`0?Oomoo`0WOol00`0?Oomoo`0QOol00`00Oomoo`0KOol0035oo`03001o
ogoo02Moo`0300moogoo02Ioo`0300moogoo02Moo`0300moogoo02Moo`0300moogoo025oo`03001o
ogoo01]oo`007Woo0`0047oo00<007ooOol09goo00<03gooOol09Woo00<03gooOol09goo00<03goo
Ool09goo00<03gooOol08Goo00<007ooOol06goo000NOol01000Oomoo`003goo0P00:7oo00<03goo
Ool09Woo00<03gooOol09goo00<03gooOol09goo00<03gooOol087oo0P007Goo000NOol00`00Oomo
o`0@Ool00`00Oomoo`0WOol00`0?Oomoo`0VOol00`0?Oomoo`0WOol00`0?Oomoo`0WOol00`0?Oomo
o`0QOol00`00Oomoo`0KOol001ioo`03001oogoo011oo`03001oogoo02Moo`0300moogoo02Ioo`03
00moogoo02Moo`0300moogoo02Moo`0300moogoo025oo`03001oogoo01]oo`007Goo100047oo0P00
:7oo00<03gooOol09Woo00<03gooOol09goo00<03gooOol09goo00<03gooOol087oo0P007Goo000N
Ool00`00Oomoo`09Ool20005Ool00`00Oomoo`0WOol00`0?Oomoo`0VOol00`0?Oomoo`0WOol00`0?
Oomoo`0WOol00`0?Oomoo`0QOol00`00Oomoo`0KOol001ioo`@000Moo`04001oogoo0004Ool00`00
Oomoo`0WOol00`0?Oomoo`0VOol00`0?Oomoo`0WOol00`0?Oomoo`0WOol00`0?Oomoo`0QOol00`00
Oomoo`0KOol001eoo`03001oogoo00Uoo`04001oogoo0004Ool2003700l3000MOol001eoo`D000Mo
o`<000Eoo`03001oogoo02Moo`0300moogoo02Ioo`0300moogoo02Moo`0300moogoo02Moo`0300mo
ogoo025oo`03001oogoo01]oo`007Goo00D007ooOomoo`0000Moo`03001oogoo00Eoo`03001oogoo
02Moo`0300moogoo02Ioo`0300moogoo02Moo`0300moogoo02Moo`0300moogoo025oo`03001oogoo
01]oo`007Woo0`002Goo0`0017oo00<007ooOol09goo00<03gooOol09Woo00<03gooOol09goo00<0
3gooOol09goo00<03gooOol08Goo00<007ooOol06goo000aOol2000XOol00`0?Oomoo`0VOol00`0?
Oomoo`0WOol00`0?Oomoo`0WOol00`0?Oomoo`0POol2000MOol001eoo`800003Ool0000000moo`03
001oogoo02Moo`0300moogoo02Ioo`0300moogoo02Moo`0300moogoo02Moo`0300moogoo025oo`03
001oogoo01]oo`007Goo00@007ooOol0011oo`03001oogoo02Moo`0300moogoo02Ioo`0300moogoo
02Moo`0300moogoo02Moo`0300moogoo025oo`03001oogoo01]oo`007Goo00@007ooOol0011oo`80
02Qoo`0300moogoo02Ioo`0300moogoo02Moo`0300moogoo02Moo`0300moogoo021oo`8001eoo`00
7Goo00@007ooOol0011oo`03001oogoo02Moo`0300moogoo02Ioo`0300moogoo02Moo`0300moogoo
02Moo`0300moogoo025oo`03001oogoo01]oo`0077oo1@0047oo00<007ooOol09goo00<03gooOol0
9Woo00<03gooOol09goo00<03gooOol09goo00<03gooOol08Goo00<007ooOol06goo000aOol2000X
Ool00`0?Oomoo`0VOol00`0?Oomoo`0WOol00`0?Oomoo`0WOol00`0?Oomoo`0POol2000MOol001io
o`<0011oo`03001oogoo02Moo`0300moogoo02Ioo`0300moogoo02Moo`0300moogoo02Moo`0300mo
ogoo025oo`03001oogoo01]oo`007Woo00@007ooOol000moo`03001oogoo02Moo`0300moogoo02Io
o`0300moogoo02Moo`0300moogoo02Moo`0300moogoo025oo`03001oogoo01]oo`007Woo00<007oo
Ool047oo00<007ooOol09goo00<03gooOol09Woo00<03gooOol09goo00<03gooOol09goo00<03goo
Ool08Goo00<007ooOol06goo000NOol00`00Oomoo`0@Ool2000XOol00`0?Oomoo`0VOol00`0?Oomo
o`0WOol00`0?Oomoo`0WOol00`0?Oomoo`0POol2000MOol001eoo`@000Uoo`8000Eoo`03001oogoo
02Moo`0300moogoo02Ioo`0300moogoo02Moo`0300moogoo02Moo`0300moogoo025oo`03001oogoo
01]oo`007Woo00<007ooOol027oo00@007ooOol000Aoo`03001oogoo02Moo`0300moogoo02Ioo`03
00moogoo02Moo`0300moogoo02Moo`0300moogoo025oo`03001oogoo01]oo`007Goo100027oo00@0
07ooOol000Aoo`800<L03`<001eoo`0087oo00<007ooOol01goo0P001Goo00<007ooOol09goo00<0
3gooOol09Woo00<03gooOol09goo00<03gooOol09goo00<03gooOol08Goo00<007ooOol06goo000M
Ool40008Ool01000Oomoo`0017oo00<007ooOol09goo00<03gooOol09Woo00<03gooOol09goo00<0
3gooOol09goo00<03gooOol08Goo00<007ooOol06goo000MOol00`00Oomoo`0:Ool20005Ool2000X
Ool00`0?Oomoo`0VOol00`0?Oomoo`0WOol00`0?Oomoo`0WOol00`0?Oomoo`0POol2000MOol001eo
o`@0011oo`03001oogoo02Moo`0300moogoo02Ioo`0300moogoo02Moo`0300moogoo02Moo`0300mo
ogoo025oo`03001oogoo01]oo`00<Goo00<007ooOol09goo00<03gooOol09Woo00<03gooOol09goo
00<03gooOol09goo00<03gooOol08Goo00<007ooOol06goo000aOol00`00Oomoo`0WOol00`0?Oomo
o`0VOol00`0?Oomoo`0WOol00`0?Oomoo`0WOol00`0?Oomoo`0QOol00`00Oomoo`0KOol0035oo`80
02Qoo`0300moogoo02Ioo`0300moogoo02Moo`0300moogoo02Moo`0300moogoo021oo`8001eoo`00
<Goo00<007ooOol09goo00<03gooOol09Woo00<03gooOol09goo00<03gooOol09goo00<03gooOol0
8Goo00<007ooOol06goo000aOol00`00Oomoo`0WOol00`0?Oomoo`0VOol00`0?Oomoo`0WOol00`0?
Oomoo`0WOol00`0?Oomoo`0QOol00`00Oomoo`0KOol0035oo`8002Qoo`0300moogoo02Ioo`0300mo
ogoo02Moo`0300moogoo02Moo`0300moogoo021oo`8001eoo`00<Goo00<007ooOol09goo00<03goo
Ool09Woo00<03gooOol09goo00<03gooOol09goo00<03gooOol08Goo00<007ooOol06goo000LOol2
0002Ool2000?Ool00`00Oomoo`0WOol00`0?Oomoo`0VOol00`0?Oomoo`0WOol00`0?Oomoo`0WOol0
0`0?Oomoo`0QOol00`00Oomoo`0KOol001eoo`04001oo`00000@Ool2000XOol00`0?Oomoo`0VOol0
0`0?Oomoo`0WOol00`0?Oomoo`0WOol00`0?Oomoo`0POol2000MOol001eoo`<0015oo`03001oogoo
02Moo`0300moogoo02Ioo`0300moogoo02Moo`0300moogoo02Moo`0300moogoo025oo`03001oogoo
01]oo`007Goo00@007ooOol0009oo`<000Aoo`8000Eoo`03001oogoo02Moo`0300moogoo02Ioo`03
00moogoo02Moo`0300moogoo02Moo`0300moogoo025oo`03001oogoo01]oo`007Goo00@007ooOol0
00=oo`03001oogoo009oo`04001oogoo0004Ool00`00Oomoo`0WOol00`0?Oomoo`0VOol00`0?Oomo
o`0WOol00`0?Oomoo`0WOol00`0?Oomoo`0QOol00`00Oomoo`0KOol001aoo`@000Aoo`03001oogoo
009oo`04001oogoo0004Ool2003700l3000MOol001ioo`@0009oo`03001oogoo009oo`04001oogoo
0004Ool00`00Oomoo`0WOol00`0?Oomoo`0VOol00`0?Oomoo`0WOol00`0?Oomoo`0WOol00`0?Oomo
o`0QOol00`00Oomoo`0KOol001eoo`03001oogoo00Aoo`03001oogoo009oo`04001oogoo0004Ool0
0`00Oomoo`0WOol00`0?Oomoo`0VOol00`0?Oomoo`0WOol00`0?Oomoo`0WOol00`0?Oomoo`0QOol0
0`00Oomoo`0KOol001eoo`D00003Ool0000000Eoo`8000Eoo`8002Qoo`0300moogoo02Ioo`0300mo
ogoo02Moo`0300moogoo02Moo`0300moogoo021oo`8001eoo`007Goo00D007ooOomoo`0000moo`03
001oogoo02Moo`0300moogoo02Ioo`0300moogoo02Moo`0300moogoo02Moo`0300moogoo025oo`03
001oogoo01]oo`007Woo0`0047oo00<007ooOol09goo00<03gooOol09Woo00<03gooOol09goo00<0
3gooOol09goo00<03gooOol08Goo00<007ooOol06goo000QOol00`00Oomoo`0=Ool2000XOol00`0?
Oomoo`0VOol00`0?Oomoo`0WOol00`0?Oomoo`0WOol00`0?Oomoo`0POol2000MOol001ioo`@000mo
o`03001oogoo02Moo`0300moogoo02Ioo`0300moogoo02Moo`0300moogoo02Moo`0300moogoo025o
o`03001oogoo01]oo`007Goo00D007ooOomoo`0000moo`03001oogoo02Moo`0300moogoo02Ioo`03
00moogoo02Moo`0300moogoo02Moo`0300moogoo025oo`03001oogoo01]oo`007Goo00D007ooOomo
o`0000moo`03001oogoo02Moo`0300moogoo02Ioo`0300moogoo02Moo`0300moogoo02Moo`0300mo
ogoo025oo`03001oogoo01]oo`007Goo00D007ooOomoo`0000moo`8002Qoo`0300moogoo02Ioo`03
00moogoo02Moo`0300moogoo02Moo`0300moogoo021oo`8001eoo`007Woo1@003Woo00<007ooOol0
9goo00<03gooOol09Woo00<03gooOol09goo00<03gooOol09goo00<03gooOol08Goo00<007ooOol0
6goo000aOol00`00Oomoo`0WOol00`0?Oomoo`0VOol00`0?Oomoo`0WOol00`0?Oomoo`0WOol00`0?
Oomoo`0QOol00`00Oomoo`0KOol001eoo`@0011oo`8002Qoo`0300moogoo02Ioo`0300moogoo02Mo
o`0300moogoo02Moo`0300moogoo021oo`8001eoo`007Woo00<007ooOol00Woo0`000goo100017oo
00<007ooOol09goo00<03gooOol09Woo00<03gooOol09goo00<03gooOol09goo00<03gooOol08Goo
00<007ooOol06goo000OOol00`00Oomoo`02Ool00`00Oomoo`03Ool00`00Oomoo`04Ool00`00Oomo
o`0WOol00`0?Oomoo`0VOol00`0?Oomoo`0WOol00`0?Oomoo`0WOol00`0?Oomoo`0QOol00`00Oomo
o`0KOol0021oo`05001oogooOol00006Ool00`00Oomoo`03Ool2003700l3000MOol001eoo`04001o
ogoo0003Ool00`00Oomoo`05Ool00`00Oomoo`02Ool00`00Oomoo`0WOol00`0?Oomoo`0VOol00`0?
Oomoo`0WOol00`0?Oomoo`0WOol00`0?Oomoo`0QOol00`00Oomoo`0KOol001ioo`8000Aoo`03001o
ogoo009oo`04001oogoo0004Ool00`00Oomoo`0WOol00`0?Oomoo`0VOol00`0?Oomoo`0WOol00`0?
Oomoo`0WOol00`0?Oomoo`0QOol00`00Oomoo`0KOol002=oo`8000Eoo`8000Eoo`03001oogoo02Mo
o`0300moogoo02Ioo`0300moogoo02Moo`0300moogoo02Moo`0300moogoo025oo`03001oogoo01]o
o`00<Goo0P00:7oo00<03gooOol09Woo00<03gooOol09goo00<03gooOol09goo00<03gooOol087oo
0P007Goo000aOol00`00Oomoo`0WOol00`0?Oomoo`0VOol00`0?Oomoo`0WOol00`0?Oomoo`0WOol0
0`0?Oomoo`0QOol00`00Oomoo`0KOol0035oo`03001oogoo02Moo`0300moogoo02Ioo`0300moogoo
02Moo`0300moogoo02Moo`0300moogoo025oo`03001oogoo01]oo`00<Goo0P00:7oo00<03gooOol0
9Woo00<03gooOol09goo00<03gooOol09goo00<03gooOol087oo0P007Goo000aOol00`00Oomoo`0W
Ool00`0?Oomoo`0VOol00`0?Oomoo`0WOol00`0?Oomoo`0WOol00`0?Oomoo`0QOol00`00Oomoo`0K
Ool0035oo`03001oogoo02Moo`0300moogoo02Ioo`0300moogoo02Moo`0300moogoo02Moo`0300mo
ogoo025oo`03001oogoo01]oo`00<Goo0P00:7oo00<03gooOol09Woo00<03gooOol09goo00<03goo
Ool09goo00<03gooOol087oo0P007Goo000aOol00`00Oomoo`0WOol00`0?Oomoo`0VOol00`0?Oomo
o`0WOol00`0?Oomoo`0WOol00`0?Oomoo`0QOol00`00Oomoo`0KOol0035oo`03001oogoo02Moo`03
00moogoo02Ioo`0300moogoo02Moo`0300moogoo02Moo`0300moogoo025oo`03001oogoo01]oo`00
<Goo00<007ooOol09goo00<03gooOol09Woo00<03gooOol09goo00<03gooOol09goo00<03gooOol0
8Goo00<007ooOol06goo000aOol2000XOol00`0?Oomoo`0VOol00`0?Oomoo`0WOol00`0?Oomoo`0W
Ool00`0?Oomoo`0POol2000MOol002=oo`<000Aoo`<000Aoo`03001oogoo02Moo`0300moogoo02Io
o`0300moogoo02Moo`0300moogoo02Moo`0300moogoo025oo`03001oogoo01]oo`0097oo00<007oo
Ool017oo00<007ooOol00goo00<007ooOol09goo00<03gooOol09Woo00<03gooOol09goo00<03goo
Ool09goo00<03gooOol08Goo00<007ooOol06goo000TOol00`00Oomoo`02Ool40004Ool2003700l3
000MOol002Aoo`03001oogoo009oo`03001oo`0000Eoo`03001oogoo02Moo`0300moogoo02Ioo`03
00moogoo02Moo`0300moogoo02Moo`0300moogoo025oo`03001oogoo01]oo`0097oo00<007ooOol0
0Woo00<007oo00001Goo00<007ooOol09goo00<03gooOol09Woo00<03gooOol09goo00<03gooOol0
9goo00<03gooOol08Goo00<007ooOol06goo000SOol20005Ool20005Ool2000XOol00`0?Oomoo`0V
Ool00`0?Oomoo`0WOol00`0?Oomoo`0WOol00`0?Oomoo`0POol2000MOol0035oo`03001oogoo02Mo
o`0300moogoo02Ioo`0300moogoo02Moo`0300moogoo02Moo`0300moogoo025oo`03001oogoo01]o
o`00<Goo00<007ooOol09goo00<03gooOol09Woo00<03gooOol09goo00<03gooOol09goo00<03goo
Ool08Goo00<007ooOol06goo000aOol00`00Oomoo`0WOol00`0?Oomoo`0VOol00`0?Oomoo`0WOol0
0`0?Oomoo`0WOol00`0?Oomoo`0QOol00`00Oomoo`0KOol0035oo`8002Qoo`03001oogoo02Ioo`03
001oogoo02Moo`03001oogoo02Moo`03001oogoo021oo`8001eoo`00<Gooc0007Goo003oOolKOol0
0?mooa]oo`00ogoo6goo003oOolKOol00?mooa]oo`00RGoo0`009goo0`008Woo00<007ooOol0?goo
002<Ool00`00Oomoo`0WOol00`00Oomoo`0OOol00`00Oomoo`08Ool00`00Oomoo`0dOol003Yoo`D0
0004Ool00000Ool200000goo000000030002Ool30002Ool500000goo0000000300000goo00000003
00000goo0000000300000goo000000020003Ool40006Ool20002Ool20002Ool40002Ool4000017oo
000000002Goo10001goo0P000Woo0P000Woo10000Woo100000=oo`0000000P0027oo1@0000=oo`00
00000P002Woo00<007ooOol00Woo0P0017oo00<007ooOol00goo0P00;goo000lOol01@00Oomoogoo
00000Woo00<007ooOol00Woo00<007ooOol00Woo00@007ooOol000=oo`05001oogooOol00002Ool0
0`00Oomoo`02Ool00`00Oomoo`03Ool00`00Oomoo`02Ool00`00Oomoo`02Ool00`00Oomoo`09Ool0
1000Ool000000Woo00<007ooOol00goo00D007ooOomoo`00009oo`03001oogoo00Qoo`03001oo`00
00Uoo`04001oo`000002Ool00`00Oomoo`03Ool01@00Oomoogoo00000Woo00<007ooOol027oo00@0
07ooOol000Eoo`03001oogoo00Qoo`05001oogooOol00002Ool00`00Oomoo`02Ool01@00Oomoogoo
00000Woo00@007oo000002]oo`00?7oo00D007ooOomoo`00009oo`03001oogoo009oo`03001oogoo
009oo`03001oogoo00Aoo`04001oogooOol40004Ool00`00Oomoo`03Ool00`00Oomoo`02Ool20003
Ool50007Ool30003Ool500000goo001oo`02Ool01000Oomoo`002Woo100027oo0`000goo1@0000=o
o`00Ool00Woo00D007ooOomoo`0000Uoo`@0009oo`@000Yoo`05001oogooOol00002Ool00`00Oomo
o`06Ool01000Oomoo`000goo0P00:Goo000lOol01@00Oomoogoo00000Woo00<007ooOol00Woo00<0
07ooOol00Woo00<007ooOol017oo00<007ooOol017oo00<007ooOol00Woo00<007ooOol00goo00<0
07ooOol00goo00D007ooOomoo`0000=oo`03001oogoo00Eoo`04001oogoo0002Ool01`00Oomoogoo
001oo`0000=oo`04001oogoo000;Ool00`00Oomoo`08Ool01000Oomoo`000Woo00L007ooOomoo`00
Ool00003Ool00`00Oomoo`02Ool00`00Oomoo`09Ool01000Oomoo`003Goo00D007ooOomoo`00009o
o`03001oogoo00Ioo`04001oogoo0005Ool00`00Oomoo`0VOol003aoo`03001oogoo00D000=oo`80
00=oo`@000=oo`8000Aoo`<000Aoo`03001oogoo009oo`8000=oo`@000=oo`<000Qoo`04001oogoo
0003Ool30003Ool500000goo001oo`0:Ool00`00Oomoo`08Ool01000Oomoo`000goo0`000goo1P00
0Woo00<007ooOol01goo0`000Woo10002Woo00D007ooOomoo`00009oo`03001oogoo00Ioo`04001o
ogoo0003Ool2000YOol003Yoo`D000ioo`03001oogoo011oo`03001oogoo01Qoo`@000moo`8000]o
o`8000Qoo`@0011oo`8001eoo`03001oogoo009oo`8000Yoo`80009oo`8002]oo`00B7oo00<007oo
Ool00Woo00<007ooOol017oo00<007ooOol01goo0`001Goo00<007ooOol0Kgoo00<007ooOol0?goo
003HOol00`00Oomoo`0oOol00001\
\>"],
  ImageRangeCache->{{{0, 281}, {173, 0}} -> {-59.0858, -3.91469, 1.19858, 
  0.119713}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-4.25007e-17 0.00411523 0 0.0412023 [
[(50)] .20576 0 0 2 0 Minner Mrotsboxa
[(100)] .41152 0 0 2 0 Minner Mrotsboxa
[(150)] .61728 0 0 2 0 Minner Mrotsboxa
[(200)] .82305 0 0 2 0 Minner Mrotsboxa
[(Contents of Reg1)] .5 0 0 2 0 0 -1 Mouter Mrotsboxa
[(0)] -0.0125 0 1 0 0 Minner Mrotsboxa
[(2)] -0.0125 .0824 1 0 0 Minner Mrotsboxa
[(4)] -0.0125 .16481 1 0 0 Minner Mrotsboxa
[(6)] -0.0125 .24721 1 0 0 Minner Mrotsboxa
[(8)] -0.0125 .32962 1 0 0 Minner Mrotsboxa
[(10)] -0.0125 .41202 1 0 0 Minner Mrotsboxa
[(12)] -0.0125 .49443 1 0 0 Minner Mrotsboxa
[(14)] -0.0125 .57683 1 0 0 Minner Mrotsboxa
[(Contents of Reg2)] -0.0125 .30902 1 0 90 -1 0 Mouter Mrotsboxa
[(Load Reg1 with 1/Sqrt[q] Sum[|a,0>, {a,0,q-1}])] .5 .61803 0 -2 Msboxa
[ -0.001 -0.001 0 0 ]
[ 1.001 .61903 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
[ ] 0 setdash
0 g
p
p
0 0 .5 r
.001 w
.20576 0 m
.20576 .61803 L
s
P
p
0 0 .5 r
.001 w
.41152 0 m
.41152 .61803 L
s
P
p
0 0 .5 r
.001 w
.61728 0 m
.61728 .61803 L
s
P
p
0 0 .5 r
.001 w
.82305 0 m
.82305 .61803 L
s
P
p
0 0 .5 r
.001 w
0 .0824 m
1 .0824 L
s
P
p
0 0 .5 r
.001 w
0 .16481 m
1 .16481 L
s
P
p
0 0 .5 r
.001 w
0 .24721 m
1 .24721 L
s
P
p
0 0 .5 r
.001 w
0 .32962 m
1 .32962 L
s
P
p
0 0 .5 r
.001 w
0 .41202 m
1 .41202 L
s
P
p
0 0 .5 r
.001 w
0 .49443 m
1 .49443 L
s
P
p
0 0 .5 r
.001 w
0 .57683 m
1 .57683 L
s
P
p
.002 w
.20576 0 m
.20576 .00625 L
s
P
[(50)] .20576 0 0 2 0 Minner Mrotshowa
p
.002 w
.41152 0 m
.41152 .00625 L
s
P
[(100)] .41152 0 0 2 0 Minner Mrotshowa
p
.002 w
.61728 0 m
.61728 .00625 L
s
P
[(150)] .61728 0 0 2 0 Minner Mrotshowa
p
.002 w
.82305 0 m
.82305 .00625 L
s
P
[(200)] .82305 0 0 2 0 Minner Mrotshowa
p
.001 w
.04115 0 m
.04115 .00375 L
s
P
p
.001 w
.0823 0 m
.0823 .00375 L
s
P
p
.001 w
.12346 0 m
.12346 .00375 L
s
P
p
.001 w
.16461 0 m
.16461 .00375 L
s
P
p
.001 w
.24691 0 m
.24691 .00375 L
s
P
p
.001 w
.28807 0 m
.28807 .00375 L
s
P
p
.001 w
.32922 0 m
.32922 .00375 L
s
P
p
.001 w
.37037 0 m
.37037 .00375 L
s
P
p
.001 w
.45267 0 m
.45267 .00375 L
s
P
p
.001 w
.49383 0 m
.49383 .00375 L
s
P
p
.001 w
.53498 0 m
.53498 .00375 L
s
P
p
.001 w
.57613 0 m
.57613 .00375 L
s
P
p
.001 w
.65844 0 m
.65844 .00375 L
s
P
p
.001 w
.69959 0 m
.69959 .00375 L
s
P
p
.001 w
.74074 0 m
.74074 .00375 L
s
P
p
.001 w
.78189 0 m
.78189 .00375 L
s
P
p
.001 w
.8642 0 m
.8642 .00375 L
s
P
p
.001 w
.90535 0 m
.90535 .00375 L
s
P
p
.001 w
.9465 0 m
.9465 .00375 L
s
P
p
.001 w
.98765 0 m
.98765 .00375 L
s
P
[(Contents of Reg1)] .5 0 0 2 0 0 -1 Mouter Mrotshowa
p
.002 w
0 0 m
1 0 L
s
P
p
.002 w
0 0 m
.00625 0 L
s
P
[(0)] -0.0125 0 1 0 0 Minner Mrotshowa
p
.002 w
0 .0824 m
.00625 .0824 L
s
P
[(2)] -0.0125 .0824 1 0 0 Minner Mrotshowa
p
.002 w
0 .16481 m
.00625 .16481 L
s
P
[(4)] -0.0125 .16481 1 0 0 Minner Mrotshowa
p
.002 w
0 .24721 m
.00625 .24721 L
s
P
[(6)] -0.0125 .24721 1 0 0 Minner Mrotshowa
p
.002 w
0 .32962 m
.00625 .32962 L
s
P
[(8)] -0.0125 .32962 1 0 0 Minner Mrotshowa
p
.002 w
0 .41202 m
.00625 .41202 L
s
P
[(10)] -0.0125 .41202 1 0 0 Minner Mrotshowa
p
.002 w
0 .49443 m
.00625 .49443 L
s
P
[(12)] -0.0125 .49443 1 0 0 Minner Mrotshowa
p
.002 w
0 .57683 m
.00625 .57683 L
s
P
[(14)] -0.0125 .57683 1 0 0 Minner Mrotshowa
p
.001 w
0 .01648 m
.00375 .01648 L
s
P
p
.001 w
0 .03296 m
.00375 .03296 L
s
P
p
.001 w
0 .04944 m
.00375 .04944 L
s
P
p
.001 w
0 .06592 m
.00375 .06592 L
s
P
p
.001 w
0 .09889 m
.00375 .09889 L
s
P
p
.001 w
0 .11537 m
.00375 .11537 L
s
P
p
.001 w
0 .13185 m
.00375 .13185 L
s
P
p
.001 w
0 .14833 m
.00375 .14833 L
s
P
p
.001 w
0 .18129 m
.00375 .18129 L
s
P
p
.001 w
0 .19777 m
.00375 .19777 L
s
P
p
.001 w
0 .21425 m
.00375 .21425 L
s
P
p
.001 w
0 .23073 m
.00375 .23073 L
s
P
p
.001 w
0 .26369 m
.00375 .26369 L
s
P
p
.001 w
0 .28018 m
.00375 .28018 L
s
P
p
.001 w
0 .29666 m
.00375 .29666 L
s
P
p
.001 w
0 .31314 m
.00375 .31314 L
s
P
p
.001 w
0 .3461 m
.00375 .3461 L
s
P
p
.001 w
0 .36258 m
.00375 .36258 L
s
P
p
.001 w
0 .37906 m
.00375 .37906 L
s
P
p
.001 w
0 .39554 m
.00375 .39554 L
s
P
p
.001 w
0 .4285 m
.00375 .4285 L
s
P
p
.001 w
0 .44498 m
.00375 .44498 L
s
P
p
.001 w
0 .46147 m
.00375 .46147 L
s
P
p
.001 w
0 .47795 m
.00375 .47795 L
s
P
p
.001 w
0 .51091 m
.00375 .51091 L
s
P
p
.001 w
0 .52739 m
.00375 .52739 L
s
P
p
.001 w
0 .54387 m
.00375 .54387 L
s
P
p
.001 w
0 .56035 m
.00375 .56035 L
s
P
p
.001 w
0 .59331 m
.00375 .59331 L
s
P
p
.001 w
0 .60979 m
.00375 .60979 L
s
P
[(Contents of Reg2)] -0.0125 .30902 1 0 90 -1 0 Mouter Mrotshowa
p
.002 w
0 0 m
0 .61803 L
s
P
P
p
p
.002 w
0 .61178 m
0 .61803 L
s
P
p
.002 w
.20576 .61178 m
.20576 .61803 L
s
P
p
.002 w
.41152 .61178 m
.41152 .61803 L
s
P
p
.002 w
.61728 .61178 m
.61728 .61803 L
s
P
p
.002 w
.82305 .61178 m
.82305 .61803 L
s
P
p
.001 w
.04115 .61428 m
.04115 .61803 L
s
P
p
.001 w
.0823 .61428 m
.0823 .61803 L
s
P
p
.001 w
.12346 .61428 m
.12346 .61803 L
s
P
p
.001 w
.16461 .61428 m
.16461 .61803 L
s
P
p
.001 w
.24691 .61428 m
.24691 .61803 L
s
P
p
.001 w
.28807 .61428 m
.28807 .61803 L
s
P
p
.001 w
.32922 .61428 m
.32922 .61803 L
s
P
p
.001 w
.37037 .61428 m
.37037 .61803 L
s
P
p
.001 w
.45267 .61428 m
.45267 .61803 L
s
P
p
.001 w
.49383 .61428 m
.49383 .61803 L
s
P
p
.001 w
.53498 .61428 m
.53498 .61803 L
s
P
p
.001 w
.57613 .61428 m
.57613 .61803 L
s
P
p
.001 w
.65844 .61428 m
.65844 .61803 L
s
P
p
.001 w
.69959 .61428 m
.69959 .61803 L
s
P
p
.001 w
.74074 .61428 m
.74074 .61803 L
s
P
p
.001 w
.78189 .61428 m
.78189 .61803 L
s
P
p
.001 w
.8642 .61428 m
.8642 .61803 L
s
P
p
.001 w
.90535 .61428 m
.90535 .61803 L
s
P
p
.001 w
.9465 .61428 m
.9465 .61803 L
s
P
p
.001 w
.98765 .61428 m
.98765 .61803 L
s
P
p
.002 w
0 .61803 m
1 .61803 L
s
P
[(Load Reg1 with 1/Sqrt[q] Sum[|a,0>, {a,0,q-1}])] .5 .61803 0 -2 Mshowa
p
.002 w
.99375 0 m
1 0 L
s
P
p
.002 w
.99375 .0824 m
1 .0824 L
s
P
p
.002 w
.99375 .16481 m
1 .16481 L
s
P
p
.002 w
.99375 .24721 m
1 .24721 L
s
P
p
.002 w
.99375 .32962 m
1 .32962 L
s
P
p
.002 w
.99375 .41202 m
1 .41202 L
s
P
p
.002 w
.99375 .49443 m
1 .49443 L
s
P
p
.002 w
.99375 .57683 m
1 .57683 L
s
P
p
.001 w
.99625 .01648 m
1 .01648 L
s
P
p
.001 w
.99625 .03296 m
1 .03296 L
s
P
p
.001 w
.99625 .04944 m
1 .04944 L
s
P
p
.001 w
.99625 .06592 m
1 .06592 L
s
P
p
.001 w
.99625 .09889 m
1 .09889 L
s
P
p
.001 w
.99625 .11537 m
1 .11537 L
s
P
p
.001 w
.99625 .13185 m
1 .13185 L
s
P
p
.001 w
.99625 .14833 m
1 .14833 L
s
P
p
.001 w
.99625 .18129 m
1 .18129 L
s
P
p
.001 w
.99625 .19777 m
1 .19777 L
s
P
p
.001 w
.99625 .21425 m
1 .21425 L
s
P
p
.001 w
.99625 .23073 m
1 .23073 L
s
P
p
.001 w
.99625 .26369 m
1 .26369 L
s
P
p
.001 w
.99625 .28018 m
1 .28018 L
s
P
p
.001 w
.99625 .29666 m
1 .29666 L
s
P
p
.001 w
.99625 .31314 m
1 .31314 L
s
P
p
.001 w
.99625 .3461 m
1 .3461 L
s
P
p
.001 w
.99625 .36258 m
1 .36258 L
s
P
p
.001 w
.99625 .37906 m
1 .37906 L
s
P
p
.001 w
.99625 .39554 m
1 .39554 L
s
P
p
.001 w
.99625 .4285 m
1 .4285 L
s
P
p
.001 w
.99625 .44498 m
1 .44498 L
s
P
p
.001 w
.99625 .46147 m
1 .46147 L
s
P
p
.001 w
.99625 .47795 m
1 .47795 L
s
P
p
.001 w
.99625 .51091 m
1 .51091 L
s
P
p
.001 w
.99625 .52739 m
1 .52739 L
s
P
p
.001 w
.99625 .54387 m
1 .54387 L
s
P
p
.001 w
.99625 .56035 m
1 .56035 L
s
P
p
.001 w
.99625 .59331 m
1 .59331 L
s
P
p
.001 w
.99625 .60979 m
1 .60979 L
s
P
p
.002 w
1 0 m
1 .61803 L
s
P
P
p
P
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
p
p
.02 w
0 0 Mdot
.00412 0 Mdot
.00823 0 Mdot
.01235 0 Mdot
.01646 0 Mdot
.02058 0 Mdot
.02469 0 Mdot
.02881 0 Mdot
.03292 0 Mdot
.03704 0 Mdot
.04115 0 Mdot
.04527 0 Mdot
.04938 0 Mdot
.0535 0 Mdot
.05761 0 Mdot
.06173 0 Mdot
.06584 0 Mdot
.06996 0 Mdot
.07407 0 Mdot
.07819 0 Mdot
.0823 0 Mdot
.08642 0 Mdot
.09053 0 Mdot
.09465 0 Mdot
.09877 0 Mdot
.10288 0 Mdot
.107 0 Mdot
.11111 0 Mdot
.11523 0 Mdot
.11934 0 Mdot
.12346 0 Mdot
.12757 0 Mdot
.13169 0 Mdot
.1358 0 Mdot
.13992 0 Mdot
.14403 0 Mdot
.14815 0 Mdot
.15226 0 Mdot
.15638 0 Mdot
.16049 0 Mdot
.16461 0 Mdot
.16872 0 Mdot
.17284 0 Mdot
.17695 0 Mdot
.18107 0 Mdot
.18519 0 Mdot
.1893 0 Mdot
.19342 0 Mdot
.19753 0 Mdot
.20165 0 Mdot
.20576 0 Mdot
.20988 0 Mdot
.21399 0 Mdot
.21811 0 Mdot
.22222 0 Mdot
.22634 0 Mdot
.23045 0 Mdot
.23457 0 Mdot
.23868 0 Mdot
.2428 0 Mdot
.24691 0 Mdot
.25103 0 Mdot
.25514 0 Mdot
.25926 0 Mdot
.26337 0 Mdot
.26749 0 Mdot
.2716 0 Mdot
.27572 0 Mdot
.27984 0 Mdot
.28395 0 Mdot
.28807 0 Mdot
.29218 0 Mdot
.2963 0 Mdot
.30041 0 Mdot
.30453 0 Mdot
.30864 0 Mdot
.31276 0 Mdot
.31687 0 Mdot
.32099 0 Mdot
.3251 0 Mdot
.32922 0 Mdot
.33333 0 Mdot
.33745 0 Mdot
.34156 0 Mdot
.34568 0 Mdot
.34979 0 Mdot
.35391 0 Mdot
.35802 0 Mdot
.36214 0 Mdot
.36626 0 Mdot
.37037 0 Mdot
.37449 0 Mdot
.3786 0 Mdot
.38272 0 Mdot
.38683 0 Mdot
.39095 0 Mdot
.39506 0 Mdot
.39918 0 Mdot
.40329 0 Mdot
.40741 0 Mdot
.41152 0 Mdot
.41564 0 Mdot
.41975 0 Mdot
.42387 0 Mdot
.42798 0 Mdot
.4321 0 Mdot
.43621 0 Mdot
.44033 0 Mdot
.44444 0 Mdot
.44856 0 Mdot
.45267 0 Mdot
.45679 0 Mdot
.46091 0 Mdot
.46502 0 Mdot
.46914 0 Mdot
.47325 0 Mdot
.47737 0 Mdot
.48148 0 Mdot
.4856 0 Mdot
.48971 0 Mdot
.49383 0 Mdot
.49794 0 Mdot
.50206 0 Mdot
.50617 0 Mdot
.51029 0 Mdot
.5144 0 Mdot
.51852 0 Mdot
.52263 0 Mdot
.52675 0 Mdot
.53086 0 Mdot
.53498 0 Mdot
.53909 0 Mdot
.54321 0 Mdot
.54733 0 Mdot
.55144 0 Mdot
.55556 0 Mdot
.55967 0 Mdot
.56379 0 Mdot
.5679 0 Mdot
.57202 0 Mdot
.57613 0 Mdot
.58025 0 Mdot
.58436 0 Mdot
.58848 0 Mdot
.59259 0 Mdot
.59671 0 Mdot
.60082 0 Mdot
.60494 0 Mdot
.60905 0 Mdot
.61317 0 Mdot
.61728 0 Mdot
.6214 0 Mdot
.62551 0 Mdot
.62963 0 Mdot
.63374 0 Mdot
.63786 0 Mdot
.64198 0 Mdot
.64609 0 Mdot
.65021 0 Mdot
.65432 0 Mdot
.65844 0 Mdot
.66255 0 Mdot
.66667 0 Mdot
.67078 0 Mdot
.6749 0 Mdot
.67901 0 Mdot
.68313 0 Mdot
.68724 0 Mdot
.69136 0 Mdot
.69547 0 Mdot
.69959 0 Mdot
.7037 0 Mdot
.70782 0 Mdot
.71193 0 Mdot
.71605 0 Mdot
.72016 0 Mdot
.72428 0 Mdot
.7284 0 Mdot
.73251 0 Mdot
.73663 0 Mdot
.74074 0 Mdot
.74486 0 Mdot
.74897 0 Mdot
.75309 0 Mdot
.7572 0 Mdot
.76132 0 Mdot
.76543 0 Mdot
.76955 0 Mdot
.77366 0 Mdot
.77778 0 Mdot
.78189 0 Mdot
.78601 0 Mdot
.79012 0 Mdot
.79424 0 Mdot
.79835 0 Mdot
.80247 0 Mdot
.80658 0 Mdot
.8107 0 Mdot
.81481 0 Mdot
.81893 0 Mdot
.82305 0 Mdot
.82716 0 Mdot
.83128 0 Mdot
.83539 0 Mdot
.83951 0 Mdot
.84362 0 Mdot
.84774 0 Mdot
.85185 0 Mdot
.85597 0 Mdot
.86008 0 Mdot
.8642 0 Mdot
.86831 0 Mdot
.87243 0 Mdot
.87654 0 Mdot
.88066 0 Mdot
.88477 0 Mdot
.88889 0 Mdot
.893 0 Mdot
.89712 0 Mdot
.90123 0 Mdot
.90535 0 Mdot
.90947 0 Mdot
.91358 0 Mdot
.9177 0 Mdot
.92181 0 Mdot
.92593 0 Mdot
.93004 0 Mdot
.93416 0 Mdot
.93827 0 Mdot
.94239 0 Mdot
.9465 0 Mdot
.95062 0 Mdot
.95473 0 Mdot
.95885 0 Mdot
.96296 0 Mdot
.96708 0 Mdot
.97119 0 Mdot
.97531 0 Mdot
.97942 0 Mdot
.98354 0 Mdot
.98765 0 Mdot
.99177 0 Mdot
.99588 0 Mdot
P
P
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  Evaluatable->False,
  AspectRatioFixed->True,
  ImageSize->{282, 174},
  ImageMargins->{{34, Inherited}, {Inherited, Inherited}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004J0000[Q000`40O003h00Oogoo6goo003oOolK
Ool00;9oo`<006Eoo`00]Goo00<007ooOol0HWoo001MOol40003Ool30002Ool200000goo00000002
Ool30003Ool4000017oo000007oo0P000Woo0`000Woo10002Goo0`000Woo10001goo0P000Woo0P00
0Woo10000Woo100000Aoo`000000061oo`00G7oo00<007ooOol017oo00L007ooOomoo`00Ool00002
Ool01@00Oomoogoo00000Woo00<007oo00001Goo00@007ooOol000=oo`04001oogoo0004Ool00`00
Oomoo`06Ool01@00Oomoogoo00000Woo00<007ooOol027oo00@007oo0000009oo`03001oogoo00=o
o`05001oogooOol00002Ool00`00Oomoo`1OOol005aoo`03001oogoo00Aoo`07001oogooOol007oo
00000Woo00D007ooOomoo`0000Aoo`D00005Ool007ooOol00003Ool00`00Oomoo`02Ool40008Ool0
1@00Oomoogoo00000Woo00<007ooOol027oo0`000goo1@0000=oo`00Ool00Woo00@007ooOol0065o
o`00G7oo00<007ooOol017oo00L007ooOomoo`00Ool00002Ool01@00Oomoogoo000017oo00L007oo
Oomoo`00Ool00002Ool01@00Oomoogoo000017oo00<007ooOol02Goo00D007ooOomoo`00009oo`03
001oogoo00Qoo`04001oogoo0002Ool01`00Oomoogoo001oo`0000=oo`04001oogoo001QOol005ao
o`05001oogooOol00003Ool300000goo000000030002Ool40003Ool300000goo000000030002Ool4
0002Ool40009Ool30002Ool40008Ool01000Oomoo`000goo0`000goo1@0000=oo`00Ool0H7oo001M
Ool4000?Ool00`00Oomoo`0?Ool00`00Oomoo`0EOol00`00Oomoo`07Ool4000?Ool2001QOol0071o
o`03001oogoo00moo`03001oogoo01Eoo`<007eoo`00ogoo6goo003oOolKOol00?mooa]oo`00ogoo
6goo003oOolKOol00?mooa]oo`00ogoo6goo003oOolKOol00?mooa]oo`00ogoo6goo001;Ool30004
Ool2000NOol30004Ool20004Ool2000KOol30003Ool30004Ool2000JOol40003Ool20004Ool20016
Ool004ioo`04001oogoo0002Ool00`00Oomoo`0LOol00`00Oomoo`02Ool01000Oomoo`000Woo00@0
07ooOol001]oo`03001oogoo00Eoo`04001oogoo0002Ool00`00Oomoo`0HOol00`00Oomoo`02Ool0
1000Oomoo`000Woo00@007ooOol004Eoo`00CWoo00@007ooOol0009oo`03001oogoo01aoo`03001o
ogoo009oo`04001oogoo0002Ool01000Oomoo`006goo00<007ooOol01Goo00@007ooOol0009oo`03
001oogoo01Uoo`05001oogooOol00002Ool01000Oomoo`000Woo00<007ooOol0@goo001;Ool30003
Ool01000Oomoo`007Woo00<007ooOol00Woo00@007ooOol0009oo`04001oogoo000KOol00`00Oomo
o`02Ool30003Ool01000Oomoo`0077oo00@007ooOol0009oo`04001oogoo0002Ool00`00Oomoo`13
Ool004]oo`03001oogoo00=oo`04001oogoo000NOol00`00Oomoo`02Ool01000Oomoo`000Woo00@0
07ooOol001]oo`03001oogoo009oo`03001oogoo00=oo`04001oogoo000IOol01000Oomoo`000Woo
00@007ooOol0009oo`04001oogoo0015Ool004]oo`@000=oo`8001ioo`8000Eoo`8000Aoo`8001]o
o`8000Aoo`@000=oo`8001]oo`8000Aoo`8000Aoo`8004Ioo`00ogoo6goo003oOolKOol00?mooa]o
o`00ogoo6goo000POol2003hOol001moo`04001oogoo0003Ooo<000XOol001moo`04001oogoo0002
Ooo>000WOol001moo`04001oogoo0002Ooo>000WOol001moo`04001oogoo0003Ooo<000XOol0021o
o`8000Eoo`03001oogoo02Ioo`0300moogoo02Moo`0300moogoo02Moo`0300moogoo02Ioo`0300mo
ogoo025oo`03001oogoo02Ioo`009goo00<007ooOol09Woo00<03gooOol09goo00<03gooOol09goo
00<03gooOol09Woo00<03gooOol08Goo00<007ooOol09Woo000WOol00`00Oomoo`0VOol00`0?Oomo
o`0WOol00`0?Oomoo`0WOol00`0?Oomoo`0VOol00`0?Oomoo`0QOol00`00Oomoo`0VOol002Moo`03
001oogoo02Ioo`0300moogoo02Moo`0300moogoo02Moo`0300moogoo02Ioo`0300moogoo025oo`03
001oogoo02Ioo`009goo00<007ooOol09Woo00<03gooOol09goo00<03gooOol09goo00<03gooOol0
9Woo00<03gooOol08Goo00<007ooOol09Woo000WOol00`00Oomoo`0VOol00`0?Oomoo`0WOol00`0?
Oomoo`0WOol00`0?Oomoo`0VOol00`0?Oomoo`0QOol00`00Oomoo`0VOol002Moo`03001oogoo02Io
o`0300moogoo02Moo`0300moogoo02Moo`0300moogoo02Ioo`0300moogoo025oo`03001oogoo02Io
o`009goo00<007ooOol09Woo00<03gooOol09goo00<03gooOol09goo00<03gooOol09Woo00<03goo
Ool08Goo00<007ooOol09Woo000WOol00`00Oomoo`0VOol00`0?Oomoo`0WOol00`0?Oomoo`0WOol0
0`0?Oomoo`0VOol00`0?Oomoo`0QOol00`00Oomoo`0VOol002Moo`03001oogoo02Ioo`0300moogoo
02Moo`0300moogoo02Moo`0300moogoo02Ioo`0300moogoo025oo`03001oogoo02Ioo`009goo00<0
07ooOol09Woo00<03gooOol09goo00<03gooOol09goo00<03gooOol09Woo00<03gooOol08Goo00<0
07ooOol09Woo000WOol00`00Oomoo`0VOol00`0?Oomoo`0WOol00`0?Oomoo`0WOol00`0?Oomoo`0V
Ool00`0?Oomoo`0QOol00`00Oomoo`0VOol001moo`@000Aoo`03001oogoo02Ioo`0300moogoo02Mo
o`0300moogoo02Moo`0300moogoo02Ioo`0300moogoo025oo`03001oogoo02Ioo`004goo10002Goo
00<007ooOol017oo00<007ooOol09Woo00<03gooOol09goo00<03gooOol09goo00<03gooOol09Woo
00<03gooOol08Goo00<007ooOol09Woo000BOol00`00Oomoo`0<Ool00`00Oomoo`03Ool2003700l2
000XOol0019oo`03001oogoo00eoo`03001oogoo009oo`03001oogoo02Ioo`0300moogoo02Moo`03
00moogoo02Moo`0300moogoo02Ioo`0300moogoo025oo`03001oogoo02Ioo`004Woo00<007ooOol0
2Woo00@007ooOol000Aoo`03001oogoo02Ioo`0300moogoo02Moo`0300moogoo02Moo`0300moogoo
02Ioo`0300moogoo025oo`03001oogoo02Ioo`004Woo00D007ooOomoo`0000Uoo`8000Eoo`03001o
ogoo02Ioo`0300moogoo02Moo`0300moogoo02Moo`0300moogoo02Ioo`0300moogoo025oo`03001o
ogoo02Ioo`004goo100047oo00<007ooOol09Woo00<03gooOol09goo00<03gooOol09goo00<03goo
Ool09Woo00<03gooOol08Goo00<007ooOol09Woo000DOol3000@Ool00`00Oomoo`0VOol00`0?Oomo
o`0WOol00`0?Oomoo`0WOol00`0?Oomoo`0VOol00`0?Oomoo`0QOol00`00Oomoo`0VOol001=oo`05
001oogooOol0000?Ool00`00Oomoo`0VOol00`0?Oomoo`0WOol00`0?Oomoo`0WOol00`0?Oomoo`0V
Ool00`0?Oomoo`0QOol00`00Oomoo`0VOol001=oo`05001oogooOol0000?Ool00`00Oomoo`0VOol0
0`0?Oomoo`0WOol00`0?Oomoo`0WOol00`0?Oomoo`0VOol00`0?Oomoo`0QOol00`00Oomoo`0VOol0
01=oo`05001oogooOol0000?Ool00`00Oomoo`0VOol00`0?Oomoo`0WOol00`0?Oomoo`0WOol00`0?
Oomoo`0VOol00`0?Oomoo`0QOol00`00Oomoo`0VOol001Aoo`<0011oo`03001oogoo02Ioo`0300mo
ogoo02Moo`0300moogoo02Moo`0300moogoo02Ioo`0300moogoo025oo`03001oogoo02Ioo`009goo
00<007ooOol09Woo00<03gooOol09goo00<03gooOol09goo00<03gooOol09Woo00<03gooOol08Goo
00<007ooOol09Woo000COol200000goo0000000?Ool00`00Oomoo`0VOol00`0?Oomoo`0WOol00`0?
Oomoo`0WOol00`0?Oomoo`0VOol00`0?Oomoo`0QOol00`00Oomoo`0VOol001=oo`04001oogoo000@
Ool00`00Oomoo`0VOol00`0?Oomoo`0WOol00`0?Oomoo`0WOol00`0?Oomoo`0VOol00`0?Oomoo`0Q
Ool00`00Oomoo`0VOol001=oo`04001oogoo000@Ool00`00Oomoo`0VOol00`0?Oomoo`0WOol00`0?
Oomoo`0WOol00`0?Oomoo`0VOol00`0?Oomoo`0QOol00`00Oomoo`0VOol001=oo`04001oogoo000@
Ool00`00Oomoo`0VOol00`0?Oomoo`0WOol00`0?Oomoo`0WOol00`0?Oomoo`0VOol00`0?Oomoo`0Q
Ool00`00Oomoo`0VOol0019oo`D000Uoo`<000Aoo`03001oogoo02Ioo`0300moogoo02Moo`0300mo
ogoo02Moo`0300moogoo02Ioo`0300moogoo025oo`03001oogoo02Ioo`008Goo00<007ooOol00goo
00<007ooOol09Woo00<03gooOol09goo00<03gooOol09goo00<03gooOol09Woo00<03gooOol08Goo
00<007ooOol09Woo000DOol30008Ool40004Ool2003700l2000XOol001Aoo`04001oogoo0007Ool0
0`00Ool00005Ool00`00Oomoo`0VOol00`0?Oomoo`0WOol00`0?Oomoo`0WOol00`0?Oomoo`0VOol0
0`0?Oomoo`0QOol00`00Oomoo`0VOol001Aoo`03001oogoo00Qoo`03001oo`0000Eoo`03001oogoo
02Ioo`0300moogoo02Moo`0300moogoo02Moo`0300moogoo02Ioo`0300moogoo025oo`03001oogoo
02Ioo`0057oo00<007ooOol02Goo0P001Goo00<007ooOol09Woo00<03gooOol09goo00<03gooOol0
9goo00<03gooOol09Woo00<03gooOol08Goo00<007ooOol09Woo000COol4000@Ool00`00Oomoo`0V
Ool00`0?Oomoo`0WOol00`0?Oomoo`0WOol00`0?Oomoo`0VOol00`0?Oomoo`0QOol00`00Oomoo`0V
Ool001Aoo`03001oogoo011oo`03001oogoo02Ioo`0300moogoo02Moo`0300moogoo02Moo`0300mo
ogoo02Ioo`0300moogoo025oo`03001oogoo02Ioo`0057oo10003goo00<007ooOol09Woo00<03goo
Ool09goo00<03gooOol09goo00<03gooOol09Woo00<03gooOol08Goo00<007ooOol09Woo000COol0
0`00Oomoo`0AOol00`00Oomoo`0VOol00`0?Oomoo`0WOol00`0?Oomoo`0WOol00`0?Oomoo`0VOol0
0`0?Oomoo`0QOol00`00Oomoo`0VOol001=oo`D000moo`03001oogoo02Ioo`0300moogoo02Moo`03
00moogoo02Moo`0300moogoo02Ioo`0300moogoo025oo`03001oogoo02Ioo`004goo00D007ooOomo
o`0000moo`03001oogoo02Ioo`0300moogoo02Moo`0300moogoo02Moo`0300moogoo02Ioo`0300mo
ogoo025oo`03001oogoo02Ioo`0057oo0`0047oo00<007ooOol09Woo00<03gooOol09goo00<03goo
Ool09goo00<03gooOol09Woo00<03gooOol08Goo00<007ooOol09Woo000WOol00`00Oomoo`0VOol0
0`0?Oomoo`0WOol00`0?Oomoo`0WOol00`0?Oomoo`0VOol00`0?Oomoo`0QOol00`00Oomoo`0VOol0
01=oo`800003Ool0000000moo`03001oogoo02Ioo`0300moogoo02Moo`0300moogoo02Moo`0300mo
ogoo02Ioo`0300moogoo025oo`03001oogoo02Ioo`004goo00@007ooOol0011oo`03001oogoo02Io
o`0300moogoo02Moo`0300moogoo02Moo`0300moogoo02Ioo`0300moogoo025oo`03001oogoo02Io
o`004goo00@007ooOol000Uoo`8000Eoo`03001oogoo02Ioo`0300moogoo02Moo`0300moogoo02Mo
o`0300moogoo02Ioo`0300moogoo025oo`03001oogoo02Ioo`004goo00@007ooOol000Qoo`04001o
ogoo0004Ool00`00Oomoo`0VOol00`0?Oomoo`0WOol00`0?Oomoo`0WOol00`0?Oomoo`0VOol00`0?
Oomoo`0QOol00`00Oomoo`0VOol0019oo`D000Qoo`04001oogoo0004Ool2003700l2000XOol001mo
o`<000Eoo`03001oogoo02Ioo`0300moogoo02Moo`0300moogoo02Moo`0300moogoo02Ioo`0300mo
ogoo025oo`03001oogoo02Ioo`0057oo0`0027oo00<007ooOol01Goo00<007ooOol09Woo00<03goo
Ool09goo00<03gooOol09goo00<03gooOol09Woo00<03gooOol08Goo00<007ooOol09Woo000DOol0
1000Oomoo`0027oo0`0017oo00<007ooOol09Woo00<03gooOol09goo00<03gooOol09goo00<03goo
Ool09Woo00<03gooOol08Goo00<007ooOol09Woo000DOol00`00Oomoo`0@Ool00`00Oomoo`0VOol0
0`0?Oomoo`0WOol00`0?Oomoo`0WOol00`0?Oomoo`0VOol00`0?Oomoo`0QOol00`00Oomoo`0VOol0
01Aoo`03001oogoo011oo`03001oogoo02Ioo`0300moogoo02Moo`0300moogoo02Moo`0300moogoo
02Ioo`0300moogoo025oo`03001oogoo02Ioo`004goo100047oo00<007ooOol09Woo00<03gooOol0
9goo00<03gooOol09goo00<03gooOol09Woo00<03gooOol08Goo00<007ooOol09Woo000DOol00`00
Oomoo`0@Ool00`00Oomoo`0VOol00`0?Oomoo`0WOol00`0?Oomoo`0WOol00`0?Oomoo`0VOol00`0?
Oomoo`0QOol00`00Oomoo`0VOol001=oo`@0011oo`03001oogoo02Ioo`0300moogoo02Moo`0300mo
ogoo02Moo`0300moogoo02Ioo`0300moogoo025oo`03001oogoo02Ioo`005Woo00<007ooOol03Woo
00<007ooOol09Woo00<03gooOol09goo00<03gooOol09goo00<03gooOol09Woo00<03gooOol08Goo
00<007ooOol09Woo000COol4000@Ool00`00Oomoo`0VOol00`0?Oomoo`0WOol00`0?Oomoo`0WOol0
0`0?Oomoo`0VOol00`0?Oomoo`0QOol00`00Oomoo`0VOol001=oo`03001oogoo015oo`03001oogoo
02Ioo`0300moogoo02Moo`0300moogoo02Moo`0300moogoo02Ioo`0300moogoo025oo`03001oogoo
02Ioo`004goo100047oo00<007ooOol09Woo00<03gooOol09goo00<03gooOol09goo00<03gooOol0
9Woo00<03gooOol08Goo00<007ooOol09Woo000WOol00`00Oomoo`0VOol00`0?Oomoo`0WOol00`0?
Oomoo`0WOol00`0?Oomoo`0VOol00`0?Oomoo`0QOol00`00Oomoo`0VOol002Moo`03001oogoo02Io
o`0300moogoo02Moo`0300moogoo02Moo`0300moogoo02Ioo`0300moogoo025oo`03001oogoo02Io
o`0087oo0P001Goo00<007ooOol09Woo00<03gooOol09goo00<03gooOol09goo00<03gooOol09Woo
00<03gooOol08Goo00<007ooOol09Woo000OOol01000Oomoo`0017oo00<007ooOol09Woo00<03goo
Ool09goo00<03gooOol09goo00<03gooOol09Woo00<03gooOol08Goo00<007ooOol09Woo000OOol0
1000Oomoo`0017oo0P00a`0?0P00:7oo000POol20005Ool00`00Oomoo`0VOol00`0?Oomoo`0WOol0
0`0?Oomoo`0WOol00`0?Oomoo`0VOol00`0?Oomoo`0QOol00`00Oomoo`0VOol001moo`04001oogoo
0004Ool00`00Oomoo`0VOol00`0?Oomoo`0WOol00`0?Oomoo`0WOol00`0?Oomoo`0VOol00`0?Oomo
o`0QOol00`00Oomoo`0VOol001Aoo`<000Uoo`8000Eoo`03001oogoo02Ioo`0300moogoo02Moo`03
00moogoo02Moo`0300moogoo02Ioo`0300moogoo025oo`03001oogoo02Ioo`004goo00D007ooOomo
o`0000moo`03001oogoo02Ioo`0300moogoo02Moo`0300moogoo02Moo`0300moogoo02Ioo`0300mo
ogoo025oo`03001oogoo02Ioo`004goo00D007ooOomoo`0000moo`03001oogoo02Ioo`0300moogoo
02Moo`0300moogoo02Moo`0300moogoo02Ioo`0300moogoo025oo`03001oogoo02Ioo`004goo00D0
07ooOomoo`0000moo`03001oogoo02Ioo`0300moogoo02Moo`0300moogoo02Moo`0300moogoo02Io
o`0300moogoo025oo`03001oogoo02Ioo`0057oo0`0047oo00<007ooOol09Woo00<03gooOol09goo
00<03gooOol09goo00<03gooOol09Woo00<03gooOol08Goo00<007ooOol09Woo000WOol00`00Oomo
o`0VOol00`0?Oomoo`0WOol00`0?Oomoo`0WOol00`0?Oomoo`0VOol00`0?Oomoo`0QOol00`00Oomo
o`0VOol001=oo`@0011oo`03001oogoo02Ioo`0300moogoo02Moo`0300moogoo02Moo`0300moogoo
02Ioo`0300moogoo025oo`03001oogoo02Ioo`0057oo00<007ooOol047oo00<007ooOol09Woo00<0
3gooOol09goo00<03gooOol09goo00<03gooOol09Woo00<03gooOol08Goo00<007ooOol09Woo000D
Ool00`00Oomoo`0@Ool00`00Oomoo`0VOol00`0?Oomoo`0WOol00`0?Oomoo`0WOol00`0?Oomoo`0V
Ool00`0?Oomoo`0QOol00`00Oomoo`0VOol001Aoo`03001oogoo011oo`03001oogoo02Ioo`0300mo
ogoo02Moo`0300moogoo02Moo`0300moogoo02Ioo`0300moogoo025oo`03001oogoo02Ioo`004goo
100047oo00<007ooOol09Woo00<03gooOol09goo00<03gooOol09goo00<03gooOol09Woo00<03goo
Ool08Goo00<007ooOol09Woo000DOol00`00Oomoo`0@Ool00`00Oomoo`0VOol00`0?Oomoo`0WOol0
0`0?Oomoo`0WOol00`0?Oomoo`0VOol00`0?Oomoo`0QOol00`00Oomoo`0VOol001Aoo`<0009oo`<0
00Aoo`8000Eoo`03001oogoo02Ioo`0300moogoo02Moo`0300moogoo02Moo`0300moogoo02Ioo`03
00moogoo025oo`03001oogoo02Ioo`006Woo00<007ooOol00Woo00@007ooOol000Aoo`03001oogoo
02Ioo`0300moogoo02Moo`0300moogoo02Moo`0300moogoo02Ioo`0300moogoo025oo`03001oogoo
02Ioo`006Woo00<007ooOol00Woo00@007ooOol000Aoo`800<L03`8002Qoo`006Woo00<007ooOol0
0Woo00@007ooOol000Aoo`03001oogoo02Ioo`0300moogoo02Moo`0300moogoo02Moo`0300moogoo
02Ioo`0300moogoo025oo`03001oogoo02Ioo`006Woo00<007ooOol00Woo00@007ooOol000Aoo`03
001oogoo02Ioo`0300moogoo02Moo`0300moogoo02Moo`0300moogoo02Ioo`0300moogoo025oo`03
001oogoo02Ioo`006Goo0P001Goo0P001Goo00<007ooOol09Woo00<03gooOol09goo00<03gooOol0
9goo00<03gooOol09Woo00<03gooOol08Goo00<007ooOol09Woo000BOol20002Ool2000?Ool00`00
Oomoo`0VOol00`0?Oomoo`0WOol00`0?Oomoo`0WOol00`0?Oomoo`0VOol00`0?Oomoo`0QOol00`00
Oomoo`0VOol001=oo`04001oo`00000@Ool00`00Oomoo`0VOol00`0?Oomoo`0WOol00`0?Oomoo`0W
Ool00`0?Oomoo`0VOol00`0?Oomoo`0QOol00`00Oomoo`0VOol001=oo`<0015oo`03001oogoo02Io
o`0300moogoo02Moo`0300moogoo02Moo`0300moogoo02Ioo`0300moogoo025oo`03001oogoo02Io
o`004goo00@007ooOol0011oo`03001oogoo02Ioo`0300moogoo02Moo`0300moogoo02Moo`0300mo
ogoo02Ioo`0300moogoo025oo`03001oogoo02Ioo`004goo00@007ooOol0011oo`03001oogoo02Io
o`0300moogoo02Moo`0300moogoo02Moo`0300moogoo02Ioo`0300moogoo025oo`03001oogoo02Io
o`004Woo10004Goo00<007ooOol09Woo00<03gooOol09goo00<03gooOol09goo00<03gooOol09Woo
00<03gooOol08Goo00<007ooOol09Woo000DOol4000?Ool00`00Oomoo`0VOol00`0?Oomoo`0WOol0
0`0?Oomoo`0WOol00`0?Oomoo`0VOol00`0?Oomoo`0QOol00`00Oomoo`0VOol001=oo`03001oogoo
015oo`03001oogoo02Ioo`0300moogoo02Moo`0300moogoo02Moo`0300moogoo02Ioo`0300moogoo
025oo`03001oogoo02Ioo`004goo1@003goo00<007ooOol09Woo00<03gooOol09goo00<03gooOol0
9goo00<03gooOol09Woo00<03gooOol08Goo00<007ooOol09Woo000COol01@00Oomoogoo00003goo
00<007ooOol09Woo00<03gooOol09goo00<03gooOol09goo00<03gooOol09Woo00<03gooOol08Goo
00<007ooOol09Woo000DOol30002Ool30003Ool40004Ool00`00Oomoo`0VOol00`0?Oomoo`0WOol0
0`0?Oomoo`0WOol00`0?Oomoo`0VOol00`0?Oomoo`0QOol00`00Oomoo`0VOol001Moo`04001oogoo
0005Ool00`00Oomoo`04Ool00`00Oomoo`0VOol00`0?Oomoo`0WOol00`0?Oomoo`0WOol00`0?Oomo
o`0VOol00`0?Oomoo`0QOol00`00Oomoo`0VOol001Aoo`@0009oo`03001oogoo00Aoo`03001oogoo
00=oo`800<L03`8002Qoo`004goo00D007ooOomoo`00009oo`03001oogoo00Eoo`03001oogoo009o
o`03001oogoo02Ioo`0300moogoo02Moo`0300moogoo02Moo`0300moogoo02Ioo`0300moogoo025o
o`03001oogoo02Ioo`004goo00D007ooOomoo`00009oo`03001oogoo009oo`04001oogoo0004Ool0
0`00Oomoo`0VOol00`0?Oomoo`0WOol00`0?Oomoo`0WOol00`0?Oomoo`0VOol00`0?Oomoo`0QOol0
0`00Oomoo`0VOol001=oo`06001oogooOol007oo0P001Goo0P001Goo00<007ooOol09Woo00<03goo
Ool09goo00<03gooOol09goo00<03gooOol09Woo00<03gooOol08Goo00<007ooOol09Woo000DOol5
000>Ool00`00Oomoo`0VOol00`0?Oomoo`0WOol00`0?Oomoo`0WOol00`0?Oomoo`0VOol00`0?Oomo
o`0QOol00`00Oomoo`0VOol002Moo`03001oogoo02Ioo`0300moogoo02Moo`0300moogoo02Moo`03
00moogoo02Ioo`0300moogoo025oo`03001oogoo02Ioo`004goo100047oo00<007ooOol09Woo00<0
3gooOol09goo00<03gooOol09goo00<03gooOol09Woo00<03gooOol08Goo00<007ooOol09Woo000D
Ool00`00Oomoo`0@Ool00`00Oomoo`0VOol00`0?Oomoo`0WOol00`0?Oomoo`0WOol00`0?Oomoo`0V
Ool00`0?Oomoo`0QOol00`00Oomoo`0VOol001Eoo`03001oogoo00moo`03001oogoo02Ioo`0300mo
ogoo02Moo`0300moogoo02Moo`0300moogoo02Ioo`0300moogoo025oo`03001oogoo02Ioo`005Woo
00<007ooOol03Woo00<007ooOol09Woo00<03gooOol09goo00<03gooOol09goo00<03gooOol09Woo
00<03gooOol08Goo00<007ooOol09Woo000COol01000Oomoo`0047oo00<007ooOol09Woo00<03goo
Ool09goo00<03gooOol09goo00<03gooOol09Woo00<03gooOol08Goo00<007ooOol09Woo000DOol2
000AOol00`00Oomoo`0VOol00`0?Oomoo`0WOol00`0?Oomoo`0WOol00`0?Oomoo`0VOol00`0?Oomo
o`0QOol00`00Oomoo`0VOol002Moo`03001oogoo02Ioo`0300moogoo02Moo`0300moogoo02Moo`03
00moogoo02Ioo`0300moogoo025oo`03001oogoo02Ioo`009goo00<007ooOol09Woo00<03gooOol0
9goo00<03gooOol09goo00<03gooOol09Woo00<03gooOol08Goo00<007ooOol09Woo000WOol00`00
Oomoo`0VOol00`0?Oomoo`0WOol00`0?Oomoo`0WOol00`0?Oomoo`0VOol00`0?Oomoo`0QOol00`00
Oomoo`0VOol001Uoo`<000Aoo`<000Aoo`03001oogoo02Ioo`0300moogoo02Moo`0300moogoo02Mo
o`0300moogoo02Ioo`0300moogoo025oo`03001oogoo02Ioo`006Woo00<007ooOol017oo00<007oo
Ool00goo00<007ooOol09Woo00<03gooOol09goo00<03gooOol09goo00<03gooOol09Woo00<03goo
Ool08Goo00<007ooOol09Woo000JOol00`00Oomoo`02Ool40004Ool2003700l2000XOol001Yoo`03
001oogoo009oo`03001oo`0000Eoo`03001oogoo02Ioo`0300moogoo02Moo`0300moogoo02Moo`03
00moogoo02Ioo`0300moogoo025oo`03001oogoo02Ioo`006Woo00<007ooOol00Woo00<007oo0000
1Goo00<007ooOol09Woo00<03gooOol09goo00<03gooOol09goo00<03gooOol09Woo00<03gooOol0
8Goo00<007ooOol09Woo000IOol20005Ool20005Ool00`00Oomoo`0VOol00`0?Oomoo`0WOol00`0?
Oomoo`0WOol00`0?Oomoo`0VOol00`0?Oomoo`0QOol00`00Oomoo`0VOol002Moo`03001oogoo02Io
o`0300moogoo02Moo`0300moogoo02Moo`0300moogoo02Ioo`0300moogoo025oo`03001oogoo02Io
o`009goo00<007ooOol09Woo00<03gooOol09goo00<03gooOol09goo00<03gooOol09Woo00<03goo
Ool08Goo00<007ooOol09Woo000WOol00`00Oomoo`0VOol00`0?Oomoo`0WOol00`0?Oomoo`0WOol0
0`0?Oomoo`0VOol00`0?Oomoo`0QOol00`00Oomoo`0VOol002Moo`03001oogoo02Ioo`03001oogoo
02Moo`03001oogoo02Moo`03001oogoo02Ioo`03001oogoo025oo`03001oogoo02Ioo`009goob`00
:7oo003oOolKOol00?mooa]oo`00ogoo6goo003oOolKOol00?mooa]oo`00;Woo0`00@7oo10003Goo
0P001Goo100000=oo`00000077oo0P001Goo00<007ooOol09Woo0P007Goo100037oo0P001Goo0P00
1Woo000aOol00`00Oomoo`0_Ool00`00Oomoo`0=Ool00`00Oomoo`0<Ool00`00Oomoo`06Ool01@00
Oomoogoo000077oo00<007ooOol017oo00<007ooOol027oo00<007ooOol03goo00<007ooOol02Goo
00<007ooOol02Goo00<007ooOol02Goo00<007ooOol01Woo00<007ooOol037oo00<007ooOol017oo
00<007ooOol017oo0002Ool50003Ool30002Ool50002Ool50005Ool20002Ool20002Ool40002Ool4
000017oo000000002Goo00@007ooOol0009oo`D0009oo`<0009oo`800003Ool0000000Moo`<000=o
o`03001oogoo00=oo`<000Aoo`@00003Ool00000008000=oo`<000=oo`03001oogoo00=oo`@000=o
o`03001oogoo00Moo`<000=oo`D00006Ool007oo001oo`000Woo00<007ooOol017oo00@007ooOomo
o`D0009oo`03001oogoo00=oo`8000Yoo`03001oogoo00Uoo`03001oogoo009oo`D0009oo`03001o
ogoo00=oo`8000Aoo`03001oogoo00=oo`@000Moo`<000Aoo`03001oogoo00Aoo`03001oogoo00Ao
o`000goo00@007ooOol0009oo`07001oogooOol007oo00000Woo00@007ooOol000=oo`03001oogoo
00Eoo`04001oo`000002Ool00`00Oomoo`03Ool01@00Oomoogoo00000Woo00<007ooOol027oo1000
17oo00<007ooOol00Woo00H007ooOol007oo0002Ool00`00Oomoo`07Ool00`00Oomoo`03Ool00`00
Oomoo`02Ool01000Oomoo`000Woo00D007ooOomoo`00009oo`03001oogoo00=oo`04001oogoo0002
Ool00`00Oomoo`02Ool01@00Oomoogoo00000goo00<007ooOol01goo00@007ooOol0009oo`04001o
ogoo0002Ool01@00Ool007oo00000Woo00<007ooOol017oo00D007ooOomoo`00009oo`03001oogoo
009oo`05001oogooOol00002Ool01000Ool000001goo00<007ooOol027oo00<007ooOol00Woo00@0
07ooOol000Aoo`05001oogooOol00002Ool00`00Oomoo`02Ool01@00Oomoogoo00000goo00<007oo
Ool01Woo00<007ooOol00goo00<007ooOol017oo00<007ooOol017oo0003Ool01000Oomoo`000Woo
00H007ooOomoo`00Ool40002Ool01@00Oomoogoo00001goo0`000goo1@0000=oo`00Ool00Woo00@0
07ooOol000Yoo`@000Aoo`03001oogoo009oo`03001oogoo009oo`04001oogoo0009Ool00`00Oomo
o`03Ool00`00Oomoo`04Ool20002Ool01@00Oomoogoo00000Woo00<007ooOol00goo00<007ooOol0
0goo00<007ooOol00Woo00D007ooOomoo`0000=oo`03001oogoo00Uoo`80009oo`04001oogoo0002
Ool01@00Ool007oo00000Woo00<007ooOol017oo00@007ooOomoo`@000Qoo`04001oogoo0003Ool2
000?Ool00`00Oomoo`03Ool40008Ool01000Oomoo`0027oo00H007ooOomoo`00Ool50002Ool00`00
Oomoo`04Ool00`00Oomoo`03Ool00`00Oomoo`04Ool000=oo`03001oogoo00=oo`05001oogooOol0
0004Ool01000Oomoo`000goo00<007ooOol01Goo00@007ooOol0009oo`07001oogooOol007oo0000
0goo00@007ooOol000Yoo`04001oogoo0004Ool00`00Oomoo`02Ool00`00Oomoo`02Ool01000Oomo
o`002Goo00<007ooOol017oo00@007ooOomoo`8000Aoo`05001oogooOol00002Ool20004Ool00`00
Oomoo`03Ool00`00Oomoo`02Ool01@00Oomoogoo00000goo00<007ooOol01goo0P0017oo00@007oo
Ool0009oo`05001oo`00Ool00002Ool00`00Oomoo`04Ool00`00Oomoo`04Ool00`00Oomoo`06Ool0
1000Oomoo`001Goo00<007ooOol03Goo00<007ooOol01Goo00<007ooOol01Woo00@007ooOol000Qo
o`05001oogooOol00008Ool00`00Oomoo`03Ool00`00Oomoo`04Ool00`00Oomoo`04Ool000=oo`03
001oogoo00Aoo`<000=oo`<000=oo`@000Moo`04001oogoo0003Ool30003Ool500000goo001oo`08
Ool20002Ool20002Ool20003Ool40002Ool40009Ool00`00Oomoo`04Ool01@00Oomoogoo00000Woo
00@007ooOomoo`L00004Ool00000Ool40003Ool00`00Oomoo`03Ool50002Ool00`00Oomoo`07Ool0
1@00Oomoo`00Ool00P0000Aoo`00001oo`H0009oo`03001oogoo00Aoo`03001oogoo009oo`<000Qo
o`04001oogoo0003Ool2000@Ool00`00Oomoo`03Ool30008Ool01000Oomoo`002Goo1@001goo00<0
07ooOol00goo00<007ooOol017oo00<007ooOol017oo0002Ool3000DOol00`00Oomoo`04Ool4000?
Ool2000GOol00`00Oomoo`02Ool00`00Oomoo`09Ool20007Ool01000Oomoogoo0`003goo00<007oo
Ool00goo0P002Woo0P002Woo0`003goo0P001Goo00<007ooOol03Woo0P000Woo0P004Woo0P0047oo
0P005Goo0P0017oo0P001Goo0P001Woo000HOol2000]Ool00`00Oomoo`02Ool01000Oomoogoo0P00
57oo00<007ooOol04goo00<007ooOol0=7oo00<007ooOol0I7oo002cOol00`00Oomoo`1TOol00001
\
\>"],
  ImageRangeCache->{{{0, 281}, {173, 0}} -> {-46.9013, -3.91469, 1.19858, 
  0.119713}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-1.38778e-17 0.0454545 0 0.0441453 [
[(5)] .22727 0 0 2 0 Minner Mrotsboxa
[(10)] .45455 0 0 2 0 Minner Mrotsboxa
[(15)] .68182 0 0 2 0 Minner Mrotsboxa
[(20)] .90909 0 0 2 0 Minner Mrotsboxa
[(Contents Reg1)] .5 0 0 2 0 0 -1 Mouter Mrotsboxa
[(0)] -0.0125 0 1 0 0 Minner Mrotsboxa
[(2)] -0.0125 .08829 1 0 0 Minner Mrotsboxa
[(4)] -0.0125 .17658 1 0 0 Minner Mrotsboxa
[(6)] -0.0125 .26487 1 0 0 Minner Mrotsboxa
[(8)] -0.0125 .35316 1 0 0 Minner Mrotsboxa
[(10)] -0.0125 .44145 1 0 0 Minner Mrotsboxa
[(12)] -0.0125 .52974 1 0 0 Minner Mrotsboxa
[(14)] -0.0125 .61803 1 0 0 Minner Mrotsboxa
[(Contents Reg2)] -0.0125 .30902 1 0 90 -1 0 Mouter Mrotsboxa
[(Put superposition x^a mod n in Reg2 )( 1/Sqrt[q] Sum[|a, x^a mod \
n>,{a,0,q-1}])] .5 .61803 0 -2 Msboxa
[ -0.001 -0.001 0 0 ]
[ 1.001 .61903 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
[ ] 0 setdash
0 g
p
p
0 0 .5 r
.001 w
.22727 0 m
.22727 .61803 L
s
P
p
0 0 .5 r
.001 w
.45455 0 m
.45455 .61803 L
s
P
p
0 0 .5 r
.001 w
.68182 0 m
.68182 .61803 L
s
P
p
0 0 .5 r
.001 w
.90909 0 m
.90909 .61803 L
s
P
p
0 0 .5 r
.001 w
0 .08829 m
1 .08829 L
s
P
p
0 0 .5 r
.001 w
0 .17658 m
1 .17658 L
s
P
p
0 0 .5 r
.001 w
0 .26487 m
1 .26487 L
s
P
p
0 0 .5 r
.001 w
0 .35316 m
1 .35316 L
s
P
p
0 0 .5 r
.001 w
0 .44145 m
1 .44145 L
s
P
p
0 0 .5 r
.001 w
0 .52974 m
1 .52974 L
s
P
p
.002 w
.22727 0 m
.22727 .00625 L
s
P
[(5)] .22727 0 0 2 0 Minner Mrotshowa
p
.002 w
.45455 0 m
.45455 .00625 L
s
P
[(10)] .45455 0 0 2 0 Minner Mrotshowa
p
.002 w
.68182 0 m
.68182 .00625 L
s
P
[(15)] .68182 0 0 2 0 Minner Mrotshowa
p
.002 w
.90909 0 m
.90909 .00625 L
s
P
[(20)] .90909 0 0 2 0 Minner Mrotshowa
p
.001 w
.04545 0 m
.04545 .00375 L
s
P
p
.001 w
.09091 0 m
.09091 .00375 L
s
P
p
.001 w
.13636 0 m
.13636 .00375 L
s
P
p
.001 w
.18182 0 m
.18182 .00375 L
s
P
p
.001 w
.27273 0 m
.27273 .00375 L
s
P
p
.001 w
.31818 0 m
.31818 .00375 L
s
P
p
.001 w
.36364 0 m
.36364 .00375 L
s
P
p
.001 w
.40909 0 m
.40909 .00375 L
s
P
p
.001 w
.5 0 m
.5 .00375 L
s
P
p
.001 w
.54545 0 m
.54545 .00375 L
s
P
p
.001 w
.59091 0 m
.59091 .00375 L
s
P
p
.001 w
.63636 0 m
.63636 .00375 L
s
P
p
.001 w
.72727 0 m
.72727 .00375 L
s
P
p
.001 w
.77273 0 m
.77273 .00375 L
s
P
p
.001 w
.81818 0 m
.81818 .00375 L
s
P
p
.001 w
.86364 0 m
.86364 .00375 L
s
P
p
.001 w
.95455 0 m
.95455 .00375 L
s
P
[(Contents Reg1)] .5 0 0 2 0 0 -1 Mouter Mrotshowa
p
.002 w
0 0 m
1 0 L
s
P
p
.002 w
0 0 m
.00625 0 L
s
P
[(0)] -0.0125 0 1 0 0 Minner Mrotshowa
p
.002 w
0 .08829 m
.00625 .08829 L
s
P
[(2)] -0.0125 .08829 1 0 0 Minner Mrotshowa
p
.002 w
0 .17658 m
.00625 .17658 L
s
P
[(4)] -0.0125 .17658 1 0 0 Minner Mrotshowa
p
.002 w
0 .26487 m
.00625 .26487 L
s
P
[(6)] -0.0125 .26487 1 0 0 Minner Mrotshowa
p
.002 w
0 .35316 m
.00625 .35316 L
s
P
[(8)] -0.0125 .35316 1 0 0 Minner Mrotshowa
p
.002 w
0 .44145 m
.00625 .44145 L
s
P
[(10)] -0.0125 .44145 1 0 0 Minner Mrotshowa
p
.002 w
0 .52974 m
.00625 .52974 L
s
P
[(12)] -0.0125 .52974 1 0 0 Minner Mrotshowa
p
.002 w
0 .61803 m
.00625 .61803 L
s
P
[(14)] -0.0125 .61803 1 0 0 Minner Mrotshowa
p
.001 w
0 .01766 m
.00375 .01766 L
s
P
p
.001 w
0 .03532 m
.00375 .03532 L
s
P
p
.001 w
0 .05297 m
.00375 .05297 L
s
P
p
.001 w
0 .07063 m
.00375 .07063 L
s
P
p
.001 w
0 .10595 m
.00375 .10595 L
s
P
p
.001 w
0 .12361 m
.00375 .12361 L
s
P
p
.001 w
0 .14126 m
.00375 .14126 L
s
P
p
.001 w
0 .15892 m
.00375 .15892 L
s
P
p
.001 w
0 .19424 m
.00375 .19424 L
s
P
p
.001 w
0 .2119 m
.00375 .2119 L
s
P
p
.001 w
0 .22956 m
.00375 .22956 L
s
P
p
.001 w
0 .24721 m
.00375 .24721 L
s
P
p
.001 w
0 .28253 m
.00375 .28253 L
s
P
p
.001 w
0 .30019 m
.00375 .30019 L
s
P
p
.001 w
0 .31785 m
.00375 .31785 L
s
P
p
.001 w
0 .3355 m
.00375 .3355 L
s
P
p
.001 w
0 .37082 m
.00375 .37082 L
s
P
p
.001 w
0 .38848 m
.00375 .38848 L
s
P
p
.001 w
0 .40614 m
.00375 .40614 L
s
P
p
.001 w
0 .42379 m
.00375 .42379 L
s
P
p
.001 w
0 .45911 m
.00375 .45911 L
s
P
p
.001 w
0 .47677 m
.00375 .47677 L
s
P
p
.001 w
0 .49443 m
.00375 .49443 L
s
P
p
.001 w
0 .51209 m
.00375 .51209 L
s
P
p
.001 w
0 .5474 m
.00375 .5474 L
s
P
p
.001 w
0 .56506 m
.00375 .56506 L
s
P
p
.001 w
0 .58272 m
.00375 .58272 L
s
P
p
.001 w
0 .60038 m
.00375 .60038 L
s
P
[(Contents Reg2)] -0.0125 .30902 1 0 90 -1 0 Mouter Mrotshowa
p
.002 w
0 0 m
0 .61803 L
s
P
P
p
p
.002 w
0 .61178 m
0 .61803 L
s
P
p
.002 w
.22727 .61178 m
.22727 .61803 L
s
P
p
.002 w
.45455 .61178 m
.45455 .61803 L
s
P
p
.002 w
.68182 .61178 m
.68182 .61803 L
s
P
p
.002 w
.90909 .61178 m
.90909 .61803 L
s
P
p
.001 w
.04545 .61428 m
.04545 .61803 L
s
P
p
.001 w
.09091 .61428 m
.09091 .61803 L
s
P
p
.001 w
.13636 .61428 m
.13636 .61803 L
s
P
p
.001 w
.18182 .61428 m
.18182 .61803 L
s
P
p
.001 w
.27273 .61428 m
.27273 .61803 L
s
P
p
.001 w
.31818 .61428 m
.31818 .61803 L
s
P
p
.001 w
.36364 .61428 m
.36364 .61803 L
s
P
p
.001 w
.40909 .61428 m
.40909 .61803 L
s
P
p
.001 w
.5 .61428 m
.5 .61803 L
s
P
p
.001 w
.54545 .61428 m
.54545 .61803 L
s
P
p
.001 w
.59091 .61428 m
.59091 .61803 L
s
P
p
.001 w
.63636 .61428 m
.63636 .61803 L
s
P
p
.001 w
.72727 .61428 m
.72727 .61803 L
s
P
p
.001 w
.77273 .61428 m
.77273 .61803 L
s
P
p
.001 w
.81818 .61428 m
.81818 .61803 L
s
P
p
.001 w
.86364 .61428 m
.86364 .61803 L
s
P
p
.001 w
.95455 .61428 m
.95455 .61803 L
s
P
p
.002 w
0 .61803 m
1 .61803 L
s
P
[(Put superposition x^a mod n in Reg2 )( 1/Sqrt[q] Sum[|a, x^a mod \
n>,{a,0,q-1}])] .5 .61803 0 -2 Mshowa
p
.002 w
.99375 0 m
1 0 L
s
P
p
.002 w
.99375 .08829 m
1 .08829 L
s
P
p
.002 w
.99375 .17658 m
1 .17658 L
s
P
p
.002 w
.99375 .26487 m
1 .26487 L
s
P
p
.002 w
.99375 .35316 m
1 .35316 L
s
P
p
.002 w
.99375 .44145 m
1 .44145 L
s
P
p
.002 w
.99375 .52974 m
1 .52974 L
s
P
p
.001 w
.99625 .01766 m
1 .01766 L
s
P
p
.001 w
.99625 .03532 m
1 .03532 L
s
P
p
.001 w
.99625 .05297 m
1 .05297 L
s
P
p
.001 w
.99625 .07063 m
1 .07063 L
s
P
p
.001 w
.99625 .10595 m
1 .10595 L
s
P
p
.001 w
.99625 .12361 m
1 .12361 L
s
P
p
.001 w
.99625 .14126 m
1 .14126 L
s
P
p
.001 w
.99625 .15892 m
1 .15892 L
s
P
p
.001 w
.99625 .19424 m
1 .19424 L
s
P
p
.001 w
.99625 .2119 m
1 .2119 L
s
P
p
.001 w
.99625 .22956 m
1 .22956 L
s
P
p
.001 w
.99625 .24721 m
1 .24721 L
s
P
p
.001 w
.99625 .28253 m
1 .28253 L
s
P
p
.001 w
.99625 .30019 m
1 .30019 L
s
P
p
.001 w
.99625 .31785 m
1 .31785 L
s
P
p
.001 w
.99625 .3355 m
1 .3355 L
s
P
p
.001 w
.99625 .37082 m
1 .37082 L
s
P
p
.001 w
.99625 .38848 m
1 .38848 L
s
P
p
.001 w
.99625 .40614 m
1 .40614 L
s
P
p
.001 w
.99625 .42379 m
1 .42379 L
s
P
p
.001 w
.99625 .45911 m
1 .45911 L
s
P
p
.001 w
.99625 .47677 m
1 .47677 L
s
P
p
.001 w
.99625 .49443 m
1 .49443 L
s
P
p
.001 w
.99625 .51209 m
1 .51209 L
s
P
p
.001 w
.99625 .5474 m
1 .5474 L
s
P
p
.001 w
.99625 .56506 m
1 .56506 L
s
P
p
.001 w
.99625 .58272 m
1 .58272 L
s
P
p
.001 w
.99625 .60038 m
1 .60038 L
s
P
p
.002 w
1 0 m
1 .61803 L
s
P
P
p
P
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
p
p
[ .01 .01 ] 0 setdash
.004 w
0 .04415 m
.04545 .30902 L
.09091 .17658 L
.13636 .57389 L
.18182 .04415 L
.22727 .30902 L
.27273 .17658 L
.31818 .57389 L
.36364 .04415 L
.40909 .30902 L
.45455 .17658 L
.5 .57389 L
.54545 .04415 L
.59091 .30902 L
.63636 .17658 L
.68182 .57389 L
.72727 .04415 L
.77273 .30902 L
.81818 .17658 L
.86364 .57389 L
.90909 .04415 L
.95455 .30902 L
1 .17658 L
s
P
p
p
.02 w
0 .04415 Mdot
.04545 .30902 Mdot
.09091 .17658 Mdot
.13636 .57389 Mdot
.18182 .04415 Mdot
.22727 .30902 Mdot
.27273 .17658 Mdot
.31818 .57389 Mdot
.36364 .04415 Mdot
.40909 .30902 Mdot
.45455 .17658 Mdot
.5 .57389 Mdot
.54545 .04415 Mdot
.59091 .30902 Mdot
.63636 .17658 Mdot
.68182 .57389 Mdot
.72727 .04415 Mdot
.77273 .30902 Mdot
.81818 .17658 Mdot
.86364 .57389 Mdot
.90909 .04415 Mdot
.95455 .30902 Mdot
1 .17658 Mdot
P
P
P
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  Evaluatable->False,
  AspectRatioFixed->True,
  ImageSize->{282, 174},
  ImageMargins->{{34, Inherited}, {Inherited, Inherited}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004J0000[Q000`40O003h00Oogoo6goo003oOolK
Ool00:Uoo`<006ioo`00[7oo00<007ooOol0Jgoo001VOol40003Ool30002Ool200000goo00000002
Ool30003Ool4000017oo000007oo0P000Woo0`000Woo10001goo0P000Woo0P000Woo10000Woo1000
00Aoo`00000006Uoo`00IGoo00<007ooOol017oo00L007ooOomoo`00Ool00002Ool01@00Oomoogoo
00000Woo00<007oo00001Goo00@007ooOol000=oo`04001oogoo0004Ool00`00Oomoo`06Ool01000
Ool000000Woo00<007ooOol00goo00D007ooOomoo`00009oo`03001oogoo06Qoo`00IGoo00<007oo
Ool017oo00L007ooOomoo`00Ool00002Ool01@00Oomoogoo000017oo1@0000Eoo`00Oomoo`0000=o
o`03001oogoo009oo`@000Qoo`<000=oo`D00003Ool007oo009oo`04001oogoo001ZOol006Eoo`03
001oogoo00Aoo`07001oogooOol007oo00000Woo00D007ooOomoo`0000Aoo`07001oogooOol007oo
00000Woo00D007ooOomoo`0000Aoo`03001oogoo00Uoo`04001oogoo0002Ool01`00Oomoogoo001o
o`0000=oo`04001oogoo001ZOol006Eoo`05001oogooOol00003Ool300000goo000000030002Ool4
0003Ool300000goo000000030002Ool40002Ool40008Ool01000Oomoo`000goo0`000goo1@0000=o
o`00Ool0JGoo001VOol4000?Ool00`00Oomoo`0?Ool00`00Oomoo`0=Ool4000?Ool2001ZOol007Uo
o`03001oogoo00moo`03001oogoo08aoo`00ogoo6goo003oOolKOol00?mooa]oo`00ogoo6goo003o
OolKOol00?mooa]oo`00ogoo6goo003oOolKOol00?mooa]oo`00ogoo6goo001KOol3000QOol30004
Ool2000OOol30003Ool3000NOol40003Ool20013Ool005ioo`03001oogoo01moo`03001oogoo009o
o`04001oogoo000OOol00`00Oomoo`05Ool00`00Oomoo`0LOol00`00Oomoo`02Ool01000Oomoo`00
@Woo001NOol00`00Oomoo`0OOol00`00Oomoo`02Ool01000Oomoo`007goo00<007ooOol01Goo00<0
07ooOol07Goo00D007ooOomoo`00009oo`03001oogoo041oo`00Fgoo0`008Woo00<007ooOol00Woo
00@007ooOol001moo`03001oogoo009oo`<0025oo`04001oogoo0002Ool00`00Oomoo`10Ool005]o
o`03001oogoo029oo`03001oogoo009oo`04001oogoo000OOol00`00Oomoo`02Ool00`00Oomoo`0N
Ool01000Oomoo`000Woo00@007ooOol0049oo`00Fgoo100087oo0P001Goo0P007goo0P0017oo1000
7Woo0P0017oo0P00@goo003oOolKOol00?mooa]oo`00ogoo6goo003oOolKOol002moo`800>Uoo`00
;Woo00@007ooOol00>Qoo`00;Woo00@007ooOol000=oojl003Ioo`00;Woo00@007ooOol000=oo`03
001oogoo00Eoo`03001oogoo00Eoo`03001oogoo00Eoo`03001oogoo00Eoo`03001oogoo00Eoo`03
001oogoo00Aoo`03001oogoo00Eoo`03001oogoo00Eoo`03001oogoo00Eoo`03001oogoo00Eoo`03
001oogoo00Eoo`03001oogoo00Eoo`03001oogoo00Eoo`03001oogoo00Eoo`03001oogoo00Eoo`03
001oogoo00Eoo`03001oogoo00Aoo`03001oogoo00Eoo`03001oogoo00Eoo`03001oogoo00Eoo`03
001oogoo00Eoo`03001oogoo00Eoo`03001oogoo03Aoo`00;Woo00@007ooOol000=oo`03001oogoo
02Eoo`0300moogoo02Aoo`0300moogoo02Eoo`0300moogoo02Aoo`0300moogoo00eoo`03001oogoo
03Aoo`00;goo0P0017oo0P009Woo00<03gooOol097oo00<03gooOol09Goo00<03gooOol097oo00<0
3gooOol037oo0P00=Woo000eOol00`00Oomoo`0UOol00`0?Oomoo`0TOol00`0?Oomoo`0UOol00`0?
Oomoo`0TOol00`0?Oomoo`0=Ool00`00Oomoo`0dOol003Eoo`03001oogoo02Eoo`0300moogoo02Ao
o`0300moogoo02Eoo`0300moogoo02Aoo`0300moogoo00eoo`03001oogoo03Aoo`00=Goo0P009Woo
00<03gooOol097oo00<03gooOol09Goo00<03gooOol097oo00<03gooOol037oo0P00=Woo000dOol3
000LOol30007Ool00`0?Oomoo`0COol3000>Ool00`0?Oomoo`0<Ool3000FOol00`0?Oomoo`03Ool3
000MOol3000>Ool00`00Oomoo`0dOol003Aoo`<001aoo`<000Moo`0300moogoo01=oo`<000ioo`03
00moogoo00aoo`<001Ioo`0300moogoo00=oo`<001eoo`<000ioo`03001oogoo03Aoo`00=7oo0`00
77oo0`001goo00<03gooOol04goo0`003Woo00<03gooOol037oo0`005Woo00<03gooOol00goo0`00
7Goo0`003Goo0P00=Woo000eOol00`00Oomoo`0LOol20007Ool00`0?Oomoo`0DOol2000>Ool00`0?
Oomoo`0=Ool00`00Oomoo`0EOol00`0?Oomoo`04Ool2000NOol2000>Ool00`00Oomoo`0dOol003Eo
o`8001eoo`8000Moo`0300moogoo01Aoo`03001oogoo00eoo`0300moogoo00eoo`03001oogoo01Eo
o`0300moogoo00Aoo`03001oogoo01eoo`03001oogoo00eoo`03001oogoo03Aoo`00=Goo0P007Woo
00<007ooOol01Goo00<03gooOol05Goo00<007ooOol037oo00<03gooOol03Woo00<007ooOol057oo
00<03gooOol01Goo00<007ooOol077oo0P003Goo0P00=Woo000eOol2000MOol20007Ool00`0?Oomo
o`0DOol2000>Ool00`0?Oomoo`0<Ool00`00Ool0000FOol00`0?Oomoo`04Ool2000NOol2000>Ool0
0`00Oomoo`0dOol002ioo`@000=oo`03001oogoo01aoo`03001oogoo00Ioo`0300moogoo01Aoo`03
001oogoo00eoo`0300moogoo00aoo`03001oogoo01Ioo`0300moogoo00Aoo`03001oo`0001eoo`80
00ioo`03001oogoo03Aoo`00;goo00<007ooOol00goo0P007Goo00<007oo00001Woo00<03gooOol0
57oo0P003Woo00<03gooOol03Woo00<007ooOol057oo00<03gooOol01Woo00<007ooOol06goo00<0
3`00Ool03Goo00<007ooOol0=7oo000ROol4000:Ool00`00Oomoo`02Ool2000M00l00`0000l0000M
00l2000M00l00`0000l0000M00l00`0000l0000L00l00`0000l0000=00l2000fOol0025oo`03001o
ogoo00eoo`04001oogooOol2000MOol00`00Ool00006Ool00`0?Oomoo`0DOol00`00Ool0000=Ool0
0`0?Oomoo`0<Ool00`00Ool0000FOol00`0?Oomoo`04Ool00`00Ool0000LOol0100000moo`003Goo
00<007ooOol0=7oo000QOol00`00Oomoo`0:Ool01000Oomoo`000goo00<007oo000077oo00<007oo
00001Woo00<03gooOol04goo00@007ooOol000eoo`0300moogoo00aoo`03001oogoo01Ioo`0300mo
ogoo00Aoo`03001oogoo01aoo`0300003goo00ioo`03001oogoo03Aoo`008Goo00<007ooOol02goo
0P0017oo0`007Woo00<007ooOol017oo00<03gooOol05Woo00<007ooOol02goo00<03gooOol03goo
00<007ooOol04goo00<03gooOol01Woo00<007ooOol06Woo00@0000?Ool000aoo`8003Ioo`008Goo
00D007ooOomoo`0000moo`03001oo`0001aoo`04001oogoo0005Ool00`0?Oomoo`0COol01000Oomo
o`003Goo00<03gooOol037oo00@007ooOol001Eoo`0300moogoo00Aoo`04001oogoo000KOol01000
00moo`003Goo00<007ooOol0=7oo000ROol4000?Ool00`00Oomoo`0LOol00`00Oomoo`06Ool00`0?
Oomoo`0COol00`00Oomoo`0>Ool00`0?Oomoo`0<Ool00`00Oomoo`0FOol00`0?Oomoo`03Ool00`00
Oomoo`0MOol0100000moo`003Goo00<007ooOol0=7oo000SOol3000?Ool3000KOol01@00Oomoogoo
00001Goo00<03gooOol04goo00D007ooOomoo`0000aoo`0300moogoo00moo`03001oogoo01=oo`03
00moogoo00Moo`03001oogoo01Yoo`0400moogoo000;Ool2000fOol0029oo`05001oogooOol0000>
Ool01000Oomoo`006Woo00D007ooOomoo`0000Eoo`0300moogoo01=oo`05001oogooOol0000<Ool0
0`0?Oomoo`0<Ool01000Oomoo`005Goo00<03gooOol00goo00D007ooOomoo`0001]oo`0500003goo
Ool0000<Ool00`00Oomoo`0dOol0029oo`05001oogooOol0000>Ool00`00Oomoo`0KOol01@00Oomo
ogoo00001Goo00<03gooOol04goo00D007ooOomoo`0000aoo`0300moogoo00aoo`05001oogooOol0
000DOol00`0?Oomoo`03Ool01@00Oomoogoo00006goo00D0000?Oomoo`0000aoo`03001oogoo03Ao
o`008Woo00D007ooOomoo`0000ioo`800003Ool007oo01Uoo`03001oogoo009oo`03001oogoo009o
o`0300moogoo01=oo`05001oogooOol0000<Ool00`0?Oomoo`0;Ool00`00Oomoo`02Ool00`00Oomo
o`0BOol00`0?Oomoo`03Ool00`00Oomoo`0MOol00`0000moo`0=Ool2000fOol002=oo`<000moo`04
001oogoo000OOol00`00Oomoo`02Ool00`0?Oomoo`0GOol00`00Oomoo`0:Ool00`0?Oomoo`0@Ool0
0`00Oomoo`0BOol00`0?Oomoo`03Ool00`00Oomoo`02Ool00`00Oomoo`0HOol01@0000moogoo0000
37oo00<007ooOol0=7oo000eOol01000Oomoo`006Woo00<007ooOol00Woo00<007ooOol00Woo00<0
3gooOol04goo00<007ooOol00Woo00<007ooOol02Goo00<03gooOol02goo00<007ooOol00Woo00<0
07ooOol04Woo00<03gooOol00goo00<007ooOol00Woo00<007ooOol067oo00<0000?Ool00Woo00<0
07ooOol02Goo00<007ooOol0=7oo000ROol200000goo0000000>Ool2000LOol00`00Oomoo`07Ool0
0`0?Oomoo`0BOol00`00Oomoo`0?Ool00`0?Oomoo`0;Ool00`00Oomoo`0GOol00`0?Oomoo`03Ool0
0`00Oomoo`0LOol00`00Ool03`0>Ool2000fOol0029oo`04001oogoo0009Ool30003Ool01000Oomo
o`006Woo00<007ooOol00Woo00<007ooOol00Woo00<03gooOol067oo00<007ooOol02Goo00<03goo
Ool047oo00<007ooOol04Woo00<03gooOol027oo00<007ooOol06Goo00D03gooOomoo`0000]oo`03
001oogoo03Aoo`008Woo00@007ooOol000Yoo`03001oogoo009oo`05001oogooOol0000:Ool3000<
Ool00`00Oomoo`02Ool00`00Oomoo`02Ool00`0?Oomoo`03Ool3000<Ool00`00Oomoo`03Ool00`00
Oomoo`08Ool3000<Ool00`00Oomoo`02Ool00`00Oomoo`09Ool30006Ool00`0?Oomoo`03Ool00`00
Oomoo`02Ool00`00Oomoo`08Ool3000<Ool00`00Ool03`03Ool00`00Oomoo`08Ool3000eOol0029o
o`04001oogoo0008Ool40003Ool2000=00l3000<00l00`0000l03`0=00l3000<00l00`0000l03`03
00l00`0000l03`0800l3000<00l00`0000l03`0300l00`0000l03`0800l3000<00l00`0000l03`02
00l00`0000l03`0800l3000<00l00`0000l03`0300l00`0000l03`0800l3000eOol0025oo`D000Qo
o`03001oo`0000Aoo`05001oogooOol0000:Ool3000<Ool00`00Oomoo`03Ool01@00Oomoogoo00l0
1Goo0`0037oo00<007ooOol00goo00<007ooOol027oo0`0037oo00<007ooOol00goo00<007ooOol0
27oo0`001Woo00<03gooOol00goo00<007ooOol00goo00<007ooOol01goo0`0037oo00<007oo00l0
3Woo0`00=Goo000^Ool00`00Ool00004Ool01@00Oomoogoo00002goo00<007ooOol04Goo00D007oo
Oomoo`0?00Moo`03001oogoo011oo`03001oogoo00Uoo`03001oogoo015oo`03001oogoo00Uoo`03
001oogoo00Eoo`0300moogoo009oo`03001oogoo00Aoo`03001oogoo00Qoo`03001oogoo00]oo`03
001oo`0?00=oo`03001oogoo00Qoo`8003Ioo`008goo0`002Goo0P0017oo0P000Woo00<007ooOol0
27oo0P0037oo00<007ooOol017oo00D007ooOomoo`0?00Eoo`03001oo`0000aoo`03001oogoo00Ao
o`03001oogoo00Moo`8000eoo`03001oogoo00=oo`03001oogoo00Qoo`8000Moo`0300moogoo009o
o`03001oogoo00Aoo`03001oogoo00Qoo`8000aoo`03001oo`0?00Aoo`03001oogoo00Moo`8003Io
o`008goo00@007ooOol000ioo`03001oogoo009oo`03001oogoo00Moo`8000aoo`03001oogoo00Qo
o`0300moogoo00=oo`03001oo`0000aoo`03001oogoo00ioo`0300003`0000aoo`03001oogoo00eo
o`03001oo`0000Moo`0300moogoo009oo`03001oogoo00ioo`03001oo`0000aoo`03001oo`0?00io
o`8003Ioo`008goo00<007ooOol03goo00<007ooOol00Woo00<007ooOol01Woo00<007ooOol037oo
00<007ooOol017oo00D007ooOomoo`0?00Eoo`03001oogoo01=oo`03001oogoo00Qoo`0300moogoo
019oo`03001oogoo011oo`0300moogoo00Uoo`03001oogoo01Qoo`0300moogoo009oo`03001oogoo
00Qoo`03001oogoo03Aoo`008goo00<007ooOol03goo0P000goo00<007ooOol01Woo00<007oo0000
37oo00<007ooOol01Goo00@007ooOol03`Aoo`04001oogoo000<Ool00`00Oomoo`04Ool00`00Oomo
o`06Ool01000Ool03`002goo00<007ooOol01Goo00<007ooOol01Woo00<007oo00001goo00<03goo
Ool00Woo00<007ooOol017oo00<007ooOol01Woo00@007ooOol000aoo`03001oo`0?00Aoo`03001o
ogoo00Ioo`<003Ioo`008Woo10003goo00<007ooOol02goo00@007ooOol000]oo`03001oogoo00Qo
o`0300moogoo009oo`04001oogoo000<Ool00`00Oomoo`0=Ool01000Ool03`002goo00<007ooOol0
3Woo00<007oo00001goo00<03gooOol00Woo00<007ooOol01Goo00<007ooOol01Goo00@007ooOol0
00aoo`03001oo`0?00Aoo`03001oogoo00Ioo`03001oo`0003Ioo`008goo00<007ooOol03goo00<0
07ooOol00Woo00<007ooOol01Goo00<007ooOol03Goo00<007ooOol01Goo00@007ooOol03`Aoo`03
001oogoo00eoo`03001oogoo00Eoo`03001oogoo00Aoo`04001oogoo00l<Ool00`00Oomoo`05Ool0
0`00Oomoo`05Ool01@00Oomoogoo00001Woo00<03gooOol00Woo00<007ooOol01Goo00<007ooOol0
27oo00<007ooOol02Woo00<007oo00l01Goo00<007ooOol01goo00<007ooOol0=7oo000SOol4000>
Ool20003Ool00`00Oomoo`09Ool00`00Oomoo`0AOol01000Oomoo`0?0goo00D007ooOomoo`0001Ao
o`03001oogoo00Aoo`05001oogoo00l0000COol00`00Oomoo`05Ool01@00Oomoogoo00001Woo00<0
3gooOol00Woo00<007ooOol01Goo00<007ooOol017oo00D007ooOomoo`0000]oo`04001oogoo00l5
Ool00`00Oomoo`04Ool01000Ool00000=Woo000ROol00`00Oomoo`0@Ool00`00Oomoo`03Ool00`00
Oomoo`03Ool00`00Oomoo`02Ool00`00Oomoo`09Ool00`00Oomoo`05Ool01000Oomoo`0?0goo00D0
07ooOomoo`0000]oo`03001oogoo00Ioo`03001oogoo00Aoo`05001oogoo00l0000;Ool00`00Oomo
o`06Ool00`00Oomoo`04Ool01@00Oomoogoo00001Woo00<03gooOol00Woo00<007ooOol01Goo00<0
07ooOol017oo00D007ooOomoo`0000]oo`04001oogoo00l5Ool00`00Oomoo`04Ool01000Oomoo`00
=Woo000ROol5000>Ool00`00Oomoo`03Ool00`00Oomoo`03Ool00`00Oomoo`02Ool00`00Oomoo`09
Ool00`00Oomoo`05Ool01000Oomoo`0?0goo00<007ooOol00Woo00<007ooOol027oo00<007ooOol0
37oo00H007ooOomoo`0?000;Ool00`00Oomoo`0<Ool00`00Oomoo`02Ool00`00Oomoo`04Ool00`0?
Oomoo`02Ool00`00Oomoo`0<Ool00`00Oomoo`02Ool00`00Oomoo`08Ool01000Oomoo`0?2goo00D0
07ooOomoo`0003Ioo`008Woo00D007ooOomoo`0000ioo`8000Aoo`03001oogoo00Qoo`03001oogoo
00Uoo`03001oogoo00Eoo`04001oogoo00lLOol00`00Oomoo`07Ool00`0?Oomoo`0COol00`00Oomo
o`02Ool00`00Oomoo`0:Ool00`0?Oomoo`0;Ool00`00Oomoo`02Ool00`00Oomoo`0AOol00`0?Oomo
o`03Ool00`00Oomoo`03Ool00`00Oomoo`02000fOol002=oo`<000Uoo`8000Aoo`03001oogoo00=o
o`03001oogoo009oo`03001oogoo00=oo`03001oogoo00Qoo`03001oogoo00Moo`03001oo`0?009o
o`03001oogoo00=oo`03001oogoo00Qoo`03001oogoo00Ioo`03001oogoo00=oo`07001oogooOol0
3goo00002Woo00<007ooOol01Woo00<007ooOol00Woo00<007ooOol00goo00<007ooOol017oo00D0
3gooOomoo`0000Uoo`03001oogoo009oo`03001oogoo00=oo`03001oogoo00Qoo`04001oogoo00l5
Ool00`00Oomoo`03Ool01@00Oomoogoo0000=Woo000^Ool01000Oomoo`000goo00<007ooOol027oo
00<007ooOol00goo00<007ooOol027oo00<007ooOol02Goo00<03goo00001Woo00<007ooOol027oo
00<007ooOol02goo00<007ooOol00Woo00<03goo00002Woo00<007ooOol02goo00<007ooOol00goo
00<007ooOol017oo00D03gooOomoo`0000ioo`03001oogoo00=oo`03001oogoo00Qoo`04001oogoo
00l6Ool01@00Oomoogoo000017oo00<007ooOol0=7oo000ROol200000goo00000007Ool01000Oomo
o`000goo0P00100?00<0000?00l00P0?00<0000?00l03P0?00<0000?00l01`0?00<0000?00l04`0?
00<0000?00l01`0?00<0000?00l04`0?00<0000?00l01P0?00<0000?00l0200?00<0000?00l0200?
00<0000?00l01`0?00<0000?00l0200?00<0000?00l04P0?00<0000?00l01@0?0P00=Woo000ROol0
1000Oomoo`0027oo0`0017oo00<007ooOol017oo00@007ooOol000Moo`03001oogoo015oo`05001o
o`0?Ool00006Ool00`00Oomoo`0BOol01@00Oomoogoo000017oo00<03goo00002Woo00<007ooOol0
1Woo00D007ooOomoo`0000Moo`03001oogoo00=oo`0500moogooOol00009Ool01@00Oomoogoo0000
1Woo00<007ooOol027oo00@007ooOol03`Ioo`05001oogooOol00004Ool00`00Oomoo`0dOol0029o
o`04001oogoo0008Ool00`00Oomoo`04Ool00`00Oomoo`07Ool00`00Oomoo`05Ool00`00Oomoo`07
Ool00`00Oomoo`07Ool01@00Ool03goo00001Woo00<007ooOol027oo00<007ooOol01goo00D007oo
Oomoo`0000Aoo`0300moo`0000Yoo`03001oogoo00Moo`04001oogoo0007Ool00`00Oomoo`03Ool0
1@0?Oomoogoo00002Goo00@007ooOol000Moo`03001oogoo00Qoo`04001oogoo00l6Ool01000Oomo
o`001Goo00<007ooOol0=7oo000ROol01000Oomoo`002Goo0`000goo0P001Goo00@007ooOol000Mo
o`03001oogoo00Moo`03001oogoo00Qoo`0300003`0000Moo`03001oogoo00Qoo`03001oogoo00Mo
o`04001oogoo0005Ool00`0?Ool00009Ool00`00Oomoo`08Ool00`00Oomoo`08Ool00`00Oomoo`03
Ool01@0?Oomoogoo000057oo00<007ooOol027oo00@007ooOol03`ioo`8003Ioo`008Goo1@003goo
00<007ooOol017oo00<007oo000027oo00<007ooOol04Woo00<0000?000027oo00<007ooOol04Goo
00<007oo00001Woo00<03gooOol057oo00<007oo00003Woo00<03gooOol037oo00<007oo00005Goo
00<03gooOol017oo00@007ooOol000Eoo`03001oogoo03Aoo`00=Goo00<007ooOol017oo00<007oo
000027oo00<007ooOol01goo00<007ooOol027oo00<0000?000027oo00<007ooOol01goo00<007oo
Ool027oo0P001Woo00<03goo00002Goo00<007ooOol027oo00<007oo000027oo00<007ooOol00goo
00D03gooOomoo`0000Yoo`03001oo`0000Qoo`03001oogoo00Moo`04001oogoo00l7Ool20006Ool0
0`00Oomoo`0dOol002=oo`<000moo`8000Ioo`03001oogoo00Moo`03001oogoo00Moo`03001oogoo
00Uoo`03001oogoo00Moo`03001oogoo00Moo`03001oogoo00Uoo`03001oogoo00Aoo`0400moogoo
0008Ool00`00Oomoo`0:Ool00`00Oomoo`06Ool00`00Oomoo`03Ool01@0?Oomoogoo00002goo00<0
07ooOol01goo00<007ooOol01Woo00D007ooOomoo`0?00ioo`8003Ioo`008goo00@007ooOol000io
o`03001oogoo00Aoo`<0019oo`03001oogoo00Moo`<0019oo`03001oogoo00Qoo`<000Ioo`0300mo
ogoo00Uoo`03001oogoo00Qoo`<000ioo`0500moogooOol00009Ool30009Ool00`00Oomoo`0:Ool0
0`0?Oomoo`04Ool30006Ool00`00Oomoo`0dOol002=oo`03001oogoo00moo`03001oogoo00Aoo`<0
00Qoo`03001oogoo015oo`<000Uoo`03001oogoo015oo`<000Ioo`0400moogoo0008Ool00`00Oomo
o`08Ool30008Ool00`00Oomoo`03Ool01@0?Oomoogoo00002Goo0`002Goo00<007ooOol01Woo00D0
07ooOomoo`0?00Ioo`<000Ioo`03001oogoo03Aoo`008goo00<007ooOol03goo00<007ooOol017oo
0`0027oo00<007ooOol01goo00<007ooOol01goo0`002Goo00<007ooOol01Woo00<007ooOol027oo
0`001Woo00@03gooOol000Qoo`03001oogoo00Qoo`<000Qoo`03001oogoo00=oo`0500moogooOol0
0009Ool30009Ool00`00Oomoo`06Ool01@00Oomoogoo00l01Woo0`001Woo00<007ooOol0=7oo000R
Ool4000?Ool2000AOol00`00Oomoo`05Ool00`00Oomoo`0:Ool00`0?Oomoo`07Ool00`00Oomoo`06
Ool00`00Oomoo`0AOol0100?Oomoo`0027oo00<007ooOol057oo00<007ooOol00Woo00@03gooOol0
01Ioo`03001oogoo00Ioo`05001oogooOol03`0>Ool2000fOol002=oo`03001oogoo00moo`03001o
ogoo011oo`03001oogoo019oo`0300moogoo00Moo`03001oogoo01Yoo`0300moogoo02Eoo`0300mo
ogoo02Aoo`0300moogoo00eoo`03001oogoo03Aoo`008Woo10003goo00<007ooOol047oo00<007oo
Ool01Goo00<007ooOol02Woo00<03gooOol01goo00<007ooOol01Woo00<007ooOol04Goo00@03goo
Ool000Qoo`03001oogoo01Aoo`03001oogoo009oo`0400moogoo000FOol00`00Oomoo`06Ool01@00
Oomoogoo00l03goo00<007ooOol0=7oo000UOol00`00Oomoo`0=Ool2000AOol00`00Oomoo`05Ool0
0`00Oomoo`0:Ool00`0?Oomoo`08Ool00`00Oomoo`05Ool00`00Oomoo`0AOol0100?Oomoo`0027oo
00<007ooOol057oo00<007ooOol00Woo00@03gooOol001Ioo`03001oogoo00Ioo`05001oogooOol0
3`0>Ool2000fOol0029oo`@000Uoo`8000Aoo`03001oogoo01Qoo`03001oogoo00Yoo`0300moogoo
011oo`03001oogoo015oo`0300moogoo00Qoo`03001oogoo01Yoo`0300moogoo01Qoo`03001oogoo
00Uoo`0300moogoo00eoo`03001oogoo03Aoo`008Woo00<007ooOol02Goo00@007ooOol000=oo`03
001oogoo011oo`03001oogoo019oo`0300moogoo00Qoo`03001oogoo00Eoo`03001oogoo015oo`05
00moogooOol00006Ool00`00Oomoo`0EOol00`00Oomoo`02Ool0100?Oomoo`005goo00<007ooOol0
1Goo00D007ooOomoo`0?00moo`03001oogoo03Aoo`008Woo100027oo00@007ooOol000=oo`800140
3`0300003`0?00D03`0300003`0?01D03`0300003`0?00D03`0300003`0?01D03`0300003`0?00@0
3`0300003`0?01D03`0300003`0?00D03`0300003`0?01D03`0300003`0?00D03`0300003`0?0100
3`8003Ioo`00;goo0P0017oo00<007ooOol067oo00<007ooOol02Woo00<03gooOol027oo00<007oo
Ool017oo00<007ooOol04Woo00D03gooOomoo`0000Ioo`03001oogoo01Eoo`03001oogoo009oo`04
00moogoo000GOol00`00Oomoo`04Ool00`00Oomoo`02Ool00`0?Oomoo`0=Ool00`00Oomoo`0dOol0
02ioo`04001oogoo0003Ool00`00Oomoo`0AOol00`00Oomoo`0AOol00`0?Oomoo`08Ool00`00Oomo
o`0IOol01@0?Oomoogoo00008goo00<03gooOol097oo00<03gooOol03Goo00<007ooOol0=7oo000_
Ool20004Ool2000BOol00`00Oomoo`04Ool00`00Oomoo`0:Ool00`0?Oomoo`08Ool00`00Oomoo`04
Ool00`00Oomoo`0BOol01@0?Oomoogoo00001Woo00<007ooOol05Woo00D007ooOomoo`0?009oo`03
001oogoo01Eoo`03001oogoo00Aoo`03001oogoo009oo`0300moogoo00aoo`8003Ioo`00=Goo00<0
07ooOol04Goo00<007ooOol017oo00<007ooOol02Woo00<03gooOol027oo00<007ooOol017oo00<0
07ooOol04Woo00D03gooOomoo`0000Ioo`03001oogoo01Ioo`05001oogooOol03`02Ool00`00Oomo
o`0EOol00`00Oomoo`04Ool00`00Oomoo`02Ool00`0?Oomoo`0=Ool00`00Oomoo`0dOol003Eoo`03
001oogoo01Qoo`03001oogoo00Yoo`0300moogoo00moo`03001oogoo019oo`0300moogoo00Qoo`03
001oogoo01Yoo`0300moogoo02Aoo`0300moogoo00eoo`03001oogoo03Aoo`00=Goo0P004Woo00<0
07ooOol04Goo00<03gooOol02Goo00<007ooOol00goo00<007ooOol04Woo00D03gooOomoo`0000Io
o`03001oogoo01Ioo`07001oogooOol03goo00006Goo00<007ooOol00goo00<007ooOol00Woo00<0
3gooOol037oo0P00=Woo000eOol00`00Oomoo`0AOol00`00Oomoo`03Ool00`00Oomoo`0;Ool00`0?
Oomoo`09Ool00`00Oomoo`03Ool00`00Oomoo`0BOol01@0?Oomoogoo00001Woo00<007ooOol05Woo
00L007ooOomoo`0?Ool0000IOol00`00Oomoo`03Ool00`00Oomoo`02Ool00`0?Oomoo`0=Ool00`00
Oomoo`0dOol0025oo`80009oo`8000ioo`03001oogoo01Moo`03001oogoo00]oo`0300moogoo00Uo
o`03001oogoo00=oo`03001oogoo019oo`0300moogoo009oo`03001oogoo00=oo`03001oogoo01Io
o`07001oogooOol03goo00006Goo00<007ooOol00goo00<007ooOol00Woo00<03gooOol03Goo00<0
07ooOol0=7oo000ROol01000Ool000003goo0P004Woo00<007ooOol04Goo00<03gooOol02Goo00<0
07ooOol067oo00<03gooOol00Woo00<007ooOol077oo00D007ooOomoo`0?025oo`03001oogoo009o
o`0300moogoo00aoo`8003Ioo`008Woo0`0047oo00<007ooOol04Goo00<007ooOol00goo00<007oo
Ool02goo00<03gooOol02Goo00<007ooOol00goo00<007ooOol04Woo00<03gooOol00Woo00<007oo
Ool00Woo00<007ooOol05goo00L007ooOomoo`0?Ool0000IOol00`00Oomoo`03Ool00`00Oomoo`02
Ool00`0?Oomoo`0=Ool00`00Oomoo`0dOol0029oo`04001oogoo000?Ool00`00Oomoo`0BOol00`00
Oomoo`02Ool00`00Oomoo`0;Ool00`0?Oomoo`09Ool00`00Oomoo`03Ool00`00Oomoo`0BOol00`0?
Oomoo`02Ool00`00Oomoo`02Ool00`00Oomoo`0HOol01P00Oomoo`0?Ool001Uoo`03001oogoo00=o
o`03001oogoo009oo`0300moogoo00eoo`03001oogoo03Aoo`008Woo00@007ooOol000moo`8001Qo
o`03001oogoo00]oo`0300moogoo00moo`03001oogoo019oo`0300moogoo02Eoo`0300moogoo02Ao
o`0300moogoo00aoo`8003Ioo`008Goo10000goo0`0017oo0P0017oo00<007ooOol04Woo00<007oo
Ool00Woo00<007ooOol02goo00<03gooOol02Goo00<007ooOol00Woo00<007ooOol04goo00<03goo
Ool00Woo00<007ooOol00Woo00<007ooOol067oo00H007ooOol03goo000IOol00`00Oomoo`02Ool0
0`00Oomoo`03Ool00`0?Oomoo`0=Ool00`00Oomoo`0dOol002=oo`@0009oo`03001oogoo009oo`04
001oogoo0003Ool00`00Oomoo`0BOol00`00Oomoo`02Ool00`00Oomoo`0;Ool00`0?Oomoo`0:Ool0
1@00Oomoogoo00005Goo00<03gooOol00Woo00<007ooOol00Woo00<007ooOol067oo00H007ooOol0
3goo000IOol00`00Oomoo`02Ool00`00Oomoo`03Ool00`0?Oomoo`0=Ool00`00Oomoo`0dOol0029o
o`03001oogoo00Aoo`03001oogoo009oo`04001oogoo0003Ool2000H00l00`0000l03`0L00l00`00
00l03`0H00l00`0000l03`0200l00`0000l03`0H00l00`0000l03`0200l00`0000l03`0H00l01@00
00l03`0?0000500?0P00=Woo000ROol50002Ool00`00Oomoo`02Ool01000Oomoo`000goo00<007oo
Ool04Woo00<007ooOol047oo00<03gooOol02Woo00<007ooOol05goo00<03gooOol00Woo00<007oo
Ool07Goo00@007ooOol03b1oo`03001oogoo00=oo`0300moogoo00eoo`03001oogoo03Aoo`008Woo
00D007ooOomoo`00009oo`03001oogoo009oo`04001oogoo0003Ool00`00Oomoo`0BOol01@00Oomo
ogoo00003Woo00<03gooOol02Woo00D007ooOomoo`0001Eoo`0300moogoo009oo`03001oogoo009o
o`03001oogoo01Qoo`05001oogoo00l0000KOol01@00Oomoogoo00001Goo00<03gooOol03Goo00<0
07ooOol0=7oo000SOol30002Ool20005Ool20004Ool2000COol01@00Oomoogoo00003Woo00<03goo
Ool02Woo00D007ooOomoo`0001Eoo`0300moogoo00=oo`05001oogooOol0000JOol01@00Oomoo`0?
00006goo00D007ooOomoo`0000Eoo`0300moogoo00aoo`8003Ioo`009Woo00<007ooOol037oo00<0
07ooOol04goo00@007ooOol000ioo`0300moogoo00ioo`03001oogoo01=oo`0300moogoo02Eoo`03
00moogoo02Aoo`0300moogoo00eoo`03001oogoo03Aoo`008goo10003Woo00<007ooOol04goo00@0
07ooOol000ioo`0300moogoo00Yoo`05001oogooOol0000EOol00`0?Oomoo`03Ool01@00Oomoogoo
00006goo00@007oo00l001]oo`05001oogooOol00005Ool00`0?Oomoo`0=Ool00`00Oomoo`0dOol0
029oo`05001oogooOol0000>Ool2000DOol01000Oomoo`003Woo00<03gooOol02Woo00D007ooOomo
o`0001Eoo`0300moogoo00=oo`05001oogooOol0000KOol01000Ool03`006goo00D007ooOomoo`00
00Eoo`0300moogoo00aoo`8003Ioo`008Woo00D007ooOomoo`0000ioo`03001oogoo01Ioo`03001o
ogoo00aoo`0300moogoo00ioo`03001oogoo01=oo`0300moogoo00Ioo`03001oogoo01Yoo`04001o
o`0?000KOol01@00Oomoogoo00001Goo00<03gooOol03Goo00<007ooOol0=7oo000ROol01@00Oomo
ogoo00003Woo00<007ooOol04goo00<007ooOol03goo00<03gooOol02goo00<007ooOol05Woo00<0
3gooOol00goo00<007ooOol07Goo00@007oo00l001aoo`04001oogoo0005Ool00`0?Oomoo`0=Ool0
0`00Oomoo`0dOol002=oo`D000eoo`8001Aoo`04001oogoo000>Ool00`0?Oomoo`0;Ool01000Oomo
o`005Goo00<03gooOol00goo00@007ooOol001aoo`04001oo`0?000LOol01000Oomoo`001Goo00<0
3gooOol037oo0P00=Woo000eOol00`00Oomoo`0COol01000Oomoo`003Woo00<03gooOol02goo00<0
07oo00005Woo00<03gooOol00goo00@007ooOol001aoo`04001oo`0?000LOol00`00Ool00006Ool0
0`0?Oomoo`0=Ool00`00Oomoo`0dOol0029oo`@000moo`03001oogoo01=oo`04001oogoo000>Ool0
0`0?Oomoo`0TOol00`0?Oomoo`0UOol00`0?Oomoo`0TOol00`0?Oomoo`0=Ool00`00Oomoo`0dOol0
02=oo`03001oogoo00moo`8001Aoo`04001oogoo000>Ool00`0?Oomoo`0;Ool00`00Ool0000FOol0
0`0?Oomoo`04Ool00`00Ool0000LOol01000Ool03`0077oo00<007oo00001Woo00<03gooOol037oo
0P00=Woo000TOol01000Oomoogoo0`000goo10000goo00<007ooOol057oo00<007oo00003Woo00<0
3gooOol02goo00<007oo00005Woo00<03gooOol017oo00<007oo000077oo00@007oo00l001aoo`03
001oo`0000Ioo`0300moogoo00eoo`03001oogoo03Aoo`009Goo00D007ooOomoo`0000Eoo`03001o
ogoo00=oo`03001oogoo01Eoo`03001oogoo00eoo`0300moogoo00eoo`03001oogoo01Aoo`0300mo
ogoo00Ioo`03001oogoo01]oo`8001eoo`03001oo`0000Ioo`0300moogoo00eoo`03001oogoo03Ao
o`008Woo00@007ooOol000=oo`03001oogoo00Aoo`03001oogoo009oo`8001D03`0300003`0?01`0
3`0300003`0?01d03`0300003`0?01d03`8001d03`0300003`0001D03`8003Ioo`008goo0P0017oo
00<007ooOol01Goo00D007ooOomoo`0001Ioo`8000moo`0300moogoo00]oo`03001oo`0001Ioo`03
00moogoo00Aoo`03001oo`0001eoo`8001eoo`03001oo`0000Ioo`0300moogoo00eoo`03001oogoo
03Aoo`00:Goo00<007ooOol00Woo00@007ooOol000=oo`03001oogoo01Aoo`8000moo`0300moogoo
00aoo`8001Ioo`0300moogoo00Aoo`03001oo`0001eoo`8001ioo`8000Ioo`0300moogoo00eoo`03
001oogoo03Aoo`00:7oo0P001Goo0P0017oo00<007ooOol057oo0P003goo00<03gooOol037oo00<0
07ooOol05Goo00<03gooOol09Goo00<03gooOol097oo00<03gooOol03Goo00<007ooOol0=7oo000e
Ool2000EOol2000?Ool00`0?Oomoo`0<Ool2000FOol00`0?Oomoo`04Ool2000NOol2000NOol20006
Ool00`0?Oomoo`0<Ool2000fOol003Eoo`03001oogoo01Aoo`8000moo`0300moogoo00aoo`8001Io
o`0300moogoo00Eoo`03001oogoo01aoo`8001ioo`03001oogoo00Eoo`0300moogoo00eoo`03001o
ogoo03Aoo`00=Goo00<007ooOol05Goo00<007ooOol03Goo00<03gooOol03Goo00<007ooOol057oo
00<03gooOol01Goo00<007ooOol07Goo00<007ooOol077oo00<007ooOol01Goo00<03gooOol03Goo
00<007ooOol0=7oo000eOol2000EOol3000>Ool00`0?Oomoo`0;Ool3000FOol00`0?Oomoo`04Ool3
000LOol3000MOol30006Ool00`0?Oomoo`0<Ool2000fOol003Eoo`03001oogoo01Aoo`<000ioo`03
00moogoo00]oo`<001Ioo`0300moogoo00Aoo`<001aoo`<001eoo`<000Ioo`0300moogoo00eoo`03
001oogoo03Aoo`00=Goo00<007ooOol057oo0`003Woo00<03gooOol02goo0`005Woo00<03gooOol0
17oo0`0077oo0`007Goo0`001Woo00<03gooOol03Goo00<007ooOol0=7oo000eOol2000VOol00`0?
Oomoo`0TOol00`0?Oomoo`0UOol00`0?Oomoo`0TOol00`0?Oomoo`0<Ool2000fOol003Eoo`03001o
ogoo02Eoo`0300moogoo02Aoo`0300moogoo02Eoo`0300moogoo02Aoo`0300moogoo00eoo`03001o
ogoo03Aoo`00=Goo00<007ooOol09Goo00<03gooOol097oo00<03gooOol09Goo00<03gooOol097oo
00<03gooOol03Goo00<007ooOol0=7oo000eOol2000VOol00`0?Oomoo`0TOol00`0?Oomoo`0UOol0
0`0?Oomoo`0TOol00`0?Oomoo`0<Ool2000fOol002Qoo`<000Aoo`<000=oo`03001oogoo02Eoo`03
00moogoo02Aoo`0300moogoo02Eoo`0300moogoo02Aoo`0300moogoo00eoo`03001oogoo03Aoo`00
:Goo00<007ooOol017oo00<007ooOol00Woo00<007ooOol01Goo00<007ooOol01Goo00<007ooOol0
1Goo00<007ooOol01Goo00<007ooOol01Goo00<007ooOol017oo00<007ooOol01Goo00<007ooOol0
1Goo00<007ooOol01Goo00<007ooOol01Goo00<007ooOol01Goo00<007ooOol01Goo00<007ooOol0
1Goo00<007ooOol01Goo00<007ooOol01Goo00<007ooOol01Goo00<007ooOol017oo00<007ooOol0
1Goo00<007ooOol01Goo00<007ooOol01Goo00<007ooOol01Goo00<007ooOol01Goo00<007ooOol0
=7oo000YOol00`00Oomoo`02Ool40003Oon_000fOol002Uoo`03001oogoo009oo`03001oo`000>Uo
o`00:Goo00<007ooOol00Woo00<007oo0000jGoo000XOol20005Ool2003YOol00?mooa]oo`00ogoo
6goo003oOolKOol00?mooa]oo`00ogoo6goo003oOolKOol00?mooa]oo`00ogoo6goo000_Ool4000=
Ool20005Ool400000goo0000000LOol20005Ool00`00Oomoo`1FOol2000MOol4000<Ool20005Ool2
000HOol0025oo`03001oogoo00eoo`03001oogoo00aoo`03001oogoo00Ioo`05001oogooOol0000L
Ool00`00Oomoo`04Ool00`00Oomoo`08Ool00`00Oomoo`15Ool00`00Oomoo`03Ool00`00Oomoo`09
Ool00`00Oomoo`09Ool00`00Oomoo`06Ool00`00Oomoo`0<Ool00`00Oomoo`04Ool00`00Oomoo`0F
Ool001]oo`<000=oo`03001oogoo00=oo`<000Aoo`@00003Ool00000008000=oo`<000=oo`03001o
ogoo00=oo`@000=oo`03001oogoo00Moo`<000=oo`D00006Ool007oo001oo`000Woo00<007ooOol0
17oo00@007ooOomoo`D0009oo`03001oogoo00Moo`800003Ool0000000Qoo`D000Moo`05001oo`00
Ool00002Ool30003Ool50006Ool200000goo00000008Ool00`00Oomoo`03Ool00`00Oomoo`02Ool5
0002Ool00`00Oomoo`03Ool20004Ool00`00Oomoo`03Ool40007Ool30004Ool00`00Oomoo`04Ool0
0`00Oomoo`0FOol001aoo`03001oogoo00=oo`03001oogoo009oo`04001oogoo0002Ool01@00Oomo
ogoo00000Woo00<007ooOol00goo00@007ooOol0009oo`03001oogoo009oo`05001oogooOol00003
Ool00`00Oomoo`07Ool01000Oomoo`000Woo00@007ooOol0009oo`05001oo`00Ool00002Ool00`00
Oomoo`04Ool01@00Oomoogoo00000Woo00<007ooOol00Woo00<007ooOol01goo00<007oo00002Goo
00@007ooOol000Qoo`07001oo`00Ool007oo00000goo00<007oo00000goo00<007ooOol01Goo00D0
07ooOol007oo008000Moo`03001oogoo009oo`03001oogoo009oo`04001oogoo0004Ool01@00Oomo
ogoo00000Woo00<007ooOol00Woo00D007ooOomoo`0000=oo`03001oogoo00Ioo`03001oogoo00=o
o`03001oogoo00Aoo`03001oogoo01Ioo`0077oo00<007ooOol00goo00<007ooOol017oo0P000Woo
00D007ooOomoo`00009oo`03001oogoo00=oo`03001oogoo00=oo`03001oogoo009oo`05001oogoo
Ool00003Ool00`00Oomoo`09Ool20002Ool01000Oomoo`000Woo00D007oo001oo`00009oo`03001o
ogoo00Aoo`04001oogooOol4000?Ool00`00Oomoo`08Ool40008Ool01`00Ool007oo001oo`0000=o
o`03001oo`0000=oo`03001oogoo00Eoo`04001oogoo0003Ool20009Ool00`00Oomoo`03Ool40008
Ool01000Oomoo`0027oo00H007ooOomoo`00Ool50002Ool00`00Oomoo`04Ool00`00Oomoo`03Ool0
0`00Oomoo`0FOol001aoo`03001oogoo00Aoo`04001oogooOol20004Ool01@00Oomoogoo00000Woo
0P0017oo00<007ooOol00goo00<007ooOol00Woo00D007ooOomoo`0000=oo`03001oogoo00Moo`80
00Aoo`04001oogoo0002Ool01@00Ool007oo00000Woo00<007ooOol017oo00<007ooOol017oo00<0
07ooOol037oo00<007oo000037oo00<007ooOol01Woo00L007oo001oo`00Ool00003Ool00`00Ool0
0003Ool00`00Oomoo`05Ool01000Oomoo`001Goo00<007ooOol01goo00<007ooOol01Goo00<007oo
Ool01Woo00@007ooOol000Qoo`05001oogooOol00008Ool00`00Oomoo`03Ool00`00Oomoo`04Ool0
0`00Oomoo`0FOol001aoo`03001oogoo00Aoo`05001oogooOol00002Ool01000Oomoogoo1`0000Ao
o`00001oo`@000=oo`03001oogoo00=oo`D0009oo`03001oogoo00Moo`05001oogoo001oo`020000
17oo000007oo1P000Woo00<007ooOol017oo00<007ooOol00Woo0`003Goo0P0000=oo`0000002Goo
0`001goo1P000Woo0`000goo10001Woo1@000goo0P002Woo00<007ooOol00goo0`0027oo00@007oo
Ool000Uoo`D000Moo`03001oogoo00=oo`03001oogoo00Aoo`03001oogoo01Ioo`006goo0P001goo
00@007ooOomoo`<000moo`03001oogoo00=oo`8000Yoo`8000Yoo`<000moo`8000Eoo`03001oogoo
01Uoo`03001oo`0001moo`03001oogoo00Yoo`8000aoo`80011oo`8001Eoo`8000Aoo`8000Eoo`80
01Qoo`0097oo00<007ooOol04goo00<007ooOol0=7oo00<007ooOol06Woo00<007ooOol07Goo0P00
JWoo001aOol00`00Oomoo`2VOol00?mooa]oo`00ogoo6goo000hOol4000>Ool4002>Ool3000kOol0
03Uoo`03001oogoo00moo`03001oogoo095oo`03001oogoo03Qoo`0057oo0`0017oo1@000Woo0`00
27oo10000Woo1@0000=oo`0000000P000goo100000=oo`0000000P000Woo10000goo0`000Woo1000
0Woo1@000Woo0`000Woo1@000Woo0`000Woo0P0000=oo`0000001Woo0P0000=oo`00000027oo1@00
1goo00D007oo001oo`00009oo`<000=oo`D000Ioo`800003Ool0000000Moo`D00004Ool00000Ool2
0006Ool20002Ool20002Ool40002Ool400000goo00000002000eOol001Eoo`03001oogoo00=oo`04
001oogoo0003Ool01000Oomoo`002Woo00@007ooOol0009oo`04001oogoo0003Ool00`00Ool00006
Ool00`00Oomoo`02Ool01`00Oomoogoo001oo`0000=oo`03001oogoo009oo`03001oogoo009oo`03
001oogoo009oo`04001oogoo0003Ool01@00Oomoogoo00000goo00<007oo00000Woo00<007ooOol0
1Woo00<007oo00002Goo00@007ooOol000Qoo`07001oo`00Ool007oo00000goo00<007oo00000goo
00<007ooOol01Goo00@007ooOol000Yoo`05001oogooOol00002Ool00`00Oomoo`06Ool01000Ool0
00000Woo00<007ooOol00goo00D007ooOomoo`00009oo`03001oogoo03Eoo`005Goo0`000goo00@0
07ooOol000=oo`03001oogoo00Qoo`@0009oo`04001oogoo0002Ool01P00Oomoogoo001oo`D0009o
o`03001oogoo009oo`07001oogooOol007oo00000goo00<007oo00000`0017oo00<007ooOol00Woo
00<007ooOol017oo00D007ooOomoo`0000=oo`03001oo`00009oo`03001oogoo00Moo`03001oogoo
00Qoo`@000Qoo`07001oo`00Ool007oo00000goo00<007oo00000goo00<007ooOol01Goo00@007oo
Ool000Yoo`05001oogooOol00002Ool00`00Oomoo`06Ool30003Ool500000goo001oo`02Ool01@00
Oomoogoo0000=Woo000EOol01000Oomoo`000Woo00@007ooOol000=oo`03001oogoo00Qoo`03001o
ogoo00=oo`04001oogoo0002Ool01`00Oomoogoo001oo`0000=oo`03001oogoo008000=oo`07001o
ogooOol007oo00000goo00<007oo00001goo00<007ooOol00Woo00<007ooOol017oo00D007ooOomo
o`0000=oo`03001oo`00009oo`03001oogoo00Ioo`03001oo`0000aoo`03001oogoo00Ioo`07001o
o`00Ool007oo00000goo00<007oo00000goo00<007ooOol01Goo00@007ooOol000Yoo`05001oogoo
Ool00002Ool00`00Oomoo`06Ool01000Oomoo`000Woo00L007ooOomoo`00Ool00003Ool00`00Oomo
o`02Ool00`00Oomoo`0cOol001Eoo`05001oogoo001oo`0200000goo00000002Ool40008Ool40000
17oo000007oo0P0000=oo`0000000`000goo0`000Woo0P0000=oo`0000001@000goo0`000Woo1000
0goo0P000goo10000goo0P0017oo0`0000=oo`0000000`001goo0P0000=oo`0000002Goo0`001goo
1P000Woo0`000goo10001Woo1@002Goo0P000Woo1@0027oo00@007ooOol000=oo`<000=oo`H0009o
o`03001oogoo03=oo`0057oo10002Woo00<007ooOol0?goo00<007ooOol087oo00<007oo00007goo
00<007ooOol08Woo100047oo0P00=Woo000ROol00`00Oomoo`0jOol00`00Oomoo`02Ool00`00Oomo
o`04Ool00`00Oomoo`0JOol00`00Oomoo`0MOol2000EOol00`00Oomoo`1HOol00001\
\>"],
  ImageRangeCache->{{{0, 281}, {173, 0}} -> {-6.75419, -4.25473, 0.126364, 
  0.130112}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-1.38778e-17 0.0454545 0 0.0441453 [
[(5)] .22727 0 0 2 0 Minner Mrotsboxa
[(10)] .45455 0 0 2 0 Minner Mrotsboxa
[(15)] .68182 0 0 2 0 Minner Mrotsboxa
[(20)] .90909 0 0 2 0 Minner Mrotsboxa
[(Contents Reg1)] .5 0 0 2 0 0 -1 Mouter Mrotsboxa
[(0)] -0.0125 0 1 0 0 Minner Mrotsboxa
[(2)] -0.0125 .08829 1 0 0 Minner Mrotsboxa
[(4)] -0.0125 .17658 1 0 0 Minner Mrotsboxa
[(6)] -0.0125 .26487 1 0 0 Minner Mrotsboxa
[(8)] -0.0125 .35316 1 0 0 Minner Mrotsboxa
[(10)] -0.0125 .44145 1 0 0 Minner Mrotsboxa
[(12)] -0.0125 .52974 1 0 0 Minner Mrotsboxa
[(14)] -0.0125 .61803 1 0 0 Minner Mrotsboxa
[(Contents Reg2)] -0.0125 .30902 1 0 90 -1 0 Mouter Mrotsboxa
[(Measure Reg2 = 4)] .5 .61803 0 -2 Msboxa
[ -0.001 -0.001 0 0 ]
[ 1.001 .61903 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
[ ] 0 setdash
0 g
p
p
0 0 .5 r
.001 w
.22727 0 m
.22727 .61803 L
s
P
p
0 0 .5 r
.001 w
.45455 0 m
.45455 .61803 L
s
P
p
0 0 .5 r
.001 w
.68182 0 m
.68182 .61803 L
s
P
p
0 0 .5 r
.001 w
.90909 0 m
.90909 .61803 L
s
P
p
0 0 .5 r
.001 w
0 .08829 m
1 .08829 L
s
P
p
0 0 .5 r
.001 w
0 .17658 m
1 .17658 L
s
P
p
0 0 .5 r
.001 w
0 .26487 m
1 .26487 L
s
P
p
0 0 .5 r
.001 w
0 .35316 m
1 .35316 L
s
P
p
0 0 .5 r
.001 w
0 .44145 m
1 .44145 L
s
P
p
0 0 .5 r
.001 w
0 .52974 m
1 .52974 L
s
P
p
.002 w
.22727 0 m
.22727 .00625 L
s
P
[(5)] .22727 0 0 2 0 Minner Mrotshowa
p
.002 w
.45455 0 m
.45455 .00625 L
s
P
[(10)] .45455 0 0 2 0 Minner Mrotshowa
p
.002 w
.68182 0 m
.68182 .00625 L
s
P
[(15)] .68182 0 0 2 0 Minner Mrotshowa
p
.002 w
.90909 0 m
.90909 .00625 L
s
P
[(20)] .90909 0 0 2 0 Minner Mrotshowa
p
.001 w
.04545 0 m
.04545 .00375 L
s
P
p
.001 w
.09091 0 m
.09091 .00375 L
s
P
p
.001 w
.13636 0 m
.13636 .00375 L
s
P
p
.001 w
.18182 0 m
.18182 .00375 L
s
P
p
.001 w
.27273 0 m
.27273 .00375 L
s
P
p
.001 w
.31818 0 m
.31818 .00375 L
s
P
p
.001 w
.36364 0 m
.36364 .00375 L
s
P
p
.001 w
.40909 0 m
.40909 .00375 L
s
P
p
.001 w
.5 0 m
.5 .00375 L
s
P
p
.001 w
.54545 0 m
.54545 .00375 L
s
P
p
.001 w
.59091 0 m
.59091 .00375 L
s
P
p
.001 w
.63636 0 m
.63636 .00375 L
s
P
p
.001 w
.72727 0 m
.72727 .00375 L
s
P
p
.001 w
.77273 0 m
.77273 .00375 L
s
P
p
.001 w
.81818 0 m
.81818 .00375 L
s
P
p
.001 w
.86364 0 m
.86364 .00375 L
s
P
p
.001 w
.95455 0 m
.95455 .00375 L
s
P
[(Contents Reg1)] .5 0 0 2 0 0 -1 Mouter Mrotshowa
p
.002 w
0 0 m
1 0 L
s
P
p
.002 w
0 0 m
.00625 0 L
s
P
[(0)] -0.0125 0 1 0 0 Minner Mrotshowa
p
.002 w
0 .08829 m
.00625 .08829 L
s
P
[(2)] -0.0125 .08829 1 0 0 Minner Mrotshowa
p
.002 w
0 .17658 m
.00625 .17658 L
s
P
[(4)] -0.0125 .17658 1 0 0 Minner Mrotshowa
p
.002 w
0 .26487 m
.00625 .26487 L
s
P
[(6)] -0.0125 .26487 1 0 0 Minner Mrotshowa
p
.002 w
0 .35316 m
.00625 .35316 L
s
P
[(8)] -0.0125 .35316 1 0 0 Minner Mrotshowa
p
.002 w
0 .44145 m
.00625 .44145 L
s
P
[(10)] -0.0125 .44145 1 0 0 Minner Mrotshowa
p
.002 w
0 .52974 m
.00625 .52974 L
s
P
[(12)] -0.0125 .52974 1 0 0 Minner Mrotshowa
p
.002 w
0 .61803 m
.00625 .61803 L
s
P
[(14)] -0.0125 .61803 1 0 0 Minner Mrotshowa
p
.001 w
0 .01766 m
.00375 .01766 L
s
P
p
.001 w
0 .03532 m
.00375 .03532 L
s
P
p
.001 w
0 .05297 m
.00375 .05297 L
s
P
p
.001 w
0 .07063 m
.00375 .07063 L
s
P
p
.001 w
0 .10595 m
.00375 .10595 L
s
P
p
.001 w
0 .12361 m
.00375 .12361 L
s
P
p
.001 w
0 .14126 m
.00375 .14126 L
s
P
p
.001 w
0 .15892 m
.00375 .15892 L
s
P
p
.001 w
0 .19424 m
.00375 .19424 L
s
P
p
.001 w
0 .2119 m
.00375 .2119 L
s
P
p
.001 w
0 .22956 m
.00375 .22956 L
s
P
p
.001 w
0 .24721 m
.00375 .24721 L
s
P
p
.001 w
0 .28253 m
.00375 .28253 L
s
P
p
.001 w
0 .30019 m
.00375 .30019 L
s
P
p
.001 w
0 .31785 m
.00375 .31785 L
s
P
p
.001 w
0 .3355 m
.00375 .3355 L
s
P
p
.001 w
0 .37082 m
.00375 .37082 L
s
P
p
.001 w
0 .38848 m
.00375 .38848 L
s
P
p
.001 w
0 .40614 m
.00375 .40614 L
s
P
p
.001 w
0 .42379 m
.00375 .42379 L
s
P
p
.001 w
0 .45911 m
.00375 .45911 L
s
P
p
.001 w
0 .47677 m
.00375 .47677 L
s
P
p
.001 w
0 .49443 m
.00375 .49443 L
s
P
p
.001 w
0 .51209 m
.00375 .51209 L
s
P
p
.001 w
0 .5474 m
.00375 .5474 L
s
P
p
.001 w
0 .56506 m
.00375 .56506 L
s
P
p
.001 w
0 .58272 m
.00375 .58272 L
s
P
p
.001 w
0 .60038 m
.00375 .60038 L
s
P
[(Contents Reg2)] -0.0125 .30902 1 0 90 -1 0 Mouter Mrotshowa
p
.002 w
0 0 m
0 .61803 L
s
P
P
p
p
.002 w
0 .61178 m
0 .61803 L
s
P
p
.002 w
.22727 .61178 m
.22727 .61803 L
s
P
p
.002 w
.45455 .61178 m
.45455 .61803 L
s
P
p
.002 w
.68182 .61178 m
.68182 .61803 L
s
P
p
.002 w
.90909 .61178 m
.90909 .61803 L
s
P
p
.001 w
.04545 .61428 m
.04545 .61803 L
s
P
p
.001 w
.09091 .61428 m
.09091 .61803 L
s
P
p
.001 w
.13636 .61428 m
.13636 .61803 L
s
P
p
.001 w
.18182 .61428 m
.18182 .61803 L
s
P
p
.001 w
.27273 .61428 m
.27273 .61803 L
s
P
p
.001 w
.31818 .61428 m
.31818 .61803 L
s
P
p
.001 w
.36364 .61428 m
.36364 .61803 L
s
P
p
.001 w
.40909 .61428 m
.40909 .61803 L
s
P
p
.001 w
.5 .61428 m
.5 .61803 L
s
P
p
.001 w
.54545 .61428 m
.54545 .61803 L
s
P
p
.001 w
.59091 .61428 m
.59091 .61803 L
s
P
p
.001 w
.63636 .61428 m
.63636 .61803 L
s
P
p
.001 w
.72727 .61428 m
.72727 .61803 L
s
P
p
.001 w
.77273 .61428 m
.77273 .61803 L
s
P
p
.001 w
.81818 .61428 m
.81818 .61803 L
s
P
p
.001 w
.86364 .61428 m
.86364 .61803 L
s
P
p
.001 w
.95455 .61428 m
.95455 .61803 L
s
P
p
.002 w
0 .61803 m
1 .61803 L
s
P
[(Measure Reg2 = 4)] .5 .61803 0 -2 Mshowa
p
.002 w
.99375 0 m
1 0 L
s
P
p
.002 w
.99375 .08829 m
1 .08829 L
s
P
p
.002 w
.99375 .17658 m
1 .17658 L
s
P
p
.002 w
.99375 .26487 m
1 .26487 L
s
P
p
.002 w
.99375 .35316 m
1 .35316 L
s
P
p
.002 w
.99375 .44145 m
1 .44145 L
s
P
p
.002 w
.99375 .52974 m
1 .52974 L
s
P
p
.001 w
.99625 .01766 m
1 .01766 L
s
P
p
.001 w
.99625 .03532 m
1 .03532 L
s
P
p
.001 w
.99625 .05297 m
1 .05297 L
s
P
p
.001 w
.99625 .07063 m
1 .07063 L
s
P
p
.001 w
.99625 .10595 m
1 .10595 L
s
P
p
.001 w
.99625 .12361 m
1 .12361 L
s
P
p
.001 w
.99625 .14126 m
1 .14126 L
s
P
p
.001 w
.99625 .15892 m
1 .15892 L
s
P
p
.001 w
.99625 .19424 m
1 .19424 L
s
P
p
.001 w
.99625 .2119 m
1 .2119 L
s
P
p
.001 w
.99625 .22956 m
1 .22956 L
s
P
p
.001 w
.99625 .24721 m
1 .24721 L
s
P
p
.001 w
.99625 .28253 m
1 .28253 L
s
P
p
.001 w
.99625 .30019 m
1 .30019 L
s
P
p
.001 w
.99625 .31785 m
1 .31785 L
s
P
p
.001 w
.99625 .3355 m
1 .3355 L
s
P
p
.001 w
.99625 .37082 m
1 .37082 L
s
P
p
.001 w
.99625 .38848 m
1 .38848 L
s
P
p
.001 w
.99625 .40614 m
1 .40614 L
s
P
p
.001 w
.99625 .42379 m
1 .42379 L
s
P
p
.001 w
.99625 .45911 m
1 .45911 L
s
P
p
.001 w
.99625 .47677 m
1 .47677 L
s
P
p
.001 w
.99625 .49443 m
1 .49443 L
s
P
p
.001 w
.99625 .51209 m
1 .51209 L
s
P
p
.001 w
.99625 .5474 m
1 .5474 L
s
P
p
.001 w
.99625 .56506 m
1 .56506 L
s
P
p
.001 w
.99625 .58272 m
1 .58272 L
s
P
p
.001 w
.99625 .60038 m
1 .60038 L
s
P
p
.002 w
1 0 m
1 .61803 L
s
P
P
p
P
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
p
p
.6 g
[ .01 .01 ] 0 setdash
.004 w
0 .04415 m
.04545 .30902 L
.09091 .17658 L
.13636 .57389 L
.18182 .04415 L
.22727 .30902 L
.27273 .17658 L
.31818 .57389 L
.36364 .04415 L
.40909 .30902 L
.45455 .17658 L
.5 .57389 L
.54545 .04415 L
.59091 .30902 L
.63636 .17658 L
.68182 .57389 L
.72727 .04415 L
.77273 .30902 L
.81818 .17658 L
.86364 .57389 L
.90909 .04415 L
.95455 .30902 L
1 .17658 L
s
P
p
.6 g
p
.02 w
0 .04415 Mdot
.04545 .30902 Mdot
.09091 .17658 Mdot
.13636 .57389 Mdot
.18182 .04415 Mdot
.22727 .30902 Mdot
.27273 .17658 Mdot
.31818 .57389 Mdot
.36364 .04415 Mdot
.40909 .30902 Mdot
.45455 .17658 Mdot
.5 .57389 Mdot
.54545 .04415 Mdot
.59091 .30902 Mdot
.63636 .17658 Mdot
.68182 .57389 Mdot
.72727 .04415 Mdot
.77273 .30902 Mdot
.81818 .17658 Mdot
.86364 .57389 Mdot
.90909 .04415 Mdot
.95455 .30902 Mdot
1 .17658 Mdot
P
P
p
1 0 0 r
.05 w
0 .17658 Mdot
P
P
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  Evaluatable->False,
  AspectRatioFixed->True,
  ImageSize->{282, 174},
  ImageMargins->{{34, Inherited}, {Inherited, Inherited}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004J0000[Q000`40O003h00Oogoo6goo003oOolK
Ool00;=oo`<006Aoo`00]Woo00<007ooOol0HGoo001`Ool40003Ool30002Ool200000goo00000002
Ool30003Ool4000017oo000007oo0P000Woo0`000Woo10001goo0P000Woo0P000Woo10000Woo1000
00Aoo`00000005moo`00Kgoo00<007ooOol017oo00L007ooOomoo`00Ool00002Ool01@00Oomoogoo
00000Woo00<007oo00001Goo00@007ooOol000=oo`04001oogoo0004Ool00`00Oomoo`06Ool01000
Ool000000Woo00<007ooOol00goo00D007ooOomoo`00009oo`03001oogoo05ioo`00Kgoo00<007oo
Ool017oo00L007ooOomoo`00Ool00002Ool01@00Oomoogoo000017oo1@0000Eoo`00Oomoo`0000=o
o`03001oogoo009oo`@000Qoo`<000=oo`D00003Ool007oo009oo`04001oogoo001POol006moo`03
001oogoo00Aoo`07001oogooOol007oo00000Woo00D007ooOomoo`0000Aoo`07001oogooOol007oo
00000Woo00D007ooOomoo`0000Aoo`03001oogoo00Uoo`04001oogoo0002Ool01`00Oomoogoo001o
o`0000=oo`04001oogoo001POol006moo`05001oogooOol00003Ool300000goo000000030002Ool4
0003Ool300000goo000000030002Ool40002Ool40008Ool01000Oomoo`000goo0`000goo1@0000=o
o`00Ool0Ggoo001`Ool4000?Ool00`00Oomoo`0?Ool00`00Oomoo`0=Ool4000?Ool2001POol008=o
o`03001oogoo00moo`03001oogoo089oo`00ogoo6goo003oOolKOol00?mooa]oo`00ogoo6goo003o
OolKOol00?mooa]oo`00ogoo6goo003oOolKOol00?mooa]oo`00ogoo6goo001MOol3000XOol30004
Ool2000UOol30003Ool3000UOol40003Ool2000]Ool0061oo`03001oogoo02Ioo`03001oogoo009o
o`04001oogoo000UOol00`00Oomoo`05Ool00`00Oomoo`0SOol00`00Oomoo`02Ool01000Oomoo`00
;7oo001POol00`00Oomoo`0VOol00`00Oomoo`02Ool01000Oomoo`009Goo00<007ooOol01Goo00<0
07ooOol097oo00D007ooOomoo`00009oo`03001oogoo02Yoo`00GGoo0`00:Goo00<007ooOol00Woo
00@007ooOol002Eoo`03001oogoo009oo`<002Qoo`04001oogoo0002Ool00`00Oomoo`0ZOol005eo
o`03001oogoo02Uoo`03001oogoo009oo`04001oogoo000UOol00`00Oomoo`02Ool00`00Oomoo`0U
Ool01000Oomoo`000Woo00@007ooOol002aoo`00GGoo10009goo0P001Goo0P009Goo0P0017oo1000
9Goo0P0017oo0P00;Goo003oOolKOol00?mooa]oo`00ogoo6goo003oOolKOol002Yoo`800>ioo`00
:Goo00@007ooOol00>eoo`00:Goo00@007ooOol000Aool`001eoo`00:Goo00@007ooOol000Aoo`03
001oogoo00Ioo`03001oogoo00Ioo`03001oogoo00Ioo`03001oogoo00Moo`03001oogoo00Ioo`03
001oogoo00Ioo`03001oogoo00Ioo`03001oogoo00Moo`03001oogoo00Ioo`03001oogoo00Ioo`03
001oogoo00Ioo`03001oogoo00Ioo`03001oogoo00Moo`03001oogoo00Ioo`03001oogoo00Ioo`03
001oogoo00Ioo`03001oogoo00Ioo`03001oogoo00Moo`03001oogoo00Ioo`03001oogoo00Ioo`03
001oogoo00Ioo`03001oogoo00Moo`03001oogoo01]oo`00:Goo00@007ooOol000Aoo`03001oogoo
02]oo`0300moogoo02]oo`0300moogoo02]oo`0300moogoo02]oo`0300moogoo011oo`03001oogoo
01]oo`00:Woo0P001Goo00<007ooOol0:goo00<03gooOol0:goo00<03gooOol0:goo00<03gooOol0
:goo00<03gooOol047oo00<007ooOol06goo000aOol2000/Ool00`0?Oomoo`0[Ool00`0?Oomoo`0[
Ool00`0?Oomoo`0[Ool00`0?Oomoo`0?Ool2000MOol0035oo`03001oogoo02]oo`0300moogoo02]o
o`0300moogoo02]oo`0300moogoo02]oo`0300moogoo011oo`03001oogoo01]oo`00<Goo00<007oo
Ool0:goo00<03gooOol0:goo00<03gooOol0:goo00<03gooOol0:goo00<03gooOol047oo00<007oo
Ool06goo000aOol2000/Ool00`0?Oomoo`0[Ool00`0?Oomoo`0[Ool00`0?Oomoo`0[Ool00`0?Oomo
o`0?Ool2000MOol0031oo`9>Lb=oo`9>L`Qoo`0300moogoo01Qoo`9>La5oo`0300moogoo00moo`9>
LaYoo`0300moogoo00Ioo`9>Lb=oo`9>La5oo`03001oogoo01]oo`00;goo14ic8Goo14ic1goo00<0
3gooOol05goo14ic47oo00<03gooOol03Woo14ic6Goo00<03gooOol01Goo14ic8Goo14ic47oo00<0
07ooOol06goo000_Ool4CW<QOol4CW<7Ool00`0?Oomoo`0GOol4CW<@Ool00`0?Oomoo`0>Ool4CW<I
Ool00`0?Oomoo`05Ool4CW<QOol4CW<@Ool00`00Oomoo`0KOol0031oo`9>L`03001oogoo021oo`9>
L`Qoo`0300moogoo01Qoo`9>La5oo`0300moogoo00moo`9>LaYoo`0300moogoo00Ioo`9>Lb=oo`9>
La1oo`8001eoo`00<Goo00<007ooOol08Goo00=>LgooOol01goo00<03gooOol067oo00=>LgooOol0
47oo00<03gooOol03goo00=>LgooOol06Goo00<03gooOol01Woo00=>LgooOol08Woo00=>LgooOol0
47oo00<007ooOol06goo000aOol00dicOomoo`0QOol2CW<8Ool00`0?Oomoo`0HOol2CW<AOol00`0?
Oomoo`0?Ool2CW<JOol00`0?Oomoo`06Ool2CW<SOol2CW<AOol00`00Oomoo`0KOol0035oo`03CW=o
ogoo029oo`03CW=oogoo00Ioo`0300moogoo01Uoo`03CW=oogoo00moo`0300moogoo011oo`03CW=o
ogoo01Qoo`0300moogoo00Ioo`9>Lb=oo`9>La5oo`03001oogoo01]oo`00<Goo00<004icOol08Goo
00=>LgooCW<01goo00<03gooOol067oo00=>LgooCW<047oo00<03gooOol03goo0Tic6Woo00<03goo
Ool01goo00=>LgooOol08Goo00<03dicOol03goo0P007Goo000YOol40004Ool00`00Oomoo`0QOol0
0dicOomoo`07Ool00`0?Oomoo`0HOol00dicOomoo`0@Ool00`0?Oomoo`0?Ool00dicOomoo`0IOol0
0`0?Oomoo`06Ool00dicOomoo`0ROol00dicOomoo`0@Ool00`00Oomoo`0KOol002Yoo`03001oogoo
00Aoo`03001>Lgoo025oo`03CW=oodic00Moo`0300moogoo01Qoo`03CW=oodic011oo`0300moogoo
00moo`03CW=oodic01Uoo`0300moogoo00Ioo`03CW=oodic029oo`9>La5oo`03001oogoo01]oo`00
:goo00<007ooOol00goo00<004ic00l08`0?00=>L`0?00l08P0?00=>L`0?00l08P0?00=>L`0?00l0
7`0?00A>L`0?00m>Lb403`03CW<03dic00l03`<001eoo`00;7oo00<007ooOol00Woo00<004icOol0
8Goo00=>LgooCW<01goo00<03gooOol067oo00=>LgooCW<047oo00<03gooOol04Goo00=>LgooOol0
5goo00<03gooOol027oo00=>LgooOol087oo00<03gooCW<047oo00<007ooOol06goo000YOol01000
Oomoo`0017oo00<007ooOol08Goo00=>LgooOol01goo00<03gooOol067oo00=>LgooOol047oo00<0
3gooOol03Woo00=>LgooOol06Woo00<03gooOol01Goo00=>LgooOol08Woo00=>L`0?Ool04Goo00<0
07ooOol06goo000ZOol20005Ool00`00Oom>L`0QOol014icOomoodic1Woo00<03gooOol05goo00E>
LgooOomoodic00moo`0300moogoo00ioo`04CW=oogooCW<IOol00`0?Oomoo`05Ool014icOomoodic
8Goo00A>L`0?Oom>La1oo`03001oogoo01]oo`00<Goo0P0000=>LgooOol08Woo00=>LgooOol017oo
00<03gooOol06goo00=>LgooOol03Goo00<03gooOol03Woo00A>LgooOom>LaUoo`0300moogoo00Eo
o`04CW=oogooCW<QOol014ic00moodic3goo0P007Goo000aOol00`00Oom>L`0POol01DicOomoogoo
CW<01Woo00<03gooOol05goo00E>LgooOomoodic00moo`0300moogoo019oo`03CW=oogoo01Ioo`03
00moogoo00Uoo`03CW=oogoo01moo`0300moodic011oo`03001oogoo01]oo`00<Goo00<007ooOol0
87oo00=>LgooOol027oo00<03gooOol05goo00=>LgooOol04Goo00<03gooOol03Woo00=>LgooOol0
6Woo00<03gooOol01Goo00=>LgooOol08Woo00=>L`0?Ool04Goo00<007ooOol06goo000MOol4000@
Ool200000gooCW=oo`0NOol01DicOomoogooCW<01Woo00<03gooOol05goo00E>LgooOomoodic00mo
o`0300moogoo00ioo`05CW=oogooOom>L`0HOol00`0?Oomoo`05Ool01DicOomoogooCW<087oo00E>
L`0?Oomoodic00ioo`8001eoo`0077oo00<007ooOol04Woo00@007ooOom>Lb=oo`03CW=oogoo00Ao
o`0300moogoo01]oo`03CW=oogoo00eoo`0300moogoo00ioo`05CW=oogooOom>L`0HOol00`0?Oomo
o`05Ool01DicOomoogooCW<087oo00E>L`0?Oomoodic00moo`03001oogoo01]oo`0077oo00<007oo
Ool04Woo00@007ooOom>Lamoo`03CW=oogoo009oo`03CW=oogoo00=oo`0300moogoo01aoo`03CW=o
ogoo00aoo`0300moogoo019oo`03CW=oogoo01Ioo`0300moogoo00Uoo`03CW=oogoo01moo`0400mo
ogooCW<?Ool00`00Oomoo`0KOol001aoo`03001oogoo019oo`03001oogoo021oo`03CW=oogoo00Qo
o`0300moogoo01Moo`03CW=oogoo015oo`0300moogoo00ioo`03CW=oogoo01Yoo`0300moogoo00Eo
o`03CW=oogoo025oo`03CW=oo`0?019oo`03001oogoo01]oo`0077oo00D007ooOomoo`00011oo`80
0003Oom>Lgoo01ioo`03CW=oogoo009oo`03CW=oogoo00=oo`0300moogoo01Moo`03CW=oogoo009o
o`03CW=oogoo00aoo`0300moogoo00ioo`03CW=oogoo009oo`03CW=oogoo01Eoo`0300moogoo00Eo
o`03CW=oogoo009oo`03CW=oogoo01aoo`03CW=oo`0?009oo`03CW=oogoo00aoo`8001eoo`007Goo
100047oo00@007ooOom>LbAoo`03CW=oogoo00=oo`0300moogoo01Moo`03CW=oogoo009oo`03CW=o
ogoo00aoo`0300moogoo00ioo`03CW=oogoo009oo`03CW=oogoo01Eoo`0300moogoo00Aoo`03CW=o
ogoo00=oo`03CW=oogoo01aoo`03CW=oo`0?009oo`03CW=oogoo00eoo`03001oogoo01]oo`007Woo
0`0047oo00D007ooOomoodic01ioo`03CW=oogoo009oo`03CW=oogoo00=oo`0300moogoo01aoo`03
CW=oogoo00aoo`0300moogoo01=oo`03CW=oogoo01Eoo`0300moogoo00Yoo`03CW=oogoo01ioo`05
00moogooOom>L`0>Ool00`00Oomoo`0KOol001eoo`05001oogooOol0000=Ool4O00QOol00dicOomo
o`08Ool00`0?Oomoo`0GOol00dicOomoo`0AOol00`0?Oomoo`0=Ool00dicOomoo`0KOol00`0?Oomo
o`04Ool00dicOomoo`0ROol00dicOol03`0AOol2000MOol001eoo`05001oogooOol0000;Ool8O000
0dicOomoo`0LOol00dicOomoo`03Ool00dicOomoo`02Ool00`0?Oomoo`0GOol00dicOomoo`03Ool0
0dicOomoo`0;Ool00`0?Oomoo`0=Ool00dicOomoo`03Ool00dicOomoo`0EOol00`0?Oomoo`04Ool0
0dicOomoo`03Ool00dicOomoo`0LOol00dicOol03`03Ool00dicOomoo`0<Ool00`00Oomoo`0KOol0
01eoo`05001oogooOol00008Ool30008O0000dicOomoo`0;Ool2CW<EOol00dicOomoo`02Ool00`0?
Oomoo`06Ool2CW<>Ool00dicOomoo`04Ool00dicOomoo`0:Ool2CW<?Ool00dicOomoo`03Ool00dic
Oomoo`0;Ool2CW<8Ool00`0?Oomoo`04Ool00dicOomoo`03Ool00dicOomoo`0;Ool2CW<?Ool00dic
Ool03`03Ool00dicOomoo`0;Ool2CW<MOol001ioo`<000Yoo`03001l07`000Ql00aoo`A>LaAoo`03
CW=oogoo009oo`0300moogoo00Eoo`A>LaAoo`03CW=oogoo00Uoo`A>LaEoo`03CW=oogoo00Uoo`A>
L`Moo`0300moogoo00]oo`03CW=oogoo00Uoo`A>La1oo`0500moogooOom>L`0<Ool4CW<LOol002Uo
o`<000Yl00`03`A>L`d03`03CW<03`0?01403`A>L`d03`03CW<03`0?01003`A>L`h03`03CW<03`0?
01003`A>L`h03`03CW<03`0?01003`A>L`h03`03CW<03`0?01003`A>Laaoo`007Goo0P0000=oo`00
00001goo00<007oo00002W`000=>LgooOol02Woo0Tic3Woo00=>LgooOol017oo00=>LgooOol00Woo
00<03gooOol01Woo0Tic3Woo00=>LgooOol017oo00=>LgooOol02Woo0Tic3goo00=>LgooOol017oo
00=>LgooOol02Woo0Tic27oo00<03gooOol017oo00=>LgooOol017oo00=>LgooOol02Woo0Tic3goo
00=>Lgoo00l017oo00=>LgooOol02Woo0Tic7Goo000MOol01000Oomoo`0027oo00<007oo00002W`0
00=>LgooOol02Woo00=>LgooOol03Goo00=>LgooOol017oo00=>LgooOol00Woo00<03gooOol01Goo
0Tic3goo00=>LgooOol017oo00=>LgooOol02Woo0Tic3goo00=>LgooOol017oo00=>LgooOol02Woo
0Tic27oo00<03gooOol017oo00=>LgooOol017oo00=>LgooOol02Woo0Tic3goo00=>Lgoo00l017oo
00=>LgooOol02Woo00=>L`00Ool077oo000MOol01000Oomoo`002Goo0P0000=oog`0O0001W`000=o
odicOol02goo00=>LgooOol05Goo00E>LgooOomoo`0?00Qoo`03CW=oogoo01Eoo`03CW=oogoo00Yo
o`03CW=oogoo01Aoo`03CW=oogoo00]oo`03CW=oogoo00Ioo`0300moogoo00]oo`03CW=oogoo00]o
o`03CW=oogoo00moo`0300moogoo009oo`03CW=oogoo00]oo`03001oogoo01]oo`007Goo00@007oo
Ool000aoo`Ql00eoo`03CW=oodic00ioo`03CW=oogoo00Uoo`0300moogoo00Eoo`03CW=oodic00io
o`03CW=oogoo015oo`9>L`moo`03CW=oogoo011oo`03CW=oodic00Qoo`0300moogoo00Aoo`03CW=o
ogoo011oo`03CW=oodic00ioo`04CW=oogoo00l@Ool00dic0000000MOol001aoo`D000ioo`Al00=o
o`03CW=oogoo00Uoo`03CW=oogoo00ioo`03CW=oogoo00Eoo`05CW=oogooOol03`07Ool00dicOomo
o`0>Ool00dicOomoo`05Ool00dicOomoo`09Ool00dic00moo`0>Ool00dicOomoo`05Ool00dicOomo
o`08Ool00dicOomoo`08Ool00`0?Oomoo`04Ool00dicOomoo`05Ool00dicOomoo`08Ool00dicOomo
o`0>Ool014icOomoo`0?1Goo00=>LgooOol027oo00=>Lgoo00007Goo000aOol00`00Oomoo`02Ool0
0dicOomoo`08Ool014icOomoodic3Woo00=>LgooOol01Goo00E>LgooOomoo`0?00Ioo`04CW=oogoo
CW<>Ool00dicOomoo`05Ool00dicOomoo`08Ool014icOol03dic3Woo00=>LgooOol01Goo00=>Lgoo
Ool027oo00A>LgooOom>L`Moo`0300moogoo00=oo`03CW=oogoo00Ioo`03CW=oogoo00Qoo`03CW=o
odic00ioo`04CW=oogoo00l5Ool00dicOomoo`07Ool014icOomoo`007Goo000NOol3000@Ool20004
Ool00dicOomoo`07Ool014icOomoodic5Woo00E>LgooOomoo`0?00Uoo`03CW=oogoo01Aoo`03CW=o
ogoo00Yoo`0300m>Lgoo01Eoo`03CW=oogoo00]oo`03CW=oogoo00Eoo`0300moogoo00aoo`03CW=o
ogoo00Yoo`03CW=oogoo00moo`0300moogoo00=oo`03CW=oogoo00Uoo`8001eoo`007Woo00@007oo
Ool000moo`03001oogoo00eoo`04CW=oogooCW<>Ool00dicOomoo`09Ool00`0?Oomoo`03Ool01Dic
OomoogooCW<03Woo00=>LgooOol03goo00E>LgooOol03dic00eoo`03CW=oogoo011oo`05CW=oogoo
Oom>L`07Ool00`0?Oomoo`03Ool00dicOomoo`0@Ool01DicOomoogooCW<03Goo00A>LgooOol03`mo
o`04CW=oogoo000MOol001ioo`03001oogoo011oo`03001oogoo00=oo`03CW=oogoo00Ioo`03CW=o
ogoo011oo`03CW=oogoo00Ioo`04CW=oogoo00l5Ool00dicOomoo`0@Ool00dicOomoo`06Ool00dic
Oomoo`06Ool014icOomoo`0?3Woo00=>LgooOol01Woo00=>LgooOol01goo00=>LgooOol02Goo00<0
3gooOol00goo00=>LgooOol01Woo00=>LgooOol01goo00=>LgooOol03goo00A>LgooOol03`Eoo`03
CW=oogoo00Moo`04CW=oogoo000MOol001ioo`03001oogoo011oo`03001oogoo00=oo`03CW=oogoo
00Yoo`03CW=oogoo00aoo`03CW=oogoo00Ioo`04CW=oogoo00l9Ool00dicOomoo`0;Ool00dicOomo
o`07Ool00dicOomoo`06Ool01DicOomoo`0?CW<03Goo00=>LgooOol01Woo00=>LgooOol01goo00E>
LgooOomoodic00Moo`0300moogoo00=oo`03CW=oogoo00Ioo`03CW=oogoo00Ioo`03CW=oogoo009o
o`03CW=oogoo00]oo`04CW=oogoo00l5Ool00dicOomoo`06Ool01DicOomoogoo00007Goo000MOol4
000@Ool20004Ool00dicOomoo`05Ool00dicOomoo`02Ool00dicOomoo`0EOol014icOomoo`0?17oo
00=>LgooOol00Woo00=>LgooOol05Goo00=>LgooOol01Goo00I>LgooOomoo`0?CW<GOol00dicOomo
o`05Ool00dicOomoo`02Ool00dicOomoo`05Ool00`0?Oomoo`0=Ool00dicOomoo`0:Ool00dicOomo
o`0>Ool00`0?Oomoo`04Ool00dicOomoo`08Ool2000MOol001ioo`03001oogoo011oo`03001oogoo
00]oo`03CW=oogoo00=oo`03CW=oogoo00Yoo`03CW=oogoo00Yoo`0300moogoo009oo`03CW=oogoo
009oo`03CW=oogoo00]oo`03CW=oogoo00moo`06CW=oogooOol03dic3Goo00=>LgooOol03goo00=>
LgooOol00Woo00=>LgooOol01Goo00<03gooOol00goo00=>LgooOol03goo00=>LgooOol00Woo00=>
LgooOol02goo00A>LgooOol03`ioo`05CW=oogooOol0000MOol001ioo`@000moo`03001oogoo00Ao
o`03CW=oogoo00Aoo`03CW=oogoo011oo`03CW=oogoo00Moo`04CW=oogoo00l3Ool00dicOomoo`0A
Ool00dicOomoo`07Ool00dicOomoo`04Ool00dicOomoo`02Ool00`0?Oomoo`0<Ool00dicOomoo`07
Ool00dicOomoo`04Ool00dicOomoo`0;Ool00`0?Oomoo`03Ool00dicOomoo`07Ool00dicOomoo`04
Ool00dicOomoo`0AOol014icOomoo`0?1Woo00=>LgooOol01Goo00E>LgooOomoo`0001eoo`007Goo
00<007ooOol04Goo0P001Goo00=>LgooOol02Woo00=>LgooOol02Woo00=>LgooOol01goo00A>Lgoo
Ool03`Yoo`03CW=oogoo00Yoo`03CW=oogoo00Moo`03CW=oogoo00Uoo`0300moodic00aoo`03CW=o
ogoo00Moo`03CW=oogoo00Yoo`03CW=oogoo00Eoo`0300moogoo00=oo`03CW=oogoo00Moo`03CW=o
ogoo00Yoo`03CW=oogoo00]oo`04CW=oogoo00l6Ool00dicOomoo`04Ool014icOomoogoo0P007Goo
000MOol5000?Ool00`00Oomoo`04Ool00dicOomoo`03Ool00dicOomoo`04Ool00dicOomoo`0EOol0
0dicOol03`03Ool00dicOomoo`04Ool00dicOomoo`0EOol00dicOomoo`03Ool00dicOomoo`02Ool0
0`0?Oom>L`0GOol00dicOomoo`03Ool00dicOomoo`03Ool00dicOomoo`05Ool00`0?Oomoo`0=Ool0
0dicOomoo`03Ool00dicOomoo`04Ool00dicOomoo`0>Ool00`0?Oomoo`04Ool00dicOomoo`03Ool0
0dicOomoo`03Ool00`00Oomoo`0KOol001eoo`05001oogooOol00008Ool20005Ool00`00Oomoo`0:
Ool00dicOomoo`04Ool00dicOomoo`0:Ool00dicOomoo`0:Ool01@0?OomoogooCW<01Woo00=>Lgoo
Ool02Woo00=>LgooOol03Woo00=>LgooOol00Woo00<03gooCW<037oo00=>LgooOol03Woo00=>Lgoo
Ool017oo00=>LgooOol017oo00<03gooOol00goo00=>LgooOol03Goo00=>LgooOol017oo00=>Lgoo
Ool02Woo00E>LgooOomoo`0?00aoo`03CW=oogoo00=oo`03001oogoo01]oo`007Woo0`0027oo00@0
07ooOol000Aoo`03001oogoo00Aoo`03CW=oogoo009oo`03CW=oogoo019oo`03CW=oogoo00Qoo`03
CW=oo`0?009oo`03CW=oogoo019oo`03CW=oogoo00Qoo`03CW=oogoo009oo`03CW=oogoo00=oo`03
00moogoo00aoo`03CW=oogoo00Qoo`03CW=oogoo009oo`03CW=oogoo00aoo`0300moogoo00=oo`03
CW=oogoo00Qoo`03CW=oogoo009oo`03CW=oogoo015oo`05CW=oogooOol03`07Ool00dicOomoo`02
Ool00dicOomoo`03Ool00`00Oomoo`0KOol002Uoo`04001oogoo0004Ool2000500l00dic00l03`0:
00l00dic00l03`0:00l00dic00l03`0800l00dic00l03`0:00l00dic00l03`0:00l00dic00l03`08
00l00dic00l03`0:00l00dic00l03`0:00l00dic00l03`0800l00dic00l03`0:00l00dic00l03`09
00l00dic00l03`0900l00dic00l03`0:00l00dic00l03`0900l00dic00l03`0900l00dic00l03`06
00l3000MOol001eoo`800003Ool0000000Moo`<000Eoo`03001oogoo00Eoo`05CW=oogooOom>L`07
Ool00dicOomoo`0EOol00dicOol03`02Ool00dicOomoo`05Ool00dicOomoo`0EOol01DicOomoogoo
CW<01Woo00<03gooCW<05goo00E>LgooOomoodic00Qoo`03CW=oogoo00Aoo`0300moogoo00ioo`05
CW=oogooOom>L`08Ool00dicOomoo`0=Ool00`0?Oomoo`05Ool01DicOomoogooCW<01Woo00<007oo
Ool06goo000MOol01000Oomoo`0027oo00<007ooOol01Goo00<007ooOol02Goo00=>LgooOol01Woo
00=>LgooOol02Goo00=>LgooOol02Woo00@03gooOom>L`Moo`03CW=oogoo00Uoo`03CW=oogoo00eo
o`03CW=oogoo00Aoo`0300moodic00]oo`03CW=oogoo00eoo`03CW=oogoo00Ioo`03CW=oogoo00Ao
o`0300moogoo009oo`03CW=oogoo00eoo`03CW=oogoo00Ioo`03CW=oogoo00Uoo`05CW=oogooOol0
3`0;Ool00dicOomoo`04Ool00`00Oomoo`0KOol001eoo`04001oogoo0009Ool30004Ool20006Ool0
14icOomoodic5Goo00=>LgooOol02Goo00A>L`0?Oom>LaAoo`03CW=oogoo00Yoo`04CW=oogooCW<6
Ool00`0?Oomoo`0;Ool00dicOomoo`0:Ool014icOomoodic3goo00<03gooOol00Woo00=>LgooOol0
2Goo00A>LgooOom>LaEoo`05CW=oogooOol03`07Ool014icOomoodic1Woo0P007Goo000MOol01000
Oomoo`0047oo00<007ooOol01Goo00=>LgooOol02Woo00=>LgooOol027oo00=>LgooOol02Woo00=>
L`0?Ool02Woo00=>LgooOol027oo00=>LgooOol02Woo00=>LgooOol01goo00<03gooCW<02goo00=>
LgooOol02Woo00=>LgooOol02Goo00=>LgooOol017oo00<03gooOol00Woo00=>LgooOol02Goo00=>
LgooOol02Woo00=>LgooOol02Goo00E>LgooOomoo`0?00Moo`03CW=oogoo00Qoo`03001oogoo01]o
o`0077oo1@0047oo00<007ooOol01Goo00=>LgooCW<02Woo00=>LgooOol05Goo00=>L`0?CW<02Woo
00=>LgooOol05Goo00=>LgooCW<01goo00<03gooCW<067oo00=>LgooCW<02Goo00=>LgooOol017oo
00<03gooOol03goo00=>LgooCW<02Goo00=>LgooOol03Goo00<03gooOol01Woo00=>LgooCW<01goo
00<007ooOol06goo000aOol00`00Oomoo`07Ool00dicOomoo`08Ool00dicOomoo`08Ool00dicOomo
o`0;Ool00`0?CW=oo`09Ool00dicOomoo`08Ool00dicOomoo`0<Ool00dicOomoo`05Ool0100?Oomo
odic2Woo00=>LgooOol037oo00=>LgooOol027oo00=>LgooOol00goo00<03gooOol00Woo00=>Lgoo
Ool037oo00=>LgooOol01goo00=>LgooOol02Goo00E>LgooOomoo`0?00Yoo`03CW=oogoo00Eoo`03
001oogoo01]oo`007Woo0`0047oo0P001goo0Tic5Goo00=>LgooOol02Woo0dic5Goo00=>LgooOol0
2Woo0Tic27oo00<03gooOol02goo00=>LgooOol02Woo0Tic4Goo00<03gooOol00Woo00=>LgooOol0
2Woo0Tic5Woo00E>LgooOomoo`0?00Qoo`9>L`Moo`8001eoo`007Woo00@007ooOol000moo`03001o
ogoo00Eoo`A>L`Uoo`03CW=oogoo00Qoo`03CW=oogoo00Uoo`A>L`Yoo`03CW=oogoo00Qoo`03CW=o
ogoo00Uoo`A>L`Moo`0400moogooCW<:Ool00dicOomoo`09Ool4CW<:Ool00dicOomoo`03Ool00`0?
Oomoo`02Ool00dicOomoo`09Ool4CW<:Ool00dicOomoo`08Ool01DicOomoogoo00l01goo14ic1goo
00<007ooOol06goo000NOol00`00Oomoo`0@Ool00`00Oomoo`05Ool4CW<9Ool00dicOomoo`0DOol4
CW<:Ool00dicOomoo`0DOol4CW<7Ool0100?Oomoodic5Woo14ic2Woo00=>LgooOol00goo00<03goo
Ool03Woo14ic2Woo00=>LgooOol037oo00<03gooOol01Goo14ic1goo00<007ooOol06goo000NOol0
0`00Oomoo`0@Ool00`00Oomoo`06Ool2CW<:Ool00dicOomoo`08Ool00dicOomoo`0:Ool2CW<;Ool0
0dicOomoo`08Ool00dicOomoo`0:Ool2CW<8Ool0100?Oomoodic2Woo00=>LgooOol02Woo0Tic2goo
00=>LgooOol00goo00D03gooOomoodic00eoo`9>L`]oo`03CW=oogoo00Moo`03CW=oogoo009oo`03
00moogoo00Ioo`9>L`Qoo`03001oogoo01]oo`007Goo100047oo0P007Woo00=>LgooOol02goo00<0
3gooOol057oo00=>LgooOol057oo00<03gooOol02goo00=>LgooOol07Goo00D03gooOomoodic02Ao
o`03CW=oogoo009oo`0300moogoo00moo`8001eoo`007Woo00<007ooOol047oo00<007ooOol04goo
00=>LgooOol01goo00=>LgooOol02goo00<03gooOol02Woo00=>LgooOol01goo00=>LgooOol057oo
00@03gooOom>L`Uoo`03CW=oogoo01Qoo`03CW=oogoo00=oo`0500moogooOom>L`0JOol00dicOomo
o`07Ool00dicOomoo`02Ool00`0?Oomoo`0@Ool00`00Oomoo`0KOol001eoo`@0011oo`03001oogoo
01=oo`03CW=oogoo01Eoo`0300moogoo00Yoo`03CW=oogoo01ioo`0400moogooCW<TOol00dicOomo
o`03Ool00`0?Oomoo`0LOol00dicOomoo`0<Ool00`0?Oomoo`0@Ool00`00Oomoo`0KOol0021oo`03
001oogoo00ioo`8001Aoo`03CW=oogoo00Moo`03CW=oogoo00]oo`0300moogoo00Yoo`03CW=oogoo
00Ioo`03CW=oogoo01Eoo`0500moogooOom>L`08Ool00dicOomoo`0HOol00dicOomoo`03Ool01@0?
OomoogooCW<06Woo00=>LgooOol01goo00=>LgooOol00Woo00<03gooOol03goo0P007Goo000MOol4
000@Ool00`00Oomoo`0MOol00dicOomoo`0;Ool00`0?Oomoo`0COol00dicOomoo`0EOol00`0?Oomo
o`0:Ool00dicOomoo`0NOol01@0?OomoogooCW<097oo00=>LgooOol00Woo00<03gooOol047oo00<0
07ooOol06goo000MOol00`00Oomoo`0:Ool20005Ool00`00Oomoo`0COol00dicOomoo`06Ool00dic
Oomoo`0<Ool00`0?Oomoo`0:Ool00dicOomoo`06Ool00dicOomoo`0EOol01@0?OomoogooCW<027oo
00=>LgooOol06Goo00=>LgooOol00Woo00D03gooOomoodic01]oo`03CW=oogoo00Ioo`03CW=oogoo
009oo`0300moogoo011oo`03001oogoo01]oo`007Goo100027oo00@007ooOol000Aoo`03001oogoo
01=oo`03CW=oogoo01Eoo`0300moogoo00Yoo`03CW=oogoo01ioo`0500moogooOom>L`0TOol00dic
Oomoo`02Ool00`0?Oomoo`0MOol00dicOomoo`0;Ool00`0?Oomoo`0@Ool00`00Oomoo`0KOol002Uo
o`04001oogoo0004Ool2000D00l00dic00l03`0600l00dic00l03`0I00l00dic00l03`0600l00dic
00l03`0I00l00dic00l03`0600l00dic00l03`0I00l00dic00l03`0600l00dic00l03`0I00l00dic
00l03`0600l00dic00l03`0C00l3000MOol002Yoo`8000Eoo`03001oogoo01aoo`03CW=oogoo00ao
o`0300moogoo01=oo`03CW=oogoo01Eoo`0300moogoo00Yoo`03CW=oogoo01ioo`0500moogooOom>
L`0TOol00dicOomoo`02Ool00`0?Oomoo`0@Ool00`00Oomoo`0KOol002Uoo`04001oogoo0004Ool0
0`00Oomoo`0LOol00dicOomoo`0<Ool00`0?Oomoo`0:Ool00dicOomoo`06Ool00dicOomoo`0EOol0
1@0?OomoogooCW<027oo00=>LgooOol06Goo00=>LgooOol00Woo00D03gooOomoodic01]oo`03CW=o
ogoo00Ioo`03CW=oogoo009oo`0300moogoo011oo`03001oogoo01]oo`00:Woo0P001Goo0P005Goo
00=>LgooOol057oo00<03gooOol02Woo00=>LgooOol07Woo00D03gooOomoodic02Aoo`03CW=oogoo
009oo`0300moogoo01eoo`03CW=oogoo00]oo`0300moogoo00moo`8001eoo`00<Goo00<007ooOol0
57oo00=>LgooOol01Goo00=>LgooOol037oo00<03gooOol02goo00=>LgooOol01Goo00=>LgooOol0
5Goo00<03gooOol00Woo00=>LgooOol01Goo00=>LgooOol06Goo00=>LgooOol00Woo00@03gooOom>
Laaoo`03CW=oogoo00Eoo`03CW=oogoo00=oo`0300moogoo011oo`03001oogoo01]oo`00<Goo00<0
07ooOol057oo00=>LgooOol01Goo00=>LgooOol037oo00<03gooOol04goo00=>LgooOol05Goo00<0
3gooOol02Woo00=>LgooOol07Woo00@03gooOom>LbAoo`03CW=oogoo00=oo`0300moogoo011oo`03
001oogoo01]oo`00<Goo00<007ooOol077oo00=>LgooOol037oo00<03gooOol02goo00=>LgooOol0
1Goo00=>LgooOol05Goo00<03gooOol00Woo00=>LgooOol017oo00=>LgooOol06goo00E>LgooOomo
o`0?009oo`03CW=oogoo01Yoo`03CW=oogoo00Eoo`03CW=oogoo00=oo`0300moogoo011oo`03001o
ogoo01]oo`0077oo0P000Woo0P003goo0P005Goo00=>LgooOol057oo00<03gooOol02goo00=>Lgoo
Ool07Goo00<03gooOol00Woo00=>LgooOol08Woo00E>LgooOomoo`0?01moo`03CW=oogoo00]oo`03
00moogoo00moo`8001eoo`007Goo00@007oo0000011oo`03001oogoo01Aoo`03CW=oogoo00Eoo`03
CW=oogoo00aoo`0300moogoo00]oo`03CW=oogoo00Aoo`03CW=oogoo01Ioo`0300moogoo009oo`03
CW=oogoo00Aoo`03CW=oogoo01]oo`05CW=oogooOol03`02Ool00dicOomoo`0KOol00dicOomoo`04
Ool00dicOomoo`03Ool00`0?Oomoo`0@Ool00`00Oomoo`0KOol001eoo`<0015oo`03001oogoo01Ao
o`03CW=oogoo00Eoo`03CW=oogoo00aoo`0300moogoo019oo`03CW=oogoo01Ioo`0300moogoo00Uo
o`03CW=oogoo01moo`0400moogooCW<TOol00dicOomoo`03Ool00`0?Oomoo`0@Ool00`00Oomoo`0K
Ool001eoo`04001oogoo000@Ool00`00Oomoo`0KOol00dicOomoo`0=Ool00`0?Oomoo`0;Ool00dic
Oomoo`04Ool00dicOomoo`0FOol00`0?Oomoo`02Ool00dicOomoo`04Ool00dicOomoo`0KOol01Dic
Oomoogoo00l00Woo00=>LgooOol06goo00=>LgooOol017oo00=>LgooOol00goo00<03gooOol047oo
00<007ooOol06goo000MOol01000Oomoo`0047oo0P005Woo00=>LgooOol04goo00<03gooOol02goo
00=>LgooOol07Goo00<03gooOol00Woo00=>LgooOol08Woo00E>LgooOomoo`0?021oo`03CW=oogoo
00Yoo`0300moogoo00moo`8001eoo`0077oo10004Goo00<007ooOol05Goo00=>LgooOol00goo00=>
LgooOol03Goo00<03gooOol037oo00=>LgooOol00goo00=>LgooOol05Woo00<03gooOol00Woo00=>
LgooOol017oo00=>LgooOol06goo00E>LgooOomoo`0?009oo`03CW=oogoo01]oo`03CW=oogoo00Ao
o`03CW=oogoo00=oo`0300moogoo011oo`03001oogoo01]oo`007Woo10003goo00<007ooOol05Goo
00=>LgooOol00goo00=>LgooOol03Goo00<03gooOol037oo00=>LgooOol00goo00=>LgooOol05Woo
00<03gooOol02Goo00=>LgooOol07goo00@03gooOom>LbAoo`03CW=oogoo00=oo`0300moogoo011o
o`03001oogoo01]oo`007Goo00<007ooOol04Goo0P0077oo00=>LgooOol03Goo00<03gooOol04Woo
00=>LgooOol05Woo00<03gooOol00goo00=>LgooOol00goo00=>LgooOol077oo00A>LgooOol03`9o
o`03CW=oogoo01]oo`03CW=oogoo00=oo`03CW=oogoo00Aoo`0300moogoo00moo`8001eoo`007Goo
1@003goo00<007ooOol05Goo00=>LgooOol04goo00<03gooOol037oo00=>LgooOol077oo00<03goo
Ool00goo00=>LgooOol08Woo00A>LgooOol03b1oo`03CW=oogoo00Yoo`0300moogoo011oo`03001o
ogoo01]oo`007Goo00H007ooOomoo`00Ool30004Ool20005Ool00`00Oomoo`0EOol00dicOomoo`03
Ool00dicOomoo`0=Ool00`0?Oomoo`0<Ool00dicOomoo`03Ool00dicOomoo`0FOol00`0?Oomoo`03
Ool00dicOomoo`03Ool00dicOomoo`0LOol01TicOomoo`0?Oom>Lamoo`03CW=oogoo009oo`03CW=o
ogoo00Aoo`0300moogoo011oo`03001oogoo01]oo`007Woo0`000goo00<007ooOol00Woo00@007oo
Ool000Aoo`03001oogoo01Eoo`03CW=oogoo00=oo`03CW=oogoo00eoo`0300moogoo00aoo`03CW=o
ogoo00=oo`03CW=oogoo01Ioo`0300moogoo00Uoo`03CW=oogoo01moo`0300moodic02Aoo`03CW=o
ogoo00Aoo`0300moogoo011oo`03001oogoo01]oo`008Goo00@007ooOol000Aoo`04001oogoo0004
Ool2000L00l00dic00l03`0R00l00dic00l03`0L00l00dic00l03`0200l00dic00l03`0M00l00dic
00l03`0200l00dic00l03`0M00l00dic00l03`0200l00dic00l03`0E00l3000MOol001ioo`@0009o
o`03001oogoo009oo`04001oogoo0004Ool00`00Oomoo`0EOol00dicOomoo`0COol00`0?Oomoo`0<
Ool00dicOomoo`0LOol00`0?Oomoo`03Ool00dicOomoo`0ROol014icOomoo`0?8Goo00=>LgooOol0
2Goo00<03gooOol047oo00<007ooOol06goo000MOol01@00Oomoogoo00000Woo00<007ooOol00Woo
00@007ooOol000Aoo`03001oogoo01Eoo`03CW=oogoo00=oo`03CW=oogoo00eoo`0300moogoo00ao
o`03CW=oogoo009oo`03CW=oogoo01Moo`0300moogoo00=oo`03CW=oogoo009oo`03CW=oogoo01eo
o`06CW=oogoo00moodic7goo00=>LgooOol00Woo00=>LgooOol017oo00<03gooOol047oo00<007oo
Ool06goo000MOol01P00Oomoogoo001oo`8000Eoo`8000Eoo`8001Moo`03CW=oogoo009oo`03CW=o
ogoo00eoo`0300moogoo00eoo`05CW=oogooOom>L`0IOol00`0?Oomoo`08Ool00dicOomoo`0POol0
0`0?Oom>L`0TOol00dicOomoo`04Ool00`0?Oomoo`0?Ool2000MOol001eoo`05001oogooOol0000?
Ool00`00Oomoo`0JOol00dicOomoo`0>Ool00`0?Oomoo`0AOol00dicOomoo`0GOol00`0?Oomoo`04
Ool01DicOomoogooCW<07goo00I>LgooOol03gooCW<OOol00dicOomoo`02Ool00dicOomoo`04Ool0
0`0?Oomoo`0@Ool00`00Oomoo`0KOol001ioo`D000ioo`03001oogoo01Ioo`03CW=oogoo019oo`03
00moogoo00eoo`03CW=oogoo01]oo`0300moogoo00Aoo`03CW=oogoo025oo`04CW=oogoo00lQOol0
0dicOomoo`09Ool00`0?Oomoo`0@Ool00`00Oomoo`0KOol0035oo`03001oogoo01Ioo`05CW=oogoo
Oom>L`0@Ool00`0?Oomoo`0=Ool01DicOomoogooCW<06Goo00<03gooOol017oo00E>LgooOomoodic
021oo`05CW=oo`0?Oom>L`0POol01DicOomoogooCW<01Woo00<03gooOol047oo00<007ooOol06goo
000MOol4000@Ool2000GOol01DicOomoogooCW<047oo00<03gooOol03Goo00E>LgooOomoodic01Uo
o`0300moogoo00Aoo`05CW=oogooOom>L`0ROol00`0?Oom>L`0TOol00dicOomoo`04Ool00`0?Oomo
o`0?Ool2000MOol001ioo`03001oogoo011oo`03001oogoo01Yoo`03CW=oogoo00ioo`0300moogoo
015oo`03CW=oogoo01Moo`0300moogoo00Qoo`03CW=oogoo01ioo`05CW=oo`0?Oom>L`0POol014ic
Oomoodic1goo00<03gooOol047oo00<007ooOol06goo000OOol00`00Oomoo`0?Ool00`00Oomoo`0F
Ool00dicOomoo`0BOol00`0?Oomoo`0=Ool00dicOomoo`0KOol00`0?Oomoo`04Ool00dicOomoo`0R
Ool00dicOol03`0ROol00dicOomoo`08Ool00`0?Oomoo`0@Ool00`00Oomoo`0KOol0021oo`03001o
ogoo00ioo`8001Moo`05CW=oogooOom>L`0@Ool00`0?Oomoo`0=Ool01DicOomoogooCW<06Goo00<0
3gooOol017oo00E>LgooOomoodic021oo`04CW=oo`0?CW<QOol014icOomoodic1goo00<03gooOol0
3goo0P007Goo000MOol01000Oomoo`0047oo00<007ooOol05goo00A>LgooOom>La1oo`0300moogoo
00eoo`05CW=oogooOom>L`0IOol00`0?Oomoo`04Ool01DicOomoogooCW<08Woo00<03dicOol08goo
00=>LgooOol01Goo00<03gooOol047oo00<007ooOol06goo000NOol2000AOol00`00Oomoo`0JOol0
0dicOomoo`0>Ool00`0?Oomoo`0@Ool00dicOomoo`0HOol00`0?Oomoo`07Ool00dicOomoo`0OOol0
14icOol03dic8Goo00A>LgooOom>L`Moo`0300moogoo011oo`03001oogoo01]oo`00<Goo00<007oo
Ool05goo00=>LgooOol04Goo00<03gooOol03Woo00=>LgooOol06Woo00<03gooOol01Goo00=>Lgoo
Ool08Goo00=>Lgoo00l08Woo00=>LgooOol027oo00<03gooOol047oo00<007ooOol06goo000aOol2
000HOol00dicOom>L`0AOol00`0?Oomoo`0>Ool00dicOom>L`0JOol00`0?Oomoo`05Ool00dicOom>
L`0ROol00dic00m>L`0QOol014icOomoodic1goo00<03gooOol03goo0P007Goo000aOol00`00Oomo
o`0GOol00dicOom>L`0AOol00`0?Oomoo`0>Ool00dicOom>L`0JOol00`0?Oomoo`05Ool00dicOom>
L`0SOol00`0?CW=oo`0SOol00dicOomoo`05Ool00`0?Oomoo`0@Ool00`00Oomoo`0KOol002=oo`<0
00=oo`@000Aoo`03001oogoo01Uoo`03CW=oogoo00moo`0300moogoo011oo`03CW=oogoo01Qoo`03
00moogoo00Moo`03CW=oogoo025oo`0300m>Lgoo025oo`03CW=oodic00Moo`0300moogoo011oo`03
001oogoo01]oo`0097oo00<007ooOol00goo00<007ooOol017oo00<007ooOol05goo00=>LgooOol0
4Goo00<03gooOol03Woo00=>LgooOol06Woo00<03gooOol01Goo00=>LgooOol08Woo00=>L`0?Ool0
8Woo00=>LgooCW<01goo00<03gooOol047oo00<007ooOol06goo000TOol00`00Oomoo`04Ool00`00
Oomoo`03Ool2000H00l00dic00m>L`0R00l00dic00m>L`0R00l00dic00m>L`0R00l00dic00m>L`0R
00l00dic00l03`0H00l3000MOol002Aoo`03001oogoo00Eoo`03001oogoo009oo`03001oogoo01Qo
o`9>La5oo`0300moogoo00ioo`03CW=oodic01Yoo`0300moogoo00Eoo`03CW=oodic029oo`03CW<0
3dic02Aoo`03CW=oogoo00Eoo`0300moogoo011oo`03001oogoo01]oo`0097oo00<007ooOol00Woo
00@007ooOol000Aoo`03001oogoo01Uoo`03CW=oogoo00moo`0300moogoo011oo`03CW=oogoo01Qo
o`0300moogoo00Moo`03CW=oogoo025oo`0300m>Lgoo025oo`03CW=oodic00Moo`0300moogoo011o
o`03001oogoo01]oo`008goo0P001Goo0P001Goo0P006Goo00=>LgooOol047oo00<03gooOol03goo
00=>LgooOol06Goo00<03gooOol01Goo00=>LgooOol08Woo00=>L`0?Ool08Woo0Tic27oo00<03goo
Ool03goo0P007Goo000aOol00`00Oomoo`0HOol2CW<AOol00`0?Oomoo`0?Ool2CW<JOol00`0?Oomo
o`05Ool2CW<SOol00dic00moo`0ROol00dicOomoo`07Ool00`0?Oomoo`0@Ool00`00Oomoo`0KOol0
035oo`03001oogoo01Qoo`9>La5oo`0300moogoo00moo`9>LaYoo`0300moogoo00Ioo`03CW=oogoo
029oo`03CW=oogoo029oo`03CW=oogoo00Ioo`0300moogoo011oo`03001oogoo01]oo`00<Goo00<0
07ooOol06Goo00=>LgooOol03goo00<03gooOol03goo00=>LgooOol06Goo00<03gooOol01Woo00=>
LgooOol08Woo00=>LgooOol08Woo00=>LgooOol01Woo00<03gooOol047oo00<007ooOol06goo000a
Ool2000IOol2CW<AOol00`0?Oomoo`0?Ool2CW<JOol00`0?Oomoo`06Ool2CW<SOol2CW<ROol2CW<8
Ool00`0?Oomoo`0?Ool2000MOol0035oo`03001oogoo01Moo`A>La1oo`0300moogoo00ioo`A>LaUo
o`0300moogoo00Eoo`A>Lb5oo`A>Lb1oo`A>L`Moo`0300moogoo011oo`03001oogoo01]oo`00<Goo
00<007ooOol05goo14ic47oo00<03gooOol03Woo14ic6Goo00<03gooOol01Goo14ic8Goo14ic87oo
14ic1goo00<03gooOol047oo00<007ooOol06goo000aOol2000IOol2CW<AOol00`0?Oomoo`0?Ool2
CW<JOol00`0?Oomoo`06Ool2CW<SOol2CW<ROol2CW<8Ool00`0?Oomoo`0?Ool2000MOol0035oo`03
001oogoo02]oo`0300moogoo02]oo`0300moogoo02]oo`0300moogoo02]oo`0300moogoo011oo`03
001oogoo01]oo`00<Goo00<007ooOol0:goo00<03gooOol0:goo00<03gooOol0:goo00<03gooOol0
:goo00<03gooOol047oo00<007ooOol06goo000aOol00`00Oomoo`0[Ool00`0?Oomoo`0[Ool00`0?
Oomoo`0[Ool00`0?Oomoo`0[Ool00`0?Oomoo`0@Ool00`00Oomoo`0KOol0035oo`8002aoo`0300mo
ogoo02]oo`0300moogoo02]oo`0300moogoo02]oo`0300moogoo00moo`8001eoo`008goo0`0017oo
0`0017oo00<007ooOol0:goo00<03gooOol0:goo00<03gooOol0:goo00<03gooOol0:goo00<03goo
Ool047oo00<007ooOol06goo000TOol00`00Oomoo`04Ool00`00Oomoo`03Ool00`00Oomoo`0[Ool0
0`00Oomoo`0[Ool00`00Oomoo`0[Ool00`00Oomoo`0[Ool00`00Oomoo`0@Ool00`00Oomoo`0KOol0
02Aoo`03001oogoo009oo`@000Aool`001eoo`0097oo00<007ooOol00Woo00<007oo0000kWoo000T
Ool00`00Oomoo`02Ool00`00Ool0003^Ool002=oo`8000Eoo`800>ioo`00ogoo6goo003oOolKOol0
0:Aoo`<007=oo`00Ygoo00<007ooOol0L7oo001WOol01@00Oomoogoo00000Woo100000=oo`000000
0`0000=oo`0000000P000Woo1@0000=oo`0000000P000goo10001Woo0P000Woo0P000Woo10000Woo
100000=oo`0000000P005Goo0`00EGoo001WOol01`00Oomoogoo001oo`0000Eoo`04001oogoo0005
Ool01000Oomoo`000Woo00D007ooOomoo`0000Aoo`03001oogoo00Uoo`04001oo`000002Ool00`00
Oomoo`03Ool01@00Oomoogoo00000Woo00<007ooOol05Woo00<007ooOol0E7oo001WOol01P00Ool0
07oo001oo`D00003Ool000000080009oo`@0009oo`04001oogoo0003Ool00`00Oomoo`02Ool50007
Ool30003Ool500000goo001oo`02Ool01@00Oomoogoo00002Goo1@001goo1000EGoo001WOol01`00
Ool007oo001oo`0000=oo`03001oogoo009oo`04001oogoo0005Ool01000Oomoo`000goo0P000goo
00D007ooOomoo`0000Moo`04001oogoo0002Ool01`00Oomoogoo001oo`0000=oo`03001oogoo009o
o`03001oogoo019oo`03001oo`0005Ioo`00Igoo0P0000=oo`0000000Woo0`000goo0`000Woo1000
00Aoo`00001oo`80009oo`800003Ool00000009oo`<000Qoo`04001oogoo0003Ool30003Ool60002
Ool00`00Oomoo`06Ool50007Ool00`00Ool0001FOol006Ioo`8000=oo`8002Uoo`@0011oo`8001Io
o`8005Ioo`00ogoo6goo003oOolKOol00001\
\>"],
  ImageRangeCache->{{{0, 281}, {173, 0}} -> {-5.34934, -3.65371, 0.108514, 
  0.111732}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.0714286 0.047619 0 0.0441453 [
[(5)] .16667 0 0 2 0 Minner Mrotsboxa
[(10)] .40476 0 0 2 0 Minner Mrotsboxa
[(15)] .64286 0 0 2 0 Minner Mrotsboxa
[(20)] .88095 0 0 2 0 Minner Mrotsboxa
[(Contents Reg1 {a:x^a mod n = 4})] .5 0 0 2 0 0 -1 Mouter Mrotsboxa
[(0)] -0.0125 0 1 0 0 Minner Mrotsboxa
[(2)] -0.0125 .08829 1 0 0 Minner Mrotsboxa
[(4)] -0.0125 .17658 1 0 0 Minner Mrotsboxa
[(6)] -0.0125 .26487 1 0 0 Minner Mrotsboxa
[(8)] -0.0125 .35316 1 0 0 Minner Mrotsboxa
[(10)] -0.0125 .44145 1 0 0 Minner Mrotsboxa
[(12)] -0.0125 .52974 1 0 0 Minner Mrotsboxa
[(14)] -0.0125 .61803 1 0 0 Minner Mrotsboxa
[(Contents Reg2)] -0.0125 .30902 1 0 90 -1 0 Mouter Mrotsboxa
[(Project Reg1: {a:x^a mod n = 4})] .5 .61803 0 -2 Msboxa
[ -0.001 -0.001 0 0 ]
[ 1.001 .61903 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
[ ] 0 setdash
0 g
p
p
0 0 .5 r
.001 w
.16667 0 m
.16667 .61803 L
s
P
p
0 0 .5 r
.001 w
.40476 0 m
.40476 .61803 L
s
P
p
0 0 .5 r
.001 w
.64286 0 m
.64286 .61803 L
s
P
p
0 0 .5 r
.001 w
.88095 0 m
.88095 .61803 L
s
P
p
0 0 .5 r
.001 w
0 .08829 m
1 .08829 L
s
P
p
0 0 .5 r
.001 w
0 .17658 m
1 .17658 L
s
P
p
0 0 .5 r
.001 w
0 .26487 m
1 .26487 L
s
P
p
0 0 .5 r
.001 w
0 .35316 m
1 .35316 L
s
P
p
0 0 .5 r
.001 w
0 .44145 m
1 .44145 L
s
P
p
0 0 .5 r
.001 w
0 .52974 m
1 .52974 L
s
P
p
.002 w
.16667 0 m
.16667 .00625 L
s
P
[(5)] .16667 0 0 2 0 Minner Mrotshowa
p
.002 w
.40476 0 m
.40476 .00625 L
s
P
[(10)] .40476 0 0 2 0 Minner Mrotshowa
p
.002 w
.64286 0 m
.64286 .00625 L
s
P
[(15)] .64286 0 0 2 0 Minner Mrotshowa
p
.002 w
.88095 0 m
.88095 .00625 L
s
P
[(20)] .88095 0 0 2 0 Minner Mrotshowa
p
.001 w
.21429 0 m
.21429 .00375 L
s
P
p
.001 w
.2619 0 m
.2619 .00375 L
s
P
p
.001 w
.30952 0 m
.30952 .00375 L
s
P
p
.001 w
.35714 0 m
.35714 .00375 L
s
P
p
.001 w
.45238 0 m
.45238 .00375 L
s
P
p
.001 w
.5 0 m
.5 .00375 L
s
P
p
.001 w
.54762 0 m
.54762 .00375 L
s
P
p
.001 w
.59524 0 m
.59524 .00375 L
s
P
p
.001 w
.69048 0 m
.69048 .00375 L
s
P
p
.001 w
.7381 0 m
.7381 .00375 L
s
P
p
.001 w
.78571 0 m
.78571 .00375 L
s
P
p
.001 w
.83333 0 m
.83333 .00375 L
s
P
p
.001 w
.11905 0 m
.11905 .00375 L
s
P
p
.001 w
.07143 0 m
.07143 .00375 L
s
P
p
.001 w
.02381 0 m
.02381 .00375 L
s
P
p
.001 w
.92857 0 m
.92857 .00375 L
s
P
p
.001 w
.97619 0 m
.97619 .00375 L
s
P
[(Contents Reg1 {a:x^a mod n = 4})] .5 0 0 2 0 0 -1 Mouter Mrotshowa
p
.002 w
0 0 m
1 0 L
s
P
p
.002 w
0 0 m
.00625 0 L
s
P
[(0)] -0.0125 0 1 0 0 Minner Mrotshowa
p
.002 w
0 .08829 m
.00625 .08829 L
s
P
[(2)] -0.0125 .08829 1 0 0 Minner Mrotshowa
p
.002 w
0 .17658 m
.00625 .17658 L
s
P
[(4)] -0.0125 .17658 1 0 0 Minner Mrotshowa
p
.002 w
0 .26487 m
.00625 .26487 L
s
P
[(6)] -0.0125 .26487 1 0 0 Minner Mrotshowa
p
.002 w
0 .35316 m
.00625 .35316 L
s
P
[(8)] -0.0125 .35316 1 0 0 Minner Mrotshowa
p
.002 w
0 .44145 m
.00625 .44145 L
s
P
[(10)] -0.0125 .44145 1 0 0 Minner Mrotshowa
p
.002 w
0 .52974 m
.00625 .52974 L
s
P
[(12)] -0.0125 .52974 1 0 0 Minner Mrotshowa
p
.002 w
0 .61803 m
.00625 .61803 L
s
P
[(14)] -0.0125 .61803 1 0 0 Minner Mrotshowa
p
.001 w
0 .01766 m
.00375 .01766 L
s
P
p
.001 w
0 .03532 m
.00375 .03532 L
s
P
p
.001 w
0 .05297 m
.00375 .05297 L
s
P
p
.001 w
0 .07063 m
.00375 .07063 L
s
P
p
.001 w
0 .10595 m
.00375 .10595 L
s
P
p
.001 w
0 .12361 m
.00375 .12361 L
s
P
p
.001 w
0 .14126 m
.00375 .14126 L
s
P
p
.001 w
0 .15892 m
.00375 .15892 L
s
P
p
.001 w
0 .19424 m
.00375 .19424 L
s
P
p
.001 w
0 .2119 m
.00375 .2119 L
s
P
p
.001 w
0 .22956 m
.00375 .22956 L
s
P
p
.001 w
0 .24721 m
.00375 .24721 L
s
P
p
.001 w
0 .28253 m
.00375 .28253 L
s
P
p
.001 w
0 .30019 m
.00375 .30019 L
s
P
p
.001 w
0 .31785 m
.00375 .31785 L
s
P
p
.001 w
0 .3355 m
.00375 .3355 L
s
P
p
.001 w
0 .37082 m
.00375 .37082 L
s
P
p
.001 w
0 .38848 m
.00375 .38848 L
s
P
p
.001 w
0 .40614 m
.00375 .40614 L
s
P
p
.001 w
0 .42379 m
.00375 .42379 L
s
P
p
.001 w
0 .45911 m
.00375 .45911 L
s
P
p
.001 w
0 .47677 m
.00375 .47677 L
s
P
p
.001 w
0 .49443 m
.00375 .49443 L
s
P
p
.001 w
0 .51209 m
.00375 .51209 L
s
P
p
.001 w
0 .5474 m
.00375 .5474 L
s
P
p
.001 w
0 .56506 m
.00375 .56506 L
s
P
p
.001 w
0 .58272 m
.00375 .58272 L
s
P
p
.001 w
0 .60038 m
.00375 .60038 L
s
P
[(Contents Reg2)] -0.0125 .30902 1 0 90 -1 0 Mouter Mrotshowa
p
.002 w
0 0 m
0 .61803 L
s
P
P
p
p
.002 w
.16667 .61178 m
.16667 .61803 L
s
P
p
.002 w
.40476 .61178 m
.40476 .61803 L
s
P
p
.002 w
.64286 .61178 m
.64286 .61803 L
s
P
p
.002 w
.88095 .61178 m
.88095 .61803 L
s
P
p
.001 w
.21429 .61428 m
.21429 .61803 L
s
P
p
.001 w
.2619 .61428 m
.2619 .61803 L
s
P
p
.001 w
.30952 .61428 m
.30952 .61803 L
s
P
p
.001 w
.35714 .61428 m
.35714 .61803 L
s
P
p
.001 w
.45238 .61428 m
.45238 .61803 L
s
P
p
.001 w
.5 .61428 m
.5 .61803 L
s
P
p
.001 w
.54762 .61428 m
.54762 .61803 L
s
P
p
.001 w
.59524 .61428 m
.59524 .61803 L
s
P
p
.001 w
.69048 .61428 m
.69048 .61803 L
s
P
p
.001 w
.7381 .61428 m
.7381 .61803 L
s
P
p
.001 w
.78571 .61428 m
.78571 .61803 L
s
P
p
.001 w
.83333 .61428 m
.83333 .61803 L
s
P
p
.001 w
.11905 .61428 m
.11905 .61803 L
s
P
p
.001 w
.07143 .61428 m
.07143 .61803 L
s
P
p
.001 w
.02381 .61428 m
.02381 .61803 L
s
P
p
.001 w
.92857 .61428 m
.92857 .61803 L
s
P
p
.001 w
.97619 .61428 m
.97619 .61803 L
s
P
p
.002 w
0 .61803 m
1 .61803 L
s
P
[(Project Reg1: {a:x^a mod n = 4})] .5 .61803 0 -2 Mshowa
p
.002 w
.99375 0 m
1 0 L
s
P
p
.002 w
.99375 .08829 m
1 .08829 L
s
P
p
.002 w
.99375 .17658 m
1 .17658 L
s
P
p
.002 w
.99375 .26487 m
1 .26487 L
s
P
p
.002 w
.99375 .35316 m
1 .35316 L
s
P
p
.002 w
.99375 .44145 m
1 .44145 L
s
P
p
.002 w
.99375 .52974 m
1 .52974 L
s
P
p
.001 w
.99625 .01766 m
1 .01766 L
s
P
p
.001 w
.99625 .03532 m
1 .03532 L
s
P
p
.001 w
.99625 .05297 m
1 .05297 L
s
P
p
.001 w
.99625 .07063 m
1 .07063 L
s
P
p
.001 w
.99625 .10595 m
1 .10595 L
s
P
p
.001 w
.99625 .12361 m
1 .12361 L
s
P
p
.001 w
.99625 .14126 m
1 .14126 L
s
P
p
.001 w
.99625 .15892 m
1 .15892 L
s
P
p
.001 w
.99625 .19424 m
1 .19424 L
s
P
p
.001 w
.99625 .2119 m
1 .2119 L
s
P
p
.001 w
.99625 .22956 m
1 .22956 L
s
P
p
.001 w
.99625 .24721 m
1 .24721 L
s
P
p
.001 w
.99625 .28253 m
1 .28253 L
s
P
p
.001 w
.99625 .30019 m
1 .30019 L
s
P
p
.001 w
.99625 .31785 m
1 .31785 L
s
P
p
.001 w
.99625 .3355 m
1 .3355 L
s
P
p
.001 w
.99625 .37082 m
1 .37082 L
s
P
p
.001 w
.99625 .38848 m
1 .38848 L
s
P
p
.001 w
.99625 .40614 m
1 .40614 L
s
P
p
.001 w
.99625 .42379 m
1 .42379 L
s
P
p
.001 w
.99625 .45911 m
1 .45911 L
s
P
p
.001 w
.99625 .47677 m
1 .47677 L
s
P
p
.001 w
.99625 .49443 m
1 .49443 L
s
P
p
.001 w
.99625 .51209 m
1 .51209 L
s
P
p
.001 w
.99625 .5474 m
1 .5474 L
s
P
p
.001 w
.99625 .56506 m
1 .56506 L
s
P
p
.001 w
.99625 .58272 m
1 .58272 L
s
P
p
.001 w
.99625 .60038 m
1 .60038 L
s
P
p
.002 w
1 0 m
1 .61803 L
s
P
P
p
p
.002 w
.16667 0 m
.16667 .61803 L
s
P
P
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
p
p
.02 w
.02381 .17658 Mdot
.21429 .17658 Mdot
.40476 .17658 Mdot
.59524 .17658 Mdot
.78571 .17658 Mdot
.97619 .17658 Mdot
P
P
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  Evaluatable->False,
  AspectRatioFixed->True,
  ImageSize->{282, 174},
  ImageMargins->{{34, Inherited}, {Inherited, Inherited}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004J0000[Q000`40O003h00Oogoo6goo003oOolK
Ool007eoo`<000moo`8005eoo`8002Yoo`00P7oo00<007ooOol037oo00<007ooOol0GGoo00<007oo
Ool0:7oo000jOol40003Ool30002Ool200000goo00000002Ool30003Ool4000017oo000007oo0P00
0Woo0`000Woo10001goo0P000Woo0P000Woo10000Woo100000Aoo`00000000Yoo`03001oogoo009o
o`D0009oo`80009oo`800003Ool0000000Qoo`D000Moo`05001oo`00Ool00002Ool30003Ool50006
Ool200000goo0000000DOol30003Ool00`00Oomoo`0XOol003Uoo`03001oogoo00Aoo`07001oogoo
Ool007oo00000Woo00D007ooOomoo`00009oo`03001oo`0000Eoo`04001oogoo0003Ool01000Oomo
o`0017oo00<007ooOol01Woo00@007oo0000009oo`03001oogoo00=oo`05001oogooOol00002Ool0
0`00Oomoo`09Ool00`00Oomoo`02Ool01000Oomoo`000goo0P000goo00<007oo00002Goo00@007oo
Ool000Qoo`07001oo`00Ool007oo00000goo00<007oo00000goo00<007ooOol01Goo00@007ooOol0
01Ioo`03001oogoo009oo`03001oogoo02Qoo`00>Goo00<007ooOol017oo00L007ooOomoo`00Ool0
0002Ool01@00Oomoogoo000017oo1@0000Eoo`00Oomoo`0000=oo`03001oogoo009oo`@000Qoo`<0
00=oo`D00003Ool007oo009oo`04001oogoo000:Ool00`00Oomoo`03Ool40009Ool00`00Oomoo`08
Ool40008Ool01`00Ool007oo001oo`0000=oo`03001oo`0000=oo`03001oogoo00Eoo`04001oogoo
0008Ool50007Ool40004Ool00`00Oomoo`0WOol003Uoo`03001oogoo00Aoo`07001oogooOol007oo
00000Woo00D007ooOomoo`0000Aoo`07001oogooOol007oo00000Woo00D007ooOomoo`0000Aoo`03
001oogoo00Uoo`04001oogoo0002Ool01`00Oomoogoo001oo`0000=oo`04001oogoo000;Ool00`00
Oomoo`05Ool01000Oomoogoo0P000goo00<007oo000037oo00<007ooOol01Woo00L007oo001oo`00
Ool00003Ool00`00Ool00003Ool00`00Oomoo`05Ool01000Oomoo`0057oo00<007oo000017oo00<0
07ooOol0:7oo000iOol01@00Oomoogoo00000goo0`0000=oo`0000000`000Woo10000goo0`0000=o
o`0000000`000Woo10000Woo100027oo00@007ooOol000=oo`<000=oo`D00003Ool007oo00Yoo`03
001oogoo00=oo`<000=oo`80009oo`800003Ool0000000Uoo`<000Moo`H0009oo`<000=oo`@000Io
o`D000Qoo`D000Moo`03001oo`0000Aoo`03001oogoo02Qoo`00>Woo10003goo00<007ooOol03goo
00<007ooOol03Goo10003goo0P002goo0P005Goo00<007oo00007goo00<007ooOol07Woo0P000goo
0P00:Woo001=Ool00`00Oomoo`0?Ool00`00Oomoo`15Ool00`00Oomoo`0MOol2001AOol00?mooa]o
o`00ogoo6goo003oOolKOol00?mooa]oo`00ogoo6goo003oOolKOol00?mooa]oo`00ogoo6goo003o
OolKOol00?mooa]oo`00DGoo0`00:Woo0`0017oo0P009goo0`000goo0`009goo10000goo0P00<goo
001DOol00`00Oomoo`0XOol00`00Oomoo`02Ool01000Oomoo`009goo00<007ooOol01Goo00<007oo
Ool09Goo00<007ooOol00Woo00@007ooOol0039oo`00E7oo00<007ooOol0:7oo00<007ooOol00Woo
00@007ooOol002Moo`03001oogoo00Eoo`03001oogoo02Ioo`05001oogooOol00002Ool00`00Oomo
o`0`Ool0055oo`<002]oo`03001oogoo009oo`04001oogoo000WOol00`00Oomoo`02Ool3000ZOol0
1000Oomoo`000Woo00<007ooOol0<7oo001AOol00`00Oomoo`0[Ool00`00Oomoo`02Ool01000Oomo
o`009goo00<007ooOol00Woo00<007ooOol09goo00@007ooOol0009oo`04001oogoo000bOol0055o
o`@002Uoo`8000Eoo`8002Moo`8000Aoo`@002Moo`8000Aoo`8003=oo`00ogoo6goo003oOolKOol0
0?mooa]oo`00ogoo6goo000ZOol2003^Ool002Uoo`04001oogoo003]Ool002Uoo`04001oogoo0004
Ooo<000MOol002Uoo`04001oogoo0004Ool00`00Oomoo`02Ool00`00Oomoo`06Ool00`00Oomoo`07
Ool00`00Oomoo`07Ool00`00Oomoo`06Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`06
Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`06Ool00`00Oomoo`07Ool00`00Oomoo`06
Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`06Ool00`00Oomoo`07Ool00`00Oomoo`07
Ool00`00Oomoo`06Ool00`00Oomoo`07Ool00`00Oomoo`07Ool00`00Oomoo`02Ool00`00Oomoo`0K
Ool002Uoo`04001oogoo0004Ool00`00Oomoo`0OOol00`00Oomoo`0]Ool00`0?Oomoo`0]Ool00`0?
Oomoo`0]Ool00`0?Oomoo`0FOol00`00Oomoo`0KOol002Yoo`8000Eoo`03001oogoo01moo`03001o
ogoo02eoo`0300moogoo02eoo`0300moogoo02eoo`0300moogoo01Ioo`03001oogoo01]oo`00<Goo
0P0087oo00<007ooOol0;Goo00<03gooOol0;Goo00<03gooOol0;Goo00<03gooOol05Goo0P007Goo
000aOol00`00Oomoo`0OOol00`00Oomoo`0]Ool00`0?Oomoo`0]Ool00`0?Oomoo`0]Ool00`0?Oomo
o`0FOol00`00Oomoo`0KOol0035oo`03001oogoo01moo`03001oogoo02eoo`0300moogoo02eoo`03
00moogoo02eoo`0300moogoo01Ioo`03001oogoo01]oo`00<Goo0P0087oo00<007ooOol0;Goo00<0
3gooOol0;Goo00<03gooOol0;Goo00<03gooOol05Goo0P007Goo000aOol00`00Oomoo`0OOol00`00
Oomoo`0]Ool00`0?Oomoo`0]Ool00`0?Oomoo`0]Ool00`0?Oomoo`0FOol00`00Oomoo`0KOol0035o
o`03001oogoo01moo`03001oogoo02eoo`0300moogoo02eoo`0300moogoo02eoo`0300moogoo01Io
o`03001oogoo01]oo`00<Goo00<007ooOol07goo00<007ooOol0;Goo00<03gooOol0;Goo00<03goo
Ool0;Goo00<03gooOol05Woo00<007ooOol06goo000aOol2000POol00`00Oomoo`0]Ool00`0?Oomo
o`0]Ool00`0?Oomoo`0]Ool00`0?Oomoo`0EOol2000MOol0035oo`03001oogoo01moo`03001oogoo
02eoo`0300moogoo02eoo`0300moogoo02eoo`0300moogoo01Ioo`03001oogoo01]oo`00<Goo00<0
07ooOol07goo00<007ooOol0;Goo00<03gooOol0;Goo00<03gooOol0;Goo00<03gooOol05Woo00<0
07ooOol06goo000aOol00`00Oomoo`0OOol00`00Oomoo`0]Ool00`0?Oomoo`0]Ool00`0?Oomoo`0]
Ool00`0?Oomoo`0FOol00`00Oomoo`0KOol0035oo`80021oo`03001oogoo02eoo`0300moogoo02eo
o`0300moogoo02eoo`0300moogoo01Eoo`8001eoo`00:Goo100017oo00<007ooOol07goo00<007oo
Ool0;Goo00<03gooOol0;Goo00<03gooOol0;Goo00<03gooOol05Woo00<007ooOol06goo000ZOol0
0`00Oomoo`04Ool00`00Oomoo`0OOol00`00Oomoo`0]Ool00`0?Oomoo`0]Ool00`0?Oomoo`0]Ool0
0`0?Oomoo`0FOol00`00Oomoo`0KOol002]oo`03001oogoo00=oo`8002003`0300003`0?0:@03`<0
01eoo`00;7oo00<007ooOol00Woo00<007ooOol07goo00<007ooOol0;Goo00<03gooOol0;Goo00<0
3gooOol0;Goo00<03gooOol05Woo00<007ooOol06goo000YOol01000Oomoo`0017oo00<007ooOol0
7goo00<007ooOol0;Goo00<03gooOol0;Goo00<03gooOol0;Goo00<03gooOol05Woo00<007ooOol0
6goo000ZOol20005Ool00`00Oomoo`0OOol00`00Oomoo`0]Ool00`0?Oomoo`0]Ool00`0?Oomoo`0]
Ool00`0?Oomoo`0FOol00`00Oomoo`0KOol0035oo`80021oo`03001oogoo02eoo`0300moogoo02eo
o`0300moogoo02eoo`0300moogoo01Eoo`8001eoo`00<Goo00<007ooOol07goo00<007ooOol0;Goo
00<03gooOol0;Goo00<03gooOol0;Goo00<03gooOol05Woo00<007ooOol06goo000aOol00`00Oomo
o`0OOol00`00Oomoo`0]Ool00`0?Oomoo`0]Ool00`0?Oomoo`0]Ool00`0?Oomoo`0FOol00`00Oomo
o`0KOol001eoo`@0011oo`80021oo`03001oogoo02eoo`0300moogoo02eoo`0300moogoo02eoo`03
00moogoo01Eoo`8001eoo`0077oo00<007ooOol04Woo00<007ooOol07goo00<007ooOol0;Goo00<0
3gooOol0;Goo00<03gooOol0;Goo00<03gooOol05Woo00<007ooOol06goo000LOol00`00Oomoo`0B
Ool00`00Oomoo`0OOol00`00Oomoo`0]Ool00`0?Oomoo`0]Ool00`0?Oomoo`0]Ool00`0?Oomoo`0F
Ool00`00Oomoo`0KOol001aoo`03001oogoo019oo`03001oogoo01moo`03001oogoo02eoo`0300mo
ogoo02eoo`0300moogoo02eoo`0300moogoo01Ioo`03001oogoo01]oo`0077oo00D007ooOomoo`00
011oo`80021oo`03001oogoo02eoo`0300moogoo02eoo`0300moogoo02eoo`0300moogoo01Eoo`80
01eoo`007Goo100047oo00<007ooOol07goo00<007ooOol0;Goo00<03gooOol0;Goo00<03gooOol0
;Goo00<03gooOol05Woo00<007ooOol06goo000NOol3000@Ool00`00Oomoo`0OOol00`00Oomoo`0]
Ool00`0?Oomoo`0]Ool00`0?Oomoo`0]Ool00`0?Oomoo`0FOol00`00Oomoo`0KOol001eoo`05001o
ogooOol0000?Ool2000POol00`00Oomoo`0]Ool00`0?Oomoo`0]Ool00`0?Oomoo`0]Ool00`0?Oomo
o`0EOol2000MOol001eoo`05001oogooOol0000?Ool00`00Oomoo`0OOol00`00Oomoo`0]Ool00`0?
Oomoo`0]Ool00`0?Oomoo`0]Ool00`0?Oomoo`0FOol00`00Oomoo`0KOol001eoo`05001oogooOol0
0008Ool30004Ool01000Oomoogoo0P0077oo00<007ooOol01Woo0P0097oo0P009Goo0P0027oo00<0
3gooOol06Woo0P004Goo00<03gooOol047oo0P0017oo00<007ooOol06goo000NOol3000:Ool00`00
Oomoo`03Ool00`00Oomoo`04000KOol00`00Oomoo`05Ool4000ROol4000SOol40007Ool00`0?Oomo
o`0IOol4000@Ool00`0?Oomoo`0?Ool40003Ool00`00Oomoo`0KOol002Uoo`@000Aoo`80000300l0
0000008001/03`0300003`0?00D03`@002803`@002<03`@002<03`@002803`@0000400l00000000M
Ool001eoo`800003Ool0000000Moo`03001oo`0000Eoo`04001oogooOol2000LOol00`00Oomoo`06
Ool2000TOol2000UOol20008Ool00`0?Oomoo`0JOol2000AOol00`0?Oomoo`0@Ool20004Ool00`00
Oomoo`0KOol001eoo`04001oogoo0008Ool00`00Ool00005Ool00`00Oomoo`0OOol00`00Oomoo`0]
Ool00`0?Oomoo`0]Ool00`0?Oomoo`0]Ool00`0?Oomoo`0FOol00`00Oomoo`0KOol001eoo`04001o
ogoo0009Ool20005Ool00`00Oomoo`0OOol00`00Oomoo`0]Ool00`0?Oomoo`0]Ool00`0?Oomoo`0]
Ool00`0?Oomoo`0FOol00`00Oomoo`0KOol001eoo`04001oogoo000@Ool2000POol00`00Oomoo`0]
Ool00`0?Oomoo`0]Ool00`0?Oomoo`0]Ool00`0?Oomoo`0EOol2000MOol001aoo`D0011oo`03001o
ogoo01moo`03001oogoo02eoo`0300moogoo02eoo`0300moogoo02eoo`0300moogoo01Ioo`03001o
ogoo01]oo`00<Goo00<007ooOol07goo00<007ooOol0;Goo00<03gooOol0;Goo00<03gooOol0;Goo
00<03gooOol05Woo00<007ooOol06goo000NOol3000@Ool2000POol00`00Oomoo`0]Ool00`0?Oomo
o`0]Ool00`0?Oomoo`0]Ool00`0?Oomoo`0EOol2000MOol001ioo`04001oogoo000?Ool00`00Oomo
o`0OOol00`00Oomoo`0]Ool00`0?Oomoo`0]Ool00`0?Oomoo`0]Ool00`0?Oomoo`0FOol00`00Oomo
o`0KOol001ioo`03001oogoo011oo`03001oogoo01moo`03001oogoo02eoo`0300moogoo02eoo`03
00moogoo02eoo`0300moogoo01Ioo`03001oogoo01]oo`007Woo00<007ooOol047oo00<007ooOol0
7goo00<007ooOol0;Goo00<03gooOol0;Goo00<03gooOol0;Goo00<03gooOol05Woo00<007ooOol0
6goo000MOol4000@Ool2000POol00`00Oomoo`0]Ool00`0?Oomoo`0]Ool00`0?Oomoo`0]Ool00`0?
Oomoo`0EOol2000MOol001ioo`03001oogoo011oo`03001oogoo01moo`03001oogoo02eoo`0300mo
ogoo02eoo`0300moogoo02eoo`0300moogoo01Ioo`03001oogoo01]oo`007Woo10003goo00<007oo
Ool07goo00<007ooOol0;Goo00<03gooOol0;Goo00<03gooOol0;Goo00<03gooOol05Woo00<007oo
Ool06goo000MOol00`00Oomoo`0AOol2000POol00`00Oomoo`0]Ool00`0?Oomoo`0]Ool00`0?Oomo
o`0]Ool00`0?Oomoo`0EOol2000MOol001eoo`D000moo`03001oogoo01moo`03001oogoo02eoo`03
00moogoo02eoo`0300moogoo02eoo`0300moogoo01Ioo`03001oogoo01]oo`007Goo00D007ooOomo
o`0000Qoo`8000Eoo`03001oogoo01moo`03001oogoo02eoo`0300moogoo02eoo`0300moogoo02eo
o`0300moogoo01Ioo`03001oogoo01]oo`007Woo0`0027oo00@007ooOol000Aoo`03001oogoo01mo
o`03001oogoo02eoo`0300moogoo02eoo`0300moogoo02eoo`0300moogoo01Ioo`03001oogoo01]o
o`00:Goo00@007ooOol000Aoo`8002003`0300003`0?0:@03`<001eoo`007Goo0P0000=oo`000000
1goo0`001Goo00<007ooOol07goo00<007ooOol0;Goo00<03gooOol0;Goo00<03gooOol0;Goo00<0
3gooOol05Woo00<007ooOol06goo000MOol01000Oomoo`0027oo00<007ooOol01Goo00<007ooOol0
7goo00<007ooOol0;Goo00<03gooOol0;Goo00<03gooOol0;Goo00<03gooOol05Woo00<007ooOol0
6goo000MOol01000Oomoo`002Goo0`0017oo0P0087oo00<007ooOol0;Goo00<03gooOol0;Goo00<0
3gooOol0;Goo00<03gooOol05Goo0P007Goo000MOol01000Oomoo`0047oo00<007ooOol07goo00<0
07ooOol0;Goo00<03gooOol0;Goo00<03gooOol0;Goo00<03gooOol05Woo00<007ooOol06goo000L
Ool5000@Ool00`00Oomoo`0OOol00`00Oomoo`0]Ool00`0?Oomoo`0]Ool00`0?Oomoo`0]Ool00`0?
Oomoo`0FOol00`00Oomoo`0KOol0035oo`03001oogoo01moo`03001oogoo02eoo`0300moogoo02eo
o`0300moogoo02eoo`0300moogoo01Ioo`03001oogoo01]oo`007Woo0`0047oo0P0087oo00<007oo
Ool0;Goo00<03gooOol0;Goo00<03gooOol0;Goo00<03gooOol05Goo0P007Goo000NOol01000Oomo
o`003goo00<007ooOol07goo00<007ooOol0;Goo00<03gooOol0;Goo00<03gooOol0;Goo00<03goo
Ool05Woo00<007ooOol06goo000NOol00`00Oomoo`0@Ool00`00Oomoo`0OOol00`00Oomoo`0]Ool0
0`0?Oomoo`0]Ool00`0?Oomoo`0]Ool00`0?Oomoo`0FOol00`00Oomoo`0KOol001ioo`03001oogoo
011oo`03001oogoo01moo`03001oogoo02eoo`0300moogoo02eoo`0300moogoo02eoo`0300moogoo
01Ioo`03001oogoo01]oo`007Goo100047oo0P0087oo00<007ooOol0;Goo00<03gooOol0;Goo00<0
3gooOol0;Goo00<03gooOol05Goo0P007Goo000NOol00`00Oomoo`0@Ool00`00Oomoo`0OOol00`00
Oomoo`0]Ool00`0?Oomoo`0]Ool00`0?Oomoo`0]Ool00`0?Oomoo`0FOol00`00Oomoo`0KOol001eo
o`@0011oo`03001oogoo01moo`03001oogoo02eoo`0300moogoo02eoo`0300moogoo02eoo`0300mo
ogoo01Ioo`03001oogoo01]oo`0087oo00<007ooOol03Woo0P0087oo00<007ooOol0;Goo00<03goo
Ool0;Goo00<03gooOol0;Goo00<03gooOol05Goo0P007Goo000MOol4000@Ool00`00Oomoo`0OOol0
0`00Oomoo`0]Ool00`0?Oomoo`0]Ool00`0?Oomoo`0]Ool00`0?Oomoo`0FOol00`00Oomoo`0KOol0
01eoo`03001oogoo00Yoo`8000Eoo`03001oogoo01moo`03001oogoo02eoo`0300moogoo02eoo`03
00moogoo02eoo`0300moogoo01Ioo`03001oogoo01]oo`007Goo100027oo00@007ooOol000Aoo`03
001oogoo01moo`03001oogoo02eoo`0300moogoo02eoo`0300moogoo02eoo`0300moogoo01Ioo`03
001oogoo01]oo`00:Goo00@007ooOol000Aoo`8002003`0300003`0?0:@03`<001eoo`00:Woo0P00
1Goo00<007ooOol07goo00<007ooOol0;Goo00<03gooOol0;Goo00<03gooOol0;Goo00<03gooOol0
5Woo00<007ooOol06goo000YOol01000Oomoo`0017oo00<007ooOol07goo00<007ooOol0;Goo00<0
3gooOol0;Goo00<03gooOol0;Goo00<03gooOol05Woo00<007ooOol06goo000ZOol20005Ool2000P
Ool00`00Oomoo`0]Ool00`0?Oomoo`0]Ool00`0?Oomoo`0]Ool00`0?Oomoo`0EOol2000MOol0035o
o`03001oogoo01moo`03001oogoo02eoo`0300moogoo02eoo`0300moogoo02eoo`0300moogoo01Io
o`03001oogoo01]oo`00<Goo00<007ooOol07goo00<007ooOol0;Goo00<03gooOol0;Goo00<03goo
Ool0;Goo00<03gooOol05Woo00<007ooOol06goo000aOol00`00Oomoo`0OOol00`00Oomoo`0]Ool0
0`0?Oomoo`0]Ool00`0?Oomoo`0]Ool00`0?Oomoo`0FOol00`00Oomoo`0KOol001aoo`80009oo`80
00moo`80021oo`03001oogoo02eoo`0300moogoo02eoo`0300moogoo02eoo`0300moogoo01Eoo`80
01eoo`007Goo00@007oo0000011oo`03001oogoo01moo`03001oogoo02eoo`0300moogoo02eoo`03
00moogoo02eoo`0300moogoo01Ioo`03001oogoo01]oo`007Goo0`004Goo00<007ooOol07goo00<0
07ooOol0;Goo00<03gooOol0;Goo00<03gooOol0;Goo00<03gooOol05Woo00<007ooOol06goo000M
Ool01000Oomoo`0047oo00<007ooOol07goo00<007ooOol0;Goo00<03gooOol0;Goo00<03gooOol0
;Goo00<03gooOol05Woo00<007ooOol06goo000MOol01000Oomoo`0047oo0P0087oo00<007ooOol0
;Goo00<03gooOol0;Goo00<03gooOol0;Goo00<03gooOol05Goo0P007Goo000LOol4000AOol00`00
Oomoo`0OOol00`00Oomoo`0]Ool00`0?Oomoo`0]Ool00`0?Oomoo`0]Ool00`0?Oomoo`0FOol00`00
Oomoo`0KOol001ioo`@000moo`03001oogoo01moo`03001oogoo02eoo`0300moogoo02eoo`0300mo
ogoo02eoo`0300moogoo01Ioo`03001oogoo01]oo`007Goo00<007ooOol04Goo0P0087oo00<007oo
Ool0;Goo00<03gooOol0;Goo00<03gooOol0;Goo00<03gooOol05Goo0P007Goo000MOol5000?Ool0
0`00Oomoo`0OOol00`00Oomoo`0]Ool00`0?Oomoo`0]Ool00`0?Oomoo`0]Ool00`0?Oomoo`0FOol0
0`00Oomoo`0KOol001eoo`06001oogooOol007oo0`0017oo0P001Goo00<007ooOol07goo00<007oo
Ool0;Goo00<03gooOol0;Goo00<03gooOol0;Goo00<03gooOol05Woo00<007ooOol06goo000NOol3
0003Ool00`00Oomoo`02Ool01000Oomoo`0017oo00<007ooOol07goo00<007ooOol0;Goo00<03goo
Ool0;Goo00<03gooOol0;Goo00<03gooOol05Woo00<007ooOol06goo000QOol01000Oomoo`0017oo
00@007ooOol000Aoo`8002003`0300003`0?0:@03`<001eoo`007Woo10000Woo00<007ooOol00Woo
00@007ooOol000Aoo`03001oogoo01moo`03001oogoo02eoo`0300moogoo02eoo`0300moogoo02eo
o`0300moogoo01Ioo`03001oogoo01]oo`007Goo00D007ooOomoo`00009oo`03001oogoo009oo`04
001oogoo0004Ool00`00Oomoo`0OOol00`00Oomoo`0]Ool00`0?Oomoo`0]Ool00`0?Oomoo`0]Ool0
0`0?Oomoo`0FOol00`00Oomoo`0KOol001eoo`06001oogooOol007oo0P001Goo0P001Goo0P0087oo
00<007ooOol0;Goo00<03gooOol0;Goo00<03gooOol0;Goo00<03gooOol05Goo0P007Goo000MOol0
1@00Oomoogoo00003goo00<007ooOol07goo00<007ooOol0;Goo00<03gooOol0;Goo00<03gooOol0
;Goo00<03gooOol05Woo00<007ooOol06goo000NOol5000>Ool00`00Oomoo`0OOol00`00Oomoo`0]
Ool00`0?Oomoo`0]Ool00`0?Oomoo`0]Ool00`0?Oomoo`0FOol00`00Oomoo`0KOol0035oo`03001o
ogoo01moo`03001oogoo02eoo`0300moogoo02eoo`0300moogoo02eoo`0300moogoo01Ioo`03001o
ogoo01]oo`007Goo100047oo0P0087oo00<007ooOol0;Goo00<03gooOol0;Goo00<03gooOol0;Goo
00<03gooOol05Goo0P007Goo000NOol00`00Oomoo`0@Ool00`00Oomoo`0OOol00`00Oomoo`0]Ool0
0`0?Oomoo`0]Ool00`0?Oomoo`0]Ool00`0?Oomoo`0FOol00`00Oomoo`0KOol001moo`03001oogoo
00moo`03001oogoo01moo`03001oogoo02eoo`0300moogoo02eoo`0300moogoo02eoo`0300moogoo
01Ioo`03001oogoo01]oo`0087oo00<007ooOol03Woo0P0087oo00<007ooOol0;Goo00<03gooOol0
;Goo00<03gooOol0;Goo00<03gooOol05Goo0P007Goo000MOol01000Oomoo`0047oo00<007ooOol0
7goo00<007ooOol0;Goo00<03gooOol0;Goo00<03gooOol0;Goo00<03gooOol05Woo00<007ooOol0
6goo000NOol2000AOol00`00Oomoo`0OOol00`00Oomoo`0]Ool00`0?Oomoo`0]Ool00`0?Oomoo`0]
Ool00`0?Oomoo`0FOol00`00Oomoo`0KOol0035oo`03001oogoo01moo`03001oogoo02eoo`0300mo
ogoo02eoo`0300moogoo02eoo`0300moogoo01Ioo`03001oogoo01]oo`00<Goo0P0087oo00<007oo
Ool0;Goo00<03gooOol0;Goo00<03gooOol0;Goo00<03gooOol05Goo0P007Goo000aOol00`00Oomo
o`0OOol00`00Oomoo`0]Ool00`0?Oomoo`0]Ool00`0?Oomoo`0]Ool00`0?Oomoo`0FOol00`00Oomo
o`0KOol002=oo`<000=oo`@000Aoo`03001oogoo01moo`03001oogoo02eoo`0300moogoo02eoo`03
00moogoo02eoo`0300moogoo01Ioo`03001oogoo01]oo`0097oo00<007ooOol00goo00<007ooOol0
17oo00<007ooOol07goo00<007ooOol0;Goo00<03gooOol0;Goo00<03gooOol0;Goo00<03gooOol0
5Woo00<007ooOol06goo000TOol00`00Oomoo`04Ool00`00Oomoo`03Ool2000P00l00`0000l03`2T
00l3000MOol002Aoo`03001oogoo00Eoo`03001oogoo009oo`03001oogoo01moo`03001oogoo02eo
o`0300moogoo02eoo`0300moogoo02eoo`0300moogoo01Ioo`03001oogoo01]oo`0097oo00<007oo
Ool00Woo00@007ooOol000Aoo`03001oogoo01moo`03001oogoo02eoo`0300moogoo02eoo`0300mo
ogoo02eoo`0300moogoo01Ioo`03001oogoo01]oo`008goo0P001Goo0P001Goo0P0087oo00<007oo
Ool0;Goo00<03gooOol0;Goo00<03gooOol0;Goo00<03gooOol05Goo0P007Goo000aOol00`00Oomo
o`0OOol00`00Oomoo`0]Ool00`0?Oomoo`0]Ool00`0?Oomoo`0]Ool00`0?Oomoo`0FOol00`00Oomo
o`0KOol0035oo`03001oogoo01moo`03001oogoo02eoo`0300moogoo02eoo`0300moogoo02eoo`03
00moogoo01Ioo`03001oogoo01]oo`00<Goo00<007ooOol07goo00<007ooOol0;Goo00<03gooOol0
;Goo00<03gooOol0;Goo00<03gooOol05Woo00<007ooOol06goo000aOol2000POol00`00Oomoo`0]
Ool00`0?Oomoo`0]Ool00`0?Oomoo`0]Ool00`0?Oomoo`0EOol2000MOol0035oo`03001oogoo01mo
o`03001oogoo02eoo`0300moogoo02eoo`0300moogoo02eoo`0300moogoo01Ioo`03001oogoo01]o
o`00<Goo00<007ooOol07goo00<007ooOol0;Goo00<03gooOol0;Goo00<03gooOol0;Goo00<03goo
Ool05Woo00<007ooOol06goo000aOol2000POol00`00Oomoo`0]Ool00`0?Oomoo`0]Ool00`0?Oomo
o`0]Ool00`0?Oomoo`0EOol2000MOol0035oo`03001oogoo01moo`03001oogoo02eoo`0300moogoo
02eoo`0300moogoo02eoo`0300moogoo01Ioo`03001oogoo01]oo`00<Goo00<007ooOol07goo00<0
07ooOol0;Goo00<03gooOol0;Goo00<03gooOol0;Goo00<03gooOol05Woo00<007ooOol06goo000a
Ool00`00Oomoo`0OOol00`00Oomoo`0]Ool00`0?Oomoo`0]Ool00`0?Oomoo`0]Ool00`0?Oomoo`0F
Ool00`00Oomoo`0KOol0035oo`80021oo`03001oogoo02eoo`0300moogoo02eoo`0300moogoo02eo
o`0300moogoo01Eoo`8001eoo`008goo0`0017oo0`0017oo00<007ooOol07goo00<007ooOol0;Goo
00<03gooOol0;Goo00<03gooOol0;Goo00<03gooOol05Woo00<007ooOol06goo000TOol00`00Oomo
o`04Ool00`00Oomoo`03Ool00`00Oomoo`0OOol00`00Oomoo`0]Ool00`00Oomoo`0]Ool00`00Oomo
o`0]Ool00`00Oomoo`0FOol00`00Oomoo`0KOol002Aoo`03001oogoo009oo`@000Aool`001eoo`00
97oo00<007ooOol00Woo00<007oo0000kWoo000TOol00`00Oomoo`02Ool00`00Ool0003^Ool002=o
o`8000Eoo`800>ioo`00ogoo6goo003oOolKOol004aoo`<002Qoo`<001Eoo`8005eoo`8002Yoo`00
Cgoo00<007ooOol0:7oo00<007ooOol04Woo00<007ooOol0GGoo00<007ooOol0:7oo000iOol30004
Ool40003Ool30005Ool01000Oomoogoo10000Woo0`000goo0`001goo0P000Woo0P000Woo10000Woo
100000Aoo`00000000Aoo`8000Yoo`03001oogoo009oo`D0009oo`80009oo`800003Ool0000000Qo
o`D000Moo`05001oo`00Ool00002Ool30003Ool50006Ool200000goo0000000DOol30003Ool00`00
Oomoo`0XOol003Yoo`03001oogoo00Aoo`03001oogoo009oo`05001oogooOol00004Ool01000Oomo
o`001Goo00D007ooOomoo`00009oo`04001oogoo0007Ool01000Ool000000Woo00<007ooOol00goo
00D007ooOomoo`00009oo`03001oogoo00=oo`8000Yoo`03001oogoo009oo`04001oogoo0003Ool2
0003Ool00`00Ool00009Ool01000Oomoo`0027oo00L007oo001oo`00Ool00003Ool00`00Ool00003
Ool00`00Oomoo`05Ool01000Oomoo`005Woo00<007ooOol00Woo00<007ooOol0:7oo000jOol30004
Ool00`00Oomoo`02Ool01@00Oomoogoo000017oo00<007ooOol01@0000=oo`00Ool01Goo00<007oo
Ool027oo0`000goo1@0000=oo`00Ool00Woo00@007ooOol0011oo`03001oogoo00=oo`@000Uoo`03
001oogoo00Qoo`@000Qoo`07001oo`00Ool007oo00000goo00<007oo00000goo00<007ooOol01Goo
00@007ooOol000Qoo`D000Moo`@000Aoo`03001oogoo02Moo`00>Woo00@007ooOol000=oo`8000=o
o`05001oogooOol00004Ool01000Oomoo`000goo00<007oo00000goo00@007ooOol000Yoo`04001o
ogoo0002Ool01`00Oomoogoo001oo`0000=oo`04001oogoo0005Ool2000:Ool00`00Oomoo`05Ool0
1000Oomoogoo0P000goo00<007oo000037oo00<007ooOol01Woo00L007oo001oo`00Ool00003Ool0
0`00Ool00003Ool00`00Oomoo`05Ool01000Oomoo`0057oo00<007oo000017oo00<007ooOol0:7oo
000jOol01000Oomoo`000Woo0P0000=oo`0000000Woo0`000Woo10000goo0`000goo100000=oo`00
00000P0027oo00@007ooOol000=oo`<000=oo`D00003Ool007oo00Aoo`8000Yoo`03001oogoo00=o
o`<000=oo`80009oo`800003Ool0000000Uoo`<000Moo`H0009oo`<000=oo`@000Ioo`D000Qoo`D0
00Moo`03001oo`0000Aoo`03001oogoo02Qoo`00>Goo10008Woo00<007ooOol01goo10003goo0P00
4Goo0P005Goo00<007oo00007goo00<007ooOol07Woo0P000goo0P00:Woo001?Ool00`00Oomoo`0=
Ool00`00Oomoo`15Ool00`00Oomoo`0MOol2001AOol00?mooa]oo`00\
\>"],
  ImageRangeCache->{{{0, 281}, {173, 0}} -> {-3.60618, -3.65371, 0.103582, 
  0.111732}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.00393546 0.603319 0.109514 [
[(0)] .02381 0 0 2 0 Minner Mrotsboxa
[(50)] .22058 0 0 2 0 Minner Mrotsboxa
[(100)] .41736 0 0 2 0 Minner Mrotsboxa
[(150)] .61413 0 0 2 0 Minner Mrotsboxa
[(200)] .8109 0 0 2 0 Minner Mrotsboxa
[(Contents Reg1 {a:x^a mod n = 4})] .5 0 0 2 0 0 -1 Mouter Mrotsboxa
[(0.00001)] -0.0125 .05575 1 0 0 Minner Mrotsboxa
[(0.0001)] -0.0125 .16526 1 0 0 Minner Mrotsboxa
[(0.001)] -0.0125 .27478 1 0 0 Minner Mrotsboxa
[(0.01)] -0.0125 .38429 1 0 0 Minner Mrotsboxa
[(0.1)] -0.0125 .4938 1 0 0 Minner Mrotsboxa
[(1)] -0.0125 .60332 1 0 0 Minner Mrotsboxa
[(ln\\(Pr\\(Measure a\\)\\))] -0.0125 .30902 1 0 90 -1 0 Mouter Mrotsboxa
[(Compute Discrete Fourier Transform of Reg1)] .5 .61803 0 -2 Msboxa
[ -0.001 -0.001 0 0 ]
[ 1.001 .61903 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
[ ] 0 setdash
0 g
p
p
0 0 .5 r
.001 w
.22058 0 m
.22058 .61803 L
s
P
p
0 0 .5 r
.001 w
.41736 0 m
.41736 .61803 L
s
P
p
0 0 .5 r
.001 w
.61413 0 m
.61413 .61803 L
s
P
p
0 0 .5 r
.001 w
.8109 0 m
.8109 .61803 L
s
P
p
0 0 .5 r
.001 w
0 .05575 m
1 .05575 L
s
P
p
0 0 .5 r
.001 w
0 .16526 m
1 .16526 L
s
P
p
0 0 .5 r
.001 w
0 .27478 m
1 .27478 L
s
P
p
0 0 .5 r
.001 w
0 .38429 m
1 .38429 L
s
P
p
0 0 .5 r
.001 w
0 .4938 m
1 .4938 L
s
P
p
0 0 .5 r
.001 w
0 .60332 m
1 .60332 L
s
P
p
0 0 .5 r
.001 w
0 .01217 m
1 .01217 L
s
P
p
0 0 .5 r
.001 w
0 .02278 m
1 .02278 L
s
P
p
0 0 .5 r
.001 w
0 .03145 m
1 .03145 L
s
P
p
0 0 .5 r
.001 w
0 .03879 m
1 .03879 L
s
P
p
0 0 .5 r
.001 w
0 .04514 m
1 .04514 L
s
P
p
0 0 .5 r
.001 w
0 .05074 m
1 .05074 L
s
P
p
0 0 .5 r
.001 w
0 .08872 m
1 .08872 L
s
P
p
0 0 .5 r
.001 w
0 .108 m
1 .108 L
s
P
p
0 0 .5 r
.001 w
0 .12168 m
1 .12168 L
s
P
p
0 0 .5 r
.001 w
0 .1323 m
1 .1323 L
s
P
p
0 0 .5 r
.001 w
0 .14097 m
1 .14097 L
s
P
p
0 0 .5 r
.001 w
0 .1483 m
1 .1483 L
s
P
p
0 0 .5 r
.001 w
0 .15465 m
1 .15465 L
s
P
p
0 0 .5 r
.001 w
0 .16025 m
1 .16025 L
s
P
p
0 0 .5 r
.001 w
0 .19823 m
1 .19823 L
s
P
p
0 0 .5 r
.001 w
0 .21751 m
1 .21751 L
s
P
p
0 0 .5 r
.001 w
0 .2312 m
1 .2312 L
s
P
p
0 0 .5 r
.001 w
0 .24181 m
1 .24181 L
s
P
p
0 0 .5 r
.001 w
0 .25048 m
1 .25048 L
s
P
p
0 0 .5 r
.001 w
0 .25781 m
1 .25781 L
s
P
p
0 0 .5 r
.001 w
0 .26416 m
1 .26416 L
s
P
p
0 0 .5 r
.001 w
0 .26977 m
1 .26977 L
s
P
p
0 0 .5 r
.001 w
0 .30774 m
1 .30774 L
s
P
p
0 0 .5 r
.001 w
0 .32703 m
1 .32703 L
s
P
p
0 0 .5 r
.001 w
0 .34071 m
1 .34071 L
s
P
p
0 0 .5 r
.001 w
0 .35132 m
1 .35132 L
s
P
p
0 0 .5 r
.001 w
0 .36 m
1 .36 L
s
P
p
0 0 .5 r
.001 w
0 .36733 m
1 .36733 L
s
P
p
0 0 .5 r
.001 w
0 .37368 m
1 .37368 L
s
P
p
0 0 .5 r
.001 w
0 .37928 m
1 .37928 L
s
P
p
0 0 .5 r
.001 w
0 .41726 m
1 .41726 L
s
P
p
0 0 .5 r
.001 w
0 .43654 m
1 .43654 L
s
P
p
0 0 .5 r
.001 w
0 .45022 m
1 .45022 L
s
P
p
0 0 .5 r
.001 w
0 .46084 m
1 .46084 L
s
P
p
0 0 .5 r
.001 w
0 .46951 m
1 .46951 L
s
P
p
0 0 .5 r
.001 w
0 .47684 m
1 .47684 L
s
P
p
0 0 .5 r
.001 w
0 .48319 m
1 .48319 L
s
P
p
0 0 .5 r
.001 w
0 .48879 m
1 .48879 L
s
P
p
0 0 .5 r
.001 w
0 .52677 m
1 .52677 L
s
P
p
0 0 .5 r
.001 w
0 .54606 m
1 .54606 L
s
P
p
0 0 .5 r
.001 w
0 .55974 m
1 .55974 L
s
P
p
0 0 .5 r
.001 w
0 .57035 m
1 .57035 L
s
P
p
0 0 .5 r
.001 w
0 .57902 m
1 .57902 L
s
P
p
0 0 .5 r
.001 w
0 .58635 m
1 .58635 L
s
P
p
0 0 .5 r
.001 w
0 .59271 m
1 .59271 L
s
P
p
0 0 .5 r
.001 w
0 .59831 m
1 .59831 L
s
P
p
.002 w
.02381 0 m
.02381 .00625 L
s
P
[(0)] .02381 0 0 2 0 Minner Mrotshowa
p
.002 w
.22058 0 m
.22058 .00625 L
s
P
[(50)] .22058 0 0 2 0 Minner Mrotshowa
p
.002 w
.41736 0 m
.41736 .00625 L
s
P
[(100)] .41736 0 0 2 0 Minner Mrotshowa
p
.002 w
.61413 0 m
.61413 .00625 L
s
P
[(150)] .61413 0 0 2 0 Minner Mrotshowa
p
.002 w
.8109 0 m
.8109 .00625 L
s
P
[(200)] .8109 0 0 2 0 Minner Mrotshowa
p
.001 w
.06316 0 m
.06316 .00375 L
s
P
p
.001 w
.10252 0 m
.10252 .00375 L
s
P
p
.001 w
.14187 0 m
.14187 .00375 L
s
P
p
.001 w
.18123 0 m
.18123 .00375 L
s
P
p
.001 w
.25994 0 m
.25994 .00375 L
s
P
p
.001 w
.29929 0 m
.29929 .00375 L
s
P
p
.001 w
.33865 0 m
.33865 .00375 L
s
P
p
.001 w
.378 0 m
.378 .00375 L
s
P
p
.001 w
.45671 0 m
.45671 .00375 L
s
P
p
.001 w
.49606 0 m
.49606 .00375 L
s
P
p
.001 w
.53542 0 m
.53542 .00375 L
s
P
p
.001 w
.57477 0 m
.57477 .00375 L
s
P
p
.001 w
.65348 0 m
.65348 .00375 L
s
P
p
.001 w
.69284 0 m
.69284 .00375 L
s
P
p
.001 w
.73219 0 m
.73219 .00375 L
s
P
p
.001 w
.77155 0 m
.77155 .00375 L
s
P
p
.001 w
.85026 0 m
.85026 .00375 L
s
P
p
.001 w
.88961 0 m
.88961 .00375 L
s
P
p
.001 w
.92896 0 m
.92896 .00375 L
s
P
p
.001 w
.96832 0 m
.96832 .00375 L
s
P
[(Contents Reg1 {a:x^a mod n = 4})] .5 0 0 2 0 0 -1 Mouter Mrotshowa
p
.002 w
0 0 m
1 0 L
s
P
p
.002 w
0 .05575 m
.00625 .05575 L
s
P
[(0.00001)] -0.0125 .05575 1 0 0 Minner Mrotshowa
p
.002 w
0 .16526 m
.00625 .16526 L
s
P
[(0.0001)] -0.0125 .16526 1 0 0 Minner Mrotshowa
p
.002 w
0 .27478 m
.00625 .27478 L
s
P
[(0.001)] -0.0125 .27478 1 0 0 Minner Mrotshowa
p
.002 w
0 .38429 m
.00625 .38429 L
s
P
[(0.01)] -0.0125 .38429 1 0 0 Minner Mrotshowa
p
.002 w
0 .4938 m
.00625 .4938 L
s
P
[(0.1)] -0.0125 .4938 1 0 0 Minner Mrotshowa
p
.002 w
0 .60332 m
.00625 .60332 L
s
P
[(1)] -0.0125 .60332 1 0 0 Minner Mrotshowa
p
.001 w
0 .01217 m
.00375 .01217 L
s
P
p
.001 w
0 .02278 m
.00375 .02278 L
s
P
p
.001 w
0 .03145 m
.00375 .03145 L
s
P
p
.001 w
0 .03879 m
.00375 .03879 L
s
P
p
.001 w
0 .04514 m
.00375 .04514 L
s
P
p
.001 w
0 .05074 m
.00375 .05074 L
s
P
p
.001 w
0 .08872 m
.00375 .08872 L
s
P
p
.001 w
0 .108 m
.00375 .108 L
s
P
p
.001 w
0 .12168 m
.00375 .12168 L
s
P
p
.001 w
0 .1323 m
.00375 .1323 L
s
P
p
.001 w
0 .14097 m
.00375 .14097 L
s
P
p
.001 w
0 .1483 m
.00375 .1483 L
s
P
p
.001 w
0 .15465 m
.00375 .15465 L
s
P
p
.001 w
0 .16025 m
.00375 .16025 L
s
P
p
.001 w
0 .19823 m
.00375 .19823 L
s
P
p
.001 w
0 .21751 m
.00375 .21751 L
s
P
p
.001 w
0 .2312 m
.00375 .2312 L
s
P
p
.001 w
0 .24181 m
.00375 .24181 L
s
P
p
.001 w
0 .25048 m
.00375 .25048 L
s
P
p
.001 w
0 .25781 m
.00375 .25781 L
s
P
p
.001 w
0 .26416 m
.00375 .26416 L
s
P
p
.001 w
0 .26977 m
.00375 .26977 L
s
P
p
.001 w
0 .30774 m
.00375 .30774 L
s
P
p
.001 w
0 .32703 m
.00375 .32703 L
s
P
p
.001 w
0 .34071 m
.00375 .34071 L
s
P
p
.001 w
0 .35132 m
.00375 .35132 L
s
P
p
.001 w
0 .36 m
.00375 .36 L
s
P
p
.001 w
0 .36733 m
.00375 .36733 L
s
P
p
.001 w
0 .37368 m
.00375 .37368 L
s
P
p
.001 w
0 .37928 m
.00375 .37928 L
s
P
p
.001 w
0 .41726 m
.00375 .41726 L
s
P
p
.001 w
0 .43654 m
.00375 .43654 L
s
P
p
.001 w
0 .45022 m
.00375 .45022 L
s
P
p
.001 w
0 .46084 m
.00375 .46084 L
s
P
p
.001 w
0 .46951 m
.00375 .46951 L
s
P
p
.001 w
0 .47684 m
.00375 .47684 L
s
P
p
.001 w
0 .48319 m
.00375 .48319 L
s
P
p
.001 w
0 .48879 m
.00375 .48879 L
s
P
p
.001 w
0 .52677 m
.00375 .52677 L
s
P
p
.001 w
0 .54606 m
.00375 .54606 L
s
P
p
.001 w
0 .55974 m
.00375 .55974 L
s
P
p
.001 w
0 .57035 m
.00375 .57035 L
s
P
p
.001 w
0 .57902 m
.00375 .57902 L
s
P
p
.001 w
0 .58635 m
.00375 .58635 L
s
P
p
.001 w
0 .59271 m
.00375 .59271 L
s
P
p
.001 w
0 .59831 m
.00375 .59831 L
s
P
[(ln\\(Pr\\(Measure a\\)\\))] -0.0125 .30902 1 0 90 -1 0 Mouter Mrotshowa
p
.002 w
0 0 m
0 .61803 L
s
P
P
p
p
.002 w
.02381 .61178 m
.02381 .61803 L
s
P
p
.002 w
.22058 .61178 m
.22058 .61803 L
s
P
p
.002 w
.41736 .61178 m
.41736 .61803 L
s
P
p
.002 w
.61413 .61178 m
.61413 .61803 L
s
P
p
.002 w
.8109 .61178 m
.8109 .61803 L
s
P
p
.001 w
.06316 .61428 m
.06316 .61803 L
s
P
p
.001 w
.10252 .61428 m
.10252 .61803 L
s
P
p
.001 w
.14187 .61428 m
.14187 .61803 L
s
P
p
.001 w
.18123 .61428 m
.18123 .61803 L
s
P
p
.001 w
.25994 .61428 m
.25994 .61803 L
s
P
p
.001 w
.29929 .61428 m
.29929 .61803 L
s
P
p
.001 w
.33865 .61428 m
.33865 .61803 L
s
P
p
.001 w
.378 .61428 m
.378 .61803 L
s
P
p
.001 w
.45671 .61428 m
.45671 .61803 L
s
P
p
.001 w
.49606 .61428 m
.49606 .61803 L
s
P
p
.001 w
.53542 .61428 m
.53542 .61803 L
s
P
p
.001 w
.57477 .61428 m
.57477 .61803 L
s
P
p
.001 w
.65348 .61428 m
.65348 .61803 L
s
P
p
.001 w
.69284 .61428 m
.69284 .61803 L
s
P
p
.001 w
.73219 .61428 m
.73219 .61803 L
s
P
p
.001 w
.77155 .61428 m
.77155 .61803 L
s
P
p
.001 w
.85026 .61428 m
.85026 .61803 L
s
P
p
.001 w
.88961 .61428 m
.88961 .61803 L
s
P
p
.001 w
.92896 .61428 m
.92896 .61803 L
s
P
p
.001 w
.96832 .61428 m
.96832 .61803 L
s
P
p
.002 w
0 .61803 m
1 .61803 L
s
P
[(Compute Discrete Fourier Transform of Reg1)] .5 .61803 0 -2 Mshowa
p
.002 w
.99375 .05575 m
1 .05575 L
s
P
p
.002 w
.99375 .16526 m
1 .16526 L
s
P
p
.002 w
.99375 .27478 m
1 .27478 L
s
P
p
.002 w
.99375 .38429 m
1 .38429 L
s
P
p
.002 w
.99375 .4938 m
1 .4938 L
s
P
p
.002 w
.99375 .60332 m
1 .60332 L
s
P
p
.001 w
.99625 .01217 m
1 .01217 L
s
P
p
.001 w
.99625 .02278 m
1 .02278 L
s
P
p
.001 w
.99625 .03145 m
1 .03145 L
s
P
p
.001 w
.99625 .03879 m
1 .03879 L
s
P
p
.001 w
.99625 .04514 m
1 .04514 L
s
P
p
.001 w
.99625 .05074 m
1 .05074 L
s
P
p
.001 w
.99625 .08872 m
1 .08872 L
s
P
p
.001 w
.99625 .108 m
1 .108 L
s
P
p
.001 w
.99625 .12168 m
1 .12168 L
s
P
p
.001 w
.99625 .1323 m
1 .1323 L
s
P
p
.001 w
.99625 .14097 m
1 .14097 L
s
P
p
.001 w
.99625 .1483 m
1 .1483 L
s
P
p
.001 w
.99625 .15465 m
1 .15465 L
s
P
p
.001 w
.99625 .16025 m
1 .16025 L
s
P
p
.001 w
.99625 .19823 m
1 .19823 L
s
P
p
.001 w
.99625 .21751 m
1 .21751 L
s
P
p
.001 w
.99625 .2312 m
1 .2312 L
s
P
p
.001 w
.99625 .24181 m
1 .24181 L
s
P
p
.001 w
.99625 .25048 m
1 .25048 L
s
P
p
.001 w
.99625 .25781 m
1 .25781 L
s
P
p
.001 w
.99625 .26416 m
1 .26416 L
s
P
p
.001 w
.99625 .26977 m
1 .26977 L
s
P
p
.001 w
.99625 .30774 m
1 .30774 L
s
P
p
.001 w
.99625 .32703 m
1 .32703 L
s
P
p
.001 w
.99625 .34071 m
1 .34071 L
s
P
p
.001 w
.99625 .35132 m
1 .35132 L
s
P
p
.001 w
.99625 .36 m
1 .36 L
s
P
p
.001 w
.99625 .36733 m
1 .36733 L
s
P
p
.001 w
.99625 .37368 m
1 .37368 L
s
P
p
.001 w
.99625 .37928 m
1 .37928 L
s
P
p
.001 w
.99625 .41726 m
1 .41726 L
s
P
p
.001 w
.99625 .43654 m
1 .43654 L
s
P
p
.001 w
.99625 .45022 m
1 .45022 L
s
P
p
.001 w
.99625 .46084 m
1 .46084 L
s
P
p
.001 w
.99625 .46951 m
1 .46951 L
s
P
p
.001 w
.99625 .47684 m
1 .47684 L
s
P
p
.001 w
.99625 .48319 m
1 .48319 L
s
P
p
.001 w
.99625 .48879 m
1 .48879 L
s
P
p
.001 w
.99625 .52677 m
1 .52677 L
s
P
p
.001 w
.99625 .54606 m
1 .54606 L
s
P
p
.001 w
.99625 .55974 m
1 .55974 L
s
P
p
.001 w
.99625 .57035 m
1 .57035 L
s
P
p
.001 w
.99625 .57902 m
1 .57902 L
s
P
p
.001 w
.99625 .58635 m
1 .58635 L
s
P
p
.001 w
.99625 .59271 m
1 .59271 L
s
P
p
.001 w
.99625 .59831 m
1 .59831 L
s
P
p
.002 w
1 0 m
1 .61803 L
s
P
P
p
P
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
p
p
.01 w
.02381 .53758 Mdot
.02774 .01472 Mdot
.03168 .01483 Mdot
.03562 .01503 Mdot
.03955 .01531 Mdot
.04349 .01567 Mdot
.04742 .01611 Mdot
.05136 .01663 Mdot
.05529 .01723 Mdot
.05923 .01792 Mdot
.06316 .01869 Mdot
.0671 .01954 Mdot
.07104 .02048 Mdot
.07497 .0215 Mdot
.07891 .02262 Mdot
.08284 .02382 Mdot
.08678 .02511 Mdot
.09071 .02649 Mdot
.09465 .02797 Mdot
.09858 .02955 Mdot
.10252 .03122 Mdot
.10645 .033 Mdot
.11039 .03488 Mdot
.11433 .03686 Mdot
.11826 .03896 Mdot
.1222 .04117 Mdot
.12613 .04349 Mdot
.13007 .04594 Mdot
.134 .04852 Mdot
.13794 .05123 Mdot
.14187 .05407 Mdot
.14581 .05706 Mdot
.14974 .0602 Mdot
.15368 .06349 Mdot
.15762 .06695 Mdot
.16155 .07059 Mdot
.16549 .07442 Mdot
.16942 .07844 Mdot
.17336 .08267 Mdot
.17729 .08713 Mdot
.18123 .09184 Mdot
.18516 .09681 Mdot
.1891 .10207 Mdot
.19303 .10764 Mdot
.19697 .11356 Mdot
.20091 .11987 Mdot
.20484 .1266 Mdot
.20878 .13382 Mdot
.21271 .14159 Mdot
.21665 .14998 Mdot
.22058 .15912 Mdot
.22452 .16913 Mdot
.22845 .18019 Mdot
.23239 .19255 Mdot
.23632 .20656 Mdot
.24026 .22273 Mdot
.2442 .24186 Mdot
.24813 .26536 Mdot
.25207 .29592 Mdot
.256 .34003 Mdot
.25994 .42179 Mdot
.26387 .52751 Mdot
.26781 .37569 Mdot
.27174 .3211 Mdot
.27568 .2875 Mdot
.27961 .26341 Mdot
.28355 .24481 Mdot
.28749 .22977 Mdot
.29142 .21726 Mdot
.29536 .20664 Mdot
.29929 .19749 Mdot
.30323 .18952 Mdot
.30716 .18252 Mdot
.3111 .17635 Mdot
.31503 .17088 Mdot
.31897 .16602 Mdot
.3229 .1617 Mdot
.32684 .15787 Mdot
.33078 .15447 Mdot
.33471 .15147 Mdot
.33865 .14884 Mdot
.34258 .14654 Mdot
.34652 .14457 Mdot
.35045 .14289 Mdot
.35439 .14151 Mdot
.35832 .14039 Mdot
.36226 .13953 Mdot
.36619 .13893 Mdot
.37013 .13858 Mdot
.37407 .13846 Mdot
.378 .13859 Mdot
.38194 .13895 Mdot
.38587 .13955 Mdot
.38981 .14038 Mdot
.39374 .14146 Mdot
.39768 .14277 Mdot
.40161 .14433 Mdot
.40555 .14615 Mdot
.40948 .14823 Mdot
.41342 .15058 Mdot
.41736 .15321 Mdot
.42129 .15615 Mdot
.42523 .1594 Mdot
.42916 .16299 Mdot
.4331 .16694 Mdot
.43703 .17129 Mdot
.44097 .17607 Mdot
.4449 .18133 Mdot
.44884 .18713 Mdot
.45277 .19352 Mdot
.45671 .2006 Mdot
.46065 .20847 Mdot
.46458 .21729 Mdot
.46852 .22724 Mdot
.47245 .23859 Mdot
.47639 .25171 Mdot
.48032 .26719 Mdot
.48426 .28593 Mdot
.48819 .30956 Mdot
.49213 .34136 Mdot
.49606 .38981 Mdot
.5 .49424 Mdot
.50394 .49424 Mdot
.50787 .38981 Mdot
.51181 .34136 Mdot
.51574 .30956 Mdot
.51968 .28593 Mdot
.52361 .26719 Mdot
.52755 .25171 Mdot
.53148 .23859 Mdot
.53542 .22724 Mdot
.53935 .21729 Mdot
.54329 .20847 Mdot
.54723 .2006 Mdot
.55116 .19352 Mdot
.5551 .18713 Mdot
.55903 .18133 Mdot
.56297 .17607 Mdot
.5669 .17129 Mdot
.57084 .16694 Mdot
.57477 .16299 Mdot
.57871 .1594 Mdot
.58264 .15615 Mdot
.58658 .15321 Mdot
.59052 .15058 Mdot
.59445 .14823 Mdot
.59839 .14615 Mdot
.60232 .14433 Mdot
.60626 .14277 Mdot
.61019 .14146 Mdot
.61413 .14038 Mdot
.61806 .13955 Mdot
.622 .13895 Mdot
.62593 .13859 Mdot
.62987 .13846 Mdot
.63381 .13858 Mdot
.63774 .13893 Mdot
.64168 .13953 Mdot
.64561 .14039 Mdot
.64955 .14151 Mdot
.65348 .14289 Mdot
.65742 .14457 Mdot
.66135 .14654 Mdot
.66529 .14884 Mdot
.66922 .15147 Mdot
.67316 .15447 Mdot
.6771 .15787 Mdot
.68103 .1617 Mdot
.68497 .16602 Mdot
.6889 .17088 Mdot
.69284 .17635 Mdot
.69677 .18252 Mdot
.70071 .18952 Mdot
.70464 .19749 Mdot
.70858 .20664 Mdot
.71251 .21726 Mdot
.71645 .22977 Mdot
.72039 .24481 Mdot
.72432 .26341 Mdot
.72826 .2875 Mdot
.73219 .3211 Mdot
.73613 .37569 Mdot
.74006 .52751 Mdot
.744 .42179 Mdot
.74793 .34003 Mdot
.75187 .29592 Mdot
.7558 .26536 Mdot
.75974 .24186 Mdot
.76368 .22273 Mdot
.76761 .20656 Mdot
.77155 .19255 Mdot
.77548 .18019 Mdot
.77942 .16913 Mdot
.78335 .15912 Mdot
.78729 .14998 Mdot
.79122 .14159 Mdot
.79516 .13382 Mdot
.79909 .1266 Mdot
.80303 .11987 Mdot
.80697 .11356 Mdot
.8109 .10764 Mdot
.81484 .10207 Mdot
.81877 .09681 Mdot
.82271 .09184 Mdot
.82664 .08713 Mdot
.83058 .08267 Mdot
.83451 .07844 Mdot
.83845 .07442 Mdot
.84238 .07059 Mdot
.84632 .06695 Mdot
.85026 .06349 Mdot
.85419 .0602 Mdot
.85813 .05706 Mdot
.86206 .05407 Mdot
.866 .05123 Mdot
.86993 .04852 Mdot
.87387 .04594 Mdot
.8778 .04349 Mdot
.88174 .04117 Mdot
.88567 .03896 Mdot
.88961 .03686 Mdot
.89355 .03488 Mdot
.89748 .033 Mdot
.90142 .03122 Mdot
.90535 .02955 Mdot
.90929 .02797 Mdot
.91322 .02649 Mdot
.91716 .02511 Mdot
.92109 .02382 Mdot
.92503 .02262 Mdot
.92896 .0215 Mdot
.9329 .02048 Mdot
.93684 .01954 Mdot
.94077 .01869 Mdot
.94471 .01792 Mdot
.94864 .01723 Mdot
.95258 .01663 Mdot
.95651 .01611 Mdot
.96045 .01567 Mdot
.96438 .01531 Mdot
.96832 .01503 Mdot
.97226 .01483 Mdot
.97619 .01472 Mdot
P
P
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  Evaluatable->False,
  AspectRatioFixed->True,
  ImageSize->{282, 174},
  ImageMargins->{{34, Inherited}, {Inherited, Inherited}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004J0000[Q000`40O003h00Oogoo6goo003oOolK
Ool0081oo`<000moo`8005eoo`8002Moo`00Pgoo00<007ooOol037oo00<007ooOol0GGoo00<007oo
Ool09Goo000mOol40003Ool30002Ool200000goo00000002Ool30003Ool4000017oo000007oo0P00
0Woo0`000Woo10001goo0P000Woo0P000Woo10000Woo100000Aoo`00000000Yoo`03001oogoo009o
o`D0009oo`80009oo`800003Ool0000000Qoo`D000Moo`05001oo`00Ool00002Ool30003Ool50006
Ool200000goo0000000DOol30003Ool00`00Oomoo`0UOol003aoo`03001oogoo00Aoo`07001oogoo
Ool007oo00000Woo00D007ooOomoo`00009oo`03001oo`0000Eoo`04001oogoo0003Ool01000Oomo
o`0017oo00<007ooOol01Woo00@007oo0000009oo`03001oogoo00=oo`05001oogooOol00002Ool0
0`00Oomoo`09Ool00`00Oomoo`02Ool01000Oomoo`000goo0P000goo00<007oo00002Goo00@007oo
Ool000Qoo`07001oo`00Ool007oo00000goo00<007oo00000goo00<007ooOol01Goo00@007ooOol0
01Ioo`03001oogoo009oo`03001oogoo02Eoo`00?7oo00<007ooOol017oo00L007ooOomoo`00Ool0
0002Ool01@00Oomoogoo000017oo1@0000Eoo`00Oomoo`0000=oo`03001oogoo009oo`@000Qoo`<0
00=oo`D00003Ool007oo009oo`04001oogoo000:Ool00`00Oomoo`03Ool40009Ool00`00Oomoo`08
Ool40008Ool01`00Ool007oo001oo`0000=oo`03001oo`0000=oo`03001oogoo00Eoo`04001oogoo
0008Ool50007Ool40004Ool00`00Oomoo`0TOol003aoo`03001oogoo00Aoo`07001oogooOol007oo
00000Woo00D007ooOomoo`0000Aoo`07001oogooOol007oo00000Woo00D007ooOomoo`0000Aoo`03
001oogoo00Uoo`04001oogoo0002Ool01`00Oomoogoo001oo`0000=oo`04001oogoo000;Ool00`00
Oomoo`05Ool01000Oomoogoo0P000goo00<007oo000037oo00<007ooOol01Woo00L007oo001oo`00
Ool00003Ool00`00Ool00003Ool00`00Oomoo`05Ool01000Oomoo`0057oo00<007oo000017oo00<0
07ooOol09Goo000lOol01@00Oomoogoo00000goo0`0000=oo`0000000`000Woo10000goo0`0000=o
o`0000000`000Woo10000Woo100027oo00@007ooOol000=oo`<000=oo`D00003Ool007oo00Yoo`03
001oogoo00=oo`<000=oo`80009oo`800003Ool0000000Uoo`<000Moo`H0009oo`<000=oo`@000Io
o`D000Qoo`D000Moo`03001oo`0000Aoo`03001oogoo02Eoo`00?Goo10003goo00<007ooOol03goo
00<007ooOol03Goo10003goo0P002goo0P005Goo00<007oo00007goo00<007ooOol07Woo0P000goo
0P009goo001@Ool00`00Oomoo`0?Ool00`00Oomoo`15Ool00`00Oomoo`0MOol2001>Ool00?mooa]o
o`00ogoo6goo003oOolKOol00?mooa]oo`00ogoo6goo003oOolKOol00?mooa]oo`00ogoo6goo003o
OolKOol00?mooa]oo`00=goo0P008Woo0`0017oo0P0077oo0`0017oo0P0017oo0P006Goo0`000goo
0`0017oo0P006Goo10000goo0P0017oo0P00>goo000fOol01000Oomoo`0097oo00@007ooOol0009o
o`03001oogoo01Yoo`03001oogoo009oo`04001oogoo0002Ool01000Oomoo`006Goo00<007ooOol0
1Goo00@007ooOol0009oo`03001oogoo01Moo`03001oogoo009oo`04001oogoo0002Ool01000Oomo
o`00>Woo000fOol01000Oomoo`0097oo00@007ooOol0009oo`03001oogoo01Yoo`03001oogoo009o
o`04001oogoo0002Ool01000Oomoo`006Goo00<007ooOol01Goo00@007ooOol0009oo`03001oogoo
01Qoo`05001oogooOol00002Ool01000Oomoo`000Woo00<007ooOol0>7oo000fOol01000Oomoo`00
8Goo0`000goo00@007ooOol001aoo`03001oogoo009oo`04001oogoo0002Ool01000Oomoo`006Goo
00<007ooOol00Woo0`000goo00@007ooOol001]oo`04001oogoo0002Ool01000Oomoo`000Woo00<0
07ooOol0>7oo000fOol01000Oomoo`008Goo00<007ooOol00goo00@007ooOol001aoo`03001oogoo
009oo`04001oogoo0002Ool01000Oomoo`006Goo00<007ooOol00Woo00<007ooOol00goo00@007oo
Ool001Qoo`04001oogoo0002Ool01000Oomoo`000Woo00@007ooOol003Yoo`00=goo0P008Woo1000
0goo0P0077oo0P001Goo0P0017oo0P006Goo0P0017oo10000goo0P006Woo0P0017oo0P0017oo0P00
>goo003oOolKOol00?mooa]oo`00ogoo6goo003oOolKOol00?mooa]oo`00ogoo6goo000dOoo;000K
Ool003Aoo`05001oogooOol00007Ool00`00Oomoo`05Ool00`00Oomoo`05Ool00`00Oomoo`05Ool0
0`00Oomoo`05Ool00`00Oomoo`05Ool00`00Oomoo`05Ool00`00Oomoo`05Ool00`00Oomoo`05Ool0
0`00Oomoo`05Ool00`00Oomoo`05Ool00`00Oomoo`05Ool00`00Oomoo`05Ool00`00Oomoo`05Ool0
0`00Oomoo`05Ool00`00Oomoo`05Ool00`00Oomoo`05Ool00`00Oomoo`05Ool00`00Oomoo`05Ool0
0`00Oomoo`05Ool00`00Oomoo`05Ool00`00Oomoo`05Ool00`00Oomoo`05Ool00`00Oomoo`05Ool0
0`00Oomoo`03Ool00`00Oomoo`0IOol003Aoo`03001oogoo02Uoo`0300moogoo02Eoo`0300moogoo
02Eoo`0300moogoo02Eoo`0300moogoo02=oo`03001oogoo01Uoo`00=7oo00<0000?00l00P0?2@00
/00?2@000`0?00<007ooOol06Goo000dOol00`00Oomoo`02Ool<000KOol00`0?Oomoo`0UOol00`0?
Oomoo`0UOol00`0?Oomoo`0UOol00`0?Oomoo`0DOol<0003Ool00`00Oomoo`0IOol003Aoo`030000
3`0?00X03`L00:<03`P000/03`03001oogoo01Uoo`00=7oo00<007ooOol03Goo1`005Goo00<03goo
Ool09Goo00<03gooOol09Goo00<03gooOol09Goo00<03gooOol03Woo1`003Woo00<007ooOol06Goo
000dOol00`0000l03`0@00l5002K00l6000A00l00`00Oomoo`0IOol003Aoo`0300003`0?01803`D0
09P03`@001@03`03001oogoo01Uoo`00=7oo00<0000?00l0500?1000U@0?1@005@0?00<007ooOol0
6Goo0009Ool20004Ool20004Ool20004Ool20004Ool20004Ool20003Ool30005Ool00`0000l03`0F
00l4002B00l4000G00l00`00Oomoo`0IOol000Qoo`04001oogoo0003Ool20003Ool01000Oomoo`00
0Woo00@007ooOol0009oo`04001oogoo0002Ool01000Oomoo`000goo00<007ooOol017oo00<007oo
Ool05goo1@003Goo00<03gooOol09Goo00<03gooOol09Goo00<03gooOol09Goo00<03gooOol01Woo
10006Goo00<007ooOol06Goo0008Ool01000Oomoo`0027oo00@007ooOol0009oo`04001oogoo0002
Ool01000Oomoo`000Woo00@007ooOol000=oo`03001oogoo00Aoo`8001X03`<008d03`@001T03`80
01]oo`000Woo1@0000Eoo`00Oomoo`0000Qoo`04001oogoo0002Ool01000Oomoo`000Woo00@007oo
Ool0009oo`04001oogoo0003Ool00`00Oomoo`04Ool00`00Oomoo`0JOol4000;Ool00`0?Oomoo`0U
Ool00`0?Oomoo`0UOol00`0?Oomoo`0UOol00`0?Oomoo`04Ool3000LOol00`00Oomoo`0IOol000Ao
o`05001oogooOol00002Ool00`00Oomoo`06Ool01000Oomoo`000Woo00@007ooOol0009oo`04001o
ogoo0002Ool01000Oomoo`000goo00<007ooOol017oo00<007ooOol06goo10002Woo00<03gooOol0
9Goo00<03gooOol09Goo00<03gooOol09Goo00<03gooOol00goo0`007Goo00<007ooOol06Goo0004
Ool00`00Oomoo`02Ool2000:Ool20004Ool20004Ool20004Ool20003Ool20006Ool00`00Oomoo`0M
Ool30009Ool00`0?Oomoo`0UOol00`0?Oomoo`0UOol00`0?Oomoo`0UOol00`0?Oomoo`02Ool3000N
Ool00`00Oomoo`0IOol000Aoo`03001oogoo02eoo`03001oogoo01ioo`<000Qoo`0300moogoo02Eo
o`0300moogoo02Eoo`0300moogoo02Eoo`0300moogoo00@001moo`03001oogoo01Uoo`0017oo00<0
07ooOol0;Goo00<007ooOol07Woo10001goo00<03gooOol09Goo00<03gooOol09Goo00<03gooOol0
9Goo00<03gooOol00`0087oo00<007ooOol06Goo0004Ool00`00Oomoo`0]Ool00`0000l03`0P00l3
002000l3000Q00l00`00Oomoo`0IOol0009oo`D002eoo`03001oogoo025oo`<000Eoo`0300moogoo
02Eoo`0300moogoo02Eoo`0300moogoo02Eoo`0400l00000000ROol00`00Oomoo`0IOol0009oo`04
001oogoo000^Ool00`00Oomoo`0ROol20005Ool00`0?Oomoo`0UOol00`0?Oomoo`0UOol00`0?Oomo
o`0UOol3000SOol00`00Oomoo`0IOol0009oo`04001oogoo000^Ool00`00Oomoo`0ROol20005Ool0
0`0?Oomoo`0UOol00`0?Oomoo`0UOol00`0?Oomoo`0UOol2000TOol00`00Oomoo`0IOol0009oo`04
001oogoo000^Ool00`0000l03`0S00l2001k00l2000U00l00`00Oomoo`0IOol00003Ool0000000<0
02ioo`03001oogoo02=oo`<000=oo`0300moogoo02Eoo`0300moogoo02Eoo`0300moogoo02Aoo`80
02Eoo`03001oogoo01Uoo`000goo00<007ooOol0;Woo00<007ooOol097oo0`000Woo00<03gooOol0
9Goo00<03gooOol09Goo00<03gooOol08goo0`009Goo00<007ooOol06Goo0003Ool00`00Oomoo`0^
Ool00`0000l03`0U00l3001f00l3000V00l00`00Oomoo`0IOol000=oo`03001oogoo02ioo`03001o
ogoo02Ioo`800003Ool03goo02Ioo`0300moogoo02Eoo`0300moogoo029oo`800003Ool03goo02Ao
o`03001oogoo01Uoo`000goo00<007ooOol0;Woo00<0000?00l09P0?0P00M@0?0P00:00?00<007oo
Ool06Goo0003Ool00`00Oomoo`0^Ool00`00Oomoo`0VOol300000`0?Oomoo`0HOol:0003Ool00`0?
Oomoo`0TOol:000JOol30002Ool00`0?Oomoo`0SOol00`00Oomoo`0IOol000=oo`03001oogoo02io
o`0300003`0?02L03`8001T03`h002D03`l001P03`8002T03`03001oogoo01Uoo`0017oo00<007oo
Ool0;Goo00<0000?00l0:00?0P005P0?1@00200?1@008P0?1@00200?1@005P0?0P00:@0?00<007oo
Ool06Goo000017oo00000000<7oo00<007ooOol0:7oo0P005Goo100037oo10007goo1@000Woo00<0
3gooOol01goo10005Goo0P000goo00<03gooOol08goo00<007ooOol06Goo0002Ool00`00Oomoo`0:
Ool20004Ool20004Ool20004Ool20004Ool20003Ool30005Ool00`0000l03`0Y00l2000C00l3000@
00l3000M00l4000@00l3000C00l2000Z00l00`00Oomoo`0IOol0009oo`<000Uoo`04001oogoo0003
Ool20003Ool01000Oomoo`000Woo00@007ooOol0009oo`04001oogoo0003Ool00`00Oomoo`04Ool0
0`0000l03`0Y00l2000B00l3000B00l3000L00l2000B00l4000B00l2000Z00l00`00Oomoo`0IOol0
009oo`04001oogoo0008Ool01000Oomoo`0027oo00@007ooOol0009oo`04001oogoo0002Ool01000
Oomoo`000goo00<007ooOol017oo0P00:`0?0P00400?0`00500?1000600?1000500?0`00400?0P00
:P0?0P006goo0002Ool01000Oomoo`0027oo00@007ooOol000Qoo`04001oogoo0002Ool01000Oomo
o`000Woo00@007ooOol000=oo`03001oogoo00Aoo`03001oogoo02Uoo`0300l0000000moo`<001=o
o`0300moogoo00<001Moo`@000Moo`0300moogoo00aoo`<000moo`8000Eoo`0300moogoo02=oo`03
001oogoo01Uoo`0000=oo`0000000P002Goo00@007ooOol000Qoo`04001oogoo0002Ool01000Oomo
o`000Woo00@007ooOol000=oo`03001oogoo00Aoo`03001oogoo02Uoo`0300l0000000moo`8001Ao
o`0400moogooOol3000EOol30009Ool00`0?Oomoo`0=Ool2000>Ool20006Ool00`0?Oomoo`0SOol0
0`00Oomoo`0IOol0009oo`@000Uoo`8000Yoo`8000Aoo`8000Aoo`8000=oo`8000Ioo`03001oogoo
02Uoo`0300l0000000ioo`8001Eoo`0300moogoo009oo`8001Eoo`8000Yoo`0300moogoo00eoo`80
00ioo`8000Ioo`0300moogoo02=oo`03001oogoo01Uoo`000goo00<007ooOol0;Woo00<007ooOol0
:Goo00<03gooOol03Woo0P005Goo00<03gooOol00goo0P0057oo0P002Woo00<03gooOol03Goo0`00
5Goo00<03gooOol08goo00<007ooOol06Goo0003Ool00`00Oomoo`0^Ool00`00Oomoo`0YOol0100?
Ool000003Goo0P005Goo00<03gooOol00goo0`004Woo0`002Woo00<03gooOol03Woo0P003Goo0P00
1Woo00<03gooOol08goo00<007ooOol06Goo0003Ool2000_Ool00`0000l03`0[00l2000<00l2000M
00l3000@00l3000M00l2000<00l2000/00l00`00Oomoo`0IOol0009oo`D002eoo`03001oogoo02Uo
o`0300moogoo00eoo`8001Ioo`0300moogoo00Eoo`80011oo`8000aoo`0300moogoo00moo`8001Ao
o`0300moogoo02=oo`03001oogoo01Uoo`000goo00<007ooOol0;Woo00<007ooOol0:Goo00<03goo
Ool00P002Woo0P005goo00<03gooOol01Goo0P003goo0P003Goo00<03gooOol047oo0P002Woo0P00
1goo00<03gooOol08goo00<007ooOol06Goo0003Ool00`00Oomoo`0^Ool00`00Oomoo`0YOol00`0?
Oomoo`02000:Ool2000GOol00`0?Oomoo`05Ool2000?Ool2000=Ool00`0?Oomoo`0@Ool2000:Ool2
0007Ool00`0?Oomoo`0SOol00`00Oomoo`0IOol000=oo`03001oogoo02ioo`0300003`0?03L03`80
02403`8000d03`8002803`8003P03`03001oogoo01Uoo`000goo00<007ooOol0;Woo00<007ooOol0
:Goo00@03gooOomoo`8000Qoo`8001Qoo`0300moogoo00Ioo`8000eoo`8000ioo`0300moogoo015o
o`8000Qoo`8000Qoo`0300moogoo02=oo`03001oogoo01Uoo`000goo00<007ooOol0;Woo00<007oo
Ool0:Goo00@03gooOomoo`8000Moo`8001Uoo`0300moogoo00Moo`8000aoo`8000ioo`0300moogoo
015oo`8000Qoo`8000Qoo`0300moogoo02=oo`03001oogoo01Uoo`000goo00<007ooOol0;Woo00<0
000?00l0=P0?0P008`0?0P00300?0P008P0?0P00>00?00<007ooOol06Goo0004Ool00`00Oomoo`0]
Ool00`00Oomoo`0YOol00`0?Oomoo`0UOol00`0?Oomoo`08Ool2000:Ool2000?Ool00`0?Oomoo`0U
Ool00`0?Oomoo`0SOol00`00Oomoo`0IOol0009oo`05001oogooOol0000]Ool00`0000l03`0^00l2
000600l2000T00l2000:00l2000T00l2000600l2000_00l00`00Oomoo`0IOol0009oo`05001oogoo
Ool0000]Ool00`00Oomoo`0YOol00`0?Oomoo`02Ool20006Ool2000IOol00`0?Oomoo`0UOol00`0?
Oomoo`0BOol20006Ool20009Ool00`0?Oomoo`0SOol00`00Oomoo`0IOol0009oo`05001oo`00Ool0
000]Ool00`0000l03`1M00l2000800l2001N00l00`00Oomoo`0IOol0009oo`05001oo`00Ool0000]
Ool00`0000l03`1M00l2000800l2001N00l00`00Oomoo`0IOol0009oo`800003Ool0000002eoo`03
001oogoo02Uoo`0300moogoo009oo`8000Eoo`8001Yoo`0300moogoo02Eoo`0300moogoo01=oo`80
00Aoo`8000Yoo`0300moogoo02=oo`03001oogoo01Uoo`0000=oo`0000000goo0P003Goo0P0017oo
0P0017oo0P0017oo0P000goo0`001Goo00<0000?00l0;P0?0P001@0?0P009P0?0P001`0?0P009`0?
0P00100?0P00<00?00<007ooOol06Goo0003Ool4000=Ool01000Oomoo`000goo0P000goo00@007oo
Ool0009oo`04001oogoo0003Ool00`00Oomoo`04Ool00`0000l03`1M00l2000700l2001O00l00`00
Oomoo`0IOol0009oo`03001oogoo00moo`04001oogoo0008Ool01000Oomoo`000Woo00@007ooOol0
00=oo`03001oogoo00Aoo`800<L03`8001]oo`000Woo1@003Goo00@007ooOol000Qoo`04001oogoo
0002Ool01000Oomoo`000goo00<007ooOol017oo00<007ooOol0:Goo00<03gooOol09Goo00<03goo
Ool09Goo00<03gooOol09Goo00<03gooOol08goo00<007ooOol06Goo0002Ool01@00Oomoogoo0000
3Goo00@007ooOol000Qoo`04001oogoo0002Ool01000Oomoo`000goo00<007ooOol017oo00<007oo
Ool0:Goo00<03gooOol027oo0P006goo00<03gooOol02Woo0P001Goo0P004Woo00<03gooOol057oo
0P003goo00<03gooOol08goo00<007ooOol06Goo0003Ool3000?Ool2000:Ool20004Ool20003Ool2
0006Ool00`00Oomoo`0YOol00`0?Oomoo`08Ool2000KOol00`0?Oomoo`0:Ool20005Ool2000BOol0
0`0?Oomoo`0DOol2000?Ool00`0?Oomoo`0SOol00`00Oomoo`0IOol003Aoo`03001oogoo02Uoo`03
00moogoo00=oo`80021oo`0300moogoo02Eoo`0300moogoo01Uoo`8000Yoo`0300moogoo02=oo`03
001oogoo01Uoo`000Woo1@00;Goo00<007ooOol0:Goo00<03gooOol00goo0P0087oo00<03gooOol0
9Goo00<03gooOol06Goo0P002Woo00<03gooOol08goo00<007ooOol06Goo0002Ool01000Oomoo`00
;Woo00<007ooOol0:Goo00<03gooOol09Goo00<03gooOol02goo0P0017oo0P004Woo00<03gooOol0
9Goo00<03gooOol08goo00<007ooOol06Goo0002Ool4000^Ool00`0000l03`1O00l2000400l2001P
00l00`00Oomoo`0IOol000Eoo`03001oogoo02aoo`03001oogoo02Uoo`0300moogoo02Eoo`0300mo
ogoo02Eoo`0300moogoo02Eoo`0300moogoo02=oo`03001oogoo01Uoo`000goo0`00;Woo00<007oo
Ool0:Goo00<03gooOol01goo0P0077oo00<03gooOol09Goo00<03gooOol05Goo0P003Woo00<03goo
Ool08goo00<007ooOol06Goo000dOol00`00Oomoo`0YOol00`0?Oomoo`07Ool2000LOol00`0?Oomo
o`0UOol00`0?Oomoo`0EOol2000>Ool00`0?Oomoo`0SOol00`00Oomoo`0IOol0009oo`@002ioo`03
00003`0?0<L03`03001oogoo01Uoo`001Goo00<007ooOol0;7oo00<007ooOol0:Goo00<03gooOol0
9Goo00<03gooOol09Goo00<03gooOol09Goo00<03gooOol08goo00<007ooOol06Goo0002Ool4000^
Ool00`0000l03`0`00l2000^00l2000200l2000^00l2000a00l00`00Oomoo`0IOol0009oo`03001o
ogoo02moo`03001oogoo02Uoo`0300moogoo00Aoo`8001moo`0300moogoo00aoo`80009oo`8001=o
o`0300moogoo01Qoo`8000]oo`0300moogoo02=oo`03001oogoo01Uoo`000Woo1000;Woo00<0000?
00l0a`0?00<007ooOol06Goo000dOol00`00Oomoo`0YOol00`0?Oomoo`0UOol00`0?Oomoo`0UOol0
0`0?Oomoo`0UOol00`0?Oomoo`0SOol00`00Oomoo`0IOol0009oo`D002eoo`0300003`0?0<L03`03
001oogoo01Uoo`000Woo00@007ooOol002ioo`03001oogoo02Uoo`0300moogoo02Eoo`0300moogoo
02Eoo`0300moogoo02Eoo`0300moogoo02=oo`03001oogoo01Uoo`000Woo00@007ooOol002ioo`03
00003`0?0<L03`03001oogoo01Uoo`000Woo00@007ooOol001Eoo`8000Aoo`8000Aoo`8000=oo`<0
00Eoo`0300003`0?03803`8005d03`8003@03`03001oogoo01Uoo`0000Aoo`00001oo`8001Aoo`04
001oogoo0003Ool20003Ool01000Oomoo`000goo00<007ooOol017oo00<0000?00l0<P0?0P00G@0?
0P00=00?00<007ooOol06Goo000JOol01000Oomoo`0027oo00@007ooOol000=oo`03001oogoo00Ao
o`800<L03`8001]oo`000Woo100057oo00@007ooOol000Qoo`04001oogoo0003Ool00`00Oomoo`04
Ool00`00Oomoo`0YOol00`0?Oomoo`0UOol00`0?Oomoo`0=Ool4000DOol00`0?Oomoo`0UOol00`0?
Oomoo`0SOol00`00Oomoo`0IOol000=oo`03001oogoo01Aoo`04001oogoo0008Ool01000Oomoo`00
0goo00<007ooOol017oo00<007ooOol0:Goo00<03gooOol09Goo00<03gooOol03Goo100057oo00<0
3gooOol09Goo00<03gooOol08goo00<007ooOol06Goo0003Ool00`00Oomoo`0EOol2000:Ool20003
Ool20006Ool00`00Oomoo`0YOol00`0?Oomoo`0UOol00`0?Oomoo`0UOol00`0?Oomoo`0UOol00`0?
Oomoo`0SOol00`00Oomoo`0IOol000=oo`8002moo`03001oogoo02Uoo`0300moogoo02Eoo`0300mo
ogoo02Eoo`0300moogoo02Eoo`0300moogoo02=oo`03001oogoo01Uoo`000Woo0P0000=oo`000000
;Goo00<007ooOol0:Goo00<03gooOol09Goo00<03gooOol09Goo00<03gooOol09Goo00<03gooOol0
8goo00<007ooOol06Goo000dOol00`00Oomoo`0YOol00`0?Oomoo`0UOol00`0?Oomoo`0UOol00`0?
Oomoo`0UOol00`0?Oomoo`0SOol00`00Oomoo`0IOol000=oo`@002eoo`0300003`0?03403`800600
3`8003803`03001oogoo01Uoo`000Woo00<007ooOol0;goo00<007ooOol0:Goo00<03gooOol01Goo
0P007Woo00<03gooOol09Goo00<03gooOol05goo0P0037oo00<03gooOol08goo00<007ooOol06Goo
0002Ool5000]Ool00`00Oomoo`0YOol00`0?Oomoo`0UOol00`0?Oomoo`0UOol00`0?Oomoo`0UOol0
0`0?Oomoo`0SOol00`00Oomoo`0IOol0009oo`05001oogooOol0000]Ool00`00Oomoo`0YOol00`0?
Oomoo`0UOol00`0?Oomoo`0UOol00`0?Oomoo`0UOol00`0?Oomoo`0SOol00`00Oomoo`0IOol000=o
o`<002ioo`0300003`0?0<L03`03001oogoo01Uoo`00=7oo00<007ooOol0:Goo00<03gooOol09Goo
00<03gooOol09Goo00<03gooOol09Goo00<03gooOol08goo00<007ooOol06Goo000dOol00`0000l0
3`3700l00`00Oomoo`0IOol003Aoo`03001oogoo02Uoo`0300moogoo02Eoo`0300moogoo02Eoo`03
00moogoo02Eoo`0300moogoo02=oo`03001oogoo01Uoo`00=7oo00<007ooOol0:Goo00<03gooOol0
9Goo00<03gooOol09Goo00<03gooOol09Goo00<03gooOol08goo00<007ooOol06Goo000dOol00`00
00l03`3700l00`00Oomoo`0IOol003Aoo`0300003`0?0<L03`03001oogoo01Uoo`00=7oo00<007oo
Ool0:Goo00<03gooOol09Goo00<03gooOol09Goo00<03gooOol09Goo00<03gooOol08goo00<007oo
Ool06Goo0002Ool5000]Ool00`0000l03`3700l00`00Oomoo`0IOol0009oo`04001oogoo000KOol2
0004Ool20003Ool30005Ool00`0000l03`3700l00`00Oomoo`0IOol0009oo`@001Yoo`04001oogoo
0003Ool20004Ool00`00Oomoo`04Ool00`0000l03`3700l00`00Oomoo`0IOol000Eoo`03001oogoo
01Qoo`04001oogoo0009Ool00`00Oomoo`04Ool2001R00l3001R00l2000KOol000=oo`<001Yoo`04
001oogoo0009Ool00`00Oomoo`04Ool00`00Oomoo`0YOol00`0?Oomoo`0UOol00`0?Oomoo`0=Ool3
000EOol00`0?Oomoo`0UOol00`0?Oomoo`0SOol00`00Oomoo`0IOol000Aoo`03001oogoo01Uoo`04
001oogoo0009Ool00`00Oomoo`04Ool00`00Oomoo`0YOol00`0?Oomoo`0UOol00`0?Oomoo`0UOol0
0`0?Oomoo`0UOol00`0?Oomoo`0SOol00`00Oomoo`0IOol000Aoo`03001oogoo01Yoo`8000Uoo`80
00Ioo`03001oogoo02Uoo`0300moogoo02Eoo`0300moogoo02Eoo`0300moogoo02Eoo`0300moogoo
02=oo`03001oogoo01Uoo`0017oo00<007ooOol0;Goo00<007ooOol0:Goo00<03gooOol09Goo00<0
3gooOol09Goo00<03gooOol09Goo00<03gooOol08goo00<007ooOol06Goo0004Ool00`00Oomoo`0]
Ool00`00Oomoo`0YOol00`0?Oomoo`0UOol00`0?Oomoo`0UOol00`0?Oomoo`0UOol00`0?Oomoo`0S
Ool00`00Oomoo`0IOol000Aoo`03001oogoo02eoo`03001oogoo02Uoo`0300moogoo02Eoo`0300mo
ogoo02Eoo`0300moogoo02Eoo`0300moogoo02=oo`03001oogoo01Uoo`000goo0P00;goo00<0000?
00l0<P0?0P00GP0?0P00<`0?00<007ooOol06Goo0003Ool2000_Ool00`00Oomoo`0YOol00`0?Oomo
o`06Ool2000MOol00`0?Oomoo`0UOol00`0?Oomoo`0FOol2000=Ool00`0?Oomoo`0SOol00`00Oomo
o`0IOol000Aoo`03001oogoo02eoo`04001oogooOol2000VOol00`0?Oomoo`0UOol00`0?Oomoo`0U
Ool00`0?Oomoo`0UOol00`0?Oomoo`0SOol00`00Oomoo`0IOol000Aoo`03001oogoo02eoo`04001o
ogooOol2000VOol00`0?Oomoo`0UOol00`0?Oomoo`0UOol00`0?Oomoo`0UOol00`0?Oomoo`0SOol0
0`00Oomoo`0IOol000Aoo`03001oogoo02eoo`0300003`0?0<L03`03001oogoo01Uoo`0017oo00<0
07ooOol0;Goo00<007ooOol0:Goo00<03gooOol09Goo00<03gooOol09Goo00<03gooOol09Goo00<0
3gooOol08goo00<007ooOol06Goo0004Ool00`00Oomoo`0]Ool00`00Oomoo`0YOol00`0?Oomoo`0U
Ool00`0?Oomoo`0UOol00`0?Oomoo`0UOol00`0?Oomoo`0SOol00`00Oomoo`0IOol000=oo`03001o
ogoo02ioo`0300003`0?0<L03`03001oogoo01Uoo`00=7oo00<007ooOol0:Goo00<03gooOol09Goo
00<03gooOol09Goo00<03gooOol09Goo00<03gooOol08goo00<007ooOol06Goo000dOol00`0000l0
3`3700l00`00Oomoo`0IOol003Aoo`03001oogoo02Uoo`0300moogoo02Eoo`0300moogoo02Eoo`03
00moogoo02Eoo`0300moogoo02=oo`03001oogoo01Uoo`00=7oo00<0000?00l0a`0?00<007ooOol0
6Goo000dOol00`0000l03`3700l00`00Oomoo`0IOol003Aoo`0300003`0?0<L03`03001oogoo01Uo
o`00;7oo0`001Goo00<0000?00l0a`0?00<007ooOol06Goo000]Ool00`00Oomoo`04Ool00`00Oomo
o`0YOol00`0?Oomoo`0UOol00`0?Oomoo`0UOol00`0?Oomoo`0UOol00`0?Oomoo`0SOol00`00Oomo
o`0IOol002eoo`03001oogoo00Aoo`800<L03`8001]oo`00;Goo00<007ooOol017oo00D007ooOomo
o`0002Moo`03001oogoo02Eoo`03001oogoo02Eoo`03001oogoo02Eoo`03001oogoo02=oo`03001o
ogoo01Uoo`00;Goo00<007ooOol017oob`006goo000/Ool2003/Ool00?mooa]oo`00ogoo6goo003o
OolKOol00?mooa]oo`00;Goo1000g7oo0`002Woo000^Ool00`00Oomoo`3OOol00`00Oomoo`07Ool0
01aoo`@000=oo`<0009oo`06001oo`00Ool007oo10000Woo1@000Woo0`000goo10001Woo1@000Woo
1@0000=oo`0000000P000goo0`000Woo10000goo10000Woo0`000goo10001Woo0`001Goo0`000Woo
1@0000=oo`0000000P000Woo1@000Woo100000=oo`0000000P002Goo0`000Woo10000Woo1@0000Ao
o`00001oo`800003Ool000000080009oo`@000=oo`<0009oo`@0009oo`05001oo`00Ool00008Ool3
0002Ool40007Ool20002Ool20002Ool40002Ool4000017oo000000001Goo000KOol00`00Oomoo`04
Ool03@00Oomoogoo001oo`00Ool007oo001oo`0000=oo`03001oo`00009oo`05001oogooOol00002
Ool00`00Ool0000;Ool01@00Oomoogoo00000goo00<007ooOol017oo00@007ooOol000=oo`04001o
ogoo0004Ool00`00Oomoo`04Ool01P00Oomoo`00Ool000]oo`03001oogoo00=oo`07001oogooOol0
07oo00000Woo00D007ooOomoo`0000Ioo`05001oogooOol00006Ool00`00Oomoo`0:Ool00`00Oomo
o`02Ool00`00Oomoo`02Ool01000Oomoo`000Woo00@007ooOol000Eoo`05001oogooOol00004Ool0
1@00Oomoogoo00000Woo00<007ooOol00Woo00D007oo001oo`0000Moo`05001oogooOol00002Ool0
0`00Oomoo`08Ool01000Ool000000Woo00<007ooOol00goo00D007ooOomoo`00009oo`03001oogoo
00Aoo`006goo00<007ooOol017oo00d007ooOomoo`00Ool007oo001oo`00Ool00003Ool00`00Ool0
0002Ool01@00Oomoogoo000017oo1@001goo00D007ooOomoo`0000=oo`04001oogooOol40002Ool0
0`00Oomoo`04Ool00`00Oomoo`02Ool50002Ool00`00Oomoo`02Ool50007Ool00`00Oomoo`03Ool0
1`00Oomoogoo001oo`00009oo`05001oogooOol00006Ool01000Oomoogoo1@000Woo00<007ooOol0
2Woo00<007ooOol00Woo00<007ooOol00Woo10000Woo00@007ooOol0009oo`@000=oo`03001oogoo
009oo`05001oogooOol00002Ool00`00Oomoo`02Ool01@00Ool007oo00001goo00D007ooOomoo`00
009oo`03001oogoo00Qoo`<000=oo`D00003Ool007oo009oo`04001oogoo0006Ool001]oo`03001o
ogoo00Aoo`0=001oogooOol007oo001oo`00Ool007oo00000goo00<007oo00000Woo00D007ooOomo
o`0000Aoo`05001oogooOol00007Ool01@00Oomoogoo00000goo00D007ooOomoo`0000Eoo`05001o
ogooOol00002Ool20003Ool01@00Oomoogoo00000Woo00<007ooOol00Woo00D007ooOomoo`0000Mo
o`<000=oo`07001oogooOol007oo00000Woo00@007ooOomoo`8000Eoo`05001oogooOol00003Ool0
0`00Oomoo`020009Ool01@00Ool007oo00000Woo0P001Woo00@007ooOol0009oo`04001oogoo0006
Ool00`00Oomoo`02Ool01@00Oomoogoo00000Woo0P000goo00D007oo001oo`0000Moo`05001oogoo
Ool00002Ool00`00Oomoo`08Ool01000Oomoo`000Woo00L007ooOomoo`00Ool00003Ool01000Oomo
o`001Woo000KOol01@00Oomoogoo00000goo0`0000=oo`0000002@0000Aoo`00001oo`80009oo`@0
00=oo`<000Qoo`05001oogooOol00002Ool20003Ool40003Ool4000017oo000007oo0P000Woo0`00
0Woo10000goo0`0027oo00<007ooOol017oo0`0000Aoo`00001oo`80009oo`800003Ool00000009o
o`8000Aoo`<0009oo`800003Ool0000000Moo`06001oo`00Ool007oo0P0000=oo`0000000Woo0`00
00=oo`0000000`000Woo10000Woo10000goo0`000Woo0P0000=oo`0000001P0027oo0`000Woo1000
27oo00@007ooOol000=oo`<000=oo`D00003Ool007oo00Eoo`0077oo10006goo00<007ooOol03Goo
1@008Goo00<007ooOol03Goo1@00;7oo1@006Woo00<007ooOol08Goo00<007ooOol01goo10003goo
0P001Woo000kOol00`00Oomoo`0FOol00`00Oomoo`0JOol00`00Oomoo`0XOol00`00Oomoo`0bOol3
000QOol3000ROol00?mooa]oo`00\
\>"],
  ImageRangeCache->{{{0, 281}, {173, 0}} -> {-71.3267, -6.98188, 1.25334, 
  0.0450395}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.00393546 0.603319 0.109514 [
[(0)] .02381 0 0 2 0 Minner Mrotsboxa
[(50)] .22058 0 0 2 0 Minner Mrotsboxa
[(100)] .41736 0 0 2 0 Minner Mrotsboxa
[(150)] .61413 0 0 2 0 Minner Mrotsboxa
[(200)] .8109 0 0 2 0 Minner Mrotsboxa
[(Contents Reg1 {a:x^a mod n = 4})] .5 0 0 2 0 0 -1 Mouter Mrotsboxa
[(0.00001)] -0.0125 .05575 1 0 0 Minner Mrotsboxa
[(0.0001)] -0.0125 .16526 1 0 0 Minner Mrotsboxa
[(0.001)] -0.0125 .27478 1 0 0 Minner Mrotsboxa
[(0.01)] -0.0125 .38429 1 0 0 Minner Mrotsboxa
[(0.1)] -0.0125 .4938 1 0 0 Minner Mrotsboxa
[(1)] -0.0125 .60332 1 0 0 Minner Mrotsboxa
[(ln\\(Pr\\(Measure a\\)\\))] -0.0125 .30902 1 0 90 -1 0 Mouter Mrotsboxa
[(Compute Discrete Fourier Transform of Reg1)] .5 .61803 0 -2 Msboxa
[ -0.001 -0.001 0 0 ]
[ 1.001 .61903 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
[ ] 0 setdash
0 g
p
p
0 0 .5 r
.001 w
.22058 0 m
.22058 .61803 L
s
P
p
0 0 .5 r
.001 w
.41736 0 m
.41736 .61803 L
s
P
p
0 0 .5 r
.001 w
.61413 0 m
.61413 .61803 L
s
P
p
0 0 .5 r
.001 w
.8109 0 m
.8109 .61803 L
s
P
p
0 0 .5 r
.001 w
0 .05575 m
1 .05575 L
s
P
p
0 0 .5 r
.001 w
0 .16526 m
1 .16526 L
s
P
p
0 0 .5 r
.001 w
0 .27478 m
1 .27478 L
s
P
p
0 0 .5 r
.001 w
0 .38429 m
1 .38429 L
s
P
p
0 0 .5 r
.001 w
0 .4938 m
1 .4938 L
s
P
p
0 0 .5 r
.001 w
0 .60332 m
1 .60332 L
s
P
p
0 0 .5 r
.001 w
0 .01217 m
1 .01217 L
s
P
p
0 0 .5 r
.001 w
0 .02278 m
1 .02278 L
s
P
p
0 0 .5 r
.001 w
0 .03145 m
1 .03145 L
s
P
p
0 0 .5 r
.001 w
0 .03879 m
1 .03879 L
s
P
p
0 0 .5 r
.001 w
0 .04514 m
1 .04514 L
s
P
p
0 0 .5 r
.001 w
0 .05074 m
1 .05074 L
s
P
p
0 0 .5 r
.001 w
0 .08872 m
1 .08872 L
s
P
p
0 0 .5 r
.001 w
0 .108 m
1 .108 L
s
P
p
0 0 .5 r
.001 w
0 .12168 m
1 .12168 L
s
P
p
0 0 .5 r
.001 w
0 .1323 m
1 .1323 L
s
P
p
0 0 .5 r
.001 w
0 .14097 m
1 .14097 L
s
P
p
0 0 .5 r
.001 w
0 .1483 m
1 .1483 L
s
P
p
0 0 .5 r
.001 w
0 .15465 m
1 .15465 L
s
P
p
0 0 .5 r
.001 w
0 .16025 m
1 .16025 L
s
P
p
0 0 .5 r
.001 w
0 .19823 m
1 .19823 L
s
P
p
0 0 .5 r
.001 w
0 .21751 m
1 .21751 L
s
P
p
0 0 .5 r
.001 w
0 .2312 m
1 .2312 L
s
P
p
0 0 .5 r
.001 w
0 .24181 m
1 .24181 L
s
P
p
0 0 .5 r
.001 w
0 .25048 m
1 .25048 L
s
P
p
0 0 .5 r
.001 w
0 .25781 m
1 .25781 L
s
P
p
0 0 .5 r
.001 w
0 .26416 m
1 .26416 L
s
P
p
0 0 .5 r
.001 w
0 .26977 m
1 .26977 L
s
P
p
0 0 .5 r
.001 w
0 .30774 m
1 .30774 L
s
P
p
0 0 .5 r
.001 w
0 .32703 m
1 .32703 L
s
P
p
0 0 .5 r
.001 w
0 .34071 m
1 .34071 L
s
P
p
0 0 .5 r
.001 w
0 .35132 m
1 .35132 L
s
P
p
0 0 .5 r
.001 w
0 .36 m
1 .36 L
s
P
p
0 0 .5 r
.001 w
0 .36733 m
1 .36733 L
s
P
p
0 0 .5 r
.001 w
0 .37368 m
1 .37368 L
s
P
p
0 0 .5 r
.001 w
0 .37928 m
1 .37928 L
s
P
p
0 0 .5 r
.001 w
0 .41726 m
1 .41726 L
s
P
p
0 0 .5 r
.001 w
0 .43654 m
1 .43654 L
s
P
p
0 0 .5 r
.001 w
0 .45022 m
1 .45022 L
s
P
p
0 0 .5 r
.001 w
0 .46084 m
1 .46084 L
s
P
p
0 0 .5 r
.001 w
0 .46951 m
1 .46951 L
s
P
p
0 0 .5 r
.001 w
0 .47684 m
1 .47684 L
s
P
p
0 0 .5 r
.001 w
0 .48319 m
1 .48319 L
s
P
p
0 0 .5 r
.001 w
0 .48879 m
1 .48879 L
s
P
p
0 0 .5 r
.001 w
0 .52677 m
1 .52677 L
s
P
p
0 0 .5 r
.001 w
0 .54606 m
1 .54606 L
s
P
p
0 0 .5 r
.001 w
0 .55974 m
1 .55974 L
s
P
p
0 0 .5 r
.001 w
0 .57035 m
1 .57035 L
s
P
p
0 0 .5 r
.001 w
0 .57902 m
1 .57902 L
s
P
p
0 0 .5 r
.001 w
0 .58635 m
1 .58635 L
s
P
p
0 0 .5 r
.001 w
0 .59271 m
1 .59271 L
s
P
p
0 0 .5 r
.001 w
0 .59831 m
1 .59831 L
s
P
p
.002 w
.02381 0 m
.02381 .00625 L
s
P
[(0)] .02381 0 0 2 0 Minner Mrotshowa
p
.002 w
.22058 0 m
.22058 .00625 L
s
P
[(50)] .22058 0 0 2 0 Minner Mrotshowa
p
.002 w
.41736 0 m
.41736 .00625 L
s
P
[(100)] .41736 0 0 2 0 Minner Mrotshowa
p
.002 w
.61413 0 m
.61413 .00625 L
s
P
[(150)] .61413 0 0 2 0 Minner Mrotshowa
p
.002 w
.8109 0 m
.8109 .00625 L
s
P
[(200)] .8109 0 0 2 0 Minner Mrotshowa
p
.001 w
.06316 0 m
.06316 .00375 L
s
P
p
.001 w
.10252 0 m
.10252 .00375 L
s
P
p
.001 w
.14187 0 m
.14187 .00375 L
s
P
p
.001 w
.18123 0 m
.18123 .00375 L
s
P
p
.001 w
.25994 0 m
.25994 .00375 L
s
P
p
.001 w
.29929 0 m
.29929 .00375 L
s
P
p
.001 w
.33865 0 m
.33865 .00375 L
s
P
p
.001 w
.378 0 m
.378 .00375 L
s
P
p
.001 w
.45671 0 m
.45671 .00375 L
s
P
p
.001 w
.49606 0 m
.49606 .00375 L
s
P
p
.001 w
.53542 0 m
.53542 .00375 L
s
P
p
.001 w
.57477 0 m
.57477 .00375 L
s
P
p
.001 w
.65348 0 m
.65348 .00375 L
s
P
p
.001 w
.69284 0 m
.69284 .00375 L
s
P
p
.001 w
.73219 0 m
.73219 .00375 L
s
P
p
.001 w
.77155 0 m
.77155 .00375 L
s
P
p
.001 w
.85026 0 m
.85026 .00375 L
s
P
p
.001 w
.88961 0 m
.88961 .00375 L
s
P
p
.001 w
.92896 0 m
.92896 .00375 L
s
P
p
.001 w
.96832 0 m
.96832 .00375 L
s
P
[(Contents Reg1 {a:x^a mod n = 4})] .5 0 0 2 0 0 -1 Mouter Mrotshowa
p
.002 w
0 0 m
1 0 L
s
P
p
.002 w
0 .05575 m
.00625 .05575 L
s
P
[(0.00001)] -0.0125 .05575 1 0 0 Minner Mrotshowa
p
.002 w
0 .16526 m
.00625 .16526 L
s
P
[(0.0001)] -0.0125 .16526 1 0 0 Minner Mrotshowa
p
.002 w
0 .27478 m
.00625 .27478 L
s
P
[(0.001)] -0.0125 .27478 1 0 0 Minner Mrotshowa
p
.002 w
0 .38429 m
.00625 .38429 L
s
P
[(0.01)] -0.0125 .38429 1 0 0 Minner Mrotshowa
p
.002 w
0 .4938 m
.00625 .4938 L
s
P
[(0.1)] -0.0125 .4938 1 0 0 Minner Mrotshowa
p
.002 w
0 .60332 m
.00625 .60332 L
s
P
[(1)] -0.0125 .60332 1 0 0 Minner Mrotshowa
p
.001 w
0 .01217 m
.00375 .01217 L
s
P
p
.001 w
0 .02278 m
.00375 .02278 L
s
P
p
.001 w
0 .03145 m
.00375 .03145 L
s
P
p
.001 w
0 .03879 m
.00375 .03879 L
s
P
p
.001 w
0 .04514 m
.00375 .04514 L
s
P
p
.001 w
0 .05074 m
.00375 .05074 L
s
P
p
.001 w
0 .08872 m
.00375 .08872 L
s
P
p
.001 w
0 .108 m
.00375 .108 L
s
P
p
.001 w
0 .12168 m
.00375 .12168 L
s
P
p
.001 w
0 .1323 m
.00375 .1323 L
s
P
p
.001 w
0 .14097 m
.00375 .14097 L
s
P
p
.001 w
0 .1483 m
.00375 .1483 L
s
P
p
.001 w
0 .15465 m
.00375 .15465 L
s
P
p
.001 w
0 .16025 m
.00375 .16025 L
s
P
p
.001 w
0 .19823 m
.00375 .19823 L
s
P
p
.001 w
0 .21751 m
.00375 .21751 L
s
P
p
.001 w
0 .2312 m
.00375 .2312 L
s
P
p
.001 w
0 .24181 m
.00375 .24181 L
s
P
p
.001 w
0 .25048 m
.00375 .25048 L
s
P
p
.001 w
0 .25781 m
.00375 .25781 L
s
P
p
.001 w
0 .26416 m
.00375 .26416 L
s
P
p
.001 w
0 .26977 m
.00375 .26977 L
s
P
p
.001 w
0 .30774 m
.00375 .30774 L
s
P
p
.001 w
0 .32703 m
.00375 .32703 L
s
P
p
.001 w
0 .34071 m
.00375 .34071 L
s
P
p
.001 w
0 .35132 m
.00375 .35132 L
s
P
p
.001 w
0 .36 m
.00375 .36 L
s
P
p
.001 w
0 .36733 m
.00375 .36733 L
s
P
p
.001 w
0 .37368 m
.00375 .37368 L
s
P
p
.001 w
0 .37928 m
.00375 .37928 L
s
P
p
.001 w
0 .41726 m
.00375 .41726 L
s
P
p
.001 w
0 .43654 m
.00375 .43654 L
s
P
p
.001 w
0 .45022 m
.00375 .45022 L
s
P
p
.001 w
0 .46084 m
.00375 .46084 L
s
P
p
.001 w
0 .46951 m
.00375 .46951 L
s
P
p
.001 w
0 .47684 m
.00375 .47684 L
s
P
p
.001 w
0 .48319 m
.00375 .48319 L
s
P
p
.001 w
0 .48879 m
.00375 .48879 L
s
P
p
.001 w
0 .52677 m
.00375 .52677 L
s
P
p
.001 w
0 .54606 m
.00375 .54606 L
s
P
p
.001 w
0 .55974 m
.00375 .55974 L
s
P
p
.001 w
0 .57035 m
.00375 .57035 L
s
P
p
.001 w
0 .57902 m
.00375 .57902 L
s
P
p
.001 w
0 .58635 m
.00375 .58635 L
s
P
p
.001 w
0 .59271 m
.00375 .59271 L
s
P
p
.001 w
0 .59831 m
.00375 .59831 L
s
P
[(ln\\(Pr\\(Measure a\\)\\))] -0.0125 .30902 1 0 90 -1 0 Mouter Mrotshowa
p
.002 w
0 0 m
0 .61803 L
s
P
P
p
p
.002 w
.02381 .61178 m
.02381 .61803 L
s
P
p
.002 w
.22058 .61178 m
.22058 .61803 L
s
P
p
.002 w
.41736 .61178 m
.41736 .61803 L
s
P
p
.002 w
.61413 .61178 m
.61413 .61803 L
s
P
p
.002 w
.8109 .61178 m
.8109 .61803 L
s
P
p
.001 w
.06316 .61428 m
.06316 .61803 L
s
P
p
.001 w
.10252 .61428 m
.10252 .61803 L
s
P
p
.001 w
.14187 .61428 m
.14187 .61803 L
s
P
p
.001 w
.18123 .61428 m
.18123 .61803 L
s
P
p
.001 w
.25994 .61428 m
.25994 .61803 L
s
P
p
.001 w
.29929 .61428 m
.29929 .61803 L
s
P
p
.001 w
.33865 .61428 m
.33865 .61803 L
s
P
p
.001 w
.378 .61428 m
.378 .61803 L
s
P
p
.001 w
.45671 .61428 m
.45671 .61803 L
s
P
p
.001 w
.49606 .61428 m
.49606 .61803 L
s
P
p
.001 w
.53542 .61428 m
.53542 .61803 L
s
P
p
.001 w
.57477 .61428 m
.57477 .61803 L
s
P
p
.001 w
.65348 .61428 m
.65348 .61803 L
s
P
p
.001 w
.69284 .61428 m
.69284 .61803 L
s
P
p
.001 w
.73219 .61428 m
.73219 .61803 L
s
P
p
.001 w
.77155 .61428 m
.77155 .61803 L
s
P
p
.001 w
.85026 .61428 m
.85026 .61803 L
s
P
p
.001 w
.88961 .61428 m
.88961 .61803 L
s
P
p
.001 w
.92896 .61428 m
.92896 .61803 L
s
P
p
.001 w
.96832 .61428 m
.96832 .61803 L
s
P
p
.002 w
0 .61803 m
1 .61803 L
s
P
[(Compute Discrete Fourier Transform of Reg1)] .5 .61803 0 -2 Mshowa
p
.002 w
.99375 .05575 m
1 .05575 L
s
P
p
.002 w
.99375 .16526 m
1 .16526 L
s
P
p
.002 w
.99375 .27478 m
1 .27478 L
s
P
p
.002 w
.99375 .38429 m
1 .38429 L
s
P
p
.002 w
.99375 .4938 m
1 .4938 L
s
P
p
.002 w
.99375 .60332 m
1 .60332 L
s
P
p
.001 w
.99625 .01217 m
1 .01217 L
s
P
p
.001 w
.99625 .02278 m
1 .02278 L
s
P
p
.001 w
.99625 .03145 m
1 .03145 L
s
P
p
.001 w
.99625 .03879 m
1 .03879 L
s
P
p
.001 w
.99625 .04514 m
1 .04514 L
s
P
p
.001 w
.99625 .05074 m
1 .05074 L
s
P
p
.001 w
.99625 .08872 m
1 .08872 L
s
P
p
.001 w
.99625 .108 m
1 .108 L
s
P
p
.001 w
.99625 .12168 m
1 .12168 L
s
P
p
.001 w
.99625 .1323 m
1 .1323 L
s
P
p
.001 w
.99625 .14097 m
1 .14097 L
s
P
p
.001 w
.99625 .1483 m
1 .1483 L
s
P
p
.001 w
.99625 .15465 m
1 .15465 L
s
P
p
.001 w
.99625 .16025 m
1 .16025 L
s
P
p
.001 w
.99625 .19823 m
1 .19823 L
s
P
p
.001 w
.99625 .21751 m
1 .21751 L
s
P
p
.001 w
.99625 .2312 m
1 .2312 L
s
P
p
.001 w
.99625 .24181 m
1 .24181 L
s
P
p
.001 w
.99625 .25048 m
1 .25048 L
s
P
p
.001 w
.99625 .25781 m
1 .25781 L
s
P
p
.001 w
.99625 .26416 m
1 .26416 L
s
P
p
.001 w
.99625 .26977 m
1 .26977 L
s
P
p
.001 w
.99625 .30774 m
1 .30774 L
s
P
p
.001 w
.99625 .32703 m
1 .32703 L
s
P
p
.001 w
.99625 .34071 m
1 .34071 L
s
P
p
.001 w
.99625 .35132 m
1 .35132 L
s
P
p
.001 w
.99625 .36 m
1 .36 L
s
P
p
.001 w
.99625 .36733 m
1 .36733 L
s
P
p
.001 w
.99625 .37368 m
1 .37368 L
s
P
p
.001 w
.99625 .37928 m
1 .37928 L
s
P
p
.001 w
.99625 .41726 m
1 .41726 L
s
P
p
.001 w
.99625 .43654 m
1 .43654 L
s
P
p
.001 w
.99625 .45022 m
1 .45022 L
s
P
p
.001 w
.99625 .46084 m
1 .46084 L
s
P
p
.001 w
.99625 .46951 m
1 .46951 L
s
P
p
.001 w
.99625 .47684 m
1 .47684 L
s
P
p
.001 w
.99625 .48319 m
1 .48319 L
s
P
p
.001 w
.99625 .48879 m
1 .48879 L
s
P
p
.001 w
.99625 .52677 m
1 .52677 L
s
P
p
.001 w
.99625 .54606 m
1 .54606 L
s
P
p
.001 w
.99625 .55974 m
1 .55974 L
s
P
p
.001 w
.99625 .57035 m
1 .57035 L
s
P
p
.001 w
.99625 .57902 m
1 .57902 L
s
P
p
.001 w
.99625 .58635 m
1 .58635 L
s
P
p
.001 w
.99625 .59271 m
1 .59271 L
s
P
p
.001 w
.99625 .59831 m
1 .59831 L
s
P
p
.002 w
1 0 m
1 .61803 L
s
P
P
p
P
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
p
p
p
.01 w
.02381 .53758 Mdot
.02774 .01472 Mdot
.03168 .01483 Mdot
.03562 .01503 Mdot
.03955 .01531 Mdot
.04349 .01567 Mdot
.04742 .01611 Mdot
.05136 .01663 Mdot
.05529 .01723 Mdot
.05923 .01792 Mdot
.06316 .01869 Mdot
.0671 .01954 Mdot
.07104 .02048 Mdot
.07497 .0215 Mdot
.07891 .02262 Mdot
.08284 .02382 Mdot
.08678 .02511 Mdot
.09071 .02649 Mdot
.09465 .02797 Mdot
.09858 .02955 Mdot
.10252 .03122 Mdot
.10645 .033 Mdot
.11039 .03488 Mdot
.11433 .03686 Mdot
.11826 .03896 Mdot
.1222 .04117 Mdot
.12613 .04349 Mdot
.13007 .04594 Mdot
.134 .04852 Mdot
.13794 .05123 Mdot
.14187 .05407 Mdot
.14581 .05706 Mdot
.14974 .0602 Mdot
.15368 .06349 Mdot
.15762 .06695 Mdot
.16155 .07059 Mdot
.16549 .07442 Mdot
.16942 .07844 Mdot
.17336 .08267 Mdot
.17729 .08713 Mdot
.18123 .09184 Mdot
.18516 .09681 Mdot
.1891 .10207 Mdot
.19303 .10764 Mdot
.19697 .11356 Mdot
.20091 .11987 Mdot
.20484 .1266 Mdot
.20878 .13382 Mdot
.21271 .14159 Mdot
.21665 .14998 Mdot
.22058 .15912 Mdot
.22452 .16913 Mdot
.22845 .18019 Mdot
.23239 .19255 Mdot
.23632 .20656 Mdot
.24026 .22273 Mdot
.2442 .24186 Mdot
.24813 .26536 Mdot
.25207 .29592 Mdot
.256 .34003 Mdot
.25994 .42179 Mdot
.26387 .52751 Mdot
.26781 .37569 Mdot
.27174 .3211 Mdot
.27568 .2875 Mdot
.27961 .26341 Mdot
.28355 .24481 Mdot
.28749 .22977 Mdot
.29142 .21726 Mdot
.29536 .20664 Mdot
.29929 .19749 Mdot
.30323 .18952 Mdot
.30716 .18252 Mdot
.3111 .17635 Mdot
.31503 .17088 Mdot
.31897 .16602 Mdot
.3229 .1617 Mdot
.32684 .15787 Mdot
.33078 .15447 Mdot
.33471 .15147 Mdot
.33865 .14884 Mdot
.34258 .14654 Mdot
.34652 .14457 Mdot
.35045 .14289 Mdot
.35439 .14151 Mdot
.35832 .14039 Mdot
.36226 .13953 Mdot
.36619 .13893 Mdot
.37013 .13858 Mdot
.37407 .13846 Mdot
.378 .13859 Mdot
.38194 .13895 Mdot
.38587 .13955 Mdot
.38981 .14038 Mdot
.39374 .14146 Mdot
.39768 .14277 Mdot
.40161 .14433 Mdot
.40555 .14615 Mdot
.40948 .14823 Mdot
.41342 .15058 Mdot
.41736 .15321 Mdot
.42129 .15615 Mdot
.42523 .1594 Mdot
.42916 .16299 Mdot
.4331 .16694 Mdot
.43703 .17129 Mdot
.44097 .17607 Mdot
.4449 .18133 Mdot
.44884 .18713 Mdot
.45277 .19352 Mdot
.45671 .2006 Mdot
.46065 .20847 Mdot
.46458 .21729 Mdot
.46852 .22724 Mdot
.47245 .23859 Mdot
.47639 .25171 Mdot
.48032 .26719 Mdot
.48426 .28593 Mdot
.48819 .30956 Mdot
.49213 .34136 Mdot
.49606 .38981 Mdot
.5 .49424 Mdot
.50394 .49424 Mdot
.50787 .38981 Mdot
.51181 .34136 Mdot
.51574 .30956 Mdot
.51968 .28593 Mdot
.52361 .26719 Mdot
.52755 .25171 Mdot
.53148 .23859 Mdot
.53542 .22724 Mdot
.53935 .21729 Mdot
.54329 .20847 Mdot
.54723 .2006 Mdot
.55116 .19352 Mdot
.5551 .18713 Mdot
.55903 .18133 Mdot
.56297 .17607 Mdot
.5669 .17129 Mdot
.57084 .16694 Mdot
.57477 .16299 Mdot
.57871 .1594 Mdot
.58264 .15615 Mdot
.58658 .15321 Mdot
.59052 .15058 Mdot
.59445 .14823 Mdot
.59839 .14615 Mdot
.60232 .14433 Mdot
.60626 .14277 Mdot
.61019 .14146 Mdot
.61413 .14038 Mdot
.61806 .13955 Mdot
.622 .13895 Mdot
.62593 .13859 Mdot
.62987 .13846 Mdot
.63381 .13858 Mdot
.63774 .13893 Mdot
.64168 .13953 Mdot
.64561 .14039 Mdot
.64955 .14151 Mdot
.65348 .14289 Mdot
.65742 .14457 Mdot
.66135 .14654 Mdot
.66529 .14884 Mdot
.66922 .15147 Mdot
.67316 .15447 Mdot
.6771 .15787 Mdot
.68103 .1617 Mdot
.68497 .16602 Mdot
.6889 .17088 Mdot
.69284 .17635 Mdot
.69677 .18252 Mdot
.70071 .18952 Mdot
.70464 .19749 Mdot
.70858 .20664 Mdot
.71251 .21726 Mdot
.71645 .22977 Mdot
.72039 .24481 Mdot
.72432 .26341 Mdot
.72826 .2875 Mdot
.73219 .3211 Mdot
.73613 .37569 Mdot
.74006 .52751 Mdot
.744 .42179 Mdot
.74793 .34003 Mdot
.75187 .29592 Mdot
.7558 .26536 Mdot
.75974 .24186 Mdot
.76368 .22273 Mdot
.76761 .20656 Mdot
.77155 .19255 Mdot
.77548 .18019 Mdot
.77942 .16913 Mdot
.78335 .15912 Mdot
.78729 .14998 Mdot
.79122 .14159 Mdot
.79516 .13382 Mdot
.79909 .1266 Mdot
.80303 .11987 Mdot
.80697 .11356 Mdot
.8109 .10764 Mdot
.81484 .10207 Mdot
.81877 .09681 Mdot
.82271 .09184 Mdot
.82664 .08713 Mdot
.83058 .08267 Mdot
.83451 .07844 Mdot
.83845 .07442 Mdot
.84238 .07059 Mdot
.84632 .06695 Mdot
.85026 .06349 Mdot
.85419 .0602 Mdot
.85813 .05706 Mdot
.86206 .05407 Mdot
.866 .05123 Mdot
.86993 .04852 Mdot
.87387 .04594 Mdot
.8778 .04349 Mdot
.88174 .04117 Mdot
.88567 .03896 Mdot
.88961 .03686 Mdot
.89355 .03488 Mdot
.89748 .033 Mdot
.90142 .03122 Mdot
.90535 .02955 Mdot
.90929 .02797 Mdot
.91322 .02649 Mdot
.91716 .02511 Mdot
.92109 .02382 Mdot
.92503 .02262 Mdot
.92896 .0215 Mdot
.9329 .02048 Mdot
.93684 .01954 Mdot
.94077 .01869 Mdot
.94471 .01792 Mdot
.94864 .01723 Mdot
.95258 .01663 Mdot
.95651 .01611 Mdot
.96045 .01567 Mdot
.96438 .01531 Mdot
.96832 .01503 Mdot
.97226 .01483 Mdot
.97619 .01472 Mdot
P
P
p
1 0 0 r
p
.035 w
.256 .01472 Mdot
P
P
P
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  Evaluatable->False,
  AspectRatioFixed->True,
  ImageSize->{282, 174},
  ImageMargins->{{34, Inherited}, {Inherited, Inherited}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004J0000[Q000`40O003h00Oogoo6goo003oOolK
Ool0081oo`<000moo`8005eoo`8002Moo`00Pgoo00<007ooOol037oo00<007ooOol0GGoo00<007oo
Ool09Goo000mOol40003Ool30002Ool200000goo00000002Ool30003Ool4000017oo000007oo0P00
0Woo0`000Woo10001goo0P000Woo0P000Woo10000Woo100000Aoo`00000000Yoo`03001oogoo009o
o`D0009oo`80009oo`800003Ool0000000Qoo`D000Moo`05001oo`00Ool00002Ool30003Ool50006
Ool200000goo0000000DOol30003Ool00`00Oomoo`0UOol003aoo`03001oogoo00Aoo`07001oogoo
Ool007oo00000Woo00D007ooOomoo`00009oo`03001oo`0000Eoo`04001oogoo0003Ool01000Oomo
o`0017oo00<007ooOol01Woo00@007oo0000009oo`03001oogoo00=oo`05001oogooOol00002Ool0
0`00Oomoo`09Ool00`00Oomoo`02Ool01000Oomoo`000goo0P000goo00<007oo00002Goo00@007oo
Ool000Qoo`07001oo`00Ool007oo00000goo00<007oo00000goo00<007ooOol01Goo00@007ooOol0
01Ioo`03001oogoo009oo`03001oogoo02Eoo`00?7oo00<007ooOol017oo00L007ooOomoo`00Ool0
0002Ool01@00Oomoogoo000017oo1@0000Eoo`00Oomoo`0000=oo`03001oogoo009oo`@000Qoo`<0
00=oo`D00003Ool007oo009oo`04001oogoo000:Ool00`00Oomoo`03Ool40009Ool00`00Oomoo`08
Ool40008Ool01`00Ool007oo001oo`0000=oo`03001oo`0000=oo`03001oogoo00Eoo`04001oogoo
0008Ool50007Ool40004Ool00`00Oomoo`0TOol003aoo`03001oogoo00Aoo`07001oogooOol007oo
00000Woo00D007ooOomoo`0000Aoo`07001oogooOol007oo00000Woo00D007ooOomoo`0000Aoo`03
001oogoo00Uoo`04001oogoo0002Ool01`00Oomoogoo001oo`0000=oo`04001oogoo000;Ool00`00
Oomoo`05Ool01000Oomoogoo0P000goo00<007oo000037oo00<007ooOol01Woo00L007oo001oo`00
Ool00003Ool00`00Ool00003Ool00`00Oomoo`05Ool01000Oomoo`0057oo00<007oo000017oo00<0
07ooOol09Goo000lOol01@00Oomoogoo00000goo0`0000=oo`0000000`000Woo10000goo0`0000=o
o`0000000`000Woo10000Woo100027oo00@007ooOol000=oo`<000=oo`D00003Ool007oo00Yoo`03
001oogoo00=oo`<000=oo`80009oo`800003Ool0000000Uoo`<000Moo`H0009oo`<000=oo`@000Io
o`D000Qoo`D000Moo`03001oo`0000Aoo`03001oogoo02Eoo`00?Goo10003goo00<007ooOol03goo
00<007ooOol03Goo10003goo0P002goo0P005Goo00<007oo00007goo00<007ooOol07Woo0P000goo
0P009goo001@Ool00`00Oomoo`0?Ool00`00Oomoo`15Ool00`00Oomoo`0MOol2001>Ool00?mooa]o
o`00ogoo6goo003oOolKOol00?mooa]oo`00ogoo6goo003oOolKOol00?mooa]oo`00ogoo6goo003o
OolKOol00?mooa]oo`00=goo0P008Woo0`0017oo0P0077oo0`0017oo0P0017oo0P006Goo0`000goo
0`0017oo0P006Goo10000goo0P0017oo0P00>goo000fOol01000Oomoo`0097oo00@007ooOol0009o
o`03001oogoo01Yoo`03001oogoo009oo`04001oogoo0002Ool01000Oomoo`006Goo00<007ooOol0
1Goo00@007ooOol0009oo`03001oogoo01Moo`03001oogoo009oo`04001oogoo0002Ool01000Oomo
o`00>Woo000fOol01000Oomoo`0097oo00@007ooOol0009oo`03001oogoo01Yoo`03001oogoo009o
o`04001oogoo0002Ool01000Oomoo`006Goo00<007ooOol01Goo00@007ooOol0009oo`03001oogoo
01Qoo`05001oogooOol00002Ool01000Oomoo`000Woo00<007ooOol0>7oo000fOol01000Oomoo`00
8Goo0`000goo00@007ooOol001aoo`03001oogoo009oo`04001oogoo0002Ool01000Oomoo`006Goo
00<007ooOol00Woo0`000goo00@007ooOol001]oo`04001oogoo0002Ool01000Oomoo`000Woo00<0
07ooOol0>7oo000fOol01000Oomoo`008Goo00<007ooOol00goo00@007ooOol001aoo`03001oogoo
009oo`04001oogoo0002Ool01000Oomoo`006Goo00<007ooOol00Woo00<007ooOol00goo00@007oo
Ool001Qoo`04001oogoo0002Ool01000Oomoo`000Woo00@007ooOol003Yoo`00=goo0P008Woo1000
0goo0P0077oo0P001Goo0P0017oo0P006Goo0P0017oo10000goo0P006Woo0P0017oo0P0017oo0P00
>goo003oOolKOol00?mooa]oo`00ogoo6goo003oOolKOol00?mooa]oo`00ogoo6goo000dOolb0003
O02F000KOol003Aoo`05001oogooOol00007Ool00`00Oomoo`05Ool00`00Oomoo`05Ool00`00Oomo
o`05Ool00`00Oomoo`05Ool00`00Oomoo`02Ool5O006Ool00`00Oomoo`05Ool00`00Oomoo`05Ool0
0`00Oomoo`05Ool00`00Oomoo`05Ool00`00Oomoo`05Ool00`00Oomoo`05Ool00`00Oomoo`05Ool0
0`00Oomoo`05Ool00`00Oomoo`05Ool00`00Oomoo`05Ool00`00Oomoo`05Ool00`00Oomoo`05Ool0
0`00Oomoo`05Ool00`00Oomoo`05Ool00`00Oomoo`05Ool00`00Oomoo`05Ool00`00Oomoo`05Ool0
0`00Oomoo`03Ool00`00Oomoo`0IOol003Aoo`03001oogoo02Uoo`0400moogooOol7O00MOol00`0?
Oomoo`0UOol00`0?Oomoo`0UOol00`0?Oomoo`0SOol00`00Oomoo`0IOol003Aoo`0300003`0?0080
3`T002803`Ml08L03`T000<03`03001oogoo01Uoo`00=7oo00<007ooOol00Woo30006goo00@03goo
Oomoo`Ml01eoo`0300moogoo02Eoo`0300moogoo02Eoo`0300moogoo01Aoo``000=oo`03001oogoo
01Uoo`00=7oo00<0000?00l02P0?1`007@0?1G`0P@0?20002`0?00<007ooOol06Goo000dOol00`00
Oomoo`0=Ool7000EOol00`0?Oomoo`03Ool3O00OOol00`0?Oomoo`0UOol00`0?Oomoo`0UOol00`0?
Oomoo`0>Ool7000>Ool00`00Oomoo`0IOol003Aoo`0300003`0?01003`D009/03`H001403`03001o
ogoo01Uoo`00=7oo00<0000?00l04P0?1@00V00?1000500?00<007ooOol06Goo000dOol00`0000l0
3`0D00l4002E00l5000E00l00`00Oomoo`0IOol000Uoo`8000Aoo`8000Aoo`8000Aoo`8000Aoo`80
00Aoo`8000=oo`<000Eoo`0300003`0?01H03`@009803`@001L03`03001oogoo01Uoo`0027oo00@0
07ooOol000=oo`8000=oo`04001oogoo0002Ool01000Oomoo`000Woo00@007ooOol0009oo`04001o
ogoo0003Ool00`00Oomoo`04Ool00`00Oomoo`0GOol5000=Ool00`0?Oomoo`0UOol00`0?Oomoo`0U
Ool00`0?Oomoo`0UOol00`0?Oomoo`06Ool4000IOol00`00Oomoo`0IOol000Qoo`04001oogoo0008
Ool01000Oomoo`000Woo00@007ooOol0009oo`04001oogoo0002Ool01000Oomoo`000goo00<007oo
Ool017oo0P006P0?0`00S@0?10006@0?0P006goo0002Ool500001Goo001oogoo000027oo00@007oo
Ool0009oo`04001oogoo0002Ool01000Oomoo`000Woo00@007ooOol000=oo`03001oogoo00Aoo`03
001oogoo01Yoo`@000]oo`0300moogoo02Eoo`0300moogoo02Eoo`0300moogoo02Eoo`0300moogoo
00Aoo`<001aoo`03001oogoo01Uoo`0017oo00D007ooOomoo`00009oo`03001oogoo00Ioo`04001o
ogoo0002Ool01000Oomoo`000Woo00@007ooOol0009oo`04001oogoo0003Ool00`00Oomoo`04Ool0
0`00Oomoo`0KOol4000:Ool00`0?Oomoo`0UOol00`0?Oomoo`0UOol00`0?Oomoo`0UOol00`0?Oomo
o`03Ool3000MOol00`00Oomoo`0IOol000Aoo`03001oogoo009oo`8000Yoo`8000Aoo`8000Aoo`80
00Aoo`8000=oo`8000Ioo`03001oogoo01eoo`<000Uoo`0300moogoo02Eoo`0300moogoo02Eoo`03
00moogoo02Eoo`0300moogoo009oo`<001ioo`03001oogoo01Uoo`0017oo00<007ooOol0;Goo00<0
07ooOol07Woo0`0027oo00<03gooOol09Goo00<03gooOol09Goo00<03gooOol09Goo00<03gooOol0
10007goo00<007ooOol06Goo0004Ool00`00Oomoo`0]Ool00`00Oomoo`0NOol40007Ool00`0?Oomo
o`0UOol00`0?Oomoo`0UOol00`0?Oomoo`0UOol00`0?Oomoo`03000POol00`00Oomoo`0IOol000Ao
o`03001oogoo02eoo`0300003`0?02003`<008003`<002403`03001oogoo01Uoo`000Woo1@00;Goo
00<007ooOol08Goo0`001Goo00<03gooOol09Goo00<03gooOol09Goo00<03gooOol09Goo00@03`00
0000029oo`03001oogoo01Uoo`000Woo00@007ooOol002ioo`03001oogoo029oo`8000Eoo`0300mo
ogoo02Eoo`0300moogoo02Eoo`0300moogoo02Eoo`<002=oo`03001oogoo01Uoo`000Woo00@007oo
Ool002ioo`03001oogoo029oo`8000Eoo`0300moogoo02Eoo`0300moogoo02Eoo`0300moogoo02Eo
o`8002Aoo`03001oogoo01Uoo`000Woo00@007ooOol002ioo`0300003`0?02<03`8007/03`8002D0
3`03001oogoo01Uoo`0000=oo`0000000`00;Woo00<007ooOol08goo0`000goo00<03gooOol09Goo
00<03gooOol09Goo00<03gooOol097oo0P009Goo00<007ooOol06Goo0003Ool00`00Oomoo`0^Ool0
0`00Oomoo`0TOol30002Ool00`0?Oomoo`0UOol00`0?Oomoo`0UOol00`0?Oomoo`0SOol3000UOol0
0`00Oomoo`0IOol000=oo`03001oogoo02ioo`0300003`0?02D03`<007H03`<002H03`03001oogoo
01Uoo`000goo00<007ooOol0;Woo00<007ooOol09Woo0P0000=oo`0?Ool09Woo00<03gooOol09Goo
00<03gooOol08Woo0P0000=oo`0?Ool097oo00<007ooOol06Goo0003Ool00`00Oomoo`0^Ool00`00
00l03`0V00l2001e00l2000X00l00`00Oomoo`0IOol000=oo`03001oogoo02ioo`03001oogoo02Io
o`<0000300moogoo01Qoo`X000=oo`0300moogoo02Aoo`X001Yoo`<0009oo`0300moogoo02=oo`03
001oogoo01Uoo`000goo00<007ooOol0;Woo00<0000?00l09`0?0P006@0?3P009@0?3`00600?0P00
:@0?00<007ooOol06Goo0004Ool00`00Oomoo`0]Ool00`0000l03`0X00l2000F00l5000800l5000R
00l5000800l5000F00l2000Y00l00`00Oomoo`0IOol00004Ool00000000`Ool00`00Oomoo`0XOol2
000EOol4000<Ool4000OOol50002Ool00`0?Oomoo`07Ool4000EOol20003Ool00`0?Oomoo`0SOol0
0`00Oomoo`0IOol0009oo`03001oogoo00Yoo`8000Aoo`8000Aoo`8000Aoo`8000Aoo`8000=oo`<0
00Eoo`0300003`0?02T03`8001<03`<001003`<001d03`@001003`<001<03`8002X03`03001oogoo
01Uoo`000Woo0`002Goo00@007ooOol000=oo`8000=oo`04001oogoo0002Ool01000Oomoo`000Woo
00@007ooOol000=oo`03001oogoo00Aoo`0300003`0?02T03`8001803`<001803`<001`03`800180
3`@001803`8002X03`03001oogoo01Uoo`000Woo00@007ooOol000Qoo`04001oogoo0008Ool01000
Oomoo`000Woo00@007ooOol0009oo`04001oogoo0003Ool00`00Oomoo`04Ool2000[00l2000@00l3
000D00l4000H00l4000D00l3000@00l2000Z00l2000KOol0009oo`04001oogoo0008Ool01000Oomo
o`0027oo00@007ooOol0009oo`04001oogoo0002Ool01000Oomoo`000goo00<007ooOol017oo00<0
07ooOol0:Goo00<03`0000003goo0`004goo00<03gooOol00`005goo10001goo00<03gooOol037oo
0`003goo0P001Goo00<03gooOol08goo00<007ooOol06Goo00000goo000000020009Ool01000Oomo
o`0027oo00@007ooOol0009oo`04001oogoo0002Ool01000Oomoo`000goo00<007ooOol017oo00<0
07ooOol0:Goo00<03`0000003goo0P0057oo00@03gooOomoo`<001Eoo`<000Uoo`0300moogoo00eo
o`8000ioo`8000Ioo`0300moogoo02=oo`03001oogoo01Uoo`000Woo10002Goo0P002Woo0P0017oo
0P0017oo0P000goo0P001Woo00<007ooOol0:Goo00<03`0000003Woo0P005Goo00<03gooOol00Woo
0P005Goo0P002Woo00<03gooOol03Goo0P003Woo0P001Woo00<03gooOol08goo00<007ooOol06Goo
0003Ool00`00Oomoo`0^Ool00`00Oomoo`0YOol00`0?Oomoo`0>Ool2000EOol00`0?Oomoo`03Ool2
000DOol2000:Ool00`0?Oomoo`0=Ool3000EOol00`0?Oomoo`0SOol00`00Oomoo`0IOol000=oo`03
001oogoo02ioo`03001oogoo02Uoo`0400moo`00000=Ool2000EOol00`0?Oomoo`03Ool3000BOol3
000:Ool00`0?Oomoo`0>Ool2000=Ool20006Ool00`0?Oomoo`0SOol00`00Oomoo`0IOol000=oo`80
02moo`0300003`0?02/03`8000`03`8001d03`<001003`<001d03`8000`03`8002`03`03001oogoo
01Uoo`000Woo1@00;Goo00<007ooOol0:Goo00<03gooOol03Goo0P005Woo00<03gooOol01Goo0P00
47oo0P0037oo00<03gooOol03goo0P0057oo00<03gooOol08goo00<007ooOol06Goo0003Ool00`00
Oomoo`0^Ool00`00Oomoo`0YOol00`0?Oomoo`02000:Ool2000GOol00`0?Oomoo`05Ool2000?Ool2
000=Ool00`0?Oomoo`0@Ool2000:Ool20007Ool00`0?Oomoo`0SOol00`00Oomoo`0IOol000=oo`03
001oogoo02ioo`03001oogoo02Uoo`0300moogoo008000Yoo`8001Moo`0300moogoo00Eoo`8000mo
o`8000eoo`0300moogoo011oo`8000Yoo`8000Moo`0300moogoo02=oo`03001oogoo01Uoo`000goo
00<007ooOol0;Woo00<0000?00l0=`0?0P008@0?0P003@0?0P008P0?0P00>00?00<007ooOol06Goo
0003Ool00`00Oomoo`0^Ool00`00Oomoo`0YOol0100?Oomoogoo0P0027oo0P0067oo00<03gooOol0
1Woo0P003Goo0P003Woo00<03gooOol04Goo0P0027oo0P0027oo00<03gooOol08goo00<007ooOol0
6Goo0003Ool00`00Oomoo`0^Ool00`00Oomoo`0YOol0100?Oomoogoo0P001goo0P006Goo00<03goo
Ool01goo0P0037oo0P003Woo00<03gooOol04Goo0P0027oo0P0027oo00<03gooOol08goo00<007oo
Ool06Goo0003Ool00`00Oomoo`0^Ool00`0000l03`0f00l2000S00l2000<00l2000R00l2000h00l0
0`00Oomoo`0IOol000Aoo`03001oogoo02eoo`03001oogoo02Uoo`0300moogoo02Eoo`0300moogoo
00Qoo`8000Yoo`8000moo`0300moogoo02Eoo`0300moogoo02=oo`03001oogoo01Uoo`000Woo00D0
07ooOomoo`0002eoo`0300003`0?02h03`8000H03`8002@03`8000X03`8002@03`8000H03`8002l0
3`03001oogoo01Uoo`000Woo00D007ooOomoo`0002eoo`03001oogoo02Uoo`0300moogoo009oo`80
00Ioo`8001Uoo`0300moogoo02Eoo`0300moogoo019oo`8000Ioo`8000Uoo`0300moogoo02=oo`03
001oogoo01Uoo`000Woo00D007oo001oo`0002eoo`0300003`0?05d03`8000P03`8005h03`03001o
ogoo01Uoo`000Woo00D007oo001oo`0002eoo`0300003`0?05d03`8000P03`8005h03`03001oogoo
01Uoo`000Woo0P0000=oo`000000;Goo00<007ooOol0:Goo00<03gooOol00Woo0P001Goo0P006Woo
00<03gooOol09Goo00<03gooOol04goo0P0017oo0P002Woo00<03gooOol08goo00<007ooOol06Goo
00000goo00000003Ool2000=Ool20004Ool20004Ool20004Ool20003Ool30005Ool00`0000l03`0^
00l2000500l2000V00l2000700l2000W00l2000400l2000`00l00`00Oomoo`0IOol000=oo`@000eo
o`04001oogoo0003Ool20003Ool01000Oomoo`000Woo00@007ooOol000=oo`03001oogoo00Aoo`03
00003`0?05d03`8000L03`8005l03`03001oogoo01Uoo`000Woo00<007ooOol03goo00@007ooOol0
00Qoo`04001oogoo0002Ool01000Oomoo`000goo00<007ooOol017oo0P00a`0?0P006goo0002Ool5
000=Ool01000Oomoo`0027oo00@007ooOol0009oo`04001oogoo0003Ool00`00Oomoo`04Ool00`00
Oomoo`0YOol00`0?Oomoo`0UOol00`0?Oomoo`0UOol00`0?Oomoo`0UOol00`0?Oomoo`0SOol00`00
Oomoo`0IOol0009oo`05001oogooOol0000=Ool01000Oomoo`0027oo00@007ooOol0009oo`04001o
ogoo0003Ool00`00Oomoo`04Ool00`00Oomoo`0YOol00`0?Oomoo`08Ool2000KOol00`0?Oomoo`0:
Ool20005Ool2000BOol00`0?Oomoo`0DOol2000?Ool00`0?Oomoo`0SOol00`00Oomoo`0IOol000=o
o`<000moo`8000Yoo`8000Aoo`8000=oo`8000Ioo`03001oogoo02Uoo`0300moogoo00Qoo`8001]o
o`0300moogoo00Yoo`8000Eoo`80019oo`0300moogoo01Aoo`8000moo`0300moogoo02=oo`03001o
ogoo01Uoo`00=7oo00<007ooOol0:Goo00<03gooOol00goo0P0087oo00<03gooOol09Goo00<03goo
Ool06Goo0P002Woo00<03gooOol08goo00<007ooOol06Goo0002Ool5000]Ool00`00Oomoo`0YOol0
0`0?Oomoo`03Ool2000POol00`0?Oomoo`0UOol00`0?Oomoo`0IOol2000:Ool00`0?Oomoo`0SOol0
0`00Oomoo`0IOol0009oo`04001oogoo000^Ool00`00Oomoo`0YOol00`0?Oomoo`0UOol00`0?Oomo
o`0;Ool20004Ool2000BOol00`0?Oomoo`0UOol00`0?Oomoo`0SOol00`00Oomoo`0IOol0009oo`@0
02ioo`0300003`0?05l03`8000@03`8006003`03001oogoo01Uoo`001Goo00<007ooOol0;7oo00<0
07ooOol0:Goo00<03gooOol09Goo00<03gooOol09Goo00<03gooOol09Goo00<03gooOol08goo00<0
07ooOol06Goo0003Ool3000^Ool00`00Oomoo`0YOol00`0?Oomoo`07Ool2000LOol00`0?Oomoo`0U
Ool00`0?Oomoo`0EOol2000>Ool00`0?Oomoo`0SOol00`00Oomoo`0IOol003Aoo`03001oogoo02Uo
o`0300moogoo00Moo`8001aoo`0300moogoo02Eoo`0300moogoo01Eoo`8000ioo`0300moogoo02=o
o`03001oogoo01Uoo`000Woo1000;Woo00<0000?00l0a`0?00<007ooOol06Goo0005Ool00`00Oomo
o`0/Ool00`00Oomoo`0YOol00`0?Oomoo`0UOol00`0?Oomoo`0UOol00`0?Oomoo`0UOol00`0?Oomo
o`0SOol00`00Oomoo`0IOol0009oo`@002ioo`0300003`0?03003`8002h03`8000803`8002h03`80
03403`03001oogoo01Uoo`000Woo00<007ooOol0;goo00<007ooOol0:Goo00<03gooOol017oo0P00
7goo00<03gooOol037oo0P000Woo0P004goo00<03gooOol067oo0P002goo00<03gooOol08goo00<0
07ooOol06Goo0002Ool4000^Ool00`0000l03`3700l00`00Oomoo`0IOol003Aoo`03001oogoo02Uo
o`0300moogoo02Eoo`0300moogoo02Eoo`0300moogoo02Eoo`0300moogoo02=oo`03001oogoo01Uo
o`000Woo1@00;Goo00<0000?00l0a`0?00<007ooOol06Goo0002Ool01000Oomoo`00;Woo00<007oo
Ool0:Goo00<03gooOol09Goo00<03gooOol09Goo00<03gooOol09Goo00<03gooOol08goo00<007oo
Ool06Goo0002Ool01000Oomoo`00;Woo00<0000?00l0a`0?00<007ooOol06Goo0002Ool01000Oomo
o`005Goo0P0017oo0P0017oo0P000goo0`001Goo00<0000?00l0<P0?0P00G@0?0P00=00?00<007oo
Ool06Goo000017oo000007oo0P0057oo00@007ooOol000=oo`8000=oo`04001oogoo0003Ool00`00
Oomoo`04Ool00`0000l03`0b00l2001M00l2000d00l00`00Oomoo`0IOol001Yoo`04001oogoo0008
Ool01000Oomoo`000goo00<007ooOol017oo0P00a`0?0P006goo0002Ool4000DOol01000Oomoo`00
27oo00@007ooOol000=oo`03001oogoo00Aoo`03001oogoo02Uoo`0300moogoo02Eoo`0300moogoo
00eoo`@001Aoo`0300moogoo02Eoo`0300moogoo02=oo`03001oogoo01Uoo`000goo00<007ooOol0
57oo00@007ooOol000Qoo`04001oogoo0003Ool00`00Oomoo`04Ool00`00Oomoo`0YOol00`0?Oomo
o`0UOol00`0?Oomoo`0=Ool4000DOol00`0?Oomoo`0UOol00`0?Oomoo`0SOol00`00Oomoo`0IOol0
00=oo`03001oogoo01Eoo`8000Yoo`8000=oo`8000Ioo`03001oogoo02Uoo`0300moogoo02Eoo`03
00moogoo02Eoo`0300moogoo02Eoo`0300moogoo02=oo`03001oogoo01Uoo`000goo0P00;goo00<0
07ooOol0:Goo00<03gooOol09Goo00<03gooOol09Goo00<03gooOol09Goo00<03gooOol08goo00<0
07ooOol06Goo0002Ool200000goo0000000]Ool00`00Oomoo`0YOol00`0?Oomoo`0UOol00`0?Oomo
o`0UOol00`0?Oomoo`0UOol00`0?Oomoo`0SOol00`00Oomoo`0IOol003Aoo`03001oogoo02Uoo`03
00moogoo02Eoo`0300moogoo02Eoo`0300moogoo02Eoo`0300moogoo02=oo`03001oogoo01Uoo`00
0goo1000;Goo00<0000?00l0<@0?0P00H00?0P00<P0?00<007ooOol06Goo0002Ool00`00Oomoo`0_
Ool00`00Oomoo`0YOol00`0?Oomoo`05Ool2000NOol00`0?Oomoo`0UOol00`0?Oomoo`0GOol2000<
Ool00`0?Oomoo`0SOol00`00Oomoo`0IOol0009oo`D002eoo`03001oogoo02Uoo`0300moogoo02Eo
o`0300moogoo02Eoo`0300moogoo02Eoo`0300moogoo02=oo`03001oogoo01Uoo`000Woo00D007oo
Oomoo`0002eoo`03001oogoo02Uoo`0300moogoo02Eoo`0300moogoo02Eoo`0300moogoo02Eoo`03
00moogoo02=oo`03001oogoo01Uoo`000goo0`00;Woo00<0000?00l0a`0?00<007ooOol06Goo000d
Ool00`00Oomoo`0YOol00`0?Oomoo`0UOol00`0?Oomoo`0UOol00`0?Oomoo`0UOol00`0?Oomoo`0S
Ool00`00Oomoo`0IOol003Aoo`0300003`0?0<L03`03001oogoo01Uoo`00=7oo00<007ooOol0:Goo
00<03gooOol09Goo00<03gooOol09Goo00<03gooOol09Goo00<03gooOol08goo00<007ooOol06Goo
000dOol00`00Oomoo`0YOol00`0?Oomoo`0UOol00`0?Oomoo`0UOol00`0?Oomoo`0UOol00`0?Oomo
o`0SOol00`00Oomoo`0IOol003Aoo`0300003`0?0<L03`03001oogoo01Uoo`00=7oo00<0000?00l0
a`0?00<007ooOol06Goo000dOol00`00Oomoo`0YOol00`0?Oomoo`0UOol00`0?Oomoo`0UOol00`0?
Oomoo`0UOol00`0?Oomoo`0SOol00`00Oomoo`0IOol0009oo`D002eoo`0300003`0?0<L03`03001o
ogoo01Uoo`000Woo00@007ooOol001]oo`8000Aoo`8000=oo`<000Eoo`0300003`0?0<L03`03001o
ogoo01Uoo`000Woo10006Woo00@007ooOol000=oo`8000Aoo`03001oogoo00Aoo`0300003`0?0<L0
3`03001oogoo01Uoo`001Goo00<007ooOol067oo00@007ooOol000Uoo`03001oogoo00Aoo`800680
3`<006803`8001]oo`000goo0`006Woo00@007ooOol000Uoo`03001oogoo00Aoo`03001oogoo02Uo
o`0300moogoo02Eoo`0300moogoo00eoo`<001Eoo`0300moogoo02Eoo`0300moogoo02=oo`03001o
ogoo01Uoo`0017oo00<007ooOol06Goo00@007ooOol000Uoo`03001oogoo00Aoo`03001oogoo02Uo
o`0300moogoo02Eoo`0300moogoo02Eoo`0300moogoo02Eoo`0300moogoo02=oo`03001oogoo01Uo
o`0017oo00<007ooOol06Woo0P002Goo0P001Woo00<007ooOol0:Goo00<03gooOol09Goo00<03goo
Ool09Goo00<03gooOol09Goo00<03gooOol08goo00<007ooOol06Goo0004Ool00`00Oomoo`0]Ool0
0`00Oomoo`0YOol00`0?Oomoo`0UOol00`0?Oomoo`0UOol00`0?Oomoo`0UOol00`0?Oomoo`0SOol0
0`00Oomoo`0IOol000Aoo`03001oogoo02eoo`03001oogoo02Uoo`0300moogoo02Eoo`0300moogoo
02Eoo`0300moogoo02Eoo`0300moogoo02=oo`03001oogoo01Uoo`0017oo00<007ooOol0;Goo00<0
07ooOol0:Goo00<03gooOol09Goo00<03gooOol09Goo00<03gooOol09Goo00<03gooOol08goo00<0
07ooOol06Goo0003Ool2000_Ool00`0000l03`0b00l2001N00l2000c00l00`00Oomoo`0IOol000=o
o`8002moo`03001oogoo02Uoo`0300moogoo00Ioo`8001eoo`0300moogoo02Eoo`0300moogoo01Io
o`8000eoo`0300moogoo02=oo`03001oogoo01Uoo`0017oo00<007ooOol0;Goo00@007ooOomoo`80
02Ioo`0300moogoo02Eoo`0300moogoo02Eoo`0300moogoo02Eoo`0300moogoo02=oo`03001oogoo
01Uoo`0017oo00<007ooOol0;Goo00@007ooOomoo`8002Ioo`0300moogoo02Eoo`0300moogoo02Eo
o`0300moogoo02Eoo`0300moogoo02=oo`03001oogoo01Uoo`0017oo00<007ooOol0;Goo00<0000?
00l0a`0?00<007ooOol06Goo0004Ool00`00Oomoo`0]Ool00`00Oomoo`0YOol00`0?Oomoo`0UOol0
0`0?Oomoo`0UOol00`0?Oomoo`0UOol00`0?Oomoo`0SOol00`00Oomoo`0IOol000Aoo`03001oogoo
02eoo`03001oogoo02Uoo`0300moogoo02Eoo`0300moogoo02Eoo`0300moogoo02Eoo`0300moogoo
02=oo`03001oogoo01Uoo`000goo00<007ooOol0;Woo00<0000?00l0a`0?00<007ooOol06Goo000d
Ool00`00Oomoo`0YOol00`0?Oomoo`0UOol00`0?Oomoo`0UOol00`0?Oomoo`0UOol00`0?Oomoo`0S
Ool00`00Oomoo`0IOol003Aoo`0300003`0?0<L03`03001oogoo01Uoo`00=7oo00<007ooOol0:Goo
00<03gooOol09Goo00<03gooOol09Goo00<03gooOol09Goo00<03gooOol08goo00<007ooOol06Goo
000dOol00`0000l03`3700l00`00Oomoo`0IOol003Aoo`0300003`0?0<L03`03001oogoo01Uoo`00
=7oo00<0000?00l0a`0?00<007ooOol06Goo000/Ool30005Ool00`0000l03`3700l00`00Oomoo`0I
Ool002eoo`03001oogoo00Aoo`03001oogoo02Uoo`0300moogoo02Eoo`0300moogoo02Eoo`0300mo
ogoo02Eoo`0300moogoo02=oo`03001oogoo01Uoo`00;Goo00<007ooOol017oo0P00a`0?0P006goo
000]Ool00`00Oomoo`04Ool01@00Oomoogoo00009goo00<007ooOol09Goo00<007ooOol09Goo00<0
07ooOol09Goo00<007ooOol08goo00<007ooOol06Goo000]Ool00`00Oomoo`04Ooo;000KOol002ao
o`800>aoo`00ogoo6goo003oOolKOol00?mooa]oo`00ogoo6goo000]Ool4003LOol3000:Ool002io
o`03001oogoo0=moo`03001oogoo00Moo`0077oo10000goo0`000Woo00H007oo001oo`00Ool40002
Ool50002Ool30003Ool40006Ool50002Ool500000goo000000020003Ool30002Ool40003Ool40002
Ool30003Ool40006Ool30005Ool30002Ool500000goo000000020002Ool50002Ool400000goo0000
00020009Ool30002Ool40002Ool5000017oo000007oo0P0000=oo`0000000P000Woo10000goo0`00
0Woo10000Woo00D007oo001oo`0000Qoo`<0009oo`@000Moo`80009oo`80009oo`@0009oo`@00004
Ool000000005Ool001]oo`03001oogoo00Aoo`0=001oogooOol007oo001oo`00Ool007oo00000goo
00<007oo00000Woo00D007ooOomoo`00009oo`03001oo`0000]oo`05001oogooOol00003Ool00`00
Oomoo`04Ool01000Oomoo`000goo00@007ooOol000Aoo`03001oogoo00Aoo`06001oogoo001oo`00
2goo00<007ooOol00goo00L007ooOomoo`00Ool00002Ool01@00Oomoogoo00001Woo00D007ooOomo
o`0000Ioo`03001oogoo00Yoo`03001oogoo009oo`03001oogoo009oo`04001oogoo0002Ool01000
Oomoo`001Goo00D007ooOomoo`0000Aoo`05001oogooOol00002Ool00`00Oomoo`02Ool01@00Ool0
07oo00001goo00D007ooOomoo`00009oo`03001oogoo00Qoo`04001oo`000002Ool00`00Oomoo`03
Ool01@00Oomoogoo00000Woo00<007ooOol017oo000KOol00`00Oomoo`04Ool03@00Oomoogoo001o
o`00Ool007oo001oo`0000=oo`03001oo`00009oo`05001oogooOol00004Ool50007Ool01@00Oomo
ogoo00000goo00@007ooOomoo`@0009oo`03001oogoo00Aoo`03001oogoo009oo`D0009oo`03001o
ogoo009oo`D000Moo`03001oogoo00=oo`07001oogooOol007oo00000Woo00D007ooOomoo`0000Io
o`04001oogooOol50002Ool00`00Oomoo`0:Ool00`00Oomoo`02Ool00`00Oomoo`02Ool40002Ool0
1000Oomoo`000Woo10000goo00<007ooOol00Woo00D007ooOomoo`00009oo`03001oogoo009oo`05
001oo`00Ool00007Ool01@00Oomoogoo00000Woo00<007ooOol027oo0`000goo1@0000=oo`00Ool0
0Woo00@007ooOol000Ioo`006goo00<007ooOol017oo00d007ooOomoo`00Ool007oo001oo`00Ool0
0003Ool00`00Ool00002Ool01@00Oomoogoo000017oo00D007ooOomoo`0000Moo`05001oogooOol0
0003Ool01@00Oomoogoo00001Goo00D007ooOomoo`00009oo`8000=oo`05001oogooOol00002Ool0
0`00Oomoo`02Ool01@00Oomoogoo00001goo0`000goo00L007ooOomoo`00Ool00002Ool01000Oomo
ogoo0P001Goo00D007ooOomoo`0000=oo`03001oogoo008000Uoo`05001oo`00Ool00002Ool20006
Ool01000Oomoo`000Woo00@007ooOol000Ioo`03001oogoo009oo`05001oogooOol00002Ool20003
Ool01@00Ool007oo00001goo00D007ooOomoo`00009oo`03001oogoo00Qoo`04001oogoo0002Ool0
1`00Oomoogoo001oo`0000=oo`04001oogoo0006Ool001]oo`05001oogooOol00003Ool300000goo
00000009000017oo000007oo0P000Woo10000goo0`0027oo00D007ooOomoo`00009oo`8000=oo`@0
00=oo`@00004Ool00000Ool20002Ool30002Ool40003Ool30008Ool00`00Oomoo`04Ool3000017oo
000007oo0P000Woo0P0000=oo`0000000Woo0P0017oo0`000Woo0P0000=oo`0000001goo00H007oo
001oo`00Ool200000goo00000002Ool300000goo000000030002Ool40002Ool40003Ool30002Ool2
00000goo000000060008Ool30002Ool40008Ool01000Oomoo`000goo0`000goo1@0000=oo`00Ool0
1Goo000LOol4000KOol00`00Oomoo`0=Ool5000QOol00`00Oomoo`0=Ool5000/Ool5000JOol00`00
Oomoo`0QOol00`00Oomoo`07Ool4000?Ool20006Ool003]oo`03001oogoo01Ioo`03001oogoo01Yo
o`03001oogoo02Qoo`03001oogoo039oo`<0025oo`<0029oo`00ogoo6goo0000\
\>"],
  ImageRangeCache->{{{0, 281}, {173, 0}} -> {-71.3267, -6.98188, 1.25334, 
  0.0450395}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
%% Graphics
/Courier findfont 8  scalefont  setfont
% Scaling calculations
0.0238095 0.47619 0.0147151 0.47619 [
[(Repeat Shors Algm O\\(ln\\(q\\)\\) times. )( Obtain samples from DFT in \
Reg1)] .5 .61803 0 -2 Msboxa
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
[ ] 0 setdash
0 g
p
[(Repeat Shors Algm O\\(ln\\(q\\)\\) times. )( Obtain samples from DFT in \
Reg1)] .5 .61803 0 -2 Mshowa
P
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
p
p
% Start of sub-graphic
p
0.0238095 0.0147151 0.477324 0.295003 MathSubStart
%% Graphics
/Courier findfont 8  scalefont  setfont
% Scaling calculations
0.0238095 0.00393546 0.603319 0.109514 [
[(0)] .02381 0 0 2 Msboxa
[(50)] .22058 0 0 2 Msboxa
[(100)] .41736 0 0 2 Msboxa
[(150)] .61413 0 0 2 Msboxa
[(200)] .8109 0 0 2 Msboxa
[(0.00001)] -0.0125 .05575 1 0 Msboxa
[(0.0001)] -0.0125 .16526 1 0 Msboxa
[(0.001)] -0.0125 .27478 1 0 Msboxa
[(0.01)] -0.0125 .38429 1 0 Msboxa
[(0.1)] -0.0125 .4938 1 0 Msboxa
[(1)] -0.0125 .60332 1 0 Msboxa
[ -0.001 -0.001 0 0 ]
[ 1.001 .61903 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
[ ] 0 setdash
p
p
.002 w
.02381 0 m
.02381 .00625 L
s
P
[(0)] .02381 0 0 2 Mshowa
p
.002 w
.22058 0 m
.22058 .00625 L
s
P
[(50)] .22058 0 0 2 Mshowa
p
.002 w
.41736 0 m
.41736 .00625 L
s
P
[(100)] .41736 0 0 2 Mshowa
p
.002 w
.61413 0 m
.61413 .00625 L
s
P
[(150)] .61413 0 0 2 Mshowa
p
.002 w
.8109 0 m
.8109 .00625 L
s
P
[(200)] .8109 0 0 2 Mshowa
p
.001 w
.06316 0 m
.06316 .00375 L
s
P
p
.001 w
.10252 0 m
.10252 .00375 L
s
P
p
.001 w
.14187 0 m
.14187 .00375 L
s
P
p
.001 w
.18123 0 m
.18123 .00375 L
s
P
p
.001 w
.25994 0 m
.25994 .00375 L
s
P
p
.001 w
.29929 0 m
.29929 .00375 L
s
P
p
.001 w
.33865 0 m
.33865 .00375 L
s
P
p
.001 w
.378 0 m
.378 .00375 L
s
P
p
.001 w
.45671 0 m
.45671 .00375 L
s
P
p
.001 w
.49606 0 m
.49606 .00375 L
s
P
p
.001 w
.53542 0 m
.53542 .00375 L
s
P
p
.001 w
.57477 0 m
.57477 .00375 L
s
P
p
.001 w
.65348 0 m
.65348 .00375 L
s
P
p
.001 w
.69284 0 m
.69284 .00375 L
s
P
p
.001 w
.73219 0 m
.73219 .00375 L
s
P
p
.001 w
.77155 0 m
.77155 .00375 L
s
P
p
.001 w
.85026 0 m
.85026 .00375 L
s
P
p
.001 w
.88961 0 m
.88961 .00375 L
s
P
p
.001 w
.92896 0 m
.92896 .00375 L
s
P
p
.001 w
.96832 0 m
.96832 .00375 L
s
P
p
.002 w
0 0 m
1 0 L
s
P
p
.002 w
0 .05575 m
.00625 .05575 L
s
P
[(0.00001)] -0.0125 .05575 1 0 Mshowa
p
.002 w
0 .16526 m
.00625 .16526 L
s
P
[(0.0001)] -0.0125 .16526 1 0 Mshowa
p
.002 w
0 .27478 m
.00625 .27478 L
s
P
[(0.001)] -0.0125 .27478 1 0 Mshowa
p
.002 w
0 .38429 m
.00625 .38429 L
s
P
[(0.01)] -0.0125 .38429 1 0 Mshowa
p
.002 w
0 .4938 m
.00625 .4938 L
s
P
[(0.1)] -0.0125 .4938 1 0 Mshowa
p
.002 w
0 .60332 m
.00625 .60332 L
s
P
[(1)] -0.0125 .60332 1 0 Mshowa
p
.001 w
0 .01217 m
.00375 .01217 L
s
P
p
.001 w
0 .02278 m
.00375 .02278 L
s
P
p
.001 w
0 .03145 m
.00375 .03145 L
s
P
p
.001 w
0 .03879 m
.00375 .03879 L
s
P
p
.001 w
0 .04514 m
.00375 .04514 L
s
P
p
.001 w
0 .05074 m
.00375 .05074 L
s
P
p
.001 w
0 .08872 m
.00375 .08872 L
s
P
p
.001 w
0 .108 m
.00375 .108 L
s
P
p
.001 w
0 .12168 m
.00375 .12168 L
s
P
p
.001 w
0 .1323 m
.00375 .1323 L
s
P
p
.001 w
0 .14097 m
.00375 .14097 L
s
P
p
.001 w
0 .1483 m
.00375 .1483 L
s
P
p
.001 w
0 .15465 m
.00375 .15465 L
s
P
p
.001 w
0 .16025 m
.00375 .16025 L
s
P
p
.001 w
0 .19823 m
.00375 .19823 L
s
P
p
.001 w
0 .21751 m
.00375 .21751 L
s
P
p
.001 w
0 .2312 m
.00375 .2312 L
s
P
p
.001 w
0 .24181 m
.00375 .24181 L
s
P
p
.001 w
0 .25048 m
.00375 .25048 L
s
P
p
.001 w
0 .25781 m
.00375 .25781 L
s
P
p
.001 w
0 .26416 m
.00375 .26416 L
s
P
p
.001 w
0 .26977 m
.00375 .26977 L
s
P
p
.001 w
0 .30774 m
.00375 .30774 L
s
P
p
.001 w
0 .32703 m
.00375 .32703 L
s
P
p
.001 w
0 .34071 m
.00375 .34071 L
s
P
p
.001 w
0 .35132 m
.00375 .35132 L
s
P
p
.001 w
0 .36 m
.00375 .36 L
s
P
p
.001 w
0 .36733 m
.00375 .36733 L
s
P
p
.001 w
0 .37368 m
.00375 .37368 L
s
P
p
.001 w
0 .37928 m
.00375 .37928 L
s
P
p
.001 w
0 .41726 m
.00375 .41726 L
s
P
p
.001 w
0 .43654 m
.00375 .43654 L
s
P
p
.001 w
0 .45022 m
.00375 .45022 L
s
P
p
.001 w
0 .46084 m
.00375 .46084 L
s
P
p
.001 w
0 .46951 m
.00375 .46951 L
s
P
p
.001 w
0 .47684 m
.00375 .47684 L
s
P
p
.001 w
0 .48319 m
.00375 .48319 L
s
P
p
.001 w
0 .48879 m
.00375 .48879 L
s
P
p
.001 w
0 .52677 m
.00375 .52677 L
s
P
p
.001 w
0 .54606 m
.00375 .54606 L
s
P
p
.001 w
0 .55974 m
.00375 .55974 L
s
P
p
.001 w
0 .57035 m
.00375 .57035 L
s
P
p
.001 w
0 .57902 m
.00375 .57902 L
s
P
p
.001 w
0 .58635 m
.00375 .58635 L
s
P
p
.001 w
0 .59271 m
.00375 .59271 L
s
P
p
.001 w
0 .59831 m
.00375 .59831 L
s
P
p
.002 w
0 0 m
0 .61803 L
s
P
P
p
p
.002 w
.02381 .61178 m
.02381 .61803 L
s
P
p
.002 w
.22058 .61178 m
.22058 .61803 L
s
P
p
.002 w
.41736 .61178 m
.41736 .61803 L
s
P
p
.002 w
.61413 .61178 m
.61413 .61803 L
s
P
p
.002 w
.8109 .61178 m
.8109 .61803 L
s
P
p
.001 w
.06316 .61428 m
.06316 .61803 L
s
P
p
.001 w
.10252 .61428 m
.10252 .61803 L
s
P
p
.001 w
.14187 .61428 m
.14187 .61803 L
s
P
p
.001 w
.18123 .61428 m
.18123 .61803 L
s
P
p
.001 w
.25994 .61428 m
.25994 .61803 L
s
P
p
.001 w
.29929 .61428 m
.29929 .61803 L
s
P
p
.001 w
.33865 .61428 m
.33865 .61803 L
s
P
p
.001 w
.378 .61428 m
.378 .61803 L
s
P
p
.001 w
.45671 .61428 m
.45671 .61803 L
s
P
p
.001 w
.49606 .61428 m
.49606 .61803 L
s
P
p
.001 w
.53542 .61428 m
.53542 .61803 L
s
P
p
.001 w
.57477 .61428 m
.57477 .61803 L
s
P
p
.001 w
.65348 .61428 m
.65348 .61803 L
s
P
p
.001 w
.69284 .61428 m
.69284 .61803 L
s
P
p
.001 w
.73219 .61428 m
.73219 .61803 L
s
P
p
.001 w
.77155 .61428 m
.77155 .61803 L
s
P
p
.001 w
.85026 .61428 m
.85026 .61803 L
s
P
p
.001 w
.88961 .61428 m
.88961 .61803 L
s
P
p
.001 w
.92896 .61428 m
.92896 .61803 L
s
P
p
.001 w
.96832 .61428 m
.96832 .61803 L
s
P
p
.002 w
0 .61803 m
1 .61803 L
s
P
p
.002 w
.99375 .05575 m
1 .05575 L
s
P
p
.002 w
.99375 .16526 m
1 .16526 L
s
P
p
.002 w
.99375 .27478 m
1 .27478 L
s
P
p
.002 w
.99375 .38429 m
1 .38429 L
s
P
p
.002 w
.99375 .4938 m
1 .4938 L
s
P
p
.002 w
.99375 .60332 m
1 .60332 L
s
P
p
.001 w
.99625 .01217 m
1 .01217 L
s
P
p
.001 w
.99625 .02278 m
1 .02278 L
s
P
p
.001 w
.99625 .03145 m
1 .03145 L
s
P
p
.001 w
.99625 .03879 m
1 .03879 L
s
P
p
.001 w
.99625 .04514 m
1 .04514 L
s
P
p
.001 w
.99625 .05074 m
1 .05074 L
s
P
p
.001 w
.99625 .08872 m
1 .08872 L
s
P
p
.001 w
.99625 .108 m
1 .108 L
s
P
p
.001 w
.99625 .12168 m
1 .12168 L
s
P
p
.001 w
.99625 .1323 m
1 .1323 L
s
P
p
.001 w
.99625 .14097 m
1 .14097 L
s
P
p
.001 w
.99625 .1483 m
1 .1483 L
s
P
p
.001 w
.99625 .15465 m
1 .15465 L
s
P
p
.001 w
.99625 .16025 m
1 .16025 L
s
P
p
.001 w
.99625 .19823 m
1 .19823 L
s
P
p
.001 w
.99625 .21751 m
1 .21751 L
s
P
p
.001 w
.99625 .2312 m
1 .2312 L
s
P
p
.001 w
.99625 .24181 m
1 .24181 L
s
P
p
.001 w
.99625 .25048 m
1 .25048 L
s
P
p
.001 w
.99625 .25781 m
1 .25781 L
s
P
p
.001 w
.99625 .26416 m
1 .26416 L
s
P
p
.001 w
.99625 .26977 m
1 .26977 L
s
P
p
.001 w
.99625 .30774 m
1 .30774 L
s
P
p
.001 w
.99625 .32703 m
1 .32703 L
s
P
p
.001 w
.99625 .34071 m
1 .34071 L
s
P
p
.001 w
.99625 .35132 m
1 .35132 L
s
P
p
.001 w
.99625 .36 m
1 .36 L
s
P
p
.001 w
.99625 .36733 m
1 .36733 L
s
P
p
.001 w
.99625 .37368 m
1 .37368 L
s
P
p
.001 w
.99625 .37928 m
1 .37928 L
s
P
p
.001 w
.99625 .41726 m
1 .41726 L
s
P
p
.001 w
.99625 .43654 m
1 .43654 L
s
P
p
.001 w
.99625 .45022 m
1 .45022 L
s
P
p
.001 w
.99625 .46084 m
1 .46084 L
s
P
p
.001 w
.99625 .46951 m
1 .46951 L
s
P
p
.001 w
.99625 .47684 m
1 .47684 L
s
P
p
.001 w
.99625 .48319 m
1 .48319 L
s
P
p
.001 w
.99625 .48879 m
1 .48879 L
s
P
p
.001 w
.99625 .52677 m
1 .52677 L
s
P
p
.001 w
.99625 .54606 m
1 .54606 L
s
P
p
.001 w
.99625 .55974 m
1 .55974 L
s
P
p
.001 w
.99625 .57035 m
1 .57035 L
s
P
p
.001 w
.99625 .57902 m
1 .57902 L
s
P
p
.001 w
.99625 .58635 m
1 .58635 L
s
P
p
.001 w
.99625 .59271 m
1 .59271 L
s
P
p
.001 w
.99625 .59831 m
1 .59831 L
s
P
p
.002 w
1 0 m
1 .61803 L
s
P
P
p
P
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
p
p
.6 g
p
.008 w
.02381 .53758 Mdot
.02774 .01472 Mdot
.03168 .01483 Mdot
.03562 .01503 Mdot
.03955 .01531 Mdot
.04349 .01567 Mdot
.04742 .01611 Mdot
.05136 .01663 Mdot
.05529 .01723 Mdot
.05923 .01792 Mdot
.06316 .01869 Mdot
.0671 .01954 Mdot
.07104 .02048 Mdot
.07497 .0215 Mdot
.07891 .02262 Mdot
.08284 .02382 Mdot
.08678 .02511 Mdot
.09071 .02649 Mdot
.09465 .02797 Mdot
.09858 .02955 Mdot
.10252 .03122 Mdot
.10645 .033 Mdot
.11039 .03488 Mdot
.11433 .03686 Mdot
.11826 .03896 Mdot
.1222 .04117 Mdot
.12613 .04349 Mdot
.13007 .04594 Mdot
.134 .04852 Mdot
.13794 .05123 Mdot
.14187 .05407 Mdot
.14581 .05706 Mdot
.14974 .0602 Mdot
.15368 .06349 Mdot
.15762 .06695 Mdot
.16155 .07059 Mdot
.16549 .07442 Mdot
.16942 .07844 Mdot
.17336 .08267 Mdot
.17729 .08713 Mdot
.18123 .09184 Mdot
.18516 .09681 Mdot
.1891 .10207 Mdot
.19303 .10764 Mdot
.19697 .11356 Mdot
.20091 .11987 Mdot
.20484 .1266 Mdot
.20878 .13382 Mdot
.21271 .14159 Mdot
.21665 .14998 Mdot
.22058 .15912 Mdot
.22452 .16913 Mdot
.22845 .18019 Mdot
.23239 .19255 Mdot
.23632 .20656 Mdot
.24026 .22273 Mdot
.2442 .24186 Mdot
.24813 .26536 Mdot
.25207 .29592 Mdot
.256 .34003 Mdot
.25994 .42179 Mdot
.26387 .52751 Mdot
.26781 .37569 Mdot
.27174 .3211 Mdot
.27568 .2875 Mdot
.27961 .26341 Mdot
.28355 .24481 Mdot
.28749 .22977 Mdot
.29142 .21726 Mdot
.29536 .20664 Mdot
.29929 .19749 Mdot
.30323 .18952 Mdot
.30716 .18252 Mdot
.3111 .17635 Mdot
.31503 .17088 Mdot
.31897 .16602 Mdot
.3229 .1617 Mdot
.32684 .15787 Mdot
.33078 .15447 Mdot
.33471 .15147 Mdot
.33865 .14884 Mdot
.34258 .14654 Mdot
.34652 .14457 Mdot
.35045 .14289 Mdot
.35439 .14151 Mdot
.35832 .14039 Mdot
.36226 .13953 Mdot
.36619 .13893 Mdot
.37013 .13858 Mdot
.37407 .13846 Mdot
.378 .13859 Mdot
.38194 .13895 Mdot
.38587 .13955 Mdot
.38981 .14038 Mdot
.39374 .14146 Mdot
.39768 .14277 Mdot
.40161 .14433 Mdot
.40555 .14615 Mdot
.40948 .14823 Mdot
.41342 .15058 Mdot
.41736 .15321 Mdot
.42129 .15615 Mdot
.42523 .1594 Mdot
.42916 .16299 Mdot
.4331 .16694 Mdot
.43703 .17129 Mdot
.44097 .17607 Mdot
.4449 .18133 Mdot
.44884 .18713 Mdot
.45277 .19352 Mdot
.45671 .2006 Mdot
.46065 .20847 Mdot
.46458 .21729 Mdot
.46852 .22724 Mdot
.47245 .23859 Mdot
.47639 .25171 Mdot
.48032 .26719 Mdot
.48426 .28593 Mdot
.48819 .30956 Mdot
.49213 .34136 Mdot
.49606 .38981 Mdot
.5 .49424 Mdot
.50394 .49424 Mdot
.50787 .38981 Mdot
.51181 .34136 Mdot
.51574 .30956 Mdot
.51968 .28593 Mdot
.52361 .26719 Mdot
.52755 .25171 Mdot
.53148 .23859 Mdot
.53542 .22724 Mdot
.53935 .21729 Mdot
.54329 .20847 Mdot
.54723 .2006 Mdot
.55116 .19352 Mdot
.5551 .18713 Mdot
.55903 .18133 Mdot
.56297 .17607 Mdot
.5669 .17129 Mdot
.57084 .16694 Mdot
.57477 .16299 Mdot
.57871 .1594 Mdot
.58264 .15615 Mdot
.58658 .15321 Mdot
.59052 .15058 Mdot
.59445 .14823 Mdot
.59839 .14615 Mdot
.60232 .14433 Mdot
.60626 .14277 Mdot
.61019 .14146 Mdot
.61413 .14038 Mdot
.61806 .13955 Mdot
.622 .13895 Mdot
.62593 .13859 Mdot
.62987 .13846 Mdot
.63381 .13858 Mdot
.63774 .13893 Mdot
.64168 .13953 Mdot
.64561 .14039 Mdot
.64955 .14151 Mdot
.65348 .14289 Mdot
.65742 .14457 Mdot
.66135 .14654 Mdot
.66529 .14884 Mdot
.66922 .15147 Mdot
.67316 .15447 Mdot
.6771 .15787 Mdot
.68103 .1617 Mdot
.68497 .16602 Mdot
.6889 .17088 Mdot
.69284 .17635 Mdot
.69677 .18252 Mdot
.70071 .18952 Mdot
.70464 .19749 Mdot
.70858 .20664 Mdot
.71251 .21726 Mdot
.71645 .22977 Mdot
.72039 .24481 Mdot
.72432 .26341 Mdot
.72826 .2875 Mdot
.73219 .3211 Mdot
.73613 .37569 Mdot
.74006 .52751 Mdot
.744 .42179 Mdot
.74793 .34003 Mdot
.75187 .29592 Mdot
.7558 .26536 Mdot
.75974 .24186 Mdot
.76368 .22273 Mdot
.76761 .20656 Mdot
.77155 .19255 Mdot
.77548 .18019 Mdot
.77942 .16913 Mdot
.78335 .15912 Mdot
.78729 .14998 Mdot
.79122 .14159 Mdot
.79516 .13382 Mdot
.79909 .1266 Mdot
.80303 .11987 Mdot
.80697 .11356 Mdot
.8109 .10764 Mdot
.81484 .10207 Mdot
.81877 .09681 Mdot
.82271 .09184 Mdot
.82664 .08713 Mdot
.83058 .08267 Mdot
.83451 .07844 Mdot
.83845 .07442 Mdot
.84238 .07059 Mdot
.84632 .06695 Mdot
.85026 .06349 Mdot
.85419 .0602 Mdot
.85813 .05706 Mdot
.86206 .05407 Mdot
.866 .05123 Mdot
.86993 .04852 Mdot
.87387 .04594 Mdot
.8778 .04349 Mdot
.88174 .04117 Mdot
.88567 .03896 Mdot
.88961 .03686 Mdot
.89355 .03488 Mdot
.89748 .033 Mdot
.90142 .03122 Mdot
.90535 .02955 Mdot
.90929 .02797 Mdot
.91322 .02649 Mdot
.91716 .02511 Mdot
.92109 .02382 Mdot
.92503 .02262 Mdot
.92896 .0215 Mdot
.9329 .02048 Mdot
.93684 .01954 Mdot
.94077 .01869 Mdot
.94471 .01792 Mdot
.94864 .01723 Mdot
.95258 .01663 Mdot
.95651 .01611 Mdot
.96045 .01567 Mdot
.96438 .01531 Mdot
.96832 .01503 Mdot
.97226 .01483 Mdot
.97619 .01472 Mdot
P
P
p
1 0 0 r
p
.035 w
.5 .01472 Mdot
P
P
P
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.522676 0.0147151 0.97619 0.295003 MathSubStart
%% Graphics
/Courier findfont 8  scalefont  setfont
% Scaling calculations
0.0238095 0.00393546 0.603319 0.109514 [
[(0)] .02381 0 0 2 Msboxa
[(50)] .22058 0 0 2 Msboxa
[(100)] .41736 0 0 2 Msboxa
[(150)] .61413 0 0 2 Msboxa
[(200)] .8109 0 0 2 Msboxa
[(0.00001)] -0.0125 .05575 1 0 Msboxa
[(0.0001)] -0.0125 .16526 1 0 Msboxa
[(0.001)] -0.0125 .27478 1 0 Msboxa
[(0.01)] -0.0125 .38429 1 0 Msboxa
[(0.1)] -0.0125 .4938 1 0 Msboxa
[(1)] -0.0125 .60332 1 0 Msboxa
[ -0.001 -0.001 0 0 ]
[ 1.001 .61903 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
[ ] 0 setdash
p
p
.002 w
.02381 0 m
.02381 .00625 L
s
P
[(0)] .02381 0 0 2 Mshowa
p
.002 w
.22058 0 m
.22058 .00625 L
s
P
[(50)] .22058 0 0 2 Mshowa
p
.002 w
.41736 0 m
.41736 .00625 L
s
P
[(100)] .41736 0 0 2 Mshowa
p
.002 w
.61413 0 m
.61413 .00625 L
s
P
[(150)] .61413 0 0 2 Mshowa
p
.002 w
.8109 0 m
.8109 .00625 L
s
P
[(200)] .8109 0 0 2 Mshowa
p
.001 w
.06316 0 m
.06316 .00375 L
s
P
p
.001 w
.10252 0 m
.10252 .00375 L
s
P
p
.001 w
.14187 0 m
.14187 .00375 L
s
P
p
.001 w
.18123 0 m
.18123 .00375 L
s
P
p
.001 w
.25994 0 m
.25994 .00375 L
s
P
p
.001 w
.29929 0 m
.29929 .00375 L
s
P
p
.001 w
.33865 0 m
.33865 .00375 L
s
P
p
.001 w
.378 0 m
.378 .00375 L
s
P
p
.001 w
.45671 0 m
.45671 .00375 L
s
P
p
.001 w
.49606 0 m
.49606 .00375 L
s
P
p
.001 w
.53542 0 m
.53542 .00375 L
s
P
p
.001 w
.57477 0 m
.57477 .00375 L
s
P
p
.001 w
.65348 0 m
.65348 .00375 L
s
P
p
.001 w
.69284 0 m
.69284 .00375 L
s
P
p
.001 w
.73219 0 m
.73219 .00375 L
s
P
p
.001 w
.77155 0 m
.77155 .00375 L
s
P
p
.001 w
.85026 0 m
.85026 .00375 L
s
P
p
.001 w
.88961 0 m
.88961 .00375 L
s
P
p
.001 w
.92896 0 m
.92896 .00375 L
s
P
p
.001 w
.96832 0 m
.96832 .00375 L
s
P
p
.002 w
0 0 m
1 0 L
s
P
p
.002 w
0 .05575 m
.00625 .05575 L
s
P
[(0.00001)] -0.0125 .05575 1 0 Mshowa
p
.002 w
0 .16526 m
.00625 .16526 L
s
P
[(0.0001)] -0.0125 .16526 1 0 Mshowa
p
.002 w
0 .27478 m
.00625 .27478 L
s
P
[(0.001)] -0.0125 .27478 1 0 Mshowa
p
.002 w
0 .38429 m
.00625 .38429 L
s
P
[(0.01)] -0.0125 .38429 1 0 Mshowa
p
.002 w
0 .4938 m
.00625 .4938 L
s
P
[(0.1)] -0.0125 .4938 1 0 Mshowa
p
.002 w
0 .60332 m
.00625 .60332 L
s
P
[(1)] -0.0125 .60332 1 0 Mshowa
p
.001 w
0 .01217 m
.00375 .01217 L
s
P
p
.001 w
0 .02278 m
.00375 .02278 L
s
P
p
.001 w
0 .03145 m
.00375 .03145 L
s
P
p
.001 w
0 .03879 m
.00375 .03879 L
s
P
p
.001 w
0 .04514 m
.00375 .04514 L
s
P
p
.001 w
0 .05074 m
.00375 .05074 L
s
P
p
.001 w
0 .08872 m
.00375 .08872 L
s
P
p
.001 w
0 .108 m
.00375 .108 L
s
P
p
.001 w
0 .12168 m
.00375 .12168 L
s
P
p
.001 w
0 .1323 m
.00375 .1323 L
s
P
p
.001 w
0 .14097 m
.00375 .14097 L
s
P
p
.001 w
0 .1483 m
.00375 .1483 L
s
P
p
.001 w
0 .15465 m
.00375 .15465 L
s
P
p
.001 w
0 .16025 m
.00375 .16025 L
s
P
p
.001 w
0 .19823 m
.00375 .19823 L
s
P
p
.001 w
0 .21751 m
.00375 .21751 L
s
P
p
.001 w
0 .2312 m
.00375 .2312 L
s
P
p
.001 w
0 .24181 m
.00375 .24181 L
s
P
p
.001 w
0 .25048 m
.00375 .25048 L
s
P
p
.001 w
0 .25781 m
.00375 .25781 L
s
P
p
.001 w
0 .26416 m
.00375 .26416 L
s
P
p
.001 w
0 .26977 m
.00375 .26977 L
s
P
p
.001 w
0 .30774 m
.00375 .30774 L
s
P
p
.001 w
0 .32703 m
.00375 .32703 L
s
P
p
.001 w
0 .34071 m
.00375 .34071 L
s
P
p
.001 w
0 .35132 m
.00375 .35132 L
s
P
p
.001 w
0 .36 m
.00375 .36 L
s
P
p
.001 w
0 .36733 m
.00375 .36733 L
s
P
p
.001 w
0 .37368 m
.00375 .37368 L
s
P
p
.001 w
0 .37928 m
.00375 .37928 L
s
P
p
.001 w
0 .41726 m
.00375 .41726 L
s
P
p
.001 w
0 .43654 m
.00375 .43654 L
s
P
p
.001 w
0 .45022 m
.00375 .45022 L
s
P
p
.001 w
0 .46084 m
.00375 .46084 L
s
P
p
.001 w
0 .46951 m
.00375 .46951 L
s
P
p
.001 w
0 .47684 m
.00375 .47684 L
s
P
p
.001 w
0 .48319 m
.00375 .48319 L
s
P
p
.001 w
0 .48879 m
.00375 .48879 L
s
P
p
.001 w
0 .52677 m
.00375 .52677 L
s
P
p
.001 w
0 .54606 m
.00375 .54606 L
s
P
p
.001 w
0 .55974 m
.00375 .55974 L
s
P
p
.001 w
0 .57035 m
.00375 .57035 L
s
P
p
.001 w
0 .57902 m
.00375 .57902 L
s
P
p
.001 w
0 .58635 m
.00375 .58635 L
s
P
p
.001 w
0 .59271 m
.00375 .59271 L
s
P
p
.001 w
0 .59831 m
.00375 .59831 L
s
P
p
.002 w
0 0 m
0 .61803 L
s
P
P
p
p
.002 w
.02381 .61178 m
.02381 .61803 L
s
P
p
.002 w
.22058 .61178 m
.22058 .61803 L
s
P
p
.002 w
.41736 .61178 m
.41736 .61803 L
s
P
p
.002 w
.61413 .61178 m
.61413 .61803 L
s
P
p
.002 w
.8109 .61178 m
.8109 .61803 L
s
P
p
.001 w
.06316 .61428 m
.06316 .61803 L
s
P
p
.001 w
.10252 .61428 m
.10252 .61803 L
s
P
p
.001 w
.14187 .61428 m
.14187 .61803 L
s
P
p
.001 w
.18123 .61428 m
.18123 .61803 L
s
P
p
.001 w
.25994 .61428 m
.25994 .61803 L
s
P
p
.001 w
.29929 .61428 m
.29929 .61803 L
s
P
p
.001 w
.33865 .61428 m
.33865 .61803 L
s
P
p
.001 w
.378 .61428 m
.378 .61803 L
s
P
p
.001 w
.45671 .61428 m
.45671 .61803 L
s
P
p
.001 w
.49606 .61428 m
.49606 .61803 L
s
P
p
.001 w
.53542 .61428 m
.53542 .61803 L
s
P
p
.001 w
.57477 .61428 m
.57477 .61803 L
s
P
p
.001 w
.65348 .61428 m
.65348 .61803 L
s
P
p
.001 w
.69284 .61428 m
.69284 .61803 L
s
P
p
.001 w
.73219 .61428 m
.73219 .61803 L
s
P
p
.001 w
.77155 .61428 m
.77155 .61803 L
s
P
p
.001 w
.85026 .61428 m
.85026 .61803 L
s
P
p
.001 w
.88961 .61428 m
.88961 .61803 L
s
P
p
.001 w
.92896 .61428 m
.92896 .61803 L
s
P
p
.001 w
.96832 .61428 m
.96832 .61803 L
s
P
p
.002 w
0 .61803 m
1 .61803 L
s
P
p
.002 w
.99375 .05575 m
1 .05575 L
s
P
p
.002 w
.99375 .16526 m
1 .16526 L
s
P
p
.002 w
.99375 .27478 m
1 .27478 L
s
P
p
.002 w
.99375 .38429 m
1 .38429 L
s
P
p
.002 w
.99375 .4938 m
1 .4938 L
s
P
p
.002 w
.99375 .60332 m
1 .60332 L
s
P
p
.001 w
.99625 .01217 m
1 .01217 L
s
P
p
.001 w
.99625 .02278 m
1 .02278 L
s
P
p
.001 w
.99625 .03145 m
1 .03145 L
s
P
p
.001 w
.99625 .03879 m
1 .03879 L
s
P
p
.001 w
.99625 .04514 m
1 .04514 L
s
P
p
.001 w
.99625 .05074 m
1 .05074 L
s
P
p
.001 w
.99625 .08872 m
1 .08872 L
s
P
p
.001 w
.99625 .108 m
1 .108 L
s
P
p
.001 w
.99625 .12168 m
1 .12168 L
s
P
p
.001 w
.99625 .1323 m
1 .1323 L
s
P
p
.001 w
.99625 .14097 m
1 .14097 L
s
P
p
.001 w
.99625 .1483 m
1 .1483 L
s
P
p
.001 w
.99625 .15465 m
1 .15465 L
s
P
p
.001 w
.99625 .16025 m
1 .16025 L
s
P
p
.001 w
.99625 .19823 m
1 .19823 L
s
P
p
.001 w
.99625 .21751 m
1 .21751 L
s
P
p
.001 w
.99625 .2312 m
1 .2312 L
s
P
p
.001 w
.99625 .24181 m
1 .24181 L
s
P
p
.001 w
.99625 .25048 m
1 .25048 L
s
P
p
.001 w
.99625 .25781 m
1 .25781 L
s
P
p
.001 w
.99625 .26416 m
1 .26416 L
s
P
p
.001 w
.99625 .26977 m
1 .26977 L
s
P
p
.001 w
.99625 .30774 m
1 .30774 L
s
P
p
.001 w
.99625 .32703 m
1 .32703 L
s
P
p
.001 w
.99625 .34071 m
1 .34071 L
s
P
p
.001 w
.99625 .35132 m
1 .35132 L
s
P
p
.001 w
.99625 .36 m
1 .36 L
s
P
p
.001 w
.99625 .36733 m
1 .36733 L
s
P
p
.001 w
.99625 .37368 m
1 .37368 L
s
P
p
.001 w
.99625 .37928 m
1 .37928 L
s
P
p
.001 w
.99625 .41726 m
1 .41726 L
s
P
p
.001 w
.99625 .43654 m
1 .43654 L
s
P
p
.001 w
.99625 .45022 m
1 .45022 L
s
P
p
.001 w
.99625 .46084 m
1 .46084 L
s
P
p
.001 w
.99625 .46951 m
1 .46951 L
s
P
p
.001 w
.99625 .47684 m
1 .47684 L
s
P
p
.001 w
.99625 .48319 m
1 .48319 L
s
P
p
.001 w
.99625 .48879 m
1 .48879 L
s
P
p
.001 w
.99625 .52677 m
1 .52677 L
s
P
p
.001 w
.99625 .54606 m
1 .54606 L
s
P
p
.001 w
.99625 .55974 m
1 .55974 L
s
P
p
.001 w
.99625 .57035 m
1 .57035 L
s
P
p
.001 w
.99625 .57902 m
1 .57902 L
s
P
p
.001 w
.99625 .58635 m
1 .58635 L
s
P
p
.001 w
.99625 .59271 m
1 .59271 L
s
P
p
.001 w
.99625 .59831 m
1 .59831 L
s
P
p
.002 w
1 0 m
1 .61803 L
s
P
P
p
P
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
p
p
.6 g
p
.008 w
.02381 .53758 Mdot
.02774 .01472 Mdot
.03168 .01483 Mdot
.03562 .01503 Mdot
.03955 .01531 Mdot
.04349 .01567 Mdot
.04742 .01611 Mdot
.05136 .01663 Mdot
.05529 .01723 Mdot
.05923 .01792 Mdot
.06316 .01869 Mdot
.0671 .01954 Mdot
.07104 .02048 Mdot
.07497 .0215 Mdot
.07891 .02262 Mdot
.08284 .02382 Mdot
.08678 .02511 Mdot
.09071 .02649 Mdot
.09465 .02797 Mdot
.09858 .02955 Mdot
.10252 .03122 Mdot
.10645 .033 Mdot
.11039 .03488 Mdot
.11433 .03686 Mdot
.11826 .03896 Mdot
.1222 .04117 Mdot
.12613 .04349 Mdot
.13007 .04594 Mdot
.134 .04852 Mdot
.13794 .05123 Mdot
.14187 .05407 Mdot
.14581 .05706 Mdot
.14974 .0602 Mdot
.15368 .06349 Mdot
.15762 .06695 Mdot
.16155 .07059 Mdot
.16549 .07442 Mdot
.16942 .07844 Mdot
.17336 .08267 Mdot
.17729 .08713 Mdot
.18123 .09184 Mdot
.18516 .09681 Mdot
.1891 .10207 Mdot
.19303 .10764 Mdot
.19697 .11356 Mdot
.20091 .11987 Mdot
.20484 .1266 Mdot
.20878 .13382 Mdot
.21271 .14159 Mdot
.21665 .14998 Mdot
.22058 .15912 Mdot
.22452 .16913 Mdot
.22845 .18019 Mdot
.23239 .19255 Mdot
.23632 .20656 Mdot
.24026 .22273 Mdot
.2442 .24186 Mdot
.24813 .26536 Mdot
.25207 .29592 Mdot
.256 .34003 Mdot
.25994 .42179 Mdot
.26387 .52751 Mdot
.26781 .37569 Mdot
.27174 .3211 Mdot
.27568 .2875 Mdot
.27961 .26341 Mdot
.28355 .24481 Mdot
.28749 .22977 Mdot
.29142 .21726 Mdot
.29536 .20664 Mdot
.29929 .19749 Mdot
.30323 .18952 Mdot
.30716 .18252 Mdot
.3111 .17635 Mdot
.31503 .17088 Mdot
.31897 .16602 Mdot
.3229 .1617 Mdot
.32684 .15787 Mdot
.33078 .15447 Mdot
.33471 .15147 Mdot
.33865 .14884 Mdot
.34258 .14654 Mdot
.34652 .14457 Mdot
.35045 .14289 Mdot
.35439 .14151 Mdot
.35832 .14039 Mdot
.36226 .13953 Mdot
.36619 .13893 Mdot
.37013 .13858 Mdot
.37407 .13846 Mdot
.378 .13859 Mdot
.38194 .13895 Mdot
.38587 .13955 Mdot
.38981 .14038 Mdot
.39374 .14146 Mdot
.39768 .14277 Mdot
.40161 .14433 Mdot
.40555 .14615 Mdot
.40948 .14823 Mdot
.41342 .15058 Mdot
.41736 .15321 Mdot
.42129 .15615 Mdot
.42523 .1594 Mdot
.42916 .16299 Mdot
.4331 .16694 Mdot
.43703 .17129 Mdot
.44097 .17607 Mdot
.4449 .18133 Mdot
.44884 .18713 Mdot
.45277 .19352 Mdot
.45671 .2006 Mdot
.46065 .20847 Mdot
.46458 .21729 Mdot
.46852 .22724 Mdot
.47245 .23859 Mdot
.47639 .25171 Mdot
.48032 .26719 Mdot
.48426 .28593 Mdot
.48819 .30956 Mdot
.49213 .34136 Mdot
.49606 .38981 Mdot
.5 .49424 Mdot
.50394 .49424 Mdot
.50787 .38981 Mdot
.51181 .34136 Mdot
.51574 .30956 Mdot
.51968 .28593 Mdot
.52361 .26719 Mdot
.52755 .25171 Mdot
.53148 .23859 Mdot
.53542 .22724 Mdot
.53935 .21729 Mdot
.54329 .20847 Mdot
.54723 .2006 Mdot
.55116 .19352 Mdot
.5551 .18713 Mdot
.55903 .18133 Mdot
.56297 .17607 Mdot
.5669 .17129 Mdot
.57084 .16694 Mdot
.57477 .16299 Mdot
.57871 .1594 Mdot
.58264 .15615 Mdot
.58658 .15321 Mdot
.59052 .15058 Mdot
.59445 .14823 Mdot
.59839 .14615 Mdot
.60232 .14433 Mdot
.60626 .14277 Mdot
.61019 .14146 Mdot
.61413 .14038 Mdot
.61806 .13955 Mdot
.622 .13895 Mdot
.62593 .13859 Mdot
.62987 .13846 Mdot
.63381 .13858 Mdot
.63774 .13893 Mdot
.64168 .13953 Mdot
.64561 .14039 Mdot
.64955 .14151 Mdot
.65348 .14289 Mdot
.65742 .14457 Mdot
.66135 .14654 Mdot
.66529 .14884 Mdot
.66922 .15147 Mdot
.67316 .15447 Mdot
.6771 .15787 Mdot
.68103 .1617 Mdot
.68497 .16602 Mdot
.6889 .17088 Mdot
.69284 .17635 Mdot
.69677 .18252 Mdot
.70071 .18952 Mdot
.70464 .19749 Mdot
.70858 .20664 Mdot
.71251 .21726 Mdot
.71645 .22977 Mdot
.72039 .24481 Mdot
.72432 .26341 Mdot
.72826 .2875 Mdot
.73219 .3211 Mdot
.73613 .37569 Mdot
.74006 .52751 Mdot
.744 .42179 Mdot
.74793 .34003 Mdot
.75187 .29592 Mdot
.7558 .26536 Mdot
.75974 .24186 Mdot
.76368 .22273 Mdot
.76761 .20656 Mdot
.77155 .19255 Mdot
.77548 .18019 Mdot
.77942 .16913 Mdot
.78335 .15912 Mdot
.78729 .14998 Mdot
.79122 .14159 Mdot
.79516 .13382 Mdot
.79909 .1266 Mdot
.80303 .11987 Mdot
.80697 .11356 Mdot
.8109 .10764 Mdot
.81484 .10207 Mdot
.81877 .09681 Mdot
.82271 .09184 Mdot
.82664 .08713 Mdot
.83058 .08267 Mdot
.83451 .07844 Mdot
.83845 .07442 Mdot
.84238 .07059 Mdot
.84632 .06695 Mdot
.85026 .06349 Mdot
.85419 .0602 Mdot
.85813 .05706 Mdot
.86206 .05407 Mdot
.866 .05123 Mdot
.86993 .04852 Mdot
.87387 .04594 Mdot
.8778 .04349 Mdot
.88174 .04117 Mdot
.88567 .03896 Mdot
.88961 .03686 Mdot
.89355 .03488 Mdot
.89748 .033 Mdot
.90142 .03122 Mdot
.90535 .02955 Mdot
.90929 .02797 Mdot
.91322 .02649 Mdot
.91716 .02511 Mdot
.92109 .02382 Mdot
.92503 .02262 Mdot
.92896 .0215 Mdot
.9329 .02048 Mdot
.93684 .01954 Mdot
.94077 .01869 Mdot
.94471 .01792 Mdot
.94864 .01723 Mdot
.95258 .01663 Mdot
.95651 .01611 Mdot
.96045 .01567 Mdot
.96438 .01531 Mdot
.96832 .01503 Mdot
.97226 .01483 Mdot
.97619 .01472 Mdot
P
P
p
1 0 0 r
p
.035 w
.73613 .01472 Mdot
P
P
P
MathSubEnd
P
% End of sub-graphic
P
p
% Start of sub-graphic
p
0.0238095 0.323031 0.477324 0.603319 MathSubStart
%% Graphics
/Courier findfont 8  scalefont  setfont
% Scaling calculations
0.0238095 0.00393546 0.603319 0.109514 [
[(0)] .02381 0 0 2 Msboxa
[(50)] .22058 0 0 2 Msboxa
[(100)] .41736 0 0 2 Msboxa
[(150)] .61413 0 0 2 Msboxa
[(200)] .8109 0 0 2 Msboxa
[(0.00001)] -0.0125 .05575 1 0 Msboxa
[(0.0001)] -0.0125 .16526 1 0 Msboxa
[(0.001)] -0.0125 .27478 1 0 Msboxa
[(0.01)] -0.0125 .38429 1 0 Msboxa
[(0.1)] -0.0125 .4938 1 0 Msboxa
[(1)] -0.0125 .60332 1 0 Msboxa
[ -0.001 -0.001 0 0 ]
[ 1.001 .61903 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
[ ] 0 setdash
p
p
.002 w
.02381 0 m
.02381 .00625 L
s
P
[(0)] .02381 0 0 2 Mshowa
p
.002 w
.22058 0 m
.22058 .00625 L
s
P
[(50)] .22058 0 0 2 Mshowa
p
.002 w
.41736 0 m
.41736 .00625 L
s
P
[(100)] .41736 0 0 2 Mshowa
p
.002 w
.61413 0 m
.61413 .00625 L
s
P
[(150)] .61413 0 0 2 Mshowa
p
.002 w
.8109 0 m
.8109 .00625 L
s
P
[(200)] .8109 0 0 2 Mshowa
p
.001 w
.06316 0 m
.06316 .00375 L
s
P
p
.001 w
.10252 0 m
.10252 .00375 L
s
P
p
.001 w
.14187 0 m
.14187 .00375 L
s
P
p
.001 w
.18123 0 m
.18123 .00375 L
s
P
p
.001 w
.25994 0 m
.25994 .00375 L
s
P
p
.001 w
.29929 0 m
.29929 .00375 L
s
P
p
.001 w
.33865 0 m
.33865 .00375 L
s
P
p
.001 w
.378 0 m
.378 .00375 L
s
P
p
.001 w
.45671 0 m
.45671 .00375 L
s
P
p
.001 w
.49606 0 m
.49606 .00375 L
s
P
p
.001 w
.53542 0 m
.53542 .00375 L
s
P
p
.001 w
.57477 0 m
.57477 .00375 L
s
P
p
.001 w
.65348 0 m
.65348 .00375 L
s
P
p
.001 w
.69284 0 m
.69284 .00375 L
s
P
p
.001 w
.73219 0 m
.73219 .00375 L
s
P
p
.001 w
.77155 0 m
.77155 .00375 L
s
P
p
.001 w
.85026 0 m
.85026 .00375 L
s
P
p
.001 w
.88961 0 m
.88961 .00375 L
s
P
p
.001 w
.92896 0 m
.92896 .00375 L
s
P
p
.001 w
.96832 0 m
.96832 .00375 L
s
P
p
.002 w
0 0 m
1 0 L
s
P
p
.002 w
0 .05575 m
.00625 .05575 L
s
P
[(0.00001)] -0.0125 .05575 1 0 Mshowa
p
.002 w
0 .16526 m
.00625 .16526 L
s
P
[(0.0001)] -0.0125 .16526 1 0 Mshowa
p
.002 w
0 .27478 m
.00625 .27478 L
s
P
[(0.001)] -0.0125 .27478 1 0 Mshowa
p
.002 w
0 .38429 m
.00625 .38429 L
s
P
[(0.01)] -0.0125 .38429 1 0 Mshowa
p
.002 w
0 .4938 m
.00625 .4938 L
s
P
[(0.1)] -0.0125 .4938 1 0 Mshowa
p
.002 w
0 .60332 m
.00625 .60332 L
s
P
[(1)] -0.0125 .60332 1 0 Mshowa
p
.001 w
0 .01217 m
.00375 .01217 L
s
P
p
.001 w
0 .02278 m
.00375 .02278 L
s
P
p
.001 w
0 .03145 m
.00375 .03145 L
s
P
p
.001 w
0 .03879 m
.00375 .03879 L
s
P
p
.001 w
0 .04514 m
.00375 .04514 L
s
P
p
.001 w
0 .05074 m
.00375 .05074 L
s
P
p
.001 w
0 .08872 m
.00375 .08872 L
s
P
p
.001 w
0 .108 m
.00375 .108 L
s
P
p
.001 w
0 .12168 m
.00375 .12168 L
s
P
p
.001 w
0 .1323 m
.00375 .1323 L
s
P
p
.001 w
0 .14097 m
.00375 .14097 L
s
P
p
.001 w
0 .1483 m
.00375 .1483 L
s
P
p
.001 w
0 .15465 m
.00375 .15465 L
s
P
p
.001 w
0 .16025 m
.00375 .16025 L
s
P
p
.001 w
0 .19823 m
.00375 .19823 L
s
P
p
.001 w
0 .21751 m
.00375 .21751 L
s
P
p
.001 w
0 .2312 m
.00375 .2312 L
s
P
p
.001 w
0 .24181 m
.00375 .24181 L
s
P
p
.001 w
0 .25048 m
.00375 .25048 L
s
P
p
.001 w
0 .25781 m
.00375 .25781 L
s
P
p
.001 w
0 .26416 m
.00375 .26416 L
s
P
p
.001 w
0 .26977 m
.00375 .26977 L
s
P
p
.001 w
0 .30774 m
.00375 .30774 L
s
P
p
.001 w
0 .32703 m
.00375 .32703 L
s
P
p
.001 w
0 .34071 m
.00375 .34071 L
s
P
p
.001 w
0 .35132 m
.00375 .35132 L
s
P
p
.001 w
0 .36 m
.00375 .36 L
s
P
p
.001 w
0 .36733 m
.00375 .36733 L
s
P
p
.001 w
0 .37368 m
.00375 .37368 L
s
P
p
.001 w
0 .37928 m
.00375 .37928 L
s
P
p
.001 w
0 .41726 m
.00375 .41726 L
s
P
p
.001 w
0 .43654 m
.00375 .43654 L
s
P
p
.001 w
0 .45022 m
.00375 .45022 L
s
P
p
.001 w
0 .46084 m
.00375 .46084 L
s
P
p
.001 w
0 .46951 m
.00375 .46951 L
s
P
p
.001 w
0 .47684 m
.00375 .47684 L
s
P
p
.001 w
0 .48319 m
.00375 .48319 L
s
P
p
.001 w
0 .48879 m
.00375 .48879 L
s
P
p
.001 w
0 .52677 m
.00375 .52677 L
s
P
p
.001 w
0 .54606 m
.00375 .54606 L
s
P
p
.001 w
0 .55974 m
.00375 .55974 L
s
P
p
.001 w
0 .57035 m
.00375 .57035 L
s
P
p
.001 w
0 .57902 m
.00375 .57902 L
s
P
p
.001 w
0 .58635 m
.00375 .58635 L
s
P
p
.001 w
0 .59271 m
.00375 .59271 L
s
P
p
.001 w
0 .59831 m
.00375 .59831 L
s
P
p
.002 w
0 0 m
0 .61803 L
s
P
P
p
p
.002 w
.02381 .61178 m
.02381 .61803 L
s
P
p
.002 w
.22058 .61178 m
.22058 .61803 L
s
P
p
.002 w
.41736 .61178 m
.41736 .61803 L
s
P
p
.002 w
.61413 .61178 m
.61413 .61803 L
s
P
p
.002 w
.8109 .61178 m
.8109 .61803 L
s
P
p
.001 w
.06316 .61428 m
.06316 .61803 L
s
P
p
.001 w
.10252 .61428 m
.10252 .61803 L
s
P
p
.001 w
.14187 .61428 m
.14187 .61803 L
s
P
p
.001 w
.18123 .61428 m
.18123 .61803 L
s
P
p
.001 w
.25994 .61428 m
.25994 .61803 L
s
P
p
.001 w
.29929 .61428 m
.29929 .61803 L
s
P
p
.001 w
.33865 .61428 m
.33865 .61803 L
s
P
p
.001 w
.378 .61428 m
.378 .61803 L
s
P
p
.001 w
.45671 .61428 m
.45671 .61803 L
s
P
p
.001 w
.49606 .61428 m
.49606 .61803 L
s
P
p
.001 w
.53542 .61428 m
.53542 .61803 L
s
P
p
.001 w
.57477 .61428 m
.57477 .61803 L
s
P
p
.001 w
.65348 .61428 m
.65348 .61803 L
s
P
p
.001 w
.69284 .61428 m
.69284 .61803 L
s
P
p
.001 w
.73219 .61428 m
.73219 .61803 L
s
P
p
.001 w
.77155 .61428 m
.77155 .61803 L
s
P
p
.001 w
.85026 .61428 m
.85026 .61803 L
s
P
p
.001 w
.88961 .61428 m
.88961 .61803 L
s
P
p
.001 w
.92896 .61428 m
.92896 .61803 L
s
P
p
.001 w
.96832 .61428 m
.96832 .61803 L
s
P
p
.002 w
0 .61803 m
1 .61803 L
s
P
p
.002 w
.99375 .05575 m
1 .05575 L
s
P
p
.002 w
.99375 .16526 m
1 .16526 L
s
P
p
.002 w
.99375 .27478 m
1 .27478 L
s
P
p
.002 w
.99375 .38429 m
1 .38429 L
s
P
p
.002 w
.99375 .4938 m
1 .4938 L
s
P
p
.002 w
.99375 .60332 m
1 .60332 L
s
P
p
.001 w
.99625 .01217 m
1 .01217 L
s
P
p
.001 w
.99625 .02278 m
1 .02278 L
s
P
p
.001 w
.99625 .03145 m
1 .03145 L
s
P
p
.001 w
.99625 .03879 m
1 .03879 L
s
P
p
.001 w
.99625 .04514 m
1 .04514 L
s
P
p
.001 w
.99625 .05074 m
1 .05074 L
s
P
p
.001 w
.99625 .08872 m
1 .08872 L
s
P
p
.001 w
.99625 .108 m
1 .108 L
s
P
p
.001 w
.99625 .12168 m
1 .12168 L
s
P
p
.001 w
.99625 .1323 m
1 .1323 L
s
P
p
.001 w
.99625 .14097 m
1 .14097 L
s
P
p
.001 w
.99625 .1483 m
1 .1483 L
s
P
p
.001 w
.99625 .15465 m
1 .15465 L
s
P
p
.001 w
.99625 .16025 m
1 .16025 L
s
P
p
.001 w
.99625 .19823 m
1 .19823 L
s
P
p
.001 w
.99625 .21751 m
1 .21751 L
s
P
p
.001 w
.99625 .2312 m
1 .2312 L
s
P
p
.001 w
.99625 .24181 m
1 .24181 L
s
P
p
.001 w
.99625 .25048 m
1 .25048 L
s
P
p
.001 w
.99625 .25781 m
1 .25781 L
s
P
p
.001 w
.99625 .26416 m
1 .26416 L
s
P
p
.001 w
.99625 .26977 m
1 .26977 L
s
P
p
.001 w
.99625 .30774 m
1 .30774 L
s
P
p
.001 w
.99625 .32703 m
1 .32703 L
s
P
p
.001 w
.99625 .34071 m
1 .34071 L
s
P
p
.001 w
.99625 .35132 m
1 .35132 L
s
P
p
.001 w
.99625 .36 m
1 .36 L
s
P
p
.001 w
.99625 .36733 m
1 .36733 L
s
P
p
.001 w
.99625 .37368 m
1 .37368 L
s
P
p
.001 w
.99625 .37928 m
1 .37928 L
s
P
p
.001 w
.99625 .41726 m
1 .41726 L
s
P
p
.001 w
.99625 .43654 m
1 .43654 L
s
P
p
.001 w
.99625 .45022 m
1 .45022 L
s
P
p
.001 w
.99625 .46084 m
1 .46084 L
s
P
p
.001 w
.99625 .46951 m
1 .46951 L
s
P
p
.001 w
.99625 .47684 m
1 .47684 L
s
P
p
.001 w
.99625 .48319 m
1 .48319 L
s
P
p
.001 w
.99625 .48879 m
1 .48879 L
s
P
p
.001 w
.99625 .52677 m
1 .52677 L
s
P
p
.001 w
.99625 .54606 m
1 .54606 L
s
P
p
.001 w
.99625 .55974 m
1 .55974 L
s
P
p
.001 w
.99625 .57035 m
1 .57035 L
s
P
p
.001 w
.99625 .57902 m
1 .57902 L
s
P
p
.001 w
.99625 .58635 m
1 .58635 L
s
P
p
.001 w
.99625 .59271 m
1 .59271 L
s
P
p
.001 w
.99625 .59831 m
1 .59831 L
s
P
p
.002 w
1 0 m
1 .61803 L
s
P
P
p
P
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
p
p
.6 g
p
.008 w
.02381 .53758 Mdot
.02774 .01472 Mdot
.03168 .01483 Mdot
.03562 .01503 Mdot
.03955 .01531 Mdot
.04349 .01567 Mdot
.04742 .01611 Mdot
.05136 .01663 Mdot
.05529 .01723 Mdot
.05923 .01792 Mdot
.06316 .01869 Mdot
.0671 .01954 Mdot
.07104 .02048 Mdot
.07497 .0215 Mdot
.07891 .02262 Mdot
.08284 .02382 Mdot
.08678 .02511 Mdot
.09071 .02649 Mdot
.09465 .02797 Mdot
.09858 .02955 Mdot
.10252 .03122 Mdot
.10645 .033 Mdot
.11039 .03488 Mdot
.11433 .03686 Mdot
.11826 .03896 Mdot
.1222 .04117 Mdot
.12613 .04349 Mdot
.13007 .04594 Mdot
.134 .04852 Mdot
.13794 .05123 Mdot
.14187 .05407 Mdot
.14581 .05706 Mdot
.14974 .0602 Mdot
.15368 .06349 Mdot
.15762 .06695 Mdot
.16155 .07059 Mdot
.16549 .07442 Mdot
.16942 .07844 Mdot
.17336 .08267 Mdot
.17729 .08713 Mdot
.18123 .09184 Mdot
.18516 .09681 Mdot
.1891 .10207 Mdot
.19303 .10764 Mdot
.19697 .11356 Mdot
.20091 .11987 Mdot
.20484 .1266 Mdot
.20878 .13382 Mdot
.21271 .14159 Mdot
.21665 .14998 Mdot
.22058 .15912 Mdot
.22452 .16913 Mdot
.22845 .18019 Mdot
.23239 .19255 Mdot
.23632 .20656 Mdot
.24026 .22273 Mdot
.2442 .24186 Mdot
.24813 .26536 Mdot
.25207 .29592 Mdot
.256 .34003 Mdot
.25994 .42179 Mdot
.26387 .52751 Mdot
.26781 .37569 Mdot
.27174 .3211 Mdot
.27568 .2875 Mdot
.27961 .26341 Mdot
.28355 .24481 Mdot
.28749 .22977 Mdot
.29142 .21726 Mdot
.29536 .20664 Mdot
.29929 .19749 Mdot
.30323 .18952 Mdot
.30716 .18252 Mdot
.3111 .17635 Mdot
.31503 .17088 Mdot
.31897 .16602 Mdot
.3229 .1617 Mdot
.32684 .15787 Mdot
.33078 .15447 Mdot
.33471 .15147 Mdot
.33865 .14884 Mdot
.34258 .14654 Mdot
.34652 .14457 Mdot
.35045 .14289 Mdot
.35439 .14151 Mdot
.35832 .14039 Mdot
.36226 .13953 Mdot
.36619 .13893 Mdot
.37013 .13858 Mdot
.37407 .13846 Mdot
.378 .13859 Mdot
.38194 .13895 Mdot
.38587 .13955 Mdot
.38981 .14038 Mdot
.39374 .14146 Mdot
.39768 .14277 Mdot
.40161 .14433 Mdot
.40555 .14615 Mdot
.40948 .14823 Mdot
.41342 .15058 Mdot
.41736 .15321 Mdot
.42129 .15615 Mdot
.42523 .1594 Mdot
.42916 .16299 Mdot
.4331 .16694 Mdot
.43703 .17129 Mdot
.44097 .17607 Mdot
.4449 .18133 Mdot
.44884 .18713 Mdot
.45277 .19352 Mdot
.45671 .2006 Mdot
.46065 .20847 Mdot
.46458 .21729 Mdot
.46852 .22724 Mdot
.47245 .23859 Mdot
.47639 .25171 Mdot
.48032 .26719 Mdot
.48426 .28593 Mdot
.48819 .30956 Mdot
.49213 .34136 Mdot
.49606 .38981 Mdot
.5 .49424 Mdot
.50394 .49424 Mdot
.50787 .38981 Mdot
.51181 .34136 Mdot
.51574 .30956 Mdot
.51968 .28593 Mdot
.52361 .26719 Mdot
.52755 .25171 Mdot
.53148 .23859 Mdot
.53542 .22724 Mdot
.53935 .21729 Mdot
.54329 .20847 Mdot
.54723 .2006 Mdot
.55116 .19352 Mdot
.5551 .18713 Mdot
.55903 .18133 Mdot
.56297 .17607 Mdot
.5669 .17129 Mdot
.57084 .16694 Mdot
.57477 .16299 Mdot
.57871 .1594 Mdot
.58264 .15615 Mdot
.58658 .15321 Mdot
.59052 .15058 Mdot
.59445 .14823 Mdot
.59839 .14615 Mdot
.60232 .14433 Mdot
.60626 .14277 Mdot
.61019 .14146 Mdot
.61413 .14038 Mdot
.61806 .13955 Mdot
.622 .13895 Mdot
.62593 .13859 Mdot
.62987 .13846 Mdot
.63381 .13858 Mdot
.63774 .13893 Mdot
.64168 .13953 Mdot
.64561 .14039 Mdot
.64955 .14151 Mdot
.65348 .14289 Mdot
.65742 .14457 Mdot
.66135 .14654 Mdot
.66529 .14884 Mdot
.66922 .15147 Mdot
.67316 .15447 Mdot
.6771 .15787 Mdot
.68103 .1617 Mdot
.68497 .16602 Mdot
.6889 .17088 Mdot
.69284 .17635 Mdot
.69677 .18252 Mdot
.70071 .18952 Mdot
.70464 .19749 Mdot
.70858 .20664 Mdot
.71251 .21726 Mdot
.71645 .22977 Mdot
.72039 .24481 Mdot
.72432 .26341 Mdot
.72826 .2875 Mdot
.73219 .3211 Mdot
.73613 .37569 Mdot
.74006 .52751 Mdot
.744 .42179 Mdot
.74793 .34003 Mdot
.75187 .29592 Mdot
.7558 .26536 Mdot
.75974 .24186 Mdot
.76368 .22273 Mdot
.76761 .20656 Mdot
.77155 .19255 Mdot
.77548 .18019 Mdot
.77942 .16913 Mdot
.78335 .15912 Mdot
.78729 .14998 Mdot
.79122 .14159 Mdot
.79516 .13382 Mdot
.79909 .1266 Mdot
.80303 .11987 Mdot
.80697 .11356 Mdot
.8109 .10764 Mdot
.81484 .10207 Mdot
.81877 .09681 Mdot
.82271 .09184 Mdot
.82664 .08713 Mdot
.83058 .08267 Mdot
.83451 .07844 Mdot
.83845 .07442 Mdot
.84238 .07059 Mdot
.84632 .06695 Mdot
.85026 .06349 Mdot
.85419 .0602 Mdot
.85813 .05706 Mdot
.86206 .05407 Mdot
.866 .05123 Mdot
.86993 .04852 Mdot
.87387 .04594 Mdot
.8778 .04349 Mdot
.88174 .04117 Mdot
.88567 .03896 Mdot
.88961 .03686 Mdot
.89355 .03488 Mdot
.89748 .033 Mdot
.90142 .03122 Mdot
.90535 .02955 Mdot
.90929 .02797 Mdot
.91322 .02649 Mdot
.91716 .02511 Mdot
.92109 .02382 Mdot
.92503 .02262 Mdot
.92896 .0215 Mdot
.9329 .02048 Mdot
.93684 .01954 Mdot
.94077 .01869 Mdot
.94471 .01792 Mdot
.94864 .01723 Mdot
.95258 .01663 Mdot
.95651 .01611 Mdot
.96045 .01567 Mdot
.96438 .01531 Mdot
.96832 .01503 Mdot
.97226 .01483 Mdot
.97619 .01472 Mdot
P
P
p
1 0 0 r
p
.035 w
.256 .01472 Mdot
P
P
P
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.522676 0.323031 0.97619 0.603319 MathSubStart
%% Graphics
/Courier findfont 8  scalefont  setfont
% Scaling calculations
0.0238095 0.00393546 0.603319 0.109514 [
[(0)] .02381 0 0 2 Msboxa
[(50)] .22058 0 0 2 Msboxa
[(100)] .41736 0 0 2 Msboxa
[(150)] .61413 0 0 2 Msboxa
[(200)] .8109 0 0 2 Msboxa
[(0.00001)] -0.0125 .05575 1 0 Msboxa
[(0.0001)] -0.0125 .16526 1 0 Msboxa
[(0.001)] -0.0125 .27478 1 0 Msboxa
[(0.01)] -0.0125 .38429 1 0 Msboxa
[(0.1)] -0.0125 .4938 1 0 Msboxa
[(1)] -0.0125 .60332 1 0 Msboxa
[ -0.001 -0.001 0 0 ]
[ 1.001 .61903 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
[ ] 0 setdash
p
p
.002 w
.02381 0 m
.02381 .00625 L
s
P
[(0)] .02381 0 0 2 Mshowa
p
.002 w
.22058 0 m
.22058 .00625 L
s
P
[(50)] .22058 0 0 2 Mshowa
p
.002 w
.41736 0 m
.41736 .00625 L
s
P
[(100)] .41736 0 0 2 Mshowa
p
.002 w
.61413 0 m
.61413 .00625 L
s
P
[(150)] .61413 0 0 2 Mshowa
p
.002 w
.8109 0 m
.8109 .00625 L
s
P
[(200)] .8109 0 0 2 Mshowa
p
.001 w
.06316 0 m
.06316 .00375 L
s
P
p
.001 w
.10252 0 m
.10252 .00375 L
s
P
p
.001 w
.14187 0 m
.14187 .00375 L
s
P
p
.001 w
.18123 0 m
.18123 .00375 L
s
P
p
.001 w
.25994 0 m
.25994 .00375 L
s
P
p
.001 w
.29929 0 m
.29929 .00375 L
s
P
p
.001 w
.33865 0 m
.33865 .00375 L
s
P
p
.001 w
.378 0 m
.378 .00375 L
s
P
p
.001 w
.45671 0 m
.45671 .00375 L
s
P
p
.001 w
.49606 0 m
.49606 .00375 L
s
P
p
.001 w
.53542 0 m
.53542 .00375 L
s
P
p
.001 w
.57477 0 m
.57477 .00375 L
s
P
p
.001 w
.65348 0 m
.65348 .00375 L
s
P
p
.001 w
.69284 0 m
.69284 .00375 L
s
P
p
.001 w
.73219 0 m
.73219 .00375 L
s
P
p
.001 w
.77155 0 m
.77155 .00375 L
s
P
p
.001 w
.85026 0 m
.85026 .00375 L
s
P
p
.001 w
.88961 0 m
.88961 .00375 L
s
P
p
.001 w
.92896 0 m
.92896 .00375 L
s
P
p
.001 w
.96832 0 m
.96832 .00375 L
s
P
p
.002 w
0 0 m
1 0 L
s
P
p
.002 w
0 .05575 m
.00625 .05575 L
s
P
[(0.00001)] -0.0125 .05575 1 0 Mshowa
p
.002 w
0 .16526 m
.00625 .16526 L
s
P
[(0.0001)] -0.0125 .16526 1 0 Mshowa
p
.002 w
0 .27478 m
.00625 .27478 L
s
P
[(0.001)] -0.0125 .27478 1 0 Mshowa
p
.002 w
0 .38429 m
.00625 .38429 L
s
P
[(0.01)] -0.0125 .38429 1 0 Mshowa
p
.002 w
0 .4938 m
.00625 .4938 L
s
P
[(0.1)] -0.0125 .4938 1 0 Mshowa
p
.002 w
0 .60332 m
.00625 .60332 L
s
P
[(1)] -0.0125 .60332 1 0 Mshowa
p
.001 w
0 .01217 m
.00375 .01217 L
s
P
p
.001 w
0 .02278 m
.00375 .02278 L
s
P
p
.001 w
0 .03145 m
.00375 .03145 L
s
P
p
.001 w
0 .03879 m
.00375 .03879 L
s
P
p
.001 w
0 .04514 m
.00375 .04514 L
s
P
p
.001 w
0 .05074 m
.00375 .05074 L
s
P
p
.001 w
0 .08872 m
.00375 .08872 L
s
P
p
.001 w
0 .108 m
.00375 .108 L
s
P
p
.001 w
0 .12168 m
.00375 .12168 L
s
P
p
.001 w
0 .1323 m
.00375 .1323 L
s
P
p
.001 w
0 .14097 m
.00375 .14097 L
s
P
p
.001 w
0 .1483 m
.00375 .1483 L
s
P
p
.001 w
0 .15465 m
.00375 .15465 L
s
P
p
.001 w
0 .16025 m
.00375 .16025 L
s
P
p
.001 w
0 .19823 m
.00375 .19823 L
s
P
p
.001 w
0 .21751 m
.00375 .21751 L
s
P
p
.001 w
0 .2312 m
.00375 .2312 L
s
P
p
.001 w
0 .24181 m
.00375 .24181 L
s
P
p
.001 w
0 .25048 m
.00375 .25048 L
s
P
p
.001 w
0 .25781 m
.00375 .25781 L
s
P
p
.001 w
0 .26416 m
.00375 .26416 L
s
P
p
.001 w
0 .26977 m
.00375 .26977 L
s
P
p
.001 w
0 .30774 m
.00375 .30774 L
s
P
p
.001 w
0 .32703 m
.00375 .32703 L
s
P
p
.001 w
0 .34071 m
.00375 .34071 L
s
P
p
.001 w
0 .35132 m
.00375 .35132 L
s
P
p
.001 w
0 .36 m
.00375 .36 L
s
P
p
.001 w
0 .36733 m
.00375 .36733 L
s
P
p
.001 w
0 .37368 m
.00375 .37368 L
s
P
p
.001 w
0 .37928 m
.00375 .37928 L
s
P
p
.001 w
0 .41726 m
.00375 .41726 L
s
P
p
.001 w
0 .43654 m
.00375 .43654 L
s
P
p
.001 w
0 .45022 m
.00375 .45022 L
s
P
p
.001 w
0 .46084 m
.00375 .46084 L
s
P
p
.001 w
0 .46951 m
.00375 .46951 L
s
P
p
.001 w
0 .47684 m
.00375 .47684 L
s
P
p
.001 w
0 .48319 m
.00375 .48319 L
s
P
p
.001 w
0 .48879 m
.00375 .48879 L
s
P
p
.001 w
0 .52677 m
.00375 .52677 L
s
P
p
.001 w
0 .54606 m
.00375 .54606 L
s
P
p
.001 w
0 .55974 m
.00375 .55974 L
s
P
p
.001 w
0 .57035 m
.00375 .57035 L
s
P
p
.001 w
0 .57902 m
.00375 .57902 L
s
P
p
.001 w
0 .58635 m
.00375 .58635 L
s
P
p
.001 w
0 .59271 m
.00375 .59271 L
s
P
p
.001 w
0 .59831 m
.00375 .59831 L
s
P
p
.002 w
0 0 m
0 .61803 L
s
P
P
p
p
.002 w
.02381 .61178 m
.02381 .61803 L
s
P
p
.002 w
.22058 .61178 m
.22058 .61803 L
s
P
p
.002 w
.41736 .61178 m
.41736 .61803 L
s
P
p
.002 w
.61413 .61178 m
.61413 .61803 L
s
P
p
.002 w
.8109 .61178 m
.8109 .61803 L
s
P
p
.001 w
.06316 .61428 m
.06316 .61803 L
s
P
p
.001 w
.10252 .61428 m
.10252 .61803 L
s
P
p
.001 w
.14187 .61428 m
.14187 .61803 L
s
P
p
.001 w
.18123 .61428 m
.18123 .61803 L
s
P
p
.001 w
.25994 .61428 m
.25994 .61803 L
s
P
p
.001 w
.29929 .61428 m
.29929 .61803 L
s
P
p
.001 w
.33865 .61428 m
.33865 .61803 L
s
P
p
.001 w
.378 .61428 m
.378 .61803 L
s
P
p
.001 w
.45671 .61428 m
.45671 .61803 L
s
P
p
.001 w
.49606 .61428 m
.49606 .61803 L
s
P
p
.001 w
.53542 .61428 m
.53542 .61803 L
s
P
p
.001 w
.57477 .61428 m
.57477 .61803 L
s
P
p
.001 w
.65348 .61428 m
.65348 .61803 L
s
P
p
.001 w
.69284 .61428 m
.69284 .61803 L
s
P
p
.001 w
.73219 .61428 m
.73219 .61803 L
s
P
p
.001 w
.77155 .61428 m
.77155 .61803 L
s
P
p
.001 w
.85026 .61428 m
.85026 .61803 L
s
P
p
.001 w
.88961 .61428 m
.88961 .61803 L
s
P
p
.001 w
.92896 .61428 m
.92896 .61803 L
s
P
p
.001 w
.96832 .61428 m
.96832 .61803 L
s
P
p
.002 w
0 .61803 m
1 .61803 L
s
P
p
.002 w
.99375 .05575 m
1 .05575 L
s
P
p
.002 w
.99375 .16526 m
1 .16526 L
s
P
p
.002 w
.99375 .27478 m
1 .27478 L
s
P
p
.002 w
.99375 .38429 m
1 .38429 L
s
P
p
.002 w
.99375 .4938 m
1 .4938 L
s
P
p
.002 w
.99375 .60332 m
1 .60332 L
s
P
p
.001 w
.99625 .01217 m
1 .01217 L
s
P
p
.001 w
.99625 .02278 m
1 .02278 L
s
P
p
.001 w
.99625 .03145 m
1 .03145 L
s
P
p
.001 w
.99625 .03879 m
1 .03879 L
s
P
p
.001 w
.99625 .04514 m
1 .04514 L
s
P
p
.001 w
.99625 .05074 m
1 .05074 L
s
P
p
.001 w
.99625 .08872 m
1 .08872 L
s
P
p
.001 w
.99625 .108 m
1 .108 L
s
P
p
.001 w
.99625 .12168 m
1 .12168 L
s
P
p
.001 w
.99625 .1323 m
1 .1323 L
s
P
p
.001 w
.99625 .14097 m
1 .14097 L
s
P
p
.001 w
.99625 .1483 m
1 .1483 L
s
P
p
.001 w
.99625 .15465 m
1 .15465 L
s
P
p
.001 w
.99625 .16025 m
1 .16025 L
s
P
p
.001 w
.99625 .19823 m
1 .19823 L
s
P
p
.001 w
.99625 .21751 m
1 .21751 L
s
P
p
.001 w
.99625 .2312 m
1 .2312 L
s
P
p
.001 w
.99625 .24181 m
1 .24181 L
s
P
p
.001 w
.99625 .25048 m
1 .25048 L
s
P
p
.001 w
.99625 .25781 m
1 .25781 L
s
P
p
.001 w
.99625 .26416 m
1 .26416 L
s
P
p
.001 w
.99625 .26977 m
1 .26977 L
s
P
p
.001 w
.99625 .30774 m
1 .30774 L
s
P
p
.001 w
.99625 .32703 m
1 .32703 L
s
P
p
.001 w
.99625 .34071 m
1 .34071 L
s
P
p
.001 w
.99625 .35132 m
1 .35132 L
s
P
p
.001 w
.99625 .36 m
1 .36 L
s
P
p
.001 w
.99625 .36733 m
1 .36733 L
s
P
p
.001 w
.99625 .37368 m
1 .37368 L
s
P
p
.001 w
.99625 .37928 m
1 .37928 L
s
P
p
.001 w
.99625 .41726 m
1 .41726 L
s
P
p
.001 w
.99625 .43654 m
1 .43654 L
s
P
p
.001 w
.99625 .45022 m
1 .45022 L
s
P
p
.001 w
.99625 .46084 m
1 .46084 L
s
P
p
.001 w
.99625 .46951 m
1 .46951 L
s
P
p
.001 w
.99625 .47684 m
1 .47684 L
s
P
p
.001 w
.99625 .48319 m
1 .48319 L
s
P
p
.001 w
.99625 .48879 m
1 .48879 L
s
P
p
.001 w
.99625 .52677 m
1 .52677 L
s
P
p
.001 w
.99625 .54606 m
1 .54606 L
s
P
p
.001 w
.99625 .55974 m
1 .55974 L
s
P
p
.001 w
.99625 .57035 m
1 .57035 L
s
P
p
.001 w
.99625 .57902 m
1 .57902 L
s
P
p
.001 w
.99625 .58635 m
1 .58635 L
s
P
p
.001 w
.99625 .59271 m
1 .59271 L
s
P
p
.001 w
.99625 .59831 m
1 .59831 L
s
P
p
.002 w
1 0 m
1 .61803 L
s
P
P
p
P
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
p
p
.6 g
p
.008 w
.02381 .53758 Mdot
.02774 .01472 Mdot
.03168 .01483 Mdot
.03562 .01503 Mdot
.03955 .01531 Mdot
.04349 .01567 Mdot
.04742 .01611 Mdot
.05136 .01663 Mdot
.05529 .01723 Mdot
.05923 .01792 Mdot
.06316 .01869 Mdot
.0671 .01954 Mdot
.07104 .02048 Mdot
.07497 .0215 Mdot
.07891 .02262 Mdot
.08284 .02382 Mdot
.08678 .02511 Mdot
.09071 .02649 Mdot
.09465 .02797 Mdot
.09858 .02955 Mdot
.10252 .03122 Mdot
.10645 .033 Mdot
.11039 .03488 Mdot
.11433 .03686 Mdot
.11826 .03896 Mdot
.1222 .04117 Mdot
.12613 .04349 Mdot
.13007 .04594 Mdot
.134 .04852 Mdot
.13794 .05123 Mdot
.14187 .05407 Mdot
.14581 .05706 Mdot
.14974 .0602 Mdot
.15368 .06349 Mdot
.15762 .06695 Mdot
.16155 .07059 Mdot
.16549 .07442 Mdot
.16942 .07844 Mdot
.17336 .08267 Mdot
.17729 .08713 Mdot
.18123 .09184 Mdot
.18516 .09681 Mdot
.1891 .10207 Mdot
.19303 .10764 Mdot
.19697 .11356 Mdot
.20091 .11987 Mdot
.20484 .1266 Mdot
.20878 .13382 Mdot
.21271 .14159 Mdot
.21665 .14998 Mdot
.22058 .15912 Mdot
.22452 .16913 Mdot
.22845 .18019 Mdot
.23239 .19255 Mdot
.23632 .20656 Mdot
.24026 .22273 Mdot
.2442 .24186 Mdot
.24813 .26536 Mdot
.25207 .29592 Mdot
.256 .34003 Mdot
.25994 .42179 Mdot
.26387 .52751 Mdot
.26781 .37569 Mdot
.27174 .3211 Mdot
.27568 .2875 Mdot
.27961 .26341 Mdot
.28355 .24481 Mdot
.28749 .22977 Mdot
.29142 .21726 Mdot
.29536 .20664 Mdot
.29929 .19749 Mdot
.30323 .18952 Mdot
.30716 .18252 Mdot
.3111 .17635 Mdot
.31503 .17088 Mdot
.31897 .16602 Mdot
.3229 .1617 Mdot
.32684 .15787 Mdot
.33078 .15447 Mdot
.33471 .15147 Mdot
.33865 .14884 Mdot
.34258 .14654 Mdot
.34652 .14457 Mdot
.35045 .14289 Mdot
.35439 .14151 Mdot
.35832 .14039 Mdot
.36226 .13953 Mdot
.36619 .13893 Mdot
.37013 .13858 Mdot
.37407 .13846 Mdot
.378 .13859 Mdot
.38194 .13895 Mdot
.38587 .13955 Mdot
.38981 .14038 Mdot
.39374 .14146 Mdot
.39768 .14277 Mdot
.40161 .14433 Mdot
.40555 .14615 Mdot
.40948 .14823 Mdot
.41342 .15058 Mdot
.41736 .15321 Mdot
.42129 .15615 Mdot
.42523 .1594 Mdot
.42916 .16299 Mdot
.4331 .16694 Mdot
.43703 .17129 Mdot
.44097 .17607 Mdot
.4449 .18133 Mdot
.44884 .18713 Mdot
.45277 .19352 Mdot
.45671 .2006 Mdot
.46065 .20847 Mdot
.46458 .21729 Mdot
.46852 .22724 Mdot
.47245 .23859 Mdot
.47639 .25171 Mdot
.48032 .26719 Mdot
.48426 .28593 Mdot
.48819 .30956 Mdot
.49213 .34136 Mdot
.49606 .38981 Mdot
.5 .49424 Mdot
.50394 .49424 Mdot
.50787 .38981 Mdot
.51181 .34136 Mdot
.51574 .30956 Mdot
.51968 .28593 Mdot
.52361 .26719 Mdot
.52755 .25171 Mdot
.53148 .23859 Mdot
.53542 .22724 Mdot
.53935 .21729 Mdot
.54329 .20847 Mdot
.54723 .2006 Mdot
.55116 .19352 Mdot
.5551 .18713 Mdot
.55903 .18133 Mdot
.56297 .17607 Mdot
.5669 .17129 Mdot
.57084 .16694 Mdot
.57477 .16299 Mdot
.57871 .1594 Mdot
.58264 .15615 Mdot
.58658 .15321 Mdot
.59052 .15058 Mdot
.59445 .14823 Mdot
.59839 .14615 Mdot
.60232 .14433 Mdot
.60626 .14277 Mdot
.61019 .14146 Mdot
.61413 .14038 Mdot
.61806 .13955 Mdot
.622 .13895 Mdot
.62593 .13859 Mdot
.62987 .13846 Mdot
.63381 .13858 Mdot
.63774 .13893 Mdot
.64168 .13953 Mdot
.64561 .14039 Mdot
.64955 .14151 Mdot
.65348 .14289 Mdot
.65742 .14457 Mdot
.66135 .14654 Mdot
.66529 .14884 Mdot
.66922 .15147 Mdot
.67316 .15447 Mdot
.6771 .15787 Mdot
.68103 .1617 Mdot
.68497 .16602 Mdot
.6889 .17088 Mdot
.69284 .17635 Mdot
.69677 .18252 Mdot
.70071 .18952 Mdot
.70464 .19749 Mdot
.70858 .20664 Mdot
.71251 .21726 Mdot
.71645 .22977 Mdot
.72039 .24481 Mdot
.72432 .26341 Mdot
.72826 .2875 Mdot
.73219 .3211 Mdot
.73613 .37569 Mdot
.74006 .52751 Mdot
.744 .42179 Mdot
.74793 .34003 Mdot
.75187 .29592 Mdot
.7558 .26536 Mdot
.75974 .24186 Mdot
.76368 .22273 Mdot
.76761 .20656 Mdot
.77155 .19255 Mdot
.77548 .18019 Mdot
.77942 .16913 Mdot
.78335 .15912 Mdot
.78729 .14998 Mdot
.79122 .14159 Mdot
.79516 .13382 Mdot
.79909 .1266 Mdot
.80303 .11987 Mdot
.80697 .11356 Mdot
.8109 .10764 Mdot
.81484 .10207 Mdot
.81877 .09681 Mdot
.82271 .09184 Mdot
.82664 .08713 Mdot
.83058 .08267 Mdot
.83451 .07844 Mdot
.83845 .07442 Mdot
.84238 .07059 Mdot
.84632 .06695 Mdot
.85026 .06349 Mdot
.85419 .0602 Mdot
.85813 .05706 Mdot
.86206 .05407 Mdot
.866 .05123 Mdot
.86993 .04852 Mdot
.87387 .04594 Mdot
.8778 .04349 Mdot
.88174 .04117 Mdot
.88567 .03896 Mdot
.88961 .03686 Mdot
.89355 .03488 Mdot
.89748 .033 Mdot
.90142 .03122 Mdot
.90535 .02955 Mdot
.90929 .02797 Mdot
.91322 .02649 Mdot
.91716 .02511 Mdot
.92109 .02382 Mdot
.92503 .02262 Mdot
.92896 .0215 Mdot
.9329 .02048 Mdot
.93684 .01954 Mdot
.94077 .01869 Mdot
.94471 .01792 Mdot
.94864 .01723 Mdot
.95258 .01663 Mdot
.95651 .01611 Mdot
.96045 .01567 Mdot
.96438 .01531 Mdot
.96832 .01503 Mdot
.97226 .01483 Mdot
.97619 .01472 Mdot
P
P
p
1 0 0 r
p
.035 w
.25994 .01472 Mdot
P
P
P
MathSubEnd
P
% End of sub-graphic
P
P
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  Evaluatable->False,
  AspectRatioFixed->True,
  ImageSize->{282, 174},
  ImageMargins->{{34, Inherited}, {Inherited, Inherited}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004J0000[Q000`40O003h00Oogoo6goo003oOolK
Ool00?mooa]oo`00ogoo6goo003oOolKOol00?mooa]oo`00ogoo6goo003oOolKOol00?mooa]oo`00
ogoo6goo000oOol00`00Oomoo`08Ool30003Ool00`00Oomoo`03Ool30003Ool00`00Oomoo`02Ool0
0`00Oomoo`030002Ool30003Ool00`00Oomoo`030003Ool00`00Oomoo`02Ool00`00Oomoo`0eOol0
0`00Oomoo`08Ool30003Ool00`00Oomoo`03Ool30003Ool00`00Oomoo`02Ool01000Oomoogoo0`00
0Woo0`000goo00<007ooOol00`000goo00<007ooOol00Woo00<007ooOol08goo000nOol00`00Ool0
000;Ool01P00Oomoo`00Ool000Eoo`07001oogooOol007oo00000Woo00<007oo00000Woo00<007oo
Ool00goo00H007ooOol007oo0002Ool01`00Oomoogoo001oo`00009oo`03001oo`0003Eoo`03001o
o`0000]oo`06001oogoo001oo`001Goo00L007ooOomoo`00Ool00002Ool00`00Ool00003Ool00`00
Oomoo`03Ool01P00Oomoo`00Ool0009oo`07001oogooOol007oo00000Woo00<007oo000097oo000n
Ool00`00Ool00009Ool30002Ool00`00Ool00005Ool01`00Oomoogoo001oo`00009oo`03001oo`00
009oo`04001oogooOol30002Ool00`00Ool00003Ool01P00Oomoo`00Ool0009oo`03001oo`0003Eo
o`03001oo`0000Uoo`<0009oo`03001oo`0000Eoo`07001oogooOol007oo00000Woo00<007oo0000
0goo00@007ooOomoo`<0009oo`03001oo`0000=oo`06001oogoo001oo`000Woo00<007oo000097oo
000nOol00`00Ool00009Ool00`00Oomoo`02Ool00`00Ool00005Ool01`00Oomoogoo001oo`00009o
o`03001oo`00009oo`05001oogooOol00004Ool00`00Ool00003Ool01P00Oomoo`00Ool0009oo`03
001oo`0003Eoo`03001oo`0000Uoo`03001oogoo009oo`03001oo`0000Eoo`07001oogooOol007oo
00000Woo00<007oo00000goo00D007ooOomoo`0000Aoo`03001oo`0000=oo`06001oogoo001oo`00
0Woo00<007oo000097oo000oOol00`00Oomoo`08Ool30003Ool00`00Oomoo`03Ool20004Ool00`00
Oomoo`02Ool00`00Oomoo`020003Ool30003Ool00`00Oomoo`030003Ool00`00Oomoo`02Ool00`00
Oomoo`0eOol00`00Oomoo`08Ool30003Ool00`00Oomoo`03Ool20004Ool00`00Oomoo`02Ool01000
Oomoogoo0P000goo0`000goo00<007ooOol00`000goo00<007ooOol00Woo00<007ooOol08goo003o
OolKOol00?mooa]oo`00ogoo6goo003oOolKOol003eoodX002eoodX001aoo`00?Goo0`0014ic00Eo
o`00Oomoo`00009oo`03001oo`00009oo`04001oogoo0002Ool01000Oomoo`000Woo00D007ooOol0
07oo009l0005Ool007ooOol00002Ool01000Oomoo`000Woo00@007ooOol0009oo`04001oogoo0002
Ool00`00Ool00002Ool00`00CW=>L`02CW<00`00Oomoo`0[Ool00`00Oom>L`03CW<01Goo001oogoo
00000Woo00@007ooOol0009oo`04001oogoo0002Ool01P00Oomoo`00Ool0009oo`04001oogoo0002
Ool01000Oomoo`000Woo00@007ooOol0009oo`06001oog`0O01oo`000Woo00@007ooOol0009oo`03
001oogoo00E>L`03001oogoo01Yoo`00?Goo0P0017oo0dic6goo0W`077oo14ic0goo00<007ooOol0
:goo00<007ooOol00goo0dic;7oo0W`02goo0dic17oo00<007ooOol06Woo000MOol00`00Oomoo`02
Ool00`00Oomoo`02Ool01@00Oomoogoo000017oo00<007ooOol00Woo00@007ooOomoo`<00003Ool0
000000Moo`9>LcIoo`9>L`Ioo`03001oogoo00Yoo`03001oogoo009oo`03001oogoo009oo`05001o
ogooOol00004Ool00`00Oomoo`02Ool01000Oomoogoo0`000Woo00<007ooOol01Goo0dic=Goo0dic
1Woo00<007ooOol06Woo000LOol00`00Ool00007Ool01`00Ool007oo001oo`00009oo`03001oo`00
009oo`03001oo`0000=oo`03001oogoo008000Qoo`=>Lc9oo`9>L`Qoo`03001oogoo00Uoo`03001o
o`0000Moo`07001oo`00Ool007oo00000Woo00<007oo00000Woo00<007oo00000goo00D007ooOomo
o`0000Uoo`9>Lc=oo`9>L`Qoo`03001oogoo01Yoo`0077oo00<007oo00001goo00L007oo001oo`00
Ool00002Ool00`00Ool00002Ool00`00Ool00003Ool01000Oomoo`002goo0Tic<7oo0Tic2Goo00<0
07ooOol02Goo00<007oo00001goo00L007oo001oo`00Ool00002Ool00`00Ool00002Ool00`00Ool0
0003Ool01@00Oomoogoo00002Woo0Tic<7oo0Tic2Woo00<007ooOol06Woo000LOol00`00Ool00007
Ool01`00Ool007oo001oo`00009oo`03001oo`00009oo`03001oo`0000=oo`04001oogoo000<Ool2
CW<^Ool2CW<:Ool00`00Oomoo`09Ool00`00Ool00007Ool01`00Ool007oo001oo`00009oo`03001o
o`00009oo`03001oo`0000=oo`05001oogooOol0000<Ool00dicOomoo`0]Ool00dicOomoo`09Ool0
0`00Oomoo`0JOol001eoo`03001oogoo00Moo`05001oogooOol00004Ool00`00Oomoo`02Ool01000
Oomoogoo0P000Woo0P0037oo00=>LgooOol0:goo0Tic2goo00<007ooOol02Woo00<007ooOol01goo
00D007ooOomoo`0000Aoo`03001oogoo009oo`04001oogooOol20003Ool00`00Oomoo`0:Ool2CW<]
Ool00dicOomoo`0:Ool00`00Oomoo`0JOol003eoo`8000eoo`03CW=oogoo02Yoo`03CW=oogoo00Yo
o`03001oogoo02]oo`03001oogoo00]oo`9>Lb]oo`03CW=oogoo00]oo`03001oogoo01Yoo`00?Goo
0P003Goo0Tic:Woo00=>LgooOol02goo00<007ooOol0:goo00<007ooOol037oo00=>LgooOol0:Goo
00=>LgooOol02goo00<007ooOol06Woo000mOol2000>Ool00dicOomoo`07Ool5CW<>Ool4CW<9Ool2
CW<=Ool00`00Oomoo`0[Ool00`00Oomoo`0<Ool2CW<9Ool4CW<>Ool5CW<9Ool00dicOomoo`0<Ool0
0`00Oomoo`0JOol0029oo`03001oogoo009oo`03001oogoo009oo`05001oogooOol00004Ool01000
Oomoogoo0`0000=oo`0000003Woo00=>LgooOol01Woo0Tic0goo0Tic2goo0dic0goo0Tic1goo00=>
LgooOol037oo00<007ooOol03goo00<007ooOol00Woo00<007ooOol00Woo00D007ooOomoo`0000Ao
o`04001oogooOol30002Ool00`00Oomoo`0=Ool00dicOomoo`05Ool2CW<4Ool2CW<;Ool2CW<3Ool2
CW<8Ool00dicOomoo`0<Ool00`00Oomoo`0JOol0025oo`03001oo`0000Moo`07001oo`00Ool007oo
00000Woo00<007oo00000goo00<007ooOol00P003goo00=>LgooOol017oo00=>LgooOol01Goo00=>
LgooOol01goo0Tic1Woo0Tic1Woo00=>LgooOol037oo00<007ooOol03Woo00<007oo00001goo00L0
07oo001oo`00Ool00002Ool00`00Ool00003Ool01@00Oomoogoo00003goo0Tic1Goo0Tic1Woo0Tic
2Goo00=>LgooOol01Goo0Tic1Goo00=>LgooOol03Goo00<007ooOol06Woo000QOol00`00Ool00007
Ool01`00Ool007oo001oo`00009oo`03001oo`0000=oo`04001oogoo000@Ool00dicOomoo`03Ool0
0dicOomoo`07Ool00dicOomoo`05Ool2CW<8Ool2CW<4Ool00dicOomoo`0=Ool00`00Oomoo`0>Ool0
0`00Ool00007Ool01`00Ool007oo001oo`00009oo`03001oo`0000=oo`05001oogooOol0000@Ool0
0dicOomoo`03Ool00dicOomoo`06Ool2CW<7Ool2CW<8Ool00dicOomoo`03Ool00dicOomoo`0=Ool0
0`00Oomoo`0JOol0025oo`03001oo`0000Moo`07001oo`00Ool007oo00000Woo00<007oo00000goo
00@007ooOol0015oo`04CW=oogooOol2CW<9Ool2CW<6Ool00dicOomoo`08Ool00dicOomoo`02Ool0
0dicOomoo`0=Ool00`00Oomoo`0>Ool00`00Ool00007Ool01`00Ool007oo001oo`00009oo`03001o
o`0000=oo`05001oogooOol0000@Ool00dicOomoo`02Ool00dicOomoo`08Ool00dicOomoo`04Ool2
CW<9Ool2CW<4Ool00dicOomoo`0=Ool00`00Oomoo`0JOol0029oo`03001oogoo00Moo`05001oogoo
Ool00004Ool01000Oomoogoo0P000Woo0P0047oo00E>LgooOomoodic00]oo`03CW=oogoo00=oo`9>
L`Yoo`03CW=oogoo009oo`03CW=oogoo00eoo`03001oogoo00moo`03001oogoo00Moo`05001oogoo
Ool00004Ool01000Oomoogoo0P000goo00<007ooOol03Woo00=>LgooOol00Woo00=>LgooOol02Goo
00=>LgooOol00goo00=>LgooOol02Goo00E>LgooOomoodic011oo`03001oogoo01Yoo`00?Goo0P00
47oo00E>LgooOomoodic00aoo`03CW=oogoo009oo`03CW=oogoo00Yoo`04CW=oogooCW<@Ool00`00
Oomoo`0[Ool00`00Oomoo`0?Ool014icOomoodic37oo00=>LgooOol00goo00=>LgooOol02Goo00E>
LgooOomoodic011oo`03001oogoo01Yoo`00?Goo0P0057oo00=>LgooOol02Woo00A>LgooOomoo`9>
L`aoo`03CW=oogoo015oo`03001oogoo02]oo`03001oogoo019oo`03CW=oogoo00Yoo`9>L`=oo`03
CW=oogoo00]oo`03CW=oogoo015oo`03001oogoo01Yoo`00?Goo0P0047oo00A>LgooOom>L`eoo`05
CW=oogooOom>L`0=Ool014icOomoodic47oo00<007ooOol0:goo00<007ooOol03goo00A>LgooOom>
L`eoo`05CW=oogooOom>L`0=Ool014icOomoodic47oo00<007ooOol06Woo000VOol00`00Oomoo`02
Ool00`00Oomoo`02Ool01@00Oomoogoo00000goo0`000Woo0P004Goo00=>LgooCW<087oo00=>Lgoo
CW<047oo00<007ooOol057oo00<007ooOol00Woo00<007ooOol00Woo00D007ooOomoo`0000=oo`<0
009oo`03001oogoo00moo`04CW=oogooCW<OOol00dicOom>L`0AOol00`00Oomoo`0JOol002Eoo`03
001oo`0000Moo`07001oo`00Ool007oo00000goo00@007ooOomoo`80029oo`04CW=oogooCW<QOol0
0`00Oomoo`0COol00`00Ool00007Ool01`00Ool007oo001oo`0000=oo`05001oogooOol0000ROol0
14icOomoodic8Woo00<007ooOol06Woo000UOol00`00Ool00007Ool01`00Ool007oo001oo`0000=o
o`05001oogooOol0000DOol00dicOomoo`0<Ool014icOomoodic3Woo00=>LgooOol047oo00<007oo
Ool04goo00<007oo00001goo00L007oo001oo`00Ool00003Ool01@00Oomoogoo00004goo00=>Lgoo
Ool03Goo00=>LgooCW<03Woo00=>LgooOol04Goo00<007ooOol06Woo000UOol00`00Ool00007Ool0
1`00Ool007oo001oo`0000=oo`05001oogooOol0000BOol00dicOomoo`0ROol00dicOomoo`0>Ool0
0`00Oomoo`0COol00`00Ool00007Ool01`00Ool007oo001oo`0000=oo`05001oogooOol0000BOol0
0dicOomoo`0QOol00dicOomoo`0?Ool00`00Oomoo`0JOol002Ioo`03001oogoo00Moo`05001oogoo
Ool00003Ool20003Ool2000BOol00dicOomoo`0=Ool00dicOom>L`0?Ool00dicOomoo`0@Ool00`00
Oomoo`0DOol00`00Oomoo`07Ool01@00Oomoogoo00000goo0P000goo00<007ooOol04Goo00=>Lgoo
Ool03Goo00=>LgooCW<03goo00=>LgooOol047oo00<007ooOol06Woo000mOol20017Ool00`00Oomo
o`0[Ool00`00Oomoo`16Ool00`00Oomoo`0JOol003eoo`80015oo`03CW=oogoo00moo`9>La1oo`03
CW=oogoo00moo`03001oogoo02]oo`03001oogoo011oo`03CW=oogoo00ioo`03CW=oodic011oo`03
CW=oogoo00moo`03001oogoo01Yoo`00?Goo0P00Agoo00<007ooOol0:goo00<007ooOol0AWoo00<0
07ooOol06Woo000[Ool00`00Oomoo`02Ool00`00Oomoo`02Ool00`00Oomoo`030002Ool2000BOol0
0dicOomoo`0OOol00dicOomoo`0@Ool00`00Oomoo`0IOol00`00Oomoo`02Ool00`00Oomoo`02Ool0
0`00Oomoo`030002Ool00`00Oomoo`0AOol00dicOomoo`0OOol00dicOomoo`0@Ool00`00Oomoo`0J
Ool002Yoo`03001oo`0000Moo`03001oo`00009oo`04001oogooOol20017Ool00`00Oomoo`0HOol0
0`00Ool00007Ool00`00Ool00002Ool01@00Oomoogoo0000B7oo00<007ooOol06Woo000ZOol00`00
Ool00007Ool00`00Ool00002Ool01@00Oomoogoo000097oo0Tic8Woo00<007ooOol067oo00<007oo
00001goo00<007oo00000Woo00D007ooOomoo`0002=oo`9>Lb=oo`03001oogoo01Yoo`00:Woo00<0
07oo00001goo00<007oo00000Woo00D007ooOomoo`0004Qoo`03001oogoo01Qoo`03001oo`0000Mo
o`03001oo`00009oo`05001oogooOol00018Ool00`00Oomoo`0JOol002]oo`03001oogoo00Moo`03
001oogoo008000=oo`80019oo`03CW=oogoo021oo`03CW=oogoo00moo`03001oogoo01Uoo`03001o
ogoo00Moo`03001oogoo008000=oo`03001oogoo011oo`03CW=oogoo025oo`03CW=oogoo00moo`03
001oogoo01Yoo`00?Goo0P00Agoo00<007ooOol0:goo00<007ooOol0AWoo00<007ooOol06Woo000m
Ool20017Ool00`00Oomoo`0[Ool00`00Oomoo`16Ool00`00Oomoo`0JOol003eoo`8004Moo`03001o
ogoo02]oo`03001oogoo04Ioo`03001oogoo01Yoo`00<7oo00<007ooOol00Woo00@007ooOomoo`<0
0003Ool0000004Moo`03001oogoo01ioo`03001oogoo009oo`04001oogooOol300000goo001oo`17
Ool00`00Oomoo`0JOol002moo`03001oo`0000Qoo`03001oogoo008002=oo`03CW=oogoo025oo`03
001oogoo01eoo`03001oo`0000Qoo`04001oogoo000TOol00dicOomoo`0QOol00`00Oomoo`0JOol0
02moo`03001oo`0000Qoo`04001oogoo0018Ool00`00Oomoo`0MOol00`00Ool00008Ool01000Oomo
o`00B7oo00<007ooOol06Woo000_Ool00`00Ool00008Ool01000Oomoo`00B7oo00<007ooOol07Goo
00<007oo000027oo00@007ooOol004Qoo`03001oogoo01Yoo`00<7oo00<007ooOol01Woo0P000Woo
0P0000=>LgooOol03goo00=>LgooOol087oo00=>LgooOol03goo00<007ooOol07Woo00<007ooOol0
1Woo0P000Woo00<007ooCW<047oo00=>LgooOol087oo00=>LgooOol047oo00<007ooOol06Woo000m
Ool20017Ool00`00Oomoo`0[Ool00`00Oomoo`16Ool00`00Oomoo`0JOol003eoo`8004Moo`03001o
ogoo02]oo`03001oogoo04Ioo`03001oogoo01Yoo`00?Goo0P00Agoo00<007ooOol0:goo00<007oo
Ool0AWoo00<007ooOol06Woo000iOol300000goo00000017Ool00`00Oomoo`0VOol30002Ool00`00
Oomoo`16Ool00`00Oomoo`0JOol003Yoo`03001oogoo008004Moo`03001oogoo02Moo`05001oogoo
Ool00018Ool00`00Oomoo`0JOol003Yoo`03001oogoo04X002Uoo`04001oogooOom:000LOol003Yo
o`03001oogoo07=oo`03001oogoo06Moo`00>Goo0P00M7oo0P00JGoo003oOolKOol00?mooa]oo`00
ogoo6goo003oOolKOol00?mooa]oo`00ogoo6goo003oOolKOol00?mooa]oo`00ogoo6goo003oOolK
Ool00?mooa]oo`00ogoo6goo003oOolKOol00?mooa]oo`00ogoo6goo003oOolKOol003moo`03001o
ogoo00Qoo`<000=oo`03001oogoo00=oo`<000=oo`03001oogoo009oo`03001oogoo00<0009oo`<0
00=oo`03001oogoo00<000=oo`03001oogoo009oo`03001oogoo03Eoo`03001oogoo00Qoo`<000=o
o`03001oogoo00=oo`<000=oo`03001oogoo009oo`04001oogooOol30002Ool30003Ool00`00Oomo
o`030003Ool00`00Oomoo`02Ool00`00Oomoo`0SOol003ioo`03001oo`0000]oo`06001oogoo001o
o`001Goo00L007ooOomoo`00Ool00002Ool00`00Ool00002Ool00`00Oomoo`03Ool01P00Oomoo`00
Ool0009oo`07001oogooOol007oo00000Woo00<007oo0000=Goo00<007oo00002goo00H007ooOol0
07oo0005Ool01`00Oomoogoo001oo`00009oo`03001oo`0000=oo`03001oogoo00=oo`06001oogoo
001oo`000Woo00L007ooOomoo`00Ool00002Ool00`00Ool0000TOol003ioo`03001oo`0000Uoo`<0
009oo`03001oo`0000Eoo`07001oogooOol007oo00000Woo00<007oo00000Woo00@007ooOomoo`<0
009oo`03001oo`0000=oo`06001oogoo001oo`000Woo00<007oo0000=Goo00<007oo00002Goo0`00
0Woo00<007oo00001Goo00L007ooOomoo`00Ool00002Ool00`00Ool00003Ool01000Oomoogoo0`00
0Woo00<007oo00000goo00H007ooOol007oo0002Ool00`00Ool0000TOol003ioo`03001oo`0000Uo
o`03001oogoo009oo`03001oo`0000Eoo`07001oogooOol007oo00000Woo00<007oo00000Woo00D0
07ooOomoo`0000Aoo`03001oo`0000=oo`06001oogoo001oo`000Woo00<007oo0000=Goo00<007oo
00002Goo00<007ooOol00Woo00<007oo00001Goo00L007ooOomoo`00Ool00002Ool00`00Ool00003
Ool01@00Oomoogoo000017oo00<007oo00000goo00H007ooOol007oo0002Ool00`00Ool0000TOol0
03moo`03001oogoo00Qoo`<000=oo`03001oogoo00=oo`8000Aoo`03001oogoo009oo`03001oogoo
008000=oo`<000=oo`03001oogoo00<000=oo`03001oogoo009oo`03001oogoo03Eoo`03001oogoo
00Qoo`<000=oo`03001oogoo00=oo`8000Aoo`03001oogoo009oo`04001oogooOol20003Ool30003
Ool00`00Oomoo`030003Ool00`00Oomoo`02Ool00`00Oomoo`0SOol00?mooa]oo`00ogoo6goo003o
OolKOol00?mooa]oo`00?GooBP00;GooBP0077oo000mOol30003CW<2Ool01000Oomoo`000Woo00@0
07oo001oo`9l009oo`04001oogoo0002Ool01000Oomoo`000Woo00H007ooOol007oo0002Ool01000
Oomoo`000Woo00@007ooOol0009oo`04001oogoo0002Ool01P00Oomoo`00Ool0009oo`03001oodic
009>L`03001oogoo02]oo`03001oodic009>L`9oo`04001oogoo0002Ool01@00Oomoo`00Ool00W`0
0Woo00@007ooOol0009oo`03001oo`00009oo`04001oogoo0002Ool01000Oomoo`000Woo00@007oo
Ool0009oo`03001oo`00009oo`04001oogoo0002Ool01000Oomoo`000Woo00<007ooCW<00Tic00<0
07ooOol06Woo000mOol20003Ool4CW<9Ool2O00_Ool4CW<2Ool00`00Oomoo`0[Ool01000Oomoogoo
14ic2Woo0W`0;Woo14ic0goo00<007ooOol06Woo000mOol20006Ool3CW<fOol3CW<5Ool00`00Oomo
o`0[Ool00`00Oomoo`05Ool2CW<fOol3CW<6Ool00`00Oomoo`0JOol001eoo`03001oogoo009oo`03
001oogoo009oo`05001oogooOol00004Ool00`00Oomoo`02Ool01000Oomoogoo0`0000=oo`000000
27oo0Tic<goo0dic1goo00<007ooOol02Woo00<007ooOol00Woo00<007ooOol00Woo00D007ooOomo
o`0000Aoo`03001oogoo009oo`04001oogooOol30002Ool00`00Oomoo`07Ool2CW<cOol2CW<8Ool0
0`00Oomoo`0JOol001aoo`03001oo`0000Moo`07001oo`00Ool007oo00000Woo00<007oo00000Woo
00<007oo00000goo00<007ooOol00P002Woo00=>LgooOol0;goo0Tic2Goo00<007ooOol02Goo00<0
07oo00001goo00L007oo001oo`00Ool00002Ool00`00Ool00002Ool00`00Ool00003Ool01@00Oomo
ogoo00002Woo0Tic<Goo0Tic2Goo00<007ooOol06Woo000LOol00`00Ool00007Ool01`00Ool007oo
001oo`00009oo`03001oo`00009oo`03001oo`0000=oo`04001oogoo000<Ool00dicOomoo`0]Ool2
CW<:Ool00`00Oomoo`09Ool00`00Ool00007Ool01`00Ool007oo001oo`00009oo`03001oo`00009o
o`03001oo`0000=oo`05001oogooOol0000;Ool2CW<_Ool00dicOomoo`09Ool00`00Oomoo`0JOol0
01aoo`03001oo`0000Moo`07001oo`00Ool007oo00000Woo00<007oo00000Woo00<007oo00000goo
00<007ooOol00P0037oo00=>LgooOol0:goo0Tic2goo00<007ooOol02Goo00<007oo00001goo00L0
07oo001oo`00Ool00002Ool00`00Ool00002Ool00`00Ool00003Ool01@00Oomoogoo000037oo0Tic
;Goo0Tic2goo00<007ooOol06Woo000MOol00`00Oomoo`07Ool01@00Oomoogoo000017oo00<007oo
Ool00Woo00@007ooOomoo`80009oo`8000aoo`9>Lbaoo`03CW=oogoo00Yoo`03001oogoo00Yoo`03
001oogoo00Moo`05001oogooOol00004Ool00`00Oomoo`02Ool01000Oomoogoo0P000goo00<007oo
Ool02goo00=>LgooOol0:Woo0Tic37oo00<007ooOol06Woo000mOol2000=Ool2CW<ZOol2CW<<Ool0
0`00Oomoo`0[Ool00`00Oomoo`0<Ool00dicOomoo`0YOol00dicOomoo`0;Ool00`00Oomoo`0JOol0
03eoo`8000ioo`03CW=oogoo00Qoo`=>La1oo`=>L`Yoo`03CW=oogoo00]oo`03001oogoo02]oo`03
001oogoo00aoo`03CW=oogoo00Uoo`9>La1oo`=>L`Yoo`03CW=oogoo00aoo`03001oogoo01Yoo`00
?Goo0P003Woo00=>LgooOol01Woo0dic00AoodicCW=>L`]oo`=>L`9oo`=>L`Moo`03CW=oogoo00ao
o`03001oogoo02]oo`03001oogoo00eoo`03CW=oogoo00Ioo`9>L`9oo`=>L`]oo`=>L`04Oom>Ldic
CW<8Ool00dicOomoo`0<Ool00`00Oomoo`0JOol0029oo`03001oogoo009oo`03001oogoo009oo`05
001oogooOol00004Ool01000Oomoogoo0`0000=oo`0000003goo00=>LgooOol017oo0Tic1Goo0Tic
2Goo0Tic1Woo0Tic1Woo00=>LgooOol037oo00<007ooOol03goo00<007ooOol00Woo00<007ooOol0
0Woo00D007ooOomoo`0000Aoo`04001oogooOol30002Ool00`00Oomoo`0=Ool00dicOomoo`04Ool2
CW<6Ool2CW<9Ool2CW<5Ool2CW<6Ool00dicOomoo`0=Ool00`00Oomoo`0JOol0025oo`03001oo`00
00Moo`07001oo`00Ool007oo00000Woo00<007oo00000goo00<007ooOol00P003goo00=>LgooOol0
0goo0Tic27oo00=>LgooOol01Woo00=>LgooOol01Woo00=>LgooOol00goo0Tic3Woo00<007ooOol0
3Woo00<007oo00001goo00L007oo001oo`00Ool00002Ool00`00Ool00003Ool01@00Oomoogoo0000
47oo00=>LgooOol00goo00=>LgooOol01Woo00=>LgooOol01Woo0Tic27oo00=>LgooOol00goo00=>
LgooOol03Goo00<007ooOol06Woo000QOol00`00Ool00007Ool01`00Ool007oo001oo`00009oo`03
001oo`0000=oo`04001oogoo000AOol00dicOomoo`02Ool00dicOomoo`07Ool2CW<6Ool00dicOomo
o`08Ool00dicOomoo`02Ool00dicOomoo`0=Ool00`00Oomoo`0>Ool00`00Ool00007Ool01`00Ool0
07oo001oo`00009oo`03001oo`0000=oo`05001oogooOol0000@Ool00dicOomoo`02Ool2CW<9Ool0
0dicOomoo`04Ool2CW<9Ool00dicOomoo`03Ool00dicOomoo`0=Ool00`00Oomoo`0JOol0025oo`03
001oo`0000Moo`07001oo`00Ool007oo00000Woo00<007oo00000goo00<007ooOol00P0047oo00E>
LgooOomoodic00]oo`03CW=oogoo00=oo`9>L`Yoo`03CW=oogoo009oo`03CW=oogoo00eoo`03001o
ogoo00ioo`03001oo`0000Moo`07001oo`00Ool007oo00000Woo00<007oo00000goo00D007ooOomo
o`00011oo`03CW=oogoo009oo`03CW=oogoo00Uoo`03CW=oogoo00=oo`03CW=oogoo00Uoo`05CW=o
ogooOom>L`0@Ool00`00Oomoo`0JOol0029oo`03001oogoo00Moo`05001oogooOol00004Ool01000
Oomoogoo0P000Woo0P0057oo00=>LgooOol02Woo00=>LgooOol00Woo00=>LgooOol02Woo00=>Lgoo
Ool04Goo00<007ooOol03goo00<007ooOol01goo00D007ooOomoo`0000Aoo`04001oogooOol20003
Ool00`00Oomoo`0BOol00dicOomoo`0:Ool00dicOomoo`03Ool00dicOomoo`09Ool00dicOomoo`0B
Ool00`00Oomoo`0JOol003eoo`80011oo`05CW=oogooOom>L`0<Ool00dicOomoo`02Ool00dicOomo
o`0:Ool014icOomoodic47oo00<007ooOol0:goo00<007ooOol03goo00A>LgooOom>L`aoo`03CW=o
ogoo009oo`03CW=oogoo00]oo`04CW=oogooCW<@Ool00`00Oomoo`0JOol003eoo`80011oo`04CW=o
ogooCW<=Ool01DicOomoogooCW<03Goo00A>LgooOom>La1oo`03001oogoo02]oo`03001oogoo00mo
o`04CW=oogooCW<=Ool01DicOomoogooCW<03Goo00A>LgooOom>La1oo`03001oogoo01Yoo`00?Goo
0P008Goo00E>LgooOomoodic025oo`03001oogoo02]oo`03001oogoo021oo`05CW=oogooOom>L`0Q
Ool00`00Oomoo`0JOol002Ioo`03001oogoo009oo`03001oogoo009oo`05001oogooOol00003Ool3
0002Ool2000AOol00dicOom>L`0>Ool014icOomoodic3Woo00=>LgooCW<047oo00<007ooOol057oo
00<007ooOol00Woo00<007ooOol00Woo00D007ooOomoo`0000=oo`<0009oo`03001oogoo00moo`04
CW=oogooCW<=Ool014icOomoodic3Woo00=>LgooCW<04Goo00<007ooOol06Woo000UOol00`00Ool0
0007Ool01`00Ool007oo001oo`0000=oo`04001oogooOol2000COol00dicOomoo`0<Ool014icOomo
odic3Woo00=>LgooOol047oo00<007ooOol04goo00<007oo00001goo00L007oo001oo`00Ool00003
Ool01@00Oomoogoo00004goo00=>LgooOol03Goo00=>LgooCW<03Woo00=>LgooOol04Goo00<007oo
Ool06Woo000UOol00`00Ool00007Ool01`00Ool007oo001oo`0000=oo`05001oogooOol0000BOol0
0dicOomoo`0ROol00dicOomoo`0>Ool00`00Oomoo`0COol00`00Ool00007Ool01`00Ool007oo001o
o`0000=oo`05001oogooOol0000BOol00dicOomoo`0QOol00dicOomoo`0?Ool00`00Oomoo`0JOol0
02Eoo`03001oo`0000Moo`07001oo`00Ool007oo00000goo00@007ooOomoo`80029oo`03CW=oodic
029oo`03001oogoo01=oo`03001oo`0000Moo`07001oo`00Ool007oo00000goo00D007ooOomoo`00
02=oo`03CW=oodic029oo`03001oogoo01Yoo`009Woo00<007ooOol01goo00D007ooOomoo`0000=o
o`8000=oo`80019oo`03CW=oogoo01moo`03CW=oogoo011oo`03001oogoo01Aoo`03001oogoo00Mo
o`05001oogooOol00003Ool20003Ool00`00Oomoo`0AOol00dicOomoo`0OOol00dicOomoo`0@Ool0
0`00Oomoo`0JOol003eoo`80015oo`03CW=oogoo00moo`9>La1oo`03CW=oogoo00moo`03001oogoo
02]oo`03001oogoo011oo`03CW=oogoo00ioo`03CW=oodic011oo`03CW=oogoo00moo`03001oogoo
01Yoo`00?Goo0P00Agoo00<007ooOol0:goo00<007ooOol0AWoo00<007ooOol06Woo000mOol20017
Ool00`00Oomoo`0[Ool00`00Oomoo`16Ool00`00Oomoo`0JOol002]oo`03001oogoo009oo`03001o
ogoo009oo`03001oogoo00<0009oo`80019oo`03CW=oogoo01moo`03CW=oogoo011oo`03001oogoo
01Uoo`03001oogoo009oo`03001oogoo009oo`03001oogoo00<0009oo`03001oogoo015oo`03CW=o
ogoo01moo`03CW=oogoo011oo`03001oogoo01Yoo`00:Woo00<007oo00001goo00<007oo00000Woo
00@007ooOomoo`8002=oo`9>Lb9oo`03001oogoo01Qoo`03001oo`0000Moo`03001oo`00009oo`05
001oogooOol0000SOol2CW<SOol00`00Oomoo`0JOol002Yoo`03001oo`0000Moo`03001oo`00009o
o`05001oogooOol00018Ool00`00Oomoo`0HOol00`00Ool00007Ool00`00Ool00002Ool01@00Oomo
ogoo0000B7oo00<007ooOol06Woo000ZOol00`00Ool00007Ool00`00Ool00002Ool01000Oomoogoo
0P004Woo00=>LgooOol087oo00=>LgooOol03goo00<007ooOol067oo00<007oo00001goo00<007oo
00000Woo00D007ooOomoo`00019oo`03CW=oogoo025oo`03CW=oogoo00moo`03001oogoo01Yoo`00
:goo00<007ooOol01goo00<007ooOol00P000goo0P00Agoo00<007ooOol06Goo00<007ooOol01goo
00<007ooOol00P000goo00<007ooOol0AWoo00<007ooOol06Woo000mOol20017Ool00`00Oomoo`0[
Ool00`00Oomoo`16Ool00`00Oomoo`0JOol003eoo`8004Moo`03001oogoo02]oo`03001oogoo04Io
o`03001oogoo01Yoo`00?Goo0P00Agoo00<007ooOol0:goo00<007ooOol0AWoo00<007ooOol06Woo
000`Ool00`00Oomoo`02Ool01000Oomoogoo0`0000=oo`0000008goo00=>LgooOol08Goo00<007oo
Ool07Woo00<007ooOol00Woo00@007ooOomoo`<00003Ool007oo02=oo`03CW=oogoo025oo`03001o
ogoo01Yoo`00;goo00<007oo000027oo00<007ooOol00P00Agoo00<007ooOol07Goo00<007oo0000
27oo00@007ooOol004Qoo`03001oogoo01Yoo`00;goo00<007oo000027oo00@007ooOol004Qoo`03
001oogoo01eoo`03001oo`0000Qoo`04001oogoo0018Ool00`00Oomoo`0JOol002moo`03001oo`00
00Qoo`03001oogoo0080019oo`03CW=oogoo021oo`03CW=oogoo00moo`03001oogoo01eoo`03001o
o`0000Qoo`04001oogoo000BOol00dicOomoo`0POol00dicOomoo`0@Ool00`00Oomoo`0JOol0031o
o`03001oogoo00Ioo`80009oo`800003CW=oogoo04Aoo`03001oogoo01ioo`03001oogoo00Ioo`80
009oo`03001oodic04Ioo`03001oogoo01Yoo`00?Goo0P00Agoo00<007ooOol0:goo00<007ooOol0
AWoo00<007ooOol06Woo000mOol20017Ool00`00Oomoo`0[Ool00`00Oomoo`16Ool00`00Oomoo`0J
Ool003eoo`8004Moo`03001oogoo02]oo`03001oogoo04Ioo`03001oogoo01Yoo`00>Goo0`0000=o
o`000000Agoo00<007ooOol09Woo0`000Woo00<007ooOol0AWoo00<007ooOol06Woo000jOol00`00
Oomoo`030002Ool01000Oomoo`000Woo00H007ooOol007oo0002Ool01000Oomoo`000Woo00@007oo
Ool0009oo`04001oogoo0002Ool00`00Ool00002Ool01000Oomoo`000Woo00@007ooOol0009oo`04
001oogoo0002Ool01P00Oomoo`00Ool0009oo`06001oogoo001oo`00:Goo00T007ooOomoo`00Ool0
07oo00000Woo00@007ooOol0009oo`04001oogoo0002Ool01000Oomoo`000Woo00H007ooOol007oo
0002Ool01000Oomoo`000Woo00@007ooOol0009oo`04001oogoo0002Ool00`00Ool00002Ool01000
Oomoo`000Woo00@007ooOol0009oo`06001oogoo001oo`0077oo000jOol00`00Oomoo`1:000YOol0
1000OomoogooBP0077oo000jOol00`00Oomoo`1cOol00`00Oomoo`1WOol003Uoo`8007Aoo`8006Uo
o`00ogoo6goo003oOolKOol00?mooa]oo`00ogoo6goo003oOolKOol00?mooa]oo`00ogoo6goo003o
OolKOol00?mooa]oo`00ogoo6goo003oOolKOol00?mooa]oo`00ogoo6goo003oOolKOol00?mooa]o
o`00ogoo6goo001_Ool3001JOol3001;Ool0071oo`03001oogoo05]oo`03001oogoo04Uoo`00@7oo
0P000goo0`0000Aoo`000000009oo`<00003Ool0000000<00004Ool007oo0006Ool30002Ool30000
1goo001oo`00Ool007oo00<0009oo`@00005Ool00000001oo`030007Ool80002Ool200001Woo001o
o`00Ool000Ioo`<00004Ool000000002Ool30006Ool5000017oo001oo`001Goo0P0000=oo`000000
0Woo0`000Woo0`0000Aoo`00000004Moo`00?goo00@007ooOol0009oo`03001oogoo008000Aoo`<0
00=oo`07001oogooOol007oo00001goo0P000Woo0`0000Qoo`00Ool007oo001oo`000Woo00@007oo
Ool0009oo`03001oogoo00=oo`8000Qoo`05001oogooOol00003Ool00`00Oomoo`02000017oo001o
o`001Woo00H007ooOol007oo0004Ool00`00Oomoo`07Ool01`00Oomoogoo001oo`0000Ioo`<0009o
o`03001oogoo009oo`04001oogoo0002Ool00`00Oomoo`16Ool003moo`04001oogoo0002Ool00`00
Oomoo`020006Ool01@00Oomoogoo00000goo00<007oo00001Woo00<007ooOol017oo00T007oo001o
o`00Ool007oo00000Woo00@007ooOol0009oo`@00003Ool007oo00Uoo`05001oogooOol00003Ool0
0`00Oomoo`02000017oo001oo`001Woo00D007ooOol007oo00<0009oo`03001oogoo00Moo`07001o
ogooOol007oo00001Woo0`000Woo100000Eoo`00Oomoo`00009oo`03001oogoo04Ioo`00?goo00@0
07ooOol0009oo`L0009oo`<0009oo`80009oo`@000Ioo`<0009oo`<00003Ool0000000L000=oo`04
001oogooOol20002Ool30007Ool80002Ool200000goo000000030006Ool01P00Oomoo`00Ool0009o
o`05001oo`00Ool00006Ool20002Ool40006Ool00`00Ool00003Ool20003Ool30002Ool00`00Oomo
o`16Ool0041oo`8000=oo`05001oogooOol0000/Ool00`00Oomoo`0@Ool00`00Oomoo`0DOol30000
0goo00000007000COol4000<Ool20018Ool004Aoo`8000ioo`03001oogoo01ioo`80019oo`<002Qo
o`03001oogoo06=oo`00ogoo6goo003oOolKOol004Aoo`<003eoo`<002Aoo`<006aoo`00AGoo00<0
07ooOol0?Woo00<007ooOol03goo00<007ooOol037oo00<007ooOol00Woo00@007ooOol000Aoo`03
001oogoo06=oo`00>Woo0P0000=oo`0000000Woo0`0000Aoo`000000009oo`<00004Ool000000002
Ool30007Ool500000goo001oo`02Ool200000goo000000020002Ool30005Ool2000017oo000007oo
10000Woo100000Aoo`00Ool000Eoo`8000Aoo`04001oogooOol4000017oo001oo`000goo00@007oo
Oomoo`<000=oo`03001oogoo009oo`03001oogoo00Eoo`T00004Ool007oo0002Ool3000017oo0000
00000goo00<007ooOol0@Goo000kOol30002Ool00`00Oomoo`02Ool00`00Oomoo`020004Ool30002
Ool00`00Oomoo`07Ool00`00Oomoo`0200001Goo001oogoo00000Woo00<007oo00001Goo0P001Woo
0`000goo00D007ooOomoo`00009oo`800004Ool007oo0004Ool01000Oomoo`000goo00<007ooOol0
0Woo00L007ooOomoo`00Ool00003Ool01000Oomoo`000Woo00D007ooOomoo`0000Aoo`03001oogoo
00Eoo`03001oogoo009oo`0:001oogoo001oo`00Ool007oo0005Ool20017Ool003]oo`<0009oo`@0
0004Ool007ooOol50003Ool01000Oomoo`002Woo0P0000Aoo`00Ool0009oo`06001oogoo001oo`00
17oo00<007ooOol01Woo00<007oo00000goo00D007ooOomoo`00009oo`800004Ool007oo0004Ool0
1000Oomoo`000goo00<007ooOol00Woo00L007ooOomoo`00Ool00003Ool01000Oomoo`000Woo00D0
07ooOomoo`0000Aoo`03001oogoo00Eoo`03001oogoo009oo`09001oogoo001oo`00Ool007oo00@0
0003Ool007oo04Qoo`00>goo00<007oo00000goo0P0000=oo`0000000P000Woo0P000Woo0`0000=o
o`0000000P001goo00<007ooOol010000goo0P0000=oo`0000000P000Woo0`001goo0P000goo00<0
07ooOol00Woo200017oo00@007ooOol000=oo`03001oogoo009oo`03001oogoo00@000=oo`04001o
ogooOol30003Ool00`00Oomoo`02Ool00`00Oomoo`04Ool400000goo00000002Ool50002Ool20002
Ool30017Ool003Yoo`@001Eoo`03001oogoo00Moo`D001Moo`8000Aoo`03001oogoo00moo`8000Eo
o`05001oogooOol0000:Ool00`00Oomoo`05Ool00`00Oomoo`02Ool00`00Oomoo`06Ool00`00Oomo
o`1JOol00001\
\>"],
  ImageRangeCache->{{{0, 281}, {173, 0}} -> {-0.241886, -0.0309082, 
  0.00883906, 0.00883906}, {{27.3125, 135.062}, {169.5, 
  102.875}} -> {-220.548, -7.84573, 3.47138, 0.124746}, {{145.875, 253.625}, {
  169.5, 102.875}} -> {-632.123, -7.84573, 3.47138, 0.124746}, {{27.3125, 
  135.062}, {96.25, 29.625}} -> {-220.548, -16.9834, 3.47138, 0.124746}, {{
  145.875, 253.625}, {96.25, 29.625}} -> {-632.123, -16.9834, 3.47138, 
  0.124746}}]
}, Open  ]],

Cell[OutputFormData["\<\
{3, 5}\
\>", "\<\
{3, 5}\
\>"], "Output",
  Evaluatable->False,
  AspectRatioFixed->True]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData["Example 2"], "Section",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[TextData["Try me!"], "Subsubsection",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[TextData["SeedRandom[1234];\nRunShorsAlgorithm[15]"], "Input",
  AspectRatioFixed->True],

Cell[OutputFormData["\<\
{3, 5}\
\>", "\<\
{3, 5}\
\>"], "Output",
  Evaluatable->False,
  AspectRatioFixed->True]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData["Commentary Functions"], "Section",
  Editable->False,
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[TextData[
"Needs[\"Graphics`Graphics`\"]\n\nDescribeStep1[x_, n_]:=\n\t\
(Print[StringForm[\"Step 1: Picking a random integer x, 1 < x < `1`, that is \
co-prime to `1`.\", n]];\n\t Print[StringForm[\">> Picked x == `1`.\", x]];\n\
\t Print[\"\\n\"]\n\t)\n\t \nDescribeStep2[q_, n_]:=\n\t\
(Print[StringForm[\"Step 2: Picking a \\\"smooth\\\" q, i.e. an integer of \
order O(n^2) ~ `1`\", n^2]];\n\t Print[\"   that has small prime factors.\"];\
\n\t Print[StringForm[\">> Picked q == `1`.\", q]]\n\t)\n\nDescribeStep3[x_, \
q_, n_]:=\n\t(Print[StringForm[\"Step 3: Computing the period of `1` mod `2`.\
\", x^a, n]];\n\t Print[\"Repeat steps 3(a)-3(g) O(log(q)) times.\"];\n\t \
Print[\"\\nStep 3(a):\"];\n\t Print[\"Initially, place Reg1 and Reg2 in the \
state |0,0>.\"];\n\t ListPlot[{{0,0}}, \n         \
PlotStyle->PointSize[0.035],\n         PlotRange->{{0,q},{0,n}},\n         \
GridLines->Automatic,\n         Frame->True,\n         \
FrameLabel->{\"Contents Reg1\", \"Contents Reg2\"},\n         \
RotateLabel->True,\n         PlotLabel->\"Initialize Reg1 & Reg2 as |0,0>\"]\n\
   \t)\n\t\nDescribeStep4[reg1_]:=\n\t(Print[\"\\nStep 3(b):\"];\n\t \
Print[\"Loading Reg1 with a superposition of all integers in the range 0 to \
q-1,\"];\n\t Print[\"   i.e. creating the superposition 1/Sqrt[q] Sum[ket[a], \
{a,0,q-1}\"];\n\t Print[\"This puts Reg1 in the state:\"];\n\t Print[\"Reg1 = \
\", Short[reg1,8]]\n\t)\n\t\n\nDescribeStep5[reg1_, q_, n_]:=\n\t\
Module[{contentsReg1, contentsReg2},\n\t\tcontentsReg1 = Contents[reg1];\n\t\t\
contentsReg2 = Table[0, {Length[reg1]}];\n\t\tListPlot[MapThread[{#1, #2}&, \
{contentsReg1, contentsReg2}], \n\t             PlotLabel->\"Load Reg1 with \
1/Sqrt[q] Sum[|a,0>, {a,0,q-1}]\",\n\t             Frame->True,\n\t           \
  GridLines->Automatic,\n\t             FrameLabel->{\"Contents of Reg1\", \
\"Contents of Reg2\"},\n\t             RotateLabel->True,\n\t             \
PlotRange->{{0,q},{0,n}},\n\t             PlotStyle->PointSize[0.02]]\n\t]\n\n\
DescribeStep6[reg1_, reg2_, q_, n_]:=\n\tModule[{contentsReg1, contentsReg2, \
data},\n\t\tPrint[\"\\nStep 3(c):\"];\n\t\tPrint[StringForm[\"Loading Reg2 \
with `1` mod `2`\", x^a, n]];\n\t \tPrint[\"This puts Reg2 in a state \
representing a superposition of the integers:\"];\n\t\t\
Print[ShortRegister[reg2, n]];\n\t\tPrint[\"\\n\"];\n\t\t\t(* Next, only need \
to see a subset of the data as\n\t\t\t   the period of x^a mod n is at most \
n.\n\t\t\t*)\n\t\tcontentsReg1 = Take[Contents[reg1], {1, Ceiling[1.5 n]}];\n\
\t\tcontentsReg2 = Take[reg2, {1, Ceiling[1.5 n]}]; \n\t\tdata = \
Transpose[{contentsReg1, contentsReg2}];\n\t\tShow[ListPlot[data, \n\t        \
          Frame->True,\n\t                  PlotRange->{{0, Ceiling[1.5 \
n]-1}, {0, Max[contentsReg2]+1}},\n\t                  PlotLabel->\"Put \
superposition x^a mod n in Reg2 \\n 1/Sqrt[q] Sum[|a, x^a mod \
n>,{a,0,q-1}]\",\n\t                  GridLines->Automatic,\n\t               \
   FrameLabel->{\"Contents Reg1\", \"Contents Reg2\"},\n\t                  \
RotateLabel->True,\n\t                  PlotJoined->True,\n\t                 \
 PlotStyle->Dashing[{0.01,0.01}],\n\t                  \
DisplayFunction->Identity],\n\t         ListPlot[data,\n\t                  \
PlotJoined->False,\n\t                  PlotStyle->PointSize[0.02],\n\t       \
           DisplayFunction->Identity],\n\t         DisplayFunction :> \
$DisplayFunction\n\t    ]\n\t]\n\nDescribeStep7[reg1_, reg2_, q_, n_, \
measurement_]:=\n\tModule[{contentsReg1, contentsReg2, data},\n\t\t\
PrintPartOfRegister[reg2, n]; \n\t\t\t(* Next, only need to see a subset of \
the data as\n\t\t\t   the period of x^a mod n is at most n.\n\t\t\t*)\n\t\t\
contentsReg1 = Take[Contents[reg1], {1, Ceiling[1.5 n]}];\n\t\tcontentsReg2 = \
Take[reg2, {1, Ceiling[1.5 n]}]; \n\t\tdata = Transpose[{contentsReg1, \
contentsReg2}];\n\t\tShow[ListPlot[data, \n\t                  Frame->True,\n\
\t                  PlotRange->{{0, Ceiling[1.5 n]-1}, {0, \
Max[contentsReg2]+1}},\n\t                  PlotLabel->StringJoin[\"Measure \
Reg2 = \",\n\t                                        ToString[measurement]],\
\n\t                  GridLines->Automatic,\n\t                  \
FrameLabel->{\"Contents Reg1\", \"Contents Reg2\"},\n\t                  \
RotateLabel->True,\n\t                  PlotJoined->True,\n\t                 \
 PlotStyle->{GrayLevel[0.6], Dashing[{0.01,0.01}]},\n\t                  \
DisplayFunction->Identity],\n\t         ListPlot[data,\n\t                  \
PlotJoined->False,\n\t                  PlotStyle->{GrayLevel[0.6], \
PointSize[0.02]},\n\t                  DisplayFunction->Identity],\n\t        \
 Graphics[{RGBColor[1,0,0],\n\t                   PointSize[0.05],\n\t        \
           Point[{0,measurement}]\n\t                  }],\n\t         \
DisplayFunction :> $DisplayFunction\n\t    ]\n\t]\n\t\n\t\n\n\
DescribeStep8[reg1_, reg2_, projectReg1_, measureReg2_, n_]:=\n\t\
Module[{maxXValue, maxYValue, contentsProjReg1, contentsReg2, data},\n\t\t\
Print[\"projectReg1 = \", Short[projectReg1,8]];\n\t\tmaxXValue = \
Max[Take[Contents[reg1], {1, Ceiling[1.5 n]}]];\n\t\tmaxYValue = Max[reg2]+1; \
(* reg2 is already just a list of x^a mod n *)\n\t\tcontentsProjReg1 = \
Contents[projectReg1];\n\t\tcontentsReg2 = Table[measureReg2, \
{Length[contentsProjReg1]}];\n\t\tdata = Select[Transpose[{contentsProjReg1, \
contentsReg2}], \n\t\t              (#[[2]]==measureReg2 && \n\t\t            \
   #[[1]]<=maxXValue)&];  (*just plot subset*)\n\t\tListPlot[data,\n\t\t      \
   Frame->True,\n\t             PlotLabel->StringForm[\"Project Reg1: {a:x^a \
mod n = `1`}\", measureReg2],\n\t             GridLines->Automatic,\n\t       \
      FrameLabel->{StringForm[\"Contents Reg1 {a:x^a mod n = `1`}\", \
measureReg2],\n\t                          \"Contents Reg2\"},\n\t            \
 RotateLabel->True,\n\t             PlotJoined->False,\n\t             \
PlotStyle->PointSize[0.02],\n\t             PlotRange->{0, maxYValue}\n\t     \
       ]\n\t ]\n\t \nDescribeStep9[fourierReg1_, measureReg2_]:=\n\t\
Module[{probs, conts, data},\n\t\tPrint[\"The Fourier transform puts Reg1 in \
the state:\\n\"];\n\t\tPrint[\"Fourier = \", Short[fourierReg1, 8]]; \n\t\t\
probs = Probabilities[fourierReg1];\n\t\tconts = Contents[fourierReg1];\n\t\t\
data  = Transpose[{conts, probs}];\n\t\t$dft = data;\n\t\tLogListPlot[data,\n\
\t\t            Frame->True,\n\t                PlotLabel->\"Compute Discrete \
Fourier Transform of Reg1\",\n\t                GridLines->Automatic,\n\t     \
           FrameLabel->\n\t                \t{StringForm[\"Contents Reg1 \
{a:x^a mod n = `1`}\", measureReg2],\n\t                     \"ln(Pr(Measure \
a))\"\n\t                    },\n\t                RotateLabel->True,\n\t     \
           PlotJoined->False,\n\t                PlotStyle->PointSize[0.01]\n\
\t\t           ]\n\t]\n\t\nDescribeStep10[fourierReg1_, measureReg2_, \
oneSampleOfDFT_]:=\n\tModule[{probs, conts, data, dftPlot, samplePlot},\n\t\t\
probs = Probabilities[fourierReg1];\n\t\tconts = Contents[fourierReg1];\n\t\t\
data  = Transpose[{conts, probs}];\n\t\tdftPlot =\n\t\t\tLogListPlot[data,\n\t\
\t            Frame->True,\n\t                PlotLabel->\"Compute Discrete \
Fourier Transform of Reg1\",\n\t                GridLines->Automatic,\n\t     \
           FrameLabel->\n\t                \t{StringForm[\"Contents Reg1 \
{a:x^a mod n = `1`}\", measureReg2],\n\t                     \"ln(Pr(Measure \
a))\"\n\t                    },\n\t                RotateLabel->True,\n\t     \
           PlotJoined->False,\n\t                PlotStyle->PointSize[0.01],\n\
\t                DisplayFunction->Identity\n\t\t   ];\n\t\tsamplePlot = \
LogListPlot[{{oneSampleOfDFT, Min[probs]}},\n\t\t                         \
PlotStyle->{RGBColor[1,0,0], \n\t\t                                     \
PointSize[0.035]},\n\t\t                         DisplayFunction->Identity];\n\
\t\tShow[dftPlot, samplePlot, DisplayFunction:>$DisplayFunction]\n\t]\n\t\n\
DescribeStep11[fourierReg1_, samples_]:=\n\tModule[{probs, conts, data, \
dftPlot, plots},\n\t\tprobs = Probabilities[fourierReg1];\n\t\tconts = \
Contents[fourierReg1];\n\t\tdata  = Transpose[{conts, probs}];\n\t\t$dft = \
data;\n\t\tmultiplesOfPeriod = Map[{#, Min[probs]}&, samples];\n\t\tdftPlot =\
\n\t\t\tLogListPlot[data,\n\t\t                Frame->True,\n\t\t             \
   PlotStyle->{GrayLevel[0.6]},\n\t                    PlotJoined->False,\n\t \
                   DisplayFunction->Identity\n\t\t               ];\n\t\t\
plots = Map[Show[dftPlot, \n\t\t                 LogListPlot[{#},\n\t\t       \
                      PlotStyle->{RGBColor[1,0,0], \n\t\t                     \
                    PointSize[0.035]},\n\t\t                             \
DisplayFunction->Identity\n\t\t                            ], \n\t\t          \
       DisplayFunction->Identity\n\t\t           ]&, multiplesOfPeriod];\n\t\t\
$DefaultFont = {\"Courier\", 8};\n\t\tShow[GraphicsArray[Partition[plots,2]],\
\n\t\t     PlotLabel->\"Repeat Shors Algm O(ln(q)) times. \\n Obtain samples \
from DFT in Reg1\",\n\t\t     DisplayFunction:>$DisplayFunction]\n\t]\n\t\n\
DescribeStep12[]:=\n\t(Print[\"Each sample provides a value k\"];\n\t \
Print[\"Finding the closest rational to k/q, whose denominator is less than \
n.\"];\n\t Print[\"Each such rational has the form lambda/r, where r is the \
period.\"]\n\t)\n\t\nDescribeStep13[x_,r_,n_]:=\n\tModule[{fac1, fac2},\n\t \
Print[\"\\nStep 5: Obtain the factors of n from the period, r.\"];\n\t Print[\
\"Computing the factors of n from\"];\n\t Print[\"GCD[x^(r/2) - 1, n] and\"];\
\n\t Print[\"GCD[x^(r/2) + 1, n]\"];\n\t Print[\"In this case, x=\", x, \", \
r=\",r,\", n=\",n];\n\t fac1 = GCD[x^(r/2) - 1, n];\n\t fac2 = GCD[x^(r/2) + \
1, n];\n\t Print[\"GCD[\",x^(r/2),\" - 1\", \", \", n,\"] = \", fac1];\n\t \
Print[\"GCD[\",x^(r/2),\" + 1\", \", \", n,\"] = \", fac2];\n\t Print[\"So \
the factors of n=\",n,\" are \",fac1,\" and \",fac2,\".\"]\n\t]\n\t\n\t\t\n\t\
\n\n(* w_. ket[i_] + kets_. is a superposition of states of a quantum\n   \
memory register. Probabilities[...] gives the probability with\n   which each \
result would be obtained upon measuring the state of\n   the register. \
Contents[...] gives the actual values that are\n   stored in superposition in \
the register.\n*)\nProbabilities[w_. ket[i_] + kets_.]:=\n\t\
Module[{amplitudes},\n\t\tamplitudes = Map[#[[1]]&, Apply[List, w ket[i] + \
kets]];\n\t\tAbs[amplitudes/Sqrt[Apply[Plus, Abs[amplitudes]^2]]]^2\n\t]\n\n\
Probabilities[superposition_List]:=\n\tProbabilities[Apply[Plus, \
superposition]]\n\nContents[w_. ket[i_] + kets_.]:=\n\tMap[#[[2,1]]&, \
Apply[List, w ket[i] + kets]]\n\nContents[superposition_List]:=\n\t\
Contents[Apply[Plus, superposition]]\n"], "Input",
  Editable->False,
  InitializationCell->True,
  AspectRatioFixed->True],

Cell[TextData[
"General::spell1: Possible spelling error: new symbol name \"Contents\"\n     \
is similar to existing symbol \"Contexts\"."], "Message",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[
"General::spell1: Possible spelling error: new symbol name \"maxYValue\"\n    \
 is similar to existing symbol \"maxXValue\"."], "Message",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[
"General::spell1: Possible spelling error: new symbol name \"DescribeStep12\"\
\n     is similar to existing symbol \"DescribeStep2\"."], "Message",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[
"General::spell1: Possible spelling error: new symbol name \"DescribeStep13\"\
\n     is similar to existing symbol \"DescribeStep3\"."], "Message",
  Evaluatable->False,
  AspectRatioFixed->True]
}, Open  ]],

Cell[TextData[
"ShortRegister[list_, n_]:=\n\tPrint[list] /; Length[list] <= 2n\n\t\n\
ShortRegister[list_, n_]:=\n\tModule[{blanks},\n\t\tblanks = Table[\", \", \
{Length[list]}];\n\t\telems = Drop[Flatten[MapThread[{ToString[#1], #2}&, \n\t\
\t                               {list, blanks}]], -1];\n\t\tJoin[{\"{\"},\n\t\
\t     Take[elems, n],\n\t\t     {\"  ...  \"},\n\t\t     Take[elems, -n],\n\t\
\t     {\"}\"}\n\t\t    ] // StringJoin\n\t]"], "Input",
  Editable->False,
  InitializationCell->True,
  AspectRatioFixed->True]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["Code for simulating Shor's algorithm"], "Section",
  Editable->False,
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[TextData[
"Needs[\"Statistics`DataManipulation`\"]\n\nOptions[RunShorsAlgorithm] = \
{Period->QuantumMethod};\n\nRunShorsAlgorithm[n_, opts___]:=\n\t\
Module[{method,x,q,r},\n\t\t$DefaultFont = {\"Courier\", 10};\n\t\tmethod = \
Period /. {opts} /. Options[RunShorsAlgorithm];\n\t\tx = \
PickRandomInteger[n];\n\t\tDescribeStep1[x, n];\n\t\tq = PickGoodSmoothq[n];\n\
\t\tDescribeStep2[q, n];\n\t\tDescribeStep3[x, q, n];\n\t\tr = \
Which[method===QuantumMethod, Period[x, n, q],\n\t\t          \
method===ClassicalMethod, PeriodViaClassicalAlgorithm[x, n, q],\n\t\t         \
 True, Message[RunShorsAlgorithm::method]; Abort[]\n\t\t         ];\n\t\t\
Print[\"Period was r=\",r];\n\t\tIf[EvenQ[r],\n\t\t   (DescribeStep13[x,r,n];\
\n\t\t    {GCD[x^(r/2) - 1, n], GCD[x^(r/2) + 1, n]}\n\t\t   ),\n\t\t   \
Message[RunShorsAlgorithm::odd, r]\n\t\t  ]\n\t]\n\nRunShorsAlgorithm::usage \
=\n\t\"RunShorsAlgorithm[n] creates a simulation of how a \\\n\tquantum \
computer would find the factors of n using Peter \\\n\tShor's quantum \
factoring algorithm. \\\n\tYou can give RunShorsAlgorithm various options \
that control \\\n\tthe output from the simulator. The period of x^a mod n can \
be \\\n\tcalculated in one of two \\\n\tways. If you set \
Period->QuantumMethod (the default) then \\\n\tRunShorsAlgorithm performs a \
faithful quantum simulation of \\\n\tthe steps a quantum computer would take \
to compute the period \\\n\tof x^a mod n. This can be slow because of the \
need to \\\n\tcompute a discrete Fourier transform. If you are only \\\n\t\
interested in seeing what factors a quantum computer would \\\n\thave found \
(not how it did it) then you can set \\\n\tPeriod->ClassicalMethod. This \
returns the same result as the \\\n\tquantum simulation but computes the \
period in a classical way.\";\n\nRunShorsAlgorithm::method =\n\t\"The method \
for computing the period must be either \\\n\tPeriod->QuantumMethod or \
Period->ClassicalMethod.\";\n\nRunShorsAlgorithm::odd =\n\t\"The period was \
an odd number (r=`1`). Shor's quantum \\\n\tfactoring algorithm failed. Try \
again!\";\n\n"], "Input",
  Editable->False,
  InitializationCell->True,
  AspectRatioFixed->True],

Cell[TextData[
"General::spell1: Possible spelling error: new symbol name \"method\"\n     \
is similar to existing symbol \"Method\"."], "Message",
  Evaluatable->False,
  AspectRatioFixed->True]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData["Pick a Random Integer Co-prime to n"], "Subsection",
  Editable->False,
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[
"(* Picks a random integer, x, that is co-prime to n.\n   Two integers are \
co-prime if GCD[x,n]==1.\n*)\nPickRandomInteger[n_]:=\n\tModule[{x},\n\t\tx = \
n;\n\t\tWhile[GCD[x,n]=!=1,\n\t\t      x = Random[Integer, {2,n-1}]; (* \
choose random integer < n *)\n\t\t     ];\n\t\tx\n\t]\n"], "Input",
  Editable->False,
  InitializationCell->True,
  AspectRatioFixed->True]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData["Pick a Smooth q"], "Subsection",
  Editable->False,
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[
"(* Pick a smooth q i.e. an integer in n^2 <= q <= 2 n^2 that\n   has small \
prime factors. Deutsch has shown that if you pick \n   q=2^L for some integer \
L (still with n^2 <= q=2^L <= 2 n^2), \n   then you can compute the discrete \
Fourier transform (needed \n   later in the algorithm) very efficiently with \
a simple quantum \n   circuit. However, q=2^L is not necessarily the SMALLEST \
q that \n   is usable. In our (classical) simulation the size of q affects \n \
  the efficiency of the simulator. Hence I opted to go with Peter \n   Shor's \
original specification of q as being a smooth number of \n   order O(n^2). I \
actually generate a few such smooth q's and\n   pick the smallest provided it \
is smaller than the least power\n   of 2 greater than n^2 (i.e. a q of the \
form \n   n^2 <= q=2^L << 2 n^2). This was I ensure I am using about as\n   \
small a q as I can (which speeds up the computation of the\n   discrete \
Fourier transform. Computing the DFT is the slowest \n   step which dominates \
the time to factor\n   n in this simulator. I really should speed it up).\n   \
\n   The interpretation of a \"small\" prime being one of order \n   \
O(Log[n]) is mine. It might be a bit conservative.\n*)\nPickGoodSmoothq[n_]:=\
\n\tModule[{smallPrimes, maxExponents},\n\t\tsmallPrimes  = \
Table[Prime[i],{i,1,Log[n]}];\n\t\tmaxExponents = Map[Floor[Log[#, N[2 \
n^2]]]&, smallPrimes];\n\t\tMin[Join[Table[PickSmoothq[n, smallPrimes, \
maxExponents], {20}],\n\t\t         {2^Ceiling[N[Log[2, n^2]]]}\n\t\t        \
]  (* i.e. the latter is a q s.t. n^2 <= q=2^L <= 2 n^2 *)\n\t\t   ]\n\t]\n\t\
\nPickSmoothq[n_, smallPrimes_, maxExponents_]:=\n\tModule[{q},\n\t\tq = 0;\n\
\t\tWhile[Not[n^2 <= q <= 2 n^2],\n\t\t\t  q = Guessq[smallPrimes, \
maxExponents]\n\t\t\t ];\n\t\tq\n\t]\n\nGuessq[primes_, expts_]:=\n\t\
Apply[Times, \n\t      MapThread[#1^Random[Integer,{0,#2}]&, {primes, \
expts}]]"], "Input",
  Editable->False,
  InitializationCell->True,
  AspectRatioFixed->True]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[
"Compute the Period of x^a mod n (Quantum Method)"], "Subsection",
  Editable->False,
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[TextData[
"Period[x_, n_, q_]:=\n\tModule[{reg1, reg2, measureReg2, projectReg1, \
fourierReg1,\n\t        samplesOfReg1, valuesOfReg1, r},\n\t\t  \n\t\t  reg1 \
= Apply[Plus, Map[(N[1/Sqrt[q]] ket[#])&, Range[0, q-1]]];\n\t\t  \
DescribeStep4[reg1];\n\t\t  DescribeStep5[reg1,q,n]; \n\t\n\t\treg2 = \
Map[Mod[x^#[[2,1]], n]&, Apply[List, reg1]];\n\t\t  DescribeStep6[reg1, reg2, \
q, n];\n\t\t\n\t\tmeasureReg2 = SampleRegister[reg2];\n\t\t  Print[\"Step \
3(d): Measuring the state of Reg2\"];\n\t\t  Print[\"measureReg2 = \", \
measureReg2];\n\t\t  DescribeStep7[reg1, reg2, q, n, measureReg2];\n\t\t  \
Print[\"The measurement of Reg2 has a side effect on the state of Reg1.\"];\n\
\t\t  Print[\"In fact the state of Reg1 is projected into:\"];\n\t\t\n\t\t\
projectReg1 = Renormalize[Select[reg1, \n\t\t                                 \
(Mod[x^#[[2,1]], n] == measureReg2)&]];\n\t\t  DescribeStep8[reg1, reg2, \
projectReg1, measureReg2, n];\n\t\n\t      Print[\"\\n\"];\n\t      \
Print[\"Step 3(e): Computing discrete Fourier transform of the contents of \
Reg1.\"];\n\t      Print[\"This may take several minutes!\"];\n\t      Print[\
\"(Remember you are watching a classical simulation of a quantum \
algorithm).\"];\n\t\tfourierReg1  = QuantumDFT[projectReg1, q] // Chop;\n\t\t \
 DescribeStep9[fourierReg1, measureReg2];\n\t\n\t \n\t \tsamplesOfReg1 = \
Table[SampleRegister1[fourierReg1], {12}];\n\tPrint[\"\\n\"];\n\t\
Print[\"Steps 3(f)&3(g): Sample from Fourier spectrum created in Reg1\"];\n\t\
Print[\"This entails repeating the previous steps & measuring Reg1 each time.\
\"];\n\tPrint[\"Found samples: \", samplesOfReg1];\n\t\tvaluesOfReg1 = \
DeleteCases[Sort[Union[Map[First, samplesOfReg1]]], 0];\n\t\t  \
DescribeStep10[fourierReg1, measureReg2, First[valuesOfReg1]];\n\t\t  \
DescribeStep11[fourierReg1, valuesOfReg1];\n\tPrint[\"\\nStep 4: Extract the \
period, r, from the given samples.\"];\n\t\tDescribeStep12[];\n\t\tr = \
ExtractPeriodFromContinuedFraction[valuesOfReg1, n, q]\n]\n\n\n\
NotAllIntegersQ[{}]:=True\nNotAllIntegersQ[ans_]:=\n\tNot[Apply[And, \
Map[IntegerQ[#[[2]]]&, ans]]]\n\t\n\nQuantumDFT[w_. ket[a_], q_]:=\n\t\
Apply[Plus, \n\t      Map[(N[w/Sqrt[q] Exp[2 Pi I a #/q]] ket[#])&, \
Range[0,q-1]]]\n\t     \nQuantumDFT[superposition_, q_]:=\n\t\
Map[QuantumDFT[#,q]&, Expand[superposition]]\n\nRenormalize[superposition_]:=\
\n\tExpand[N[1/(Sqrt[Length[superposition]] Factor[superposition][[1]])] \
superposition]\n\t\nSampleRegister1[superposition_]:=\n\tModule[{elems, \
probs},\n\t\telems = Map[#[[2]]&, Apply[List, superposition]];\n\t\tprobs = \
Map[Abs[#[[1]]]^2&, Apply[List, superposition]];\n\t\tBiasedSelect[elems, \
probs]\n\t]\n\nSampleRegister[contentsOfRegister_]:=\n\tModule[{counts, \
elems, probs},\n\t\t{counts, elems} = \
Transpose[Frequencies[contentsOfRegister]];\n\t\tprobs = N[counts/Apply[Plus, \
counts]];\n\t\tBiasedSelect[elems, probs]\n\t]\n\t"], "Input",
  Editable->False,
  InitializationCell->True,
  AspectRatioFixed->True],

Cell[TextData[
"General::spell1: Possible spelling error: new symbol name \"counts\"\n     \
is similar to existing symbol \"conts\"."], "Message",
  Evaluatable->False,
  AspectRatioFixed->True]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[
"Extract the Period from a Continued Fraction Expansion"], "Subsection",
  Editable->False,
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox[
  "Needs[\"NumberTheory`ContinuedFractions`\"]\n\n\
ExtractPeriodFromContinuedFraction[samplesOfReg1_, n_, q_]:=\n\t\
Module[{rValues, r},\n\t rValues = Map[ExtractPeriodFromOneSample[#,n,q]&, \
samplesOfReg1];\n\t\tr = MajorityOpinion[rValues];\n\t\tr\n\t]\n\t\n\
ExtractPeriodFromContinuedFraction::canCancel = \n\t\"The quotient c/r = \
`1`/`2` can cancel further\";\n\t\nExtractPeriodFromOneSample[k_, n_, q_]:=\n\
\tModule[{f, cPrime, r},\n\t\tf = ClosestFractionTo[k/q, n, q];\n\t\tcPrime = \
Numerator[f];\n\t\tr = Denominator[f];\n\t\tIf[GCD[cPrime, r]==1,\n\t\t   r, \
\n\t\t   Message[ExtractPeriodFromContinuedFraction::canCancel, cPrime, r]\n\t\
\t  ]\n\t]\n\t\nClosestFractionTo[f_, n_, q_]:=\n\tModule[{cfs, \
approximations},\n\t\tcfs = Table[Normal[ContinuedFraction[f, i]], {i, 1, \
n}];\n\t\tapproximations = Select[cfs, Denominator[#]<=n&];\n\t\t\
Last[approximations]\n\t]\n\t\n(* Each time you approximate k/q by lambda/r \
you get a particular \n   fraction lambda/r. Unfortunately, if lambda (the \
multiple of\n   the inverse period) happens to share a common factor with the\
\n   period, r, then ",
    Editable->False,
    InitializationCell->True,
    AspectRatioFixed->True],
  StyleBox["Mathematica",
    Editable->False,
    InitializationCell->True,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[
  " will cancel the common factor between\n   lambda and r, converting \
lambda/r into lambda1/r1 (r1<r). Hence \n   the estimated value for \"r\" \
(i.e. r1) will be too low. For this \n   reason we repeat the algorithm a few \
times to obtain enough \n   samples to be sure that we have guessed the \
correct period, r.\n*)\nMajorityOpinion[rValues_]:=\n\tModule[{freq},\n\t\t\
pairs = Frequencies[rValues];\n\t\tfreq = Map[First, pairs];\n\t\tpos = \
Position[freq, Max[freq]][[1]];\n\t\tpairs[[pos]][[1,2]]\n\t]",
    Editable->False,
    InitializationCell->True,
    AspectRatioFixed->True]
}], "Input",
  Editable->False,
  InitializationCell->True,
  AspectRatioFixed->True],

Cell[TextData[
"General::spell1: Possible spelling error: new symbol name \"cPrime\"\n     \
is similar to existing symbol \"Prime\"."], "Message",
  Evaluatable->False,
  AspectRatioFixed->True]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData["Utility: BiasedSelect"], "Subsection",
  Editable->False,
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[TextData[
"(* The list of probabilities should sum to 1. The call to Partition \n   \
constructs a set of probability intervals whose width is proportional\n   to \
the probability with which the corresponding element in list \n   is \
selected.\n*)\nBiasedSelect[list_, probabilities_]:=\n\tModule[{random},\n\t\t\
random  = Random[];\n\t\tApply[Part[list, #]&,\n\t\t      Flatten[\n\t\t      \
 Position[Map[InRangeQ[random, #]&, \n\t\t                    \
Partition[FoldList[Plus,0,probabilities],2,1]\n\t\t                   ],\n\t\t\
                True\n\t\t       ]\n\t\t      ]\n\t\t     ]\n\t] (* \
/;CheckProbabilitiesQ[probabilities] *)\n\nBiasedSelect::usage =\n\t\
\"BiasedSelect[{e1,e2,...,en}, {p1,p2,...,pn}] returns element ei of \\\n\t\
the first list with probability given in the second list pi.\";\n\n\
BiasedSelect::probabilityLeak =\n\t\"You have a probability leak. The \
probabilities you specified do \\\n\tnot add up to 1.\";\n\n\
BiasedSelect::excess =\n\t\"The probabilities you specified sum to greater \
than 1.\";\n\nCheckProbabilitiesQ[probabilities_]:=\n\tModule[{psum = \
Apply[Plus, probabilities]},\n\t\tWhich[psum<1,  \
Message[BiasedSelect::probabilityLeak],\n\t\t      psum>1,  \
Message[BiasedSelect::excess],\n\t\t      psum==1, True\n\t\t     ]\n\t]\n\t\n\
InRangeQ[n_, {lb_, 1}]:=   lb <= n <= 1\nInRangeQ[n_, {lb_, ub_}]:= lb <= n < \
ub"], "Input",
  Editable->False,
  InitializationCell->True,
  AspectRatioFixed->True],

Cell[TextData[
"General::spell1: Possible spelling error: new symbol name \"random\"\n     \
is similar to existing symbol \"Random\"."], "Message",
  Evaluatable->False,
  AspectRatioFixed->True]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[
"Computing the Period of x^a mod n (Classical Method)"], "Subsection",
  Editable->False,
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[
"This function is only used to provide a quick simulation of the input/output \
behavior of Shor's algorithm. It is a purely classical algorithm."], "Text",
  Editable->False,
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[TextData[
"PeriodOfSequence[sequence_] := \n  Module[{period, chunks}, period = 1; \n   \
 chunks = PartitionWithRmdr[sequence, period]; \n    While[ \
!PeriodicQ[chunks] && period <= Length[sequence], \n     period++; chunks = \
PartitionWithRmdr[sequence, period]]; \n    If[ !PeriodicQ[chunks], Infinity, \
period]]\n\nPeriodicQ[{{___}}] := False\nPeriodicQ[{firstLists__, lastList_}] \
:= \n  Module[{firstList}, firstList = First[{firstLists}]; \n    {firstList} \
=== Union[{firstLists}] && Subsequence[lastList, firstList]]\n\n\
Subsequence[{list__}, {list__, ___}] := True\nSubsequence[_, _] := False\n\n\
PartitionWithRmdr[list_, size_] := \n  Module[{rmdr}, rmdr = {Take[list, \
-Mod[Length[list], size]]}; \n    Join[Partition[list, size], If[rmdr === \
{{}}, {}, rmdr]]]"], "Input",
  Editable->False,
  InitializationCell->True,
  AspectRatioFixed->True],

Cell[TextData[
"General::spell1: Possible spelling error: new symbol name \"period\"\n     \
is similar to existing symbol \"Period\"."], "Message",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[
"General::spell1: Possible spelling error: new symbol name \"firstList\"\n    \
 is similar to existing symbol \"firstLists\"."], "Message",
  Evaluatable->False,
  AspectRatioFixed->True]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[
"(* This function computes the period of the sequence of\n   values of x^a \
mod n directly. We use it simply to allow a\n   fast (fake) simulation of \
Shor's quantum algorithm. In Shor's\n   algorithm a quantum computer can \
compute the DFT very quickly.\n   However, when we SIMULATE a quantum \
algorithm on a classical\n   machine it appears to be much slower. Don't be \
fooled. The\n   quantum algorithm for factoring an integer would, if run on a \
\n   quantum computer, be much more efficient than any classical \n   \
factoring algorithm, running on any classical computer. Indeed\n   the \
inefficiency of simulating quantum computers on classical\n   computers is \
inevitable. Otherwise you could achieve the same\n   efficiency as a quantum \
computer simply by simulating a quantum\n   computer on a classical machine. \
This is not so. There is no\n   known way to simulate quantum physics on a \
classical machine\n   without incurring an exponential slow down.\n*)\n\n\
PeriodViaClassicalAlgorithm[x_, n_, q_]:=\n\tModule[{reg1, reg2, lists, \
periods},\n\t\treg1 = Apply[Plus, Map[(N[1/Sqrt[q]] ket[#])&, Range[0, \
q-1]]];\n\tPrint[\"reg1 = \", Short[reg1, 8]]; \n\t\treg2 = \
Map[Mod[x^#[[2,1]], n]&, Apply[List, reg1]];\n\tPrint[\"\\nreg2 = \", reg2]; \
\n\t\tPeriodOfSequence[reg2]\n\t]\n\t\nAllSameQ[first_, rest_]:=\n\t\
Apply[And, Map[first === #&, rest]]"], "Input",
  Editable->False,
  InitializationCell->True,
  AspectRatioFixed->True],

Cell[TextData[
"General::spell1: Possible spelling error: new symbol name \"lists\"\n     is \
similar to existing symbol \"list\"."], "Message",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[
"General::spell1: Possible spelling error: new symbol name \"periods\"\n     \
is similar to existing symbol \"period\"."], "Message",
  Evaluatable->False,
  AspectRatioFixed->True]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData["Code for creating graphics"], "Subsection",
  Editable->False,
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData["Clear[PlotReg2VSReg1, PlotProbabilitiesVSContents]"], "Input",
  Editable->False,
  AspectRatioFixed->True],

Cell[TextData[
"PlotReg2VSReg1[reg1_, reg2_, opts___]:=\n\tListPlot[MapThread[{#1, #2}&, \
{reg1, reg2}],\n\t         Frame->True,\n\t         GridLines->Automatic,\n\t \
        opts\n\t        ]\n\t\nPlotProbabilitiesVSContents[w_. ket[i_] + \
kets_., opts___]:=\n\tModule[{probs, conts, grid, frame},\n\t\tprobs = \
Probabilities[w ket[i] + kets];\n\t\tconts = Contents[w ket[i] + kets];\n\t\t\
ListPlot[MapThread[{#1, #2}&, {conts, probs}],\n\t\t         opts,\n\t\t      \
   GridLines->Automatic,\n\t\t         Frame->True]\n\t]\n\t\t\n(* w_. \
ket[i_] + kets_. is a superposition of states of a quantum\n   memory \
register. Probabilities[...] gives the probability with\n   which each result \
would be obtained upon measuring the state of\n   the register. Contents[...] \
gives the actual values that are\n   stored in superposition in the register.\
\n*)\nProbabilities[w_. ket[i_] + kets_.]:=\n\tModule[{amplitudes},\n\t\t\
amplitudes = Map[#[[1]]&, Apply[List, w ket[i] + kets]];\n\t\t\
Abs[amplitudes/Sqrt[Apply[Plus, Abs[amplitudes]^2]]]^2\n\t]\n\n\
Probabilities[superposition_List]:=\n\tProbabilities[Apply[Plus, \
superposition]]\n\nContents[w_. ket[i_] + kets_.]:=\n\tMap[#[[2,1]]&, \
Apply[List, w ket[i] + kets]]\n\nContents[superposition_List]:=\n\t\
Contents[Apply[Plus, superposition]]"], "Input",
  Editable->False,
  AspectRatioFixed->True]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["Your Own Experiments Here ..."], "Section",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[TextData["Try me!"], "Subsubsection",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[TextData["RunShorsAlgorithm[16]"], "Input",
  AspectRatioFixed->True],

Cell[OutputFormData["\<\
{8, 2}\
\>", "\<\
{8, 2}\
\>"], "Output",
  Evaluatable->False,
  AspectRatioFixed->True]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"Macintosh 3.0",
ScreenRectangle->{{0, 640}, {0, 460}},
AutoGeneratedPackage->Automatic,
WindowToolbars->{},
CellGrouping->Manual,
WindowSize->{520, 365},
WindowMargins->{{28, Automatic}, {Automatic, 31}},
PrintingCopies->1,
PrintingPageRange->{1, Automatic},
PrivateNotebookOptions->{"ColorPalette"->{RGBColor, -1}},
ShowCellLabel->True,
ShowCellTags->False,
RenderingOptions->{"ObjectDithering"->True,
"RasterDithering"->False},
MacintoshSystemPageSetup->"\<\
00<0004/0B`000002n88o?mooh<<H`Ui0fL5:0?l0080004/0B`000000]P2:001
0000I00000400`<300000BL?00400@BU_l0000000000060801T1T000000@0000
00000000004000000000000000000000\>"
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1731, 51, 152, 4, 174, "Title",
  Evaluatable->False],
Cell[1886, 57, 117, 3, 53, "Subsubtitle",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[2028, 64, 112, 3, 50, "Section",
  Evaluatable->False],
Cell[2143, 69, 921, 14, 222, "Text",
  Evaluatable->False]
}, Open  ]],

Cell[CellGroupData[{
Cell[3101, 88, 120, 3, 50, "Section",
  Evaluatable->False],
Cell[3224, 93, 368, 7, 94, "Text",
  Evaluatable->False],
Cell[3595, 102, 93, 2, 25, "Input"],
Cell[3691, 106, 170, 5, 30, "Text",
  Evaluatable->False],
Cell[3864, 113, 167, 4, 38, "Input"],
Cell[4034, 119, 1464, 22, 302, "Text",
  Evaluatable->False]
}, Open  ]],

Cell[CellGroupData[{
Cell[5535, 146, 145, 3, 50, "Section",
  Evaluatable->False],
Cell[5683, 151, 166, 5, 30, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[5874, 160, 90, 2, 25, "Input"],
Cell[5967, 164, 966, 15, 302, "Print",
  Evaluatable->False]
}, Open  ]],

Cell[CellGroupData[{
Cell[6970, 184, 90, 2, 42, "Subsubsection",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[7085, 190, 74, 1, 25, "Input"],
Cell[7162, 193, 3745, 50, 1814, "Print",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[10932, 247, 26227, 1157, 182, 7541, 921, "GraphicsData", 
"PostScript", "Graphics",
  Evaluatable->False],
Cell[37162, 1406, 31303, 1420, 182, 10944, 1163, "GraphicsData", 
"PostScript", "Graphics",
  Evaluatable->False],
Cell[68468, 2828, 37923, 1277, 182, 7937, 902, "GraphicsData", 
"PostScript", "Graphics",
  Evaluatable->False],
Cell[106394, 4107, 37238, 1275, 182, 7851, 907, "GraphicsData", 
"PostScript", "Graphics",
  Evaluatable->False],
Cell[143635, 5384, 26449, 1096, 182, 7167, 853, "GraphicsData", 
"PostScript", "Graphics",
  Evaluatable->False],
Cell[170087, 6482, 36287, 1915, 182, 15251, 1650, "GraphicsData", 
"PostScript", "Graphics",
  Evaluatable->False],
Cell[206377, 8399, 36367, 1924, 182, 15295, 1659, "GraphicsData", 
"PostScript", "Graphics",
  Evaluatable->False],
Cell[242747, 10325, 73912, 5389, 182, 49057, 5076, "GraphicsData", 
"PostScript", "Graphics",
  Evaluatable->False]
}, Open  ]],
Cell[316674, 15717, 114, 6, 24, "Output",
  Evaluatable->False]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[316849, 15730, 86, 2, 50, "Section",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[316960, 15736, 90, 2, 42, "Subsubsection",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[317075, 15742, 93, 1, 38, "Input"],
Cell[317171, 15745, 114, 6, 24, "Output",
  Evaluatable->False]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[317346, 15758, 116, 3, 50, "Section",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[317487, 15765, 10940, 147, 70, "Input",
  InitializationCell->True],
Cell[328430, 15914, 200, 4, 70, "Message",
  Evaluatable->False],
Cell[328633, 15920, 202, 4, 70, "Message",
  Evaluatable->False],
Cell[328838, 15926, 211, 4, 70, "Message",
  Evaluatable->False],
Cell[329052, 15932, 211, 4, 70, "Message",
  Evaluatable->False]
}, Open  ]],
Cell[329278, 15939, 533, 9, 70, "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{
Cell[329848, 15953, 132, 3, 30, "Section",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[330005, 15960, 2193, 32, 70, "Input",
  InitializationCell->True],
Cell[332201, 15994, 196, 4, 70, "Message",
  Evaluatable->False]
}, Open  ]],

Cell[CellGroupData[{
Cell[332434, 16003, 134, 3, 70, "Subsection",
  Evaluatable->False],
Cell[332571, 16008, 386, 7, 70, "Input",
  InitializationCell->True]
}, Open  ]],

Cell[CellGroupData[{
Cell[332994, 16020, 114, 3, 70, "Subsection",
  Evaluatable->False],
Cell[333111, 16025, 2019, 29, 70, "Input",
  InitializationCell->True]
}, Open  ]],

Cell[CellGroupData[{
Cell[335167, 16059, 148, 4, 70, "Subsection",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[335340, 16067, 3009, 43, 70, "Input",
  InitializationCell->True],
Cell[338352, 16112, 195, 4, 70, "Message",
  Evaluatable->False]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[338596, 16122, 154, 4, 70, "Subsection",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[338775, 16130, 2058, 40, 70, "Input",
  InitializationCell->True],
Cell[340836, 16172, 195, 4, 70, "Message",
  Evaluatable->False]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[341080, 16182, 120, 3, 70, "Subsection",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[341225, 16189, 1474, 23, 70, "Input",
  InitializationCell->True],
Cell[342702, 16214, 196, 4, 70, "Message",
  Evaluatable->False]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[342947, 16224, 152, 4, 70, "Subsection",
  Evaluatable->False],
Cell[343102, 16230, 238, 5, 70, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[343365, 16239, 872, 14, 70, "Input",
  InitializationCell->True],
Cell[344240, 16255, 196, 4, 70, "Message",
  Evaluatable->False],
Cell[344439, 16261, 203, 4, 70, "Message",
  Evaluatable->False]
}, Open  ]],

Cell[CellGroupData[{
Cell[344679, 16270, 1483, 22, 70, "Input",
  InitializationCell->True],
Cell[346165, 16294, 193, 4, 70, "Message",
  Evaluatable->False],
Cell[346361, 16300, 197, 4, 70, "Message",
  Evaluatable->False]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[346607, 16310, 125, 3, 70, "Subsection",
  Evaluatable->False],
Cell[346735, 16315, 122, 2, 70, "Input"],
Cell[346860, 16319, 1367, 20, 70, "Input"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[348276, 16345, 106, 2, 30, "Section",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[348407, 16351, 90, 2, 42, "Subsubsection",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[348522, 16357, 74, 1, 25, "Input"],
Cell[348599, 16360, 114, 6, 24, "Output",
  Evaluatable->False]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

